# de.gematik.ti#1.2.0: Implementation Guide Telematikinfrastruktur (TI) Common

## Pages

* [Home](index.md)
* [Steckbriefe](spec-sheet.md)
* [Steckbrief: ePA PS / ePA-Client-Systeme / ePA-FdV](actor-epa-client.md)
* [FHIR-Artefakte](artifacts.md)
* [Query API: Allgemeine Anforderungen Suche und Sortierung](query-api-search.md)
* [Release Notes](release-notes.md)
* [Referenzen](referenced.md)
* [Steckbrief: ePA Patient Service](actor-epa-patient.md)
* [Apache License](license.md)
* [Query API: Allgemeine Anforderungen Paginierung](query-api-paging.md)
* [Steckbrief: ePA Medication Service](actor-epa-medication.md)
* [Steckbrief: ePA Audit Event Service](actor-epa-audit.md)
* [Versionsvergleiche](comparisons.md)
* [Downloads](downloads.md)
* [Steckbrief: ePA MHD Service](actor-epa-mhd.md)
* [FHIR-Formatserialisierung](fhir-format.md)
* [Generelle Prinzipien](general-principles.md)
* [Steckbrief: VSDM 2.0](actor-vsdm.md)

## Resources

### CodeSystems

* [TI Operation Outcome Details CodeSystem](CodeSystem-operation-outcome-details-codes.md)

### ValueSets

* [TI Operation Outcome Details Value Set](ValueSet-operation-outcome-details-vs.md)

### Complex-type Profiles

* [Identifikator Profil für E-Rezept-IDs](StructureDefinition-e-prescription-id.md)
* [Profil für den Identifikator eines eMP-Eintrags](StructureDefinition-medication-plan-identifier.md)

### Resource Profiles

* [TI Operation Outcome](StructureDefinition-operation-outcome.md)
* [Capability Statement Profil für TI FHIR Data Service](StructureDefinition-ti-capability-statement.md)
* [OperationDefinition Profil für TI FHIR Data Service](StructureDefinition-ti-operationdefinition.md)
* [TI Organization](StructureDefinition-ti-organization.md)
* [TI Patient](StructureDefinition-ti-patient.md)
* [TI PractitionerRole](StructureDefinition-ti-practitioner-role.md)
* [TI Practitioner](StructureDefinition-ti-practitioner.md)

### Extensions

* [Base URL der FHIR-API](StructureDefinition-extension-base-url.md)
* [HTTP Header](StructureDefinition-extension-http-header.md)
* [HTTP Method for FHIR Operation](StructureDefinition-extension-http-method.md)
* [HTTP-Antwortinformationen](StructureDefinition-extension-http-response-info.md)
* [National Contact Point of Health (NCPeH) Country Extension](StructureDefinition-ncpeh-country-extension.md)

### ImplementationGuides

* [Implementation Guide Telematikinfrastruktur (TI) Common](index.md)

### Examples

* [example-history-bundle (Bundle)](Bundle-example-history-bundle.md)
* [0dc58d79-1b2e-4c6f-afe0-0a5b721661a2 (OperationOutcome)](OperationOutcome-0dc58d79-1b2e-4c6f-afe0-0a5b721661a2.md)
* [468ca07b-7d63-453d-a738-0c35cb9402aa (OperationOutcome)](OperationOutcome-468ca07b-7d63-453d-a738-0c35cb9402aa.md)
* [ad48bf90-a664-44f4-af14-ee6e81db3df4 (OperationOutcome)](OperationOutcome-ad48bf90-a664-44f4-af14-ee6e81db3df4.md)
* [ExampleTIPatient (Patient)](Patient-ExampleTIPatient.md)
