# Generelle Prinzipien - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* **Generelle Prinzipien**

## Generelle Prinzipien

Dieser Implementation Guide verwendet die Schlüsselwörter **MUSS**, **DARF NICHT**, **SOLL NICHT** und **KANN** als deutsche Pendants des [RFC2119], um Anforderungen als Ausdruck normativer Festlegungen zu kennzeichnen. Anforderungen werden im Implementation Guide wie folgt dargestellt:

**<IG-ID-Version> - <Titel der Anforderung>**
 Text / Beschreibung
 [<=]

### Eindeutigkeit von FHIR-Ressourcen

Der FHIR Data Service MUSS ausschließlich zeitbasierte Universally Unique IDentifier (UUID) gemäß [RFC9562] für logische IDs (d.h. für das FHIR-Element
*Resource.id*) verwenden.
### Must Support in FHIR-Profilen

Die Deklarierung als Must Support wird in der Anzeige der FHIR-Profile durch ein rotes “S” gekennzeichnet. Als Must Support deklarierte Elemente MÜSSEN durch jedes Client-System, welches diese Spezifikation implementiert, unterstützt werden. Das bedeutet:

Ein Client-System, das schreibend ein FHIR-Profil des FHIR Data Service implementiert, MUSS jedes als Must Support gekennzeichnete Element gemäß der dazugehörigen Kardinalitätsangabe befüllen. Das heißt auch, dass in optionalen Elementen (z.B. Kardinalität "0..1", "0..*") der Elementwert leer bleiben darf, sofern dem Client-System kein Wert zur Verfügung steht.

Das Client-System, das lesend ein FHIR-Profil des FHIR Data Service implementiert, MUSS in der Lage sein, alle Must-Support-Elemente in FHIR-Instanzen zu verarbeiten. Das Client-System MUSS auch Must-Support-Elemente ohne Wert verarbeiten können, ohne mit einem Fehler abzubrechen oder die Anwendung abstürzen zu lassen.

Wenn eine Anforderung vom Client-System verlangt, Inhalte einer oder mehrerer Instanzen von FHIR-Profilen des FHIR Data Service anzuzeigen, die das Client-System implementiert, MUSS das entsprechende Client-System alle Must-Support-Elemente für die menschliche Nutzung anzeigen. Es muss dabei nicht jeden Wert genauso darstellen, wie er in der Instanz kodiert ist, darf aber auch keine wesentlichen Informationen ausblenden.
### Versionierung

Jede Änderung an einer FHIR-Instanz führt zu einer neuen Version dieser Instanz, wobei jede Version eine eindeutige *Meta.versionId* und ein *Meta.lastUpdated* erhält. Auch eine neu erstellte FHIR-Instanz wird vom FHIR Data Service mit diesen Metadaten versehen. Dadurch kann der vollständige Änderungsverlauf einer Instanz nachvollzogen werden. Der FHIR Data Service speichert und stellt die Historie aller Versionen einer FHIR-Instanz bereit. Dies umfasst auch die Möglichkeit, frühere Versionen einer Instanz über die FHIR API unter Verwendung der *Meta.versionId* abzurufen. Falls eine FHIR-Instanz gleichzeitig aktualisiert wird, erkennt der FHIR Data Service potenzielle Konflikte und verarbeitet diese entsprechend.

Bei einer Aktualisierung einer FHIR-Instanz, die keine inhaltlichen Änderungen an den bestehenden Werten vornimmt, bleibt die aktuelle Version der Instanz unverändert. Der FHIR Data Service erstellt in diesem Fall keine neue Version und behält den bestehenden Wert in **Meta.versionId** sowie das Datum in **Meta.lastUpdated** bei.

Der FHIR Data Service MUSS jede neu erstellte oder neu hinzugefügte FHIR-Instanz mit einer
*Meta.versionId*und einem
*Meta.lastUpdated*versehen, um die Versionierung sicherzustellen.

Der FHIR Data Service MUSS sicherstellen, dass bei jeder Aktualisierung einer FHIR-Instanz die
*Meta.versionId*angepasst wird. Das Element
*Meta.lastUpdated*MUSS auf den Zeitpunkt der Aktualisierung gesetzt werden.

Der FHIR Data Service MUSS sicherstellen, dass bei einer Aktualisierung einer FHIR-Instanz, die keine inhaltlichen Änderungen an den bestehenden Werten vornimmt, die aktuelle Version unverändert bleibt. In diesem Fall wird keine neue Version erstellt und die bestehende
*Meta.versionId*sowie das
*Meta.lastUpdated-Datum*bleiben erhalten.
#### Format für Resource.meta.versionId

Das Metadatenattribut `Resource.meta.versionId` gibt die Versionsnummer einer FHIR-Instanz an. Die FHIR R4 Spezifikation definiert kein spezifisches Format für dieses Element. Die Vergabe und Verwaltung der *versionId* liegt ausschließlich beim FHIR Data Service.

Der FHIR Data Service MUSS sicherstellen, dass das Element
*Resource.meta.versionId*ausschließlich numerische Werte enthält. Alphanumerische Zeichen, Symbole oder Sonderzeichen dürfen nicht verwendet werden.

Der FHIR Data Service MUSS sicherstellen, dass die
*versionId*einer FHIR-Instanz bei jeder neuen Version um genau 1 erhöht wird. Die erste Version einer FHIR-Instanz erhält die
*versionId*1, die nächste Version 2, und so weiter. Beispiel: 1 → 2 → 3 →

Der FHIR Data Service MUSS sicherstellen, dass die
*Resource.meta.versionId*innerhalb einer spezifischen FHIR-Instanz eindeutig ist. Die Versionsnummer darf nicht zurückgesetzt oder übersprungen werden. Jede Instanz besitzt eine eigene fortlaufende Versionsnummer, die bei jeder Änderung der FHIR-Instanz aufsteigt.
#### Abfrage der Versionhistorie über HTTP GET

Die *_history*-Abfrage beim FHIR Data Service ermöglicht es, die Versionshistorie entweder einer spezifischen FHIR-Instanz oder aller Instanzen eines bestimmten ResourceType abzurufen. Damit kann nachverfolgt werden, welche Änderungen an einer Instanz vorgenommen wurden und welche Versionen im Laufe ihres Lebenszyklus existieren.

**Abruf der Versionshistorie einer spezifischen Instanz**

Die URL für den Abruf der Versionhistorie einer FHIR-Instanz folgt diesem Muster:

```
GET [base]/[ResourceType]/[id]/_history

```

Dabei ist:

* *ResourceType* der Typ der Ressource (z.B. *MedicationRequest*, *MedicationDispense*),
* *id* die eindeutige ID der Ressource,
* *_history* die Anzeige der Versionshistorie der Instanz, welche abgerufen werden soll

**Abruf der Versionshistorie aller Instanzen eines Ressourcentyps**

Die URL für den Abruf der Versionshistorie aller Instanzen eines Ressourcentyps folgt diesem Muster:

```
GET [base]/[ResourceType]/_history

```

Dabei gilt:

* *ResourceType* ist der Typ der Ressource (z.B. *MedicationRequest*, *MedicationDispense*)
* *_history* – zeigt an, dass die Versionshistorien aller Instanzen dieses Ressourcentyps abgerufen werden sollen

Funktionalität und Verhalten:

* Der FHIR Data Service gibt als Antwort ein **Bundle** mit dem Typ **history** zurück.
* Das **Bundle** enthält eine Liste aller bekannten Versionen der angeforderten FHIR-Instanz.
* Jede Version wird als **entry** innerhalb des **Bundles** dargestellt und enthält die entsprechenden Metadaten (**meta.versionId**, **meta.lastUpdated**)
* Falls die FHIR-Instanz gelöscht wurde, bleibt ihre Historie weiterhin abrufbar.

**Beispiel für ein Bundle mit dem Typ history**

Der FHIR Data Service MUSS die
*_history*-Abfrage gemäß der HL7 FHIR Spezifikation [FHIR History Interaction] implementieren, um die Versionshistorie einer FHIR-Instanz abrufbar zu machen.

Der FHIR Data Service MUSS es ermöglichen, die Versionshistorie aller Instanzen eines bestimmten Ressourcentyps über eine HTTP GET-Anfrage an folgende URL abzurufen:
*[base]/[ResourceType]/_history*.

Der FHIR Data Service MUSS es ermöglichen, die Versionshistorie einer FHIR-Instanz über eine HTTP GET-Anfrage an folgende URL abzurufen:
*[base]/[ResourceType]/[id]/_history*.

Der FHIR Data Service MUSS als Antwort auf eine
*_history*-Abfrage ein Bundle mit dem Typ
*history*zurückgeben, das die Versionen der angeforderten FHIR-Instanz enthält.

Der FHIR Data Service MUSS innerhalb des
*_history*
*Bundle*für jede Version einer FHIR-Instanz die zugehörigen
*entry.request*- und
*entry.response*-Elemente bereitstellen.

*  *Bundle.entry.request.method* gibt die HTTP-äquivalente Aktion an, die zur Entstehung der jeweiligen Version der Ressourceinstanz geführt hat. *POST* für das Anlegen, *PUT* für eine Aktualisierung, *DELETE* für das Löschen der Ressourceinstanz. 
*  *Bundle.entry.request.url* enthält die äquivalente Ressourcen-URL relativ zum FHIR-Endpunkt, aus der die versionsspezifische Abruf-URL *ResourceType/{id}/_history/{versionId}* abgeleitet werden kann. 
*  *Bundle.entry.response.status* enthält den HTTP-ähnlichen Status der internen Verarbeitung (z. B. *201 Created* oder *200 OK*). 
*  *Bundle.entry.response.lastModified* gibt das Datum und die Uhrzeit der letzten Änderung der jeweiligen Version der Ressourceinstanz an und stimmt mit *meta.lastUpdated* überein, sofern *Bundle.entry.resource* vorhanden ist. 
*  *Bundle.entry.response.location* enthält die vollständige versionsspezifische Ressourcen-URL (z. B. *ResourceType/{id}/_history/{versionId}*), sofern die entsprechende Version der Ressourceinstanz einzeln abrufbar ist. 

**Hinweis:**

Die in *Bundle.entry.request.method* und *Bundle.entry.request.url* abgebildete Interaktion ist die HTTP-äquivalente Repräsentation der internen Persistenz des FHIR Data Service. Sie muss nicht der tatsächlich aufgerufenen fachlichen FHIR-Operation entsprechen.

#### Abfrage einer spezifischen Version über HTTP GET

Um eine spezifische Version einer Ressource abzurufen, kann eine einfache HTTP *GET*-Anfrage an den FHIR Data Service gesendet werden. Die URL für den Abruf einer bestimmten Version einer FHIR-Instanz folgt diesem Muster:

```
GET [base]/[ResourceType]/[id]/_history/[versionId]

```

Dabei ist:

* *resourceType* der Typ der Ressource (z.B. *Medication*, *MedicationStatement*)
* *id* die eindeutige ID der Ressource
* *versionId* die spezifische *Meta.versionId* der abzurufenden Ressourcenversion

**Beispiel**

Um die 3. Version einer `MedicationStatement`-Instanz mit der ID “391fc0c6-e045-48d9-8af6-3ac2466beb88” vom FHIR Data Service abzurufen, muss die URL für die HTTP GET-Anfrage wie folgt aussehen:

```
GET [base]/epa/medication/api/v1/fhir/MedicationStatement/391fc0c6-e045-48d9-8af6-3ac2466beb88/_history/3

```

Der FHIR Data Service MUSS das Lesen spezifischer Versionen von FHIR-Instanzen gemäß der HL7 FHIR Spezifikation [FHIR Version Read] implementieren. Dabei MUSS eine angeforderte Version einer Instanz über eine GET-Anfrage der Form
*[base]/[resourceType]/[id]/_history/[versionId]*bereitgestellt werden. Die Antwort MUSS die angeforderte Version der Instanz enthalten, einschließlich der zugehörigen Metadaten (
*meta.versionId*,
*meta.lastUpdated*).

Der FHIR Data Service MUSS sicherstellen, dass eine spezifische Version einer Ressource über die
*Meta.versionId*eindeutig identifiziert und abgerufen werden kann. Die
*versionId*dient dabei zur referenzgenauen Anforderung einer bestimmten historischen Version einer Ressource.

Der FHIR Data Service MUSS bei einem HTTP GET-Request auf eine spezifische Version einer FHIR-Instanz den HTTP Status Code
*404 (Not Found)*zurückgeben, wenn die angeforderte Version nicht existiert.

Die Response MUSS eine
*OperationOutcome*-Ressource enthalten mit folgenden Eigenschaften:
* *OperationOutcome.issue.code* auf *not-found* gesetzt.
* *OperationOutcome.issue.diagnostics* mit einer Meldung, dass die angeforderte Version nicht existiert.

#### Löschen als Versionierungsergebnis

Im FHIR Data Service wird das Löschen einer Ressource als ein weiteres Ereignis im Lebenszyklus einer Ressource behandelt. Das bedeutet: Anstatt die Ressource physisch zu entfernen, wird die Ressource als gelöscht markiert und eine neue Version der Ressource erstellt, welche diesen Zustand widerspiegelt. Obwohl eine Ressource als gelöscht markiert wurde, können frühere Versionen über die versionsspezifischen Endpunkte (s.o.) abgerufen werden.

Der FHIR Data Service MUSS das Löschen einer Instanz als ein Ereignis im Lebenszyklus der Instanz behandeln, indem eine neue Version erstellt wird, die den gelöschten Zustand widerspiegelt.

Der FHIR Data Service MUSS eine als gelöscht markierte Instanz weiterhin in der Versionshistorie speichern, anstatt sie physisch zu entfernen.

Der FHIR Data Service MUSS sicherstellen, dass frühere Versionen einer gelöschten Instanz weiterhin über versionsspezifische Endpunkte abrufbar sind.

Der FHIR Data Service MUSS bei einem
*GET*-Request auf eine gelöschte FHIR-Instanz oder eine gelöschte Version den HTTP Status Code
*410 (Gone)*zurückgeben.

Dies gilt für:
* *[ResourceType]/[id]* – wenn die gesamte FHIR-Instanz gelöscht wurde
* *[ResourceType]/[id]/_history/[versionId]* – wenn eine spezifische Version der FHIR-Instanz gelöscht wurde

Die Response muss eine
*OperationOutcome*-Ressource enthalten mit folgenden Eigenschaften:
* *OperationOutcome.issue.code* ist auf *processing* gesetzt
* *OperationOutcome.issue.details* ist auf *MSG_DELETED* gesetzt
* *OperationOutcome.issue.diagnostics* enthält eine Meldung, dass die Instanz gelöscht wurde

Das folgende Beispiel zeigt die erwartete Antwort nach dem Abruf einer gelöschten Instanz.

Der FHIR Data Service MUSS innerhalb des
*_history*Bundle auch gelöschte Versionen einer FHIR-Instanz dokumentieren.

Für gelöschte Versionen gilt:
* Bei gelöschten Ressourceinstanzen wird das Element *Bundle.entry.resource* nicht ausgegeben.
* *Bundle.entry.request.method* hat für gelöschte Ressourceinstanzen den Wert *DELETE*.
* *Bundle.entry.request.url* enthält die REST-äquivalente Ressourcen-URL relativ zum FHIR-Endpunkt, *ResourceType/{id}*.
* *Bundle.entry.response.status* enthält den Wert *200 OK*.
* *Bundle.entry.response.lastModified* enthält das Löschdatum der Ressourceinstanz.

**Hinweis:**

Gelöschte Versionen enthalten keine Ressourcendarstellung. Die dokumentierte *DELETE* Aktion entspricht der internen Kennzeichnung der Ressource als gelöscht. Die Löschzeit kann mit dem Zeitpunkt der internen Markierung übereinstimmen, der in lastModified angegeben wird.

#### Versionierte Referenzen

Versionierte Referenzen in FHIR ermöglichen es, innerhalb einer FHIR-Ressource auf eine spezifische Version einer anderen Ressource zu verweisen. Dies ist besonders wichtig in Szenarien, in denen die Genauigkeit und der Kontext der bezogenen Daten über die Zeit erhalten bleiben müssen.

In FHIR kann eine Referenz auf eine andere Ressource in der Regel durch die Angabe des Ressourcentyps und der ID erfolgen. Versionierte Referenzen erweitern dieses Konzept, indem sie es ermöglichen, zusätzlich die Version der referenzierten Ressource anzugeben. Dies stellt sicher, dass immer auf den exakten Zustand der referenzierten Ressource zum Zeitpunkt der Referenzerstellung Bezug genommen wird, unabhängig von späteren Änderungen oder Aktualisierungen dieser Ressource.

Eine versionierte Referenz in FHIR beinhaltet den Ressourcentyp, die Ressourcen-ID und die spezifische *Meta.versionId* der referenzierten Ressource. Das Format sieht wie folgt aus:

```
[ResourceType]/[id]/_history/[versionId]

```

Beispiel für eine versionierte Referenz auf eine spezifische Version einer **MedicationStatement**-Instanz:

```
MedicationStatement/391fc0c6-e045-48d9-8af6-3ac2466beb88/_history/4

```

In diesem Beispiel bezieht sich die Referenz auf die 4. Version der **MedicationStatement**-Instanz mit der ID **391fc0c6-e045-48d9-8af6-3ac2466beb88**.

Der FHIR Data Service MUSS versionierte Referenzen nach [FHIR References and Versions] implementieren.

Der FHIR Data Service MUSS versionierte Referenzen unterstützen, um es zu ermöglichen, innerhalb einer FHIR-Instanz auf eine spezifische Version einer anderen Instanz zu verweisen.

Der FHIR Data Service MUSS sicherstellen, dass eine FHIR-Instanz eine andere Instanz nicht nur über Ressourcentyp und ID, sondern auch mit einer spezifischen
*Meta.versionId*referenzieren kann.

Der FHIR Data Service MUSS das Format für versionierte Referenzen verwenden, das den Ressourcentyp, die
*Resource.id*und die
*Meta.versionId*beinhaltet:
*[ResourceType]/[id]/_history/[versionId]*.

Der FHIR Data Service MUSS sicherstellen, dass versionierte Referenzen in Bundles entsprechend den Vorgaben in [FHIR Bundle References] auflösbar sind.
Zum Auflösen einer versionerten Referenz, muss zunächst ein Treffer auf Grund der Referenz ohne die Versionsinformation (also ohne `/_history/[versionId]`) mit der `Bundle.entry.fullUrl` bestimmt werden muss und anschließend die Version mit `Resource.meta.versionId` auf Übereinstimmung geprüft werden (siehe [FHIR Bundle References]). Hierbei muss die `Bundle.entry.fullUrl` nicht eindeutig sein (siehe [FHIR Bundle.entry.fullUrl]) und mehrere Versionen der selben Resourcen-Instanz mit der selben URL innerhalb eines Bundles erlaubt.

### Bereitstellung von Capability Statements

Ein FHIR Data Service MUSS an dem Endpunkt /metadata gemäß der [Capabilities-Interaktion] ein Capability Statement Typ
*kind = instance*bereitstellen. Dieses Capability Statement muss im Element
*software*den Namen und die Versionsnummer der eingesetzten Software angeben. Dieses Capability Statement muss sämtliche Anforderungen an den FHIR Data Service aus dem Capability Statement vom Typ
*kind = requirements*der zugrundeliegenden Spezifikation erfüllen.
### Verwendung von Codes im Status inactive

Der FHIR Data Service MUSS das Registrieren und Speichern von neuen Daten ablehnen und mit dem Fehler 
*SVC_INACTIVE_CODE*quittieren, falls ein Code den Status
*inactive*besitzt. Unter
*OperationOutcome.issue.diagnostics*MUSS der FHIR Data Service angeben, welcher Code nicht mehr unterstützt wird.

