# FHIR-Formatserialisierung - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* **FHIR-Formatserialisierung**

## FHIR-Formatserialisierung

Die Serialisierung von FHIR-Format-Repräsentationen in einem FHIR Data Service legt fest, in welchen Formaten der Dienst Anfragen verarbeitet und Antworten zurückgibt. Der FHIR Data Service kann sowohl JSON als auch XML unterstützen und ermöglicht es Client-Systeme, das gewünschte Format über den *Accept* Header oder den *_format*-Parameter festzulegen. Falls keine Formatangabe angezeigt wird, bestimmt der FHIR Data Service das Antwortformat. Die Anforderungen regeln zudem, wie der *Content Type Header* in POST-Nachrichten behandelt wird sowie welche Fehlerreaktion erfolgt, wenn ein nicht unterstütztes Format angefordert wird. Abhängig vom Einsatzzweck des FHIR Data Service kann es sein, dass nicht alle Anforderungen in jeder Implementierung relevant oder erforderlich sind.

Der FHIR Data Service MUSS das FHIR-Format in [FHIR JSON] verarbeiten können.

Der FHIR Data Service MUSS für Anfragenachrichten und Antwortnachrichten an den Schnittstellen den Content Type
`application/fhir+json`unterstützen.

Der FHIR Data Service MUSS das FHIR-Format in [FHIR XML] verarbeiten können.

Der FHIR Data Service MUSS für Anfragenachrichten und Antwortnachrichten an den Schnittstellen den Content Type
`application/fhir+xml`unterstützen.

Der FHIR Data Service MUSS den
*Accept*Header in eingehenden HTTP-Anfragen auswerten, um das gewünschte Antwortformat zu bestimmen. Der FHIR Data Service MUSS die Formate
*application/fhir+json*und
*application/fhir+xml*im
*Accept*Header unterstützen und die jeweilige HTTP-Antwortnachricht in dem Format zurückgeben, das von den beiden Formaten als bevorzugte Option angegeben wurde.
**Hinweis:** Einzelne Schnittstellen eines FHIR Data Services können über andere oder weitere Rückgabeformate verfügen.

**Beispiel für JSON (**application/fhir+json**)**

```
GET /AuditEvent/93f68f8b-0985-41c7-930a-44dfa6bba510 HTTP/1.1
Host: fhir.example.com
Accept: application/fhir+json

```

Der FHIR Data Service MUSS als Antwort FHIR JSON zurückgeben:

```
HTTP/1.1 200 OK
Content-Type: application/fhir+json

{
  "resourceType": "AuditEvent",
  "id": "93f68f8b-0985-41c7-930a-44dfa6bba510",
  ...
}

```

**Beispiel für XML (**application/fhir+xml**)**:

```
GET /AuditEvent/93f68f8b-0985-41c7-930a-44dfa6bba510 HTTP/1.1
Host: fhir.example.com
Accept: application/fhir+xml

```

Der FHIR Data Service MUSS als Antwort FHIR XML zurückgeben:

```
HTTP/1.1 200 OK
Content-Type: application/fhir+xml

<auditevent xmlns="http://hl7.org/fhir">
<id value="93f68f8b-0985-41c7-930a-44dfa6bba510"></id>
  ...
</auditevent>

```

Der FHIR Data Service MUSS gemäß der [FHIR General parameters] den
*_format*-Parameter in Anfragenachricht auswerten, um das gewünschte Antwortformat zu bestimmen.

Der FHIR Data Service MUSS folgende Werte für den
*_format*-Parameter unterstützen:

* XML-Formate: *xml*, *application/xml*, *application/fhir+xml*
* JSON-Formate: *json*, *application/json*, *application/fhir+json*

**Beispiel für JSON (**application/fhir+json**)**

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?_count=10&_offset=20&_format=json

```

Der FHIR Data Service MUSS, sofern die entsprechende Schnittstelle ein FHIR-Format zurückgibt, das Format
*application/fhir+json*verwenden, wenn in der Anfragenachricht kein unterstütztes Format durch den
*_format*-Parameter und
* kein *Accept* Header,
* oder durch den *Accept* Header keine eindeutige Präferenz eines unterstützten Formats
angegeben ist.

Der FHIR Data Service MUSS sicherstellen, dass der
*_format*-Parameter den Content Type Header für den Formattyp des Bodys einer POST-Nachricht nicht überschreibt.

Falls sowohl der
*Accept*Header als auch der
*_format*-Parameter in einer Anfragenachricht angegeben sind, MUSS der FHIR Data Service den
*_format*-Parameter priorisieren und das Antwortformat entsprechend diesem verarbeiten. Der
*Accept*Header MUSS in diesem Fall ignoriert werden.

