# Steckbrief: ePA Patient Service - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**Steckbriefe**](spec-sheet.md)
* **Steckbrief: ePA Patient Service**

## Steckbrief: ePA Patient Service

Die nachstehende Tabelle fasst Anforderungen dieses Implementation Guide für den **ePA Patient Service** zusammen.

| | | |
| :--- | :--- | :--- |
| [IG-TI52070SA6-01](./general-principles.md) | Bundle.entry.request und Bundle.entry.response innerhalb des _history Bundles | MUSS |
| [IG-TI61673KWG](./general-principles.md) | Unterstützung versionierter Referenzen im FHIR Data Service | MUSS |
| [IG-TI62717R2P](./fhir-format.md) | FHIR-Formatunterstützung XML | MUSS |
| [IG-TI38467S3Q](./general-principles.md) | Bereitstellung des /metadata-Endpunkts durch FHIR Data Service | MUSS |
| [IG-TI18063SU7](./fhir-format.md) | Unterstützung des _format-Parameters im FHIR Data Service | MUSS |
| [IG-TI94321ZRC](./general-principles.md) | Bereitstellung eines Bundles mit dem Typ history als Antwort | MUSS |
| [IG-TI62490PR0-01](./fhir-format.md) | Standardformat für den FHIR Data Service | MUSS |
| [IG-TI94558MGC](./fhir-format.md) | Vorrang des _format-Parameters gegenüber dem Accept Header | MUSS |
| [IG-TI97619U65](./general-principles.md) | Keine Registrierung bei Nutzung inaktiver Codes | MUSS |
| [IG-TI57083QMG](./fhir-format.md) | Unterstützung von XML Content Type für FHIR-Data-Schnittstellen | MUSS |
| [IG-TI22824X01-02](./fhir-format.md) | Unterstützung von JSON Content Type für FHIR-Data-Schnittstellen | MUSS |
| [IG-TI45064TNU](./general-principles.md) | Auflösen von versionierten Referenzen in Bundles | MUSS |
| [IG-TI44024J5L](./general-principles.md) | Eindeutigkeit der Resource.meta.versionId pro FHIR-Instanz | MUSS |
| [IG-TI06008V22](./general-principles.md) | Abruf einer spezifischen Ressourcenversion über die FHIR API | MUSS |
| [IG-TI43409LRQ](./query-api-search.md) | Verwendung von entry.search.mode = match | MUSS |
| [IG-TI72725KAW](./general-principles.md) | Format für versionierte Referenzen | MUSS |
| [IG-TI95143N18-02](./query-api-search.md) | Formatierung von Referenzen im fullUrl-Feld | MUSS |
| [IG-TI96963Y60-01](./fhir-format.md) | Unterstützung des Accept Header für Formatwahl im FHIR Data Service | MUSS |
| [IG-TI06069XBQ](./general-principles.md) | Aufsteigende Sequenz der Resource.meta.versionId | MUSS |
| [IG-TI16747WFN](./general-principles.md) | Implementierung der _history-Abfrage gemäß HL7 FHIR Spezifikation | MUSS |
| [IG-TI94882PRF](./general-principles.md) | Aktualisierung von Meta.versionId und Meta.lastUpdated bei einer Änderung | MUSS |
| [IG-TI64797XGV](./query-api-search.md) | Formatierungsvorgaben für das fullUrl-Feld in FHIR-Bundles | MUSS |
| [IG-TI59347HCY](./general-principles.md) | Initiale Versionierung neu erstellter oder hinzugefügter FHIR-Instanzen | MUSS |
| [IG-TI52829PK9](./general-principles.md) | Numerisches Format der Resource.meta.versionId | MUSS |
| [IG-TI52895H8W](./general-principles.md) | Keine neue Version bei inhaltsgleichen Aktualisierungen | MUSS |
| [IG-TI60515LXY](./general-principles.md) | Abruf der Versionshistorie aller Instanzen eines ResourceType | MUSS |
| [IG-TI29386S9L-02](./general-principles.md) | UUID für Resource.id | MUSS |
| [IG-TI02423P7B](./general-principles.md) | Referenzierung einer spezifischen Version einer FHIR-Instanz | MUSS |
| [IG-TI47719G19](./general-principles.md) | Umsetzung der Versionierte Referenzen gemäß FHIR | MUSS |
| [IG-TI29911V07](./query-api-search.md) | Konsistente Referenzierung innerhalb eines Bundles | MUSS |
| [IG-TI78384PEX](./general-principles.md) | Abruf der Versionshistorie einer FHIR-Instanz | MUSS |
| [IG-TI59271UPX](./fhir-format.md) | FHIR-Formatunterstützung JSON | MUSS |
| [IG-TI19904KM0](./fhir-format.md) | Keine Überschreibung des Content Type Header durch den _format-Parameter bei POST-Nachrichten | MUSS |
| [IG-TI66923Q9F](./general-principles.md) | Identifikation der Ressourcenversion durch Meta.versionId | MUSS |
| [IG-TI06872YZP](./general-principles.md) | 404 Not Found Antwort für nicht existierende spezifische Versionen | MUSS |

**Tabelle:**Anforderungen
*EPA-Patient-Service*

