# TI Patient - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **TI Patient**

## Resource Profile: TI Patient 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/ti/StructureDefinition/ti-patient | *Version*:1.2.0 |
| Active as of 2025-12-15 | *Computable Name*:TIPatient |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Das Patient-Profil für die Telematikinfrastruktur (TI) FHIR Data Services 

**Usages:**

* Examples for this Profile: [Patient/ExampleTIPatient](Patient-ExampleTIPatient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.ti|current/StructureDefinition/ti-patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ti-patient.csv), [Excel](StructureDefinition-ti-patient.xlsx), [Schematron](StructureDefinition-ti-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ti-patient",
  "url" : "https://gematik.de/fhir/ti/StructureDefinition/ti-patient",
  "version" : "1.2.0",
  "name" : "TIPatient",
  "title" : "TI Patient",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Das Patient-Profil für die Telematikinfrastruktur (TI) FHIR Data Services",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "constraint" : [
          {
            "key" : "pat-de-1",
            "severity" : "error",
            "human" : "Die amtliche Differenzierung der Geschlechtsangabe 'other' darf nur gefüllt sein, wenn das Geschlecht 'other' angegeben ist",
            "expression" : "gender.exists() and gender='other' implies gender.extension('http://fhir.de/StructureDefinition/gender-amtlich-de').exists()",
            "source" : "https://gematik.de/fhir/ti/StructureDefinition/ti-patient"
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:KVNR",
        "path" : "Patient.identifier",
        "sliceName" : "KVNR",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://fhir.de/StructureDefinition/identifier-kvid-10"]
          }
        ],
        "patternIdentifier" : {
          "system" : "http://fhir.de/sid/gkv/kvid-10"
        },
        "mustSupport" : true
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "comment" : "Um die Unterscheidung der Namensbestandteile gemäß dem VSDM-Datensatz beizubehalten oder Präfixe als akademische Titel zu qualifizieren, können Anbieter die im deutschen HumanName-Basisprofil spezifizierten Erweiterungen unterstützen: HumanName DE Basis (https://simplifier.net/basisprofil-de-r4/humannamedebasis).\n\nDies ist jedoch nicht verpflichtend im Rahmen dieser Spezifikation.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Name",
        "path" : "Patient.name",
        "sliceName" : "Name",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName",
            "profile" : ["http://fhir.de/StructureDefinition/humanname-de-basis"]
          }
        ],
        "patternHumanName" : {
          "use" : "official"
        },
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Name.use",
        "path" : "Patient.name.use",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Name.family",
        "path" : "Patient.name.family",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Name.family.extension:namenszusatz",
        "path" : "Patient.name.family.extension",
        "sliceName" : "namenszusatz",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Name.family.extension:nachname",
        "path" : "Patient.name.family.extension",
        "sliceName" : "nachname",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Name.family.extension:vorsatzwort",
        "path" : "Patient.name.family.extension",
        "sliceName" : "vorsatzwort",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Name.given",
        "path" : "Patient.name.given",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Name.prefix",
        "path" : "Patient.name.prefix",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Name.prefix.extension:prefix-qualifier",
        "path" : "Patient.name.prefix.extension",
        "sliceName" : "prefix-qualifier",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Name.prefix.extension:prefix-qualifier.value[x]",
        "path" : "Patient.name.prefix.extension.value[x]",
        "fixedCode" : "AC"
      },
      {
        "id" : "Patient.name:Geburtsname",
        "path" : "Patient.name",
        "sliceName" : "Geburtsname",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName",
            "profile" : ["http://fhir.de/StructureDefinition/humanname-de-basis"]
          }
        ],
        "patternHumanName" : {
          "use" : "maiden"
        },
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Geburtsname.use",
        "path" : "Patient.name.use",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Geburtsname.family",
        "path" : "Patient.name.family",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Geburtsname.family.extension:namenszusatz",
        "path" : "Patient.name.family.extension",
        "sliceName" : "namenszusatz",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Geburtsname.family.extension:nachname",
        "path" : "Patient.name.family.extension",
        "sliceName" : "nachname",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Geburtsname.family.extension:vorsatzwort",
        "path" : "Patient.name.family.extension",
        "sliceName" : "vorsatzwort",
        "mustSupport" : true
      },
      {
        "id" : "Patient.name:Geburtsname.given",
        "path" : "Patient.name.given",
        "max" : "0"
      },
      {
        "id" : "Patient.name:Geburtsname.prefix",
        "path" : "Patient.name.prefix",
        "max" : "0"
      },
      {
        "id" : "Patient.name:Geburtsname.suffix",
        "path" : "Patient.name.suffix",
        "max" : "0"
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "mustSupport" : true
      },
      {
        "id" : "Patient.gender.extension",
        "path" : "Patient.gender.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.gender.extension:other-amtlich",
        "path" : "Patient.gender.extension",
        "sliceName" : "other-amtlich",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://fhir.de/StructureDefinition/gender-amtlich-de"]
          }
        ]
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "short" : "Das Geburtsjahr ist immer anzugeben. Im Geburtsjahr oder im Geburtstag und im Geburtsmonat ist bei Ausländern '00' bzw. '0000' zulässig. Beispiel: 1990-00-00",
        "comment" : "Bei Inländern ist immer ein logisch richtiges Geburtsdatum anzugeben. Bei Ausländern gilt folgendes: Zumindest das Geburtsjahr ist immer anzugeben. Im Geburtsjahr oder im Geburtstag und im Geburtsmonat ist bei Ausländern '00' bzw. '0000' zulässig, wenn der Geburtstag und der Geburtsmonat nicht zu ermitteln sind. Das Geburtsdatum muss komplett gefüllt sein. Beispiel: 1990-00-00",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
