# Profil für den Identifikator eines eMP-Eintrags - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Profil für den Identifikator eines eMP-Eintrags**

## Data Type Profile: Profil für den Identifikator eines eMP-Eintrags 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/ti/StructureDefinition/medication-plan-identifier | *Version*:1.1.1 |
| Active as of 2025-09-12 | *Computable Name*:MedicationPlanIdentifier |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Definiert die Struktur des Identifikators für einen Eintrag im elektronischen Medikationsplan (eMP). Der Identifikator ermöglicht die eindeutige technische Referenzierung einzelner eMP-Einträge. 

**Usages:**

* This DataType Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.ti|current/StructureDefinition/medication-plan-identifier)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medication-plan-identifier.csv), [Excel](StructureDefinition-medication-plan-identifier.xlsx), [Schematron](StructureDefinition-medication-plan-identifier.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medication-plan-identifier",
  "url" : "https://gematik.de/fhir/ti/StructureDefinition/medication-plan-identifier",
  "version" : "1.1.1",
  "name" : "MedicationPlanIdentifier",
  "title" : "Profil für den Identifikator eines eMP-Eintrags",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-09-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Definiert die Struktur des Identifikators für einen Eintrag im elektronischen Medikationsplan (eMP). Der Identifikator ermöglicht die eindeutige technische Referenzierung einzelner eMP-Einträge.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier",
        "path" : "Identifier"
      },
      {
        "id" : "Identifier.id",
        "path" : "Identifier.id",
        "max" : "0"
      },
      {
        "id" : "Identifier.extension",
        "path" : "Identifier.extension",
        "max" : "0"
      },
      {
        "id" : "Identifier.use",
        "path" : "Identifier.use",
        "short" : "official",
        "fixedCode" : "official"
      },
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "min" : 1,
        "patternUri" : "https://gematik.de/fhir/sid/emp-identifier",
        "mustSupport" : true
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "short" : "Der eindeutige Identifikationswert",
        "min" : 1,
        "example" : [
          {
            "label" : "General",
            "valueString" : "687512ce-744c-8001-83c3-238227110dd6"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Identifier.period",
        "path" : "Identifier.period",
        "max" : "0"
      },
      {
        "id" : "Identifier.assigner",
        "path" : "Identifier.assigner",
        "max" : "0"
      }
    ]
  }
}

```
