# HTTP Method for FHIR Operation - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **HTTP Method for FHIR Operation**

## Extension: HTTP Method for FHIR Operation 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/ti/StructureDefinition/extension-http-method | *Version*:1.1.1 |
| Active as of 2025-09-12 | *Computable Name*:HttpMethod |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Gibt an, ob eine FHIR Operation mit GET, POST oder beidem verwendet werden darf.

**Context of Use**

This extension may be used on the following element(s):

* Element ID OperationDefinition
* Element ID CapabilityStatement.rest.operation
* Element ID CapabilityStatement.rest.resource.operation

**Usage info**

**Usages:**

* Use this Extension: [Capability Statement Profil für TI FHIR Data Service](StructureDefinition-ti-capability-statement.md) and [OperationDefinition Profil für TI FHIR Data Service](StructureDefinition-ti-operationdefinition.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.ti|current/StructureDefinition/extension-http-method)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-extension-http-method.csv), [Excel](StructureDefinition-extension-http-method.xlsx), [Schematron](StructureDefinition-extension-http-method.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "extension-http-method",
  "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method",
  "version" : "1.1.1",
  "name" : "HttpMethod",
  "title" : "HTTP Method for FHIR Operation",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-09-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Gibt an, ob eine FHIR Operation mit GET, POST oder beidem verwendet werden darf.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "OperationDefinition"
    },
    {
      "type" : "element",
      "expression" : "CapabilityStatement.rest.operation"
    },
    {
      "type" : "element",
      "expression" : "CapabilityStatement.rest.resource.operation"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "HTTP Method for FHIR Operation",
        "definition" : "Gibt an, ob eine FHIR Operation mit GET, POST oder beidem verwendet werden darf."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Extension.value[x]:valueCode",
        "path" : "Extension.value[x]",
        "sliceName" : "valueCode",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/http-verb"
        }
      }
    ]
  }
}

```
