# Release Notes - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* **Release Notes**

## Release Notes

### Version 1.2.0

#### TI Patient

* Die Kardinalität des FHIR-Elements **active** wurde auf 0..0 gesetzt.

#### Anforderungen

Neue Anforderungen wurden hinzugefügt, bestehende geändert und nicht mehr benötigte gelöscht. Die folgenden Release Notes geben einen detaillierten Überblick über alle Anpassungen.

* Die Anforderung IG-TI90315JPK-02 – Speichern der Profilversion - wurde in den IG für die [ePA-Basisfunktionalitäten#IG-EPA74597GNF] verschoben.

| | | |
| :--- | :--- | :--- |
| **ÄND** | [IG-TI52070SA6-01](./general-principles.md) | Bundle.entry.request und Bundle.entry.response innerhalb des _history Bundles |
| **ÄND** | [IG-TI62490PR0-01](./fhir-format.md) | Standardformat für den FHIR Data Service |
| **DEL** | IG-TI90315JPK-02 | Speichern der Profilversion |
| **NEU** | [IG-TI00141ZJ2](./query-api-search.md) | Sortierung des Datentyps Period |
| **ÄND** | [IG-TI23978E7A-01](./general-principles.md) | Repräsentation gelöschter Versionen in Bundle.entry.request und Bundle.entry.response innerhalb eines _history-Bundles |
| **DEL** | IG-TI44797PGD | Verhalten bei nicht unterstützten Formaten |
| **ÄND** | [IG-TI96963Y60-01](./fhir-format.md) | Unterstützung des Accept Header für Formatwahl im FHIR Data Service |

Legende:
**NEU**= Hinzugefügt|
**ÄND**= Geändert|
**VERS**= Verschoben|
**DEL**= Entfernt

### Version 1.1.1

#### TI Patient

* Must-Support-Kennzeichnen an den Elementen **id**, **meta**, **active** wurden entfernt.

#### Datentypen

* Das neue Profil **MedicationPlanIdentifier** wurde hinzugefügt, um die strukturierte Abbildung des Identifiers für den elektronischen Medikationsplan (eMP) zu unterstützen.

#### TI Common

* Entspannen von Kardinalitäten von **TIPractitioner.name**
* **TIPractitioner.name** verwendet nun **HumannameDeBasis** als Datentyp
* Bindings der ValueSets **TIOrganization.type** anziehen um Slicing-Fehler zu korrigieren
* Klarstellung: VSDM 2.0 Fachdienst wird auf der Hauptseite nicht als FHIR Data Service benannt

#### Operation API

* Die allgemeinen Anforderungen für die Operation-API stehen jetzt im IG für die ePA-Basisfunktionalitäten

#### Anforderungen

| | | |
| :--- | :--- | :--- |
| **DEL** | IG-TI19439LBP | Transaktionale Verarbeitung nach dem ACID-Prinzip im FHIR Data Service |
| **NEU** | IG-TI97619U65 | Keine Registrierung bei Nutzung inaktiver Codes |
| **NEU** | IG-TI45064TNU | Auflösen von versionierten Referenzen in Bundles |
| **DEL** | IG-TI82011VRG | Versionsprüfung bei Schreiboperationen im FHIR Data Service |
| **DEL** | IG-TI35915ZJ8 | Serielle Ausführung transaktionaler Bereiche im FHIR Data Service |
| **ÄND** | IG-TI36210TD1-02 | HTTP 410 Gone für den Abruf einer gelöschten FHIR-Instanz |

Legende:
**NEU**= Hinzugefügt|
**ÄND**= Geändert|
**VERS**= Verschoben|
**DEL**= Entfernt

### Version 1.1.0

#### TI Patient

* FHIR-Patientenprofil hinzugefügt

#### TI Common

* Hinzufügen von TI-Common Profilen für Organization, Practitioner und PractitionerRole

#### Anforderungen

* Die Anforderung IG-TI28940QKS – Hostname in **Bundle.entry.fullUrl** für die ePA wurde in den IG für die ePA-Basisfunktionalitäten verschoben.

| | | |
| :--- | :--- | :--- |
| **NEU** | IG-TI52070SA6 | Bundle.entry.request und Bundle.entry.esponse innerhalb des _history Bundles |
| **ÄND** | IG-TI44886ZXA-02 | Unterstützung der _revinclude-Suche im FHIR Data Service gemäß FHIR |
| **DEL** | IG-TI28940QKS | Hostname in Bundle.entry.fullUrl für die ePA |
| **NEU** | IG-TI61673KWG | Unterstützung versionierter Referenzen im FHIR Data Service |
| **NEU** | IG-TI62717R2P | FHIR-Formatunterstützung XML |
| **NEU** | IG-TI38467S3Q | Bereitstellung des /metadata-Endpunkts durch FHIR Data Service |
| **NEU** | IG-TI18063SU7 | Unterstützung des _format-Parameters im FHIR Data Service |
| **NEU** | IG-TI94321ZRC | Bereitstellung eines Bundles mit dem Typ history als Antwort |
| **ÄND** | IG-TI87140VUU-02 | Befüllungspflicht für Must Support |
| **NEU** | IG-TI62490PR0 | Standardformat für den FHIR Data Service |
| **NEU** | IG-TI94558MGC | Vorrang des _format-Parameters gegenüber dem Accept Header |
| **NEU** | IG-TI19439LBP | Transaktionale Verarbeitung nach dem ACID-Prinzip im FHIR Data Service |
| **ÄND** | IG-TI90315JPK-02 | Speichern der Profilversion |
| **NEU** | IG-TI57083QMG | Unterstützung von XML Content Type für FHIR-Data-Schnittstellen |
| **ÄND** | IG-TI22824X01-02 | Unterstützung von JSON Content Type für FHIR-Data-Schnittstellen |
| **NEU** | IG-TI44024J5L | Eindeutigkeit der Resource.meta.versionId pro FHIR-Instanz |
| **ÄND** | IG-TI38183K0G-02 | Unterstützung der _include-Suche im FHIR Data Service gemäß FHIR |
| **NEU** | IG-TI00242W49 | Unterstützung von _include:iterate |
| **NEU** | IG-TI06008V22 | Abruf einer spezifischen Ressourcenversion über die FHIR API |
| **NEU** | IG-TI23978E7A | Bundle.entry.request und Bundle.entry.response innerhalb des _history-Bundles bei gelöschten FHIR-Instanzen |
| **NEU** | IG-TI43409LRQ | Verwendung von entry.search.mode = match |
| **NEU** | IG-TI72725KAW | Format für versionierte Referenzen |
| **NEU** | IG-TI11342RSA | Behandlung des Löschvorgangs als versioniertes Ereignis |
| **NEU** | IG-TI44797PGD | Verhalten bei nicht unterstützten Formaten |
| **ÄND** | IG-TI95143N18-02 | Formatierung von Referenzen im fullUrl-Feld |
| **NEU** | IG-TI87465NYV | Unterstützung der umgekehrten verketteten Parametersuche |
| **ÄND** | IG-TI27170FRR-03 | Sortierung der Suchergebnisse durch _sort |
| **NEU** | IG-TI96963Y60 | Unterstützung des Accept Header für Formatwahl im FHIR Data Service |
| **NEU** | IG-TI06069XBQ | Aufsteigende Sequenz der Resource.meta.versionId |
| **NEU** | IG-TI08134XQ4 | Verarbeitung von referenzierten Ressourcen in Include-Suchen |
| **NEU** | IG-TI16747WFN | Implementierung der _history-Abfrage gemäß HL7 FHIR Spezifikation |
| **NEU** | IG-TI66054HX2 | Kennzeichnung gelöschter Instanzen statt physischer Entfernung |
| **NEU** | IG-TI82011VRG | Versionsprüfung bei Schreiboperationen im FHIR Data Service |
| **NEU** | IG-TI94882PRF | Aktualisierung von Meta.versionId und Meta.lastUpdated bei einer Änderung |
| **NEU** | IG-TI35915ZJ8 | Serielle Ausführung transaktionaler Bereiche im FHIR Data Service |
| **NEU** | IG-TI59347HCY | Initiale Versionierung neu erstellter oder hinzugefügter FHIR-Instanzen |
| **NEU** | IG-TI52829PK9 | Numerisches Format der Resource.meta.versionId |
| **NEU** | IG-TI52895H8W | Keine neue Version bei inhaltsgleichen Aktualisierungen |
| **NEU** | IG-TI97020UTC | Unterstützung des :iterate-Modifikators |
| **ÄND** | IG-TI37232GDE-02 | Unterstützung Seitennavigationslinks für Paginierungsfunktion |
| **ÄND** | IG-TI09377BM6-02 | Verarbeitung für Must Support |
| **ÄND** | IG-TI78112H2T-03 | Verwendung relativer URLs bei der Paginierung von FHIR-Bundles |
| **NEU** | IG-TI60515LXY | Abruf der Versionshistorie aller Instanzen eines ResourceType |
| **NEU** | IG-TI06315TQ1 | Unterstützung verketteter Suchparameter |
| **NEU** | IG-TI92941JBA | Einbeziehung verknüpfter Ressourcen auf derselben Ergebnisseite |
| **NEU** | IG-TI17755AMW | Unterstützung von _revinclude:iterate |
| **NEU** | IG-TI02423P7B | Referenzierung einer spezifischen Version einer FHIR-Instanz |
| **NEU** | IG-TI47719G19 | Umsetzung der Versionierte Referenzen gemäß FHIR |
| **NEU** | IG-TI36210TD1 | HTTP 410 Gone für den Abruf einer gelöschten FHIR-Instanz |
| **NEU** | IG-TI78384PEX | Abruf der Versionshistorie einer FHIR-Instanz |
| **VERS** | IG-TI59271UPX | FHIR-Formatunterstützung JSON |
| **NEU** | IG-TI19904KM0 | Keine Überschreibung des Content Type Header durch den _format-Parameter bei POST-Nachrichten |
| **NEU** | IG-TI16700VFJ | Abruf früherer Versionen einer gelöschten Instanz |
| **NEU** | IG-TI66923Q9F | Identifikation der Ressourcenversion durch Meta.versionId |
| **NEU** | IG-TI06872YZP | 404 Not Found Antwort für nicht existierende spezifische Versionen |

Legende:
**NEU**= Hinzugefügt|
**ÄND**= Geändert|
**VERS**= Verschoben|
**DEL**= Entfernt

### Version 1.0.1

#### Terminologien

* Korrektur der Displaynamen im ValueSet **TI Operation Outcome Details**

#### Anforderungen

| | | |
| :--- | :--- | :--- |
| **DEL** | IG-TI54164LKA | Ignorieren unbekannter Suchparameter |
| **NEU** | IG-TI08134XQ4 | Verarbeitung von referenzierten Ressourcen in Include-Suchen |
| **ÄND** | IG-TI29386S9L-02 | UUID für Resource.id |
| **NEU** | IG-TI92941JBA | Einbeziehung verknüpfter Ressourcen auf derselben Ergebnisseite |

Legende:
**NEU**= Hinzugefügt|
**ÄND**= Geändert|
**VERS**= Verschoben|
**DEL**= Entfernt

### Version 1.0.0

#### Anforderungen

| | | |
| :--- | :--- | :--- |
| **NEU** | IG-TI06089XAH | Anzeige für Must Support |
| **NEU** | IG-TI44886ZXA | Unterstützung der _revinclude-Suche im FHIR Data Service gemäß FHIR |
| **NEU** | IG-TI28940QKS | Hostname in Bundle.entry.fullUrl für die ePA |
| **NEU** | IG-TI14253RWM | Exakte Übereinstimmungen bei Ganzzahlen |
| **NEU** | IG-TI28968WCS | Unterstützung von Präfixen für numerische und Datumsvergleiche |
| **NEU** | IG-TI87140VUU | Befüllungspflicht für Must Support |
| **NEU** | IG-TI36297YXJ | Vergleichspräfixe für numerische Werte |
| **NEU** | IG-TI90315JPK | Speichern der Profilversion |
| **NEU** | IG-TI81327UVF | Umsetzung der Sortierfunktion gemäß FHIR |
| **NEU** | IG-TI61163GRT | Bereichsprüfung für Range- und Period-Typen |
| **NEU** | IG-TI54164LKA | Ignorieren unbekannter Suchparameter |
| **NEU** | IG-TI22824X01 | Unterstützung von JSON-Content-Types für FHIR-Data-Schnittstellen |
| **NEU** | IG-TI38183K0G | Unterstützung der _include-Suche im FHIR Data Service gemäß FHIR |
| **NEU** | IG-TI31988JEY | Unterstützung der Präzision bei numerischen und Datums-Suchparametern |
| **NEU** | IG-TI95143N18 | Formatierung von Referenzen im fullUrl-Feld |
| **NEU** | IG-TI85276Y4V | Vergleichspräfixe für Datumswerte |
| **NEU** | IG-TI07252NTV | Unterstützung URL-Parameter für Paginierungsfunktion |
| **NEU** | IG-TI27170FRR | Sortierung der Suchergebnisse durch _sort |
| **NEU** | IG-TI40876FQM | Standardpräfix für Vergleiche |
| **NEU** | IG-TI64797XGV | Formatierungsvorgaben für das fullUrl-Feld in FHIR-Bundles |
| **NEU** | IG-TI37232GDE | Unterstützung Seitennavigationslinks für Paginierungsfunktion |
| **NEU** | IG-TI09377BM6 | Verarbeitung für Must Support |
| **NEU** | IG-TI78112H2T | Verwendung relativer URLs bei der Paginierung von FHIR-Bundles |
| **NEU** | IG-TI29386S9L | UUID für Resource.id |
| **NEU** | IG-TI29911V07 | Konsistente Referenzierung innerhalb eines Bundles |
| **NEU** | IG-TI59271UPX | FHIR-Formatunterstützung JSON |

Legende:
**NEU**= Hinzugefügt|
**ÄND**= Geändert|
**VERS**= Verschoben|
**DEL**= Entfernt

