# Query API: Allgemeine Anforderungen Suche und Sortierung - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* **Query API: Allgemeine Anforderungen Suche und Sortierung**

## Query API: Allgemeine Anforderungen Suche und Sortierung

Diese Seite beschreibt Standard-API-Zugriffe für eine clientseitige Suche und Bereitstellung von Daten eines FHIR Data Service. Im Detail bedeutet dies das Navigieren in Suchergebnisseiten, die kompakte Suche mit verknüpften FHIR-Ressourcen als auch die Suche unter Nutzung von Vergleichsoperatoren.

### Suche

Die FHIR-Schnittstellen eines FHIR Data Service unterstützen standardmäßige [FHIR-Suchoperationen] gemäß den Vorgaben der FHIR-Spezifikation. Bei einer Suche wird ein **Search Set Bundle** zurückgegeben.

Der FHIR Data Service MUSS sicherstellen, dass für jede Ressource, die direkt den in der Suchanfrage angegebenen Kriterien entspricht, das Attribut
*entry.search.mode*auf
*match*gesetzt wird.
“Direkt den in der Suchanfrage angegebenen Kriterien” entsprechend heißt in diesem Fall, dass das entsprechende Ergebnis nicht über einen *_include* oder *_revinclude*-Parameter der Ergebnismenge hinzugefügt wurde.

#### fullUrl in FHIR Bundles

Der FHIR Data Service MUSS sicherstellen, dass das
*fullUrl*-Feld in jedem
*Entry*(
*Bundle.entry.fullUrl*) wie in der Standard HL7 FHIR Spezifikation als absolute URL oder als UUID-basierte URI (urn:uuid) angegeben wird. Relative Pfade sind im
*fullUrl*-Feld nicht zulässig. Für absolute URLs gilt zusätzlich, dass sie das Format
*[base]/[Ressourcentyp]/[ResourceId]*aufweisen müssen.

Der FHIR Data Service MUSS sicherstellen, dass, wenn im
*Bundle.entry.fullUrl*eine UUID-basierte URI (
*urn:uuid*) verwendet wird, alle Referenzen innerhalb desselben Bundles ebenfalls in der Form
*urn:uuid:[UUID]*angegeben werden. Eine Mischung aus absoluten URLs, UUID-basierten URIs und relativen Referenzen innerhalb eines Bundles darf nicht verwendet werden.

Der FHIR Data Service MUSS sicherstellen, dass relative Referenzen - wie
*literal*-Referenzen in der Form [Resourcetyp]/[ResourceId] - nicht im Feld
*Bundle.entry.fullUrl*verwendet werden. Alle Verweise auf Ressourcen innerhalb des FHIR Data Service MÜSSEN entweder als absolute URLs oder als UUID-basierte URIs (urn:uuid) angegeben werden.
**Beispiel**

Eine UUID-basierte URI MUSS das Format `urn:uuid:[UUID]` haben, zum Beispiel:

```
urn:uuid:ea01ccbc-aa5d-4c34-8292-d95678d52c98

```

#### Beispiele für Standardsuchparameter

**_id**: Bezieht sich auf die logische ID der Ressource

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?_id=ea01ccbc-aa5d-4c34-8292-d95678d52c98

```

**_lastUpdated**: Kann verwendet werden, um Ressourcen basierend auf dem letzten Änderungszeitpunkt auszuwählen

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?_lastUpdated=2025-15-01

```

#### Einbeziehung verknüpfter Ressourcen in das Ergebnis

##### _include

In der FHIR-Spezifikation wird der Suchparameter *_include* verwendet, um zu fordern, dass der Server nicht nur die angeforderten Ressourcen, sondern auch andere Ressourcen, die über eine angegebene Referenz mit ihnen verbunden sind, zurückgibt. Dieser Parameter ist besonders nützlich, um verknüpfte Ressourcen in einer einzigen Abfrage abzurufen, wodurch die Notwendigkeit nachfolgender Anfragen verringert wird. Beispielsweise, wenn eine Abfrage an *MedicationRequest*-Instanzen mit einem *_include*-Parameter wie *MedicationRequest:medication* durchgeführt wird, gibt der FHIR Data Service die angeforderten *MedicationRequest*-Instanzen zusammen mit verknüpften *Medication*-Instanzen zurück. Das bedeutet, dass eine Liste von *Medication*-Instanzen ebenso erhalten ist.

**Beispiel**

```
GET [base]/epa/medication/api/v1/fhir/MedicationRequest?_include=MedicationRequest:medication

```

In dieser Abfrage bedeutet:

1. **MedicationRequest**der FHIR-Ressourcentyp, der abgefragt wird
1. *_include=MedicationRequest:medication*die Anweisung an den FHIR Data Service, die*Medication*-Instanzen einzubeziehen, auf die in den*MedicationRequest*-Instanzen referenziert wird

Diese Abfrage gibt ein *Search Set Bundle* zurück, welches alle im FHIR Data Service verfügbaren *MedicationRequest*-Instanzen enthält - also auch zugehörige *Medication*-Instanzen. Hinweis: Dies kann potenziell eine große Ergebnismenge bedeuten und ist davon abhängig, wie viele *MedicationRequest*-Datensätze gespeichert sind.

Der FHIR Data Service MUSS die
*_include*-Suche gemäß der [FHIR Search Include] unterstützen, sodass referenzierte Ressourcen innerhalb der Suchergebnisse automatisch mit einbezogen werden können.
##### _revinclude

In der FHIR-Spezifikation ist *_revinclude* ein Suchparameter, der es ermöglicht, Ressourceninstanzen in die Ergebnismenge einzubeziehen, die jeweils auf die primäre Ressourceninstanz referenziert.

Der FHIR Data Servic MUSS die
*_revinclude*-Suche gemäß der [FHIR Search Revinclude] unterstützen, sodass Ressourcen, die auf die gesuchten Ressourcen verweisen, innerhalb der Suchergebnisse automatisch mit einbezogen werden können.
**Beispiel**

```
GET [base]/epa/medication/api/v1/fhir/MedicationRequest?_revinclude=MedicationDispense:prescription

```

In dieser Abfrage bedeutet:

1. *MedicationRequest*der FHIR-Ressourcentyp, der abgefragt wird
1. *_revinclude=MedicationDispense:prescription*die Anweisung an den FHIR Data Service, die*MedicationDispense*-Instanzen einzuschließen, die eine*authorizingPrescription*-Referenz haben, welche wiederum auf die*MedicationRequest*-Instanzen verweist

Diese Abfrage gibt ein *Search Set Bundle* zurück, welche *MedicationRequest*-Instanzen zusammen mit den *MedicationDispense*-Instanzen enthält.

Der FHIR Data Service MUSS für jede zurückgegebene Ressource die zugehörigen Ressourcen gemäß den Verknüpfungskriterien ermitteln und mit
*entry.search.mode = "include"*in die Antwort aufnehmen. Falls eine referenzierte Ressource nicht existiert, nicht gefunden wird oder nicht abrufbar ist, darf kein Fehler zurückgegeben werden.

Der FHIR Data Service MUSS sicherstellen, dass Ressourcen, die durch
*_include*oder
*_revinclude*in das Suchergebnis aufgenommen werden, stets auf derselben Ergebnisseite wie die zugehörigen Suchtreffer (
*entry.search.mode = "match"*) enthalten sind.
#### Unterstützung des :iterate-Modifikators

Der *:iterate*-Modifikator ermöglicht es, bei der Verwendung von *_include* und *_revinclude* die Einschlusslogik rekursiv anzuwenden. Dadurch werden nicht nur direkt referenzierte Ressourcen in das Suchergebnis aufgenommen, sondern auch alle Ressourcen, die durch die eingeschlossenen Ressourcen weiter referenziert werden. Dies ist besonders nützlich für mehrstufige Abhängigkeiten und zirkuläre Beziehungen.

Der FHIR Data Service MUSS den
*:iterate*-Modifikator für
*_include*und
*_revinclude*unterstützen, um rekursive Einschlussabfragen gemäß der FHIR-Spezifikation zu ermöglichen.

Der FHIR Data Service MUSS alle weiter referenzierten Ressourcen gemäß der angegebenen Referenzpfade iterativ in die Antwort aufnehmen, wenn
*_include:iterate*verwendet wird.

Der FHIR Data Service MUSS alle iterativ verknüpften rückreferenzierenden Ressourcen zurückgeben, wenn
*_revinclude:iterate*verwendet wird.
##### Beispiel: Einbeziehung von MedicationDispense und der zugehörigen abgebenden Leistungserbringerinstitution (LEI) in die Medikamentensuche

Die folgende FHIR-Suchanfrage kombiniert *_revinclude* und *_include:iterate*, um sowohl rückverknüpfte als auch iterativ eingeschlossene Ressourcen in die Antwort aufzunehmen:

```
GET [base]/Medication?_revinclude=MedicationDispense:medication&_include:iterate=MedicationDispense:performer

```

In dieser Abfrage bedeutet:

1. _revinclude=MedicationDispense:medication
* Sucht alle **Medication**-Instanzen und schließt zusätzlich alle **MedicationDispense**-Instanzen ein, die diese **Medikamente** referenzieren.

1. _include:iterate=MedicationDispense:performer
* Nachdem die **MedicationDispense**-Instanzen über ***revinclude</i> einbezogen wurden, bewirkt der _:iterate**-Modifikator, dass die in**MedicationDispense.performer**referenzierten Organisationen ebenfalls in die Antwort aufgenommen werden.*

##### Beispiel: Abruf aller Verschreibungen mit zugehörigem verschreibenden Leistungserbringer (LE) und verschreibender Leistungserbringerinstitution (LEI)

Die folgende FHIR-Suchanfrage kombiniert ***include</i> und*_include:iterate*, um eine vollständige Abfrage aller _MedicationRequest**-Instanzen mit den relevanten Informationen zum verschreibenden LE und zur verschreibenden LEI durchzuführen. Diese Abfrage ermöglicht es, alle Verschreibungen (**MedicationRequest**) mit dem zugehörigen verschreibenden LE (**Practitioner**) und der verschreibenden LEI (**Organization**) abzurufen.*

```
GET [base]/MedicationRequest?_include=MedicationRequest:medication
    &_include=MedicationRequest:requester
    &_include:iterate=PractitionerRole:organization
    &_include:iterate=PractitionerRole:practitioner

```

In dieser Abfrage bedeutet:

1. _include=MedicationRequest:medication
* Bezieht die in **MedicationRequest.medication** referenzierte **Medication**-Instanz in die Antwort ein.

1. _include=MedicationRequest:requester
* Bezieht die in **MedicationRequest.requester** referenzierte **PractitionerRole**-Instanz mit ein.

1. _include:iterate=PractitionerRole:organization
* Falls die **PractitionerRole**-Instanz eine Referenz zu einer **Organization** enthält, wird diese in die Antwort aufgenommen.
* So kann die verschreibende LEI (z. B. eine Praxis oder Klinik) ermittelt werden.

1. _include:iterate=PractitionerRole:practitioner
* Falls die **PractitionerRole**-Instanz eine Referenz zu einer **Practitioner**-Instanz enthält, wird diese in die Antwort aufgenommen.
* So kann der verschreibenden LE ermittelt werden.

### Vergleiche und Präzision für Zahlen, Daten und Mengen

Bei einer Suche, die numerische oder Datumsparameter umfasst, hängen die verwendeten Werte von der Präzision des bereitgestellten Parameters ab. Zum Beispiel erstreckt sich für das Datum 2025-02-11 der Bereich von 2025-02-11, um 00:00:00 Uhr (inklusive) bis 2025-02-12, um 00:00:00 Uhr (exklusive).

#### Präfix

In FHIR werden Gleitkommazahlen durch Datentypen wie [FHIR decimal) und [FHIR Quantity] dargestellt, die die Präzision des gespeicherten Werts erfassen. Dies schließt jedoch einige Felder aus, die einfache Ganzzahlen verwenden. Suchoperationen in diesen Feldern führen zu exakten numerischen Übereinstimmungen. Bei numerischen Vergleichen ([FHIR Search number], [FHIR Search quantity]) mit einem einzelnen Wert sind nachfolgende spezifische Präfixe anwendbar. Wenn kein Präfix angegeben wird, wird standardmäßig **eq** verwendet. Weitere Details finden sich hier: [FHIR Search Prefixes]

| | |
| :--- | :--- |
| `eq` | Der Wert des Parameters in der Ressource ist gleich dem bereitgestellten Wert. |
| `ne` | Der Wert des Parameters in der Ressource ist nicht gleich dem bereitgestellten Wert. |
| `gt` | Der Wert des Parameters in der Ressource ist größer als der bereitgestellte Wert. |
| `lt` | Der Wert des Parameters in der Ressource ist kleiner als der bereitgestellte Wert. |
| `ge` | Der Wert des Parameters in der Ressource ist größer oder gleich dem bereitgestellten Wert. |
| `le` | Der Wert des Parameters in der Ressource ist kleiner oder gleich dem bereitgestellten Wert. |

**Tabelle:**Präfixe für numerische Vergleiche


Datumsangaben haben einen Bereich, der auf ihrer Präzision (Jahr, Monat, Tag) basiert. Für Typen wie [FHIR Range] oder [FHIR Period] sind eindeutige obere und untere Grenzen definiert. Es gibt spezifische Präfixe für derartige Vergleiche. Wird kein Präfix angegeben, ist **eq** die Standardwahl.

| | |
| :--- | :--- |
| `eq` | Der Bereich des Suchwerts enthält den Bereich des Zielwerts vollständig. |
| `ne` | Der Bereich des Suchwerts enthält den Bereich des Zielwerts nicht vollständig. |
| `gt` | Der Bereich oberhalb des Suchwerts überlappt mit dem Bereich des Zielwerts. |
| `lt` | Der Bereich unterhalb des Suchwerts überlappt mit dem Bereich des Zielwerts. |
| `ge` | Der Bereich oberhalb des Suchwerts überlappt mit oder schließt den Bereich des Zielwerts vollständig ein. |
| `le` | Der Bereich unterhalb des Suchwerts überlappt mit oder schließt den Bereich des Zielwerts vollständig ein. |
| `sa` | Der Bereich des Parameterwerts beginnt nach dem Zielbereich. |
| `eb` | Der Bereich des Parameterwerts endet vor dem Zielbereich. |

**Tabelle:**Präfixe für datumsbasierte Vergleiche


Der FHIR Data Service MUSS numerische und datumsbasierte Suchparameter so verarbeiten, dass die Suchwerte entsprechend ihrer Präzision interpretiert werden. Beispielsweise muss eine Suche nach 2025-02-11 den Bereich von 2025-02-11T00:00:00 (inklusive) bis 2025-02-12T00:00:00 (exklusive) abdecken.

Der FHIR Data Service MUSS die in der [FHIR Search Prefixes] definierten Vergleichspräfixe für numerische (
*number*,
*quantity*) und Datumsparameter (
*date*,
*Range*,
*Period*) unterstützen.

Der FHIR Data Service MUSS standardmäßig das Präfix
*eq*verwenden, falls kein Vergleichspräfix angegeben wird.

Der FHIR Data Service MUSS die folgenden Vergleichspräfixe für numerische Werte (number, quantity) unterstützen:
*eq*,
*ne*,
*gt*,
*lt*,
*ge*,
*le*

Der FHIR Data Service MUSS die folgenden Vergleichspräfixe für Datumswerte (date, Range, Period) unterstützen:
*eq*,
*ne*,
*gt*,
*lt*,
*ge*,
*le*,
*sa*,
*eb*

Der FHIR Data Service MUSS sicherstellen, dass Suchoperationen für Felder mit Ganzzahlen (
*integer*) nur exakte numerische Übereinstimmungen liefern und keine Präzisionsanpassungen wie bei Gleitkommazahlen (
*decimal*,
*quantity*) vornehmen.

Der FHIR Data Service MUSS für Suchanfragen, die Range- oder Period-Werte betreffen, sicherstellen, dass obere und untere Grenzen des Bereichs korrekt berücksichtigt werden und mit den definierten Vergleichspräfixen korrekt verarbeitet werden.
**Beispiele**

Alle *AuditEvent*s, die vor dem 15. Januar 2025 aktualisiert oder erstellt wurden:

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?_lastUpdated=lt2025-01-15T00:00:00Z

```

Alle *AuditEvent*s nach dem 15. Januar 2025:

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?date=gt2025-01-15T00:00:00Z

```

Alle *AuditEvent*s seit dem 15. Januar 2025 und von der Allgemeinarztpraxis “Praxis Dr. John Doe”:

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?date=ge2025-01-15T11:00:00Z&altid=1-883110000092404

```

Alle *AuditEvent*s ab dem 15. Januar 2025 und alle *AuditEvent*s, die eine Erstellung protokollieren:

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?date=2025-01-15T11:00:00Z&action=C

```

Alle *AuditEvent*s für das IHE XDS-Dokument mit dem Titel *Arztbrief4711*:

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?entity-name=Arztbrief4711

```

### Verkettete Parameter (Chained Parameters)

Das Client-System kann in dem FHIR Data Service einen Referenzparameter mithilfe sogenannter “Chained Parameters” verwenden. Dabei wird ein Referenzparameter durch einen Punkt (`.`) mit dem Namen eines Suchparameters der Zielressource verknüpft. Diese Verkettung kann mehrstufig durchgeführt werden, indem ein logischer Pfad über mehrere verknüpfte Ressourcen definiert wird.

Die Syntax für eine verkettete Parametersuche sieht folgendermaßen aus:

```
[Referenzparameter]:[Ressourcentyp].[innerer Suchparameter]=[innerer Wert]

```

Wenn der Referenzparameter nur auf einen einzelnen Ressourcentyp verweist, kann *:[Ressourcentyp]* weggelassen werden. Die Syntax lautet dann:

```
[Referenzparameter].[innerer Suchparameter]=[innerer Wert]

```

Der FHIR Data Service MUSS die Suche von verketteten Parametern gemäß der Spezifikation unter [FHIR Chained parameters] implementieren und unterstützen.
**Beispiel**

In diesem Beispiel gibt der FHIR Data Service nur *MedicationRequest*-Instanzen zurück, die sich auf das Medikament Ibuprofen beziehen:

```
GET [base]/MedicationRequest?medication.code=http://fhir.de/CodeSystem/bfarm/atc|M01AE01

```

### Reverse Chaining (_has)

Das Client-System kann in dem FHIR Data Service den *_has*-Parameter verwenden, um eine umgekehrte verkettete Parametersuche durchzuführen. Bei einer umgekehrten verketteten Parametersuche werden Ressourceninstanzen basierend auf den Kriterien von anderen Ressourceninstanzen abgeglichen, die auf sie verweisen. Dies ist das Gegenteil der verketteten Parametersuche, bei der Instanzen basierend auf den Eigenschaften von Ressourcen ausgewählt werden, auf die sie verweisen.

Die Syntax für eine umgekehrte verkettete Parametersuche sieht folgendermaßen aus:

```
_has:[Ressourcentyp]:[Referenzparameter]:[Suchparameter]=[Wert]

```

Der FHIR Data Service MUSS die umgekehrte verkettete Parametersuche gemäß der Spezifikation unter [FHIR Reverse Chaining] implementieren und unterstützen.
**Beispiele**

In diesem Beispiel wird nach *Medication*-Ressourceninstanzen gesucht, die von *MedicationStatement*-Instanzen referenziert werden und der Status der *MedicationStatement*-Instanzen auf “active” steht.

```
GET [base]/Medication?_has:MedicationStatement:medication:status=active

```

In diesem Beispiel wird nach *Medication*-Ressourceninstanzen gesucht, die von *MedicationStatement*-Instanzen referenziert werden und das *effective*-Datum zwischen dem 22. Juli 2025 und dem 23. Juli 2025 liegt.

```
GET [base]/Medication?_has:MedicationStatement:medication:effective=ge2025-07-22&_has:MedicationStatement:medication:effective=le2025-07-23

```

In diesem Beispiel wird nach *Medication*-Ressourceninstanzen gesucht, die von *MedicationStatement*-Instanzen referenziert werden und der Status der *MedicationStatement*-Instanzen auf “stopped” steht. Mit dem *_revinclude*-Parameter werden zusätzlich alle zugehörigen *MedicationStatement*-Instanzen, die auf die jeweilige *Medication*-Ressource verweisen, in den Ergebnissen zurückgegeben.

```
GET [base]/Medication?_has:MedicationStatement:medication:status=stopped&_revinclude=MedicationStatement:medication

```

### Sortierung

Das Client-System KANN die Reihenfolge der zurückgegebenen Ergebnisse durch den Parameter
*_sort*angeben, der eine durch Kommas getrennte Liste von Sortierregeln in Prioritätsreihenfolge enthalten kann.

Der FHIR Data Service MUSS die Sortierfunktion nach [FHIR Sorting] implementieren.
**Beispiel**

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?_sort=action,-date

```

Der FHIR Data Service MUSS bei der Sortierung von Instanzen anhand des Datentyps
*Period*nach dem Element
*Period.start*sortieren. Sofern zwei Instanzen den gleichen
*start*-Wert besitzen, muss sofern vorhanden weitergehend nach
*Period.end*sortiert werden. Ein nicht angegebener
*Period.end*-Wert ist hierbei als noch offen, also unendlich anzusehen.

