# Query API: Allgemeine Anforderungen Paginierung - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* **Query API: Allgemeine Anforderungen Paginierung**

## Query API: Allgemeine Anforderungen Paginierung

Bei einer Suche im FHIR Data Service über die FHIR Query API stellt der Service dem Client-System in seiner Antwort ggf. Links zu weiteren Ergebnissen zur Verfügung, die es dem Client erlauben, bequem durch die Ergebnismenge zu navigieren.

Der FHIR Data Service MUSS eine Paginierungsfunktion implementieren und in seiner Antwort Navigationsinformationen in Ergebnisseiten zur Verfügung stellen. Um die Paginierungsfunktion zu implementieren, werden die URL-Parameter
`_count`und
`_offset`verwendet. Der Parameter
`_count`bestimmt die Anzahl der Einträge pro
*Seite*(page), während
`_offset`das Startelement der Seite angibt. Zusätzlich entscheidet der
`_total`-Parameter, ob die Gesamtanzahl der Einträge in der Antwort enthalten sein soll.

| | | |
| :--- | :--- | :--- |
| `_count` | Das Client-System KANN die maximale Anzahl von Elementen festlegen, die auf einer*Seite*(page) der Antwort enthalten sein soll. Das bedeutet, dass der Audit Event Service die Ergebnismenge auf diese maximal angegebene Anzahl beschränkt. | 25 |
| `_offset` | Dieser Parameter gibt den (zero-based) Offset des ersten zurückgegebenen Elements in der Sammlung an. | 0 |
| `_total` | Dieser Parameter steuert, ob und wie der Audit Event Service die Gesamtanzahl der Suchergebnisse zurückgibt. Folgende Werte können eingestellt werden:`none`,`estimate`,`accurate`. | - |

**Tabelle:**URL-Parameter für Paginierungsfunktion

Werte für
`_total`:

* `none` (Standardwert): Die Gesamtanzahl der Suchtreffer wird nicht angezeigt.
* `estimate`: Die ungefähre Gesamtanzahl der Suchtreffer wird angezeigt.
* `accurate`: Die genaue Gesamtanzahl der Suchtreffer wird angezeigt.

**Beispiele**

API-Anfrage von zehn Elementen des Ressourcentyps **AuditEvent**, beginnend mit Element 20 der Liste:

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?_count=10&_offset=20

```

API-Anfrage der ersten fünf Elemente:

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?_count=5

```

API-Anfrage nur für die Gesamtanzahl der Einträge:

```
GET [base]/epa/audit/api/v1/fhir/AuditEvent?_count=0_total=accurate

```

Der FHIR Data Service MUSS in einem FHIR Search Set Bundle das FHIR-Element
`link`belegen, welches eine Liste von Link-Elementen beinhaltet, welche jeweils einem spezifischen Navigationszweck innerhalb des FHIR Bundles dienen.

Die folgenden Beziehungen werden gemäß den [Link Relation Types] bereitgestellt.

| | | |
| :--- | :--- | :--- |
| `self` | Ein Link zur aktuellen Seite der Ergebnisse, der die Abfrage repräsentiert, die diese Ergebnisse generiert hat | MUSS |
| `next` | Wird verwendet, um zur nächsten Seite der Ergebnisse zu navigieren, entsprechend der festgelegten Paginierung | MUSS |
| `previous` | Ermöglicht die Rückkehr zur vorherigen Ergebnismenge und erleichtert die rückwärtige Navigation durch die Seiten | MUSS |
| `first` | Navigiert zur ersten Seite der Suchergebnisse und ermöglicht eine schnelle Navigation zum Anfang der Ergebnisliste | KANN |
| `last` | Navigiert zur letzten Seite der Suchergebnisse, um ans Ende der Ergebnisliste zu gelangen | KANN |

**Tabelle:**Seitennavigationslinks für Paginierungsfunktion

Jeder Link MUSS eine URL enthalten, um das entsprechende Ergebnis-Set abzurufen, das dynamisch basierend auf der Suchanfrage und den Paginierungsparametern wie
*_count*und
*_offset*generiert wird. Diese Links vereinfachen die Navigation eines Client-Systems durch große Suchergebnisse, indem sie die Notwendigkeit manueller Anpassungen der Abfrageparameter ausräumt.

Der FHIR Data Service KANN beim Paginieren von FHIR Bundles das Feld
*Bundle.link.url*mit relativen URLs befüllen, sofern diese sich auf die Basis-URL beziehen.
Zu jedem Link können zusätzlich zu den Standardpaginierungsparametern wie *_count* und *_offset* auch andere Parameter enthalten sein, die die Paginierung innerhalb des FHIR Data Service erleichtern. Ein Beispiel hierfür ist der Parameter *stateid*, der den aktuellen Zustand der Ergebnisliste repräsentiert. Dies ermöglicht es dem FHIR Data Service, die Navigation durch die Ergebnisse effizient zu verwalten, indem der Kontext oder Zustand der Suche erhalten bleibt. Dies ist besonders nützlich, wenn Clients durch umfangreiche oder komplex strukturierte Ergebnismengen navigieren.

**Beispiel (Audit Event Service)**

```
{
    "resourceType": "Bundle",
    "id": "86604fc1-b356-57e3-8738-8ef36c8d608c",
    "type": "searchset",
    "total": 100,
    "link": [
    {
        "relation": "self",
        "url": "/epa/audit/api/v1/fhir/AuditEvent?_count=10&_offset=20"
    },
    {
        "relation": "first",
        "url": "/epa/audit/api/v1/fhir/AuditEvent?_count=10&_offset=0"
    },
    {
        "relation": "previous",
        "url": "/epa/audit/api/v1/fhir/AuditEvent?_count=10&_offset=10"
    },
    {
        "relation": "next",
        "url": "/epa/audit/api/v1/fhir/AuditEvent?_count=10&_offset=30"
    },
    {
        "relation": "last",
        "url": "/epa/audit/api/v1/fhir/AuditEvent?_count=10&_offset=90"
    }
    ],
    "entry": [
    {
        "fullUrl": "http://epa4all/epa/audit/api/v1/fhir/AuditEvent/5abff610-a1ad-450d-aa63-a60622b1052e",
        "resource": {
        "resourceType": "AuditEvent",
        "id": "5abff610-a1ad-450d-aa63-a60622b1052e",
        // Details of the AuditEvent resource
        }
    },
    // More AuditEvent entries
    ]
}

```

