# FHIR-Artefakte - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* **FHIR-Artefakte**

## FHIR-Artefakte

Auf dieser Seite befindet sich eine Liste der FHIR-Artefakte, welche im Rahmen dieses Implementation Guide definiert werden.

### Ressourcenprofile

| | |
| :--- | :--- |
| [TI Organization](StructureDefinition-ti-organization.md) | Definiert die Datenstruktur für medizinische, regulatorische und technische Organisationen |
| [TI Patient](StructureDefinition-ti-patient.md) | Das Patient-Profil für die Telematikinfrastruktur (TI) FHIR Data Services |
| [TI PractitionerRole](StructureDefinition-ti-practitioner-role.md) | Dieses Profil beschreibt die Verwendung der FHIR-Ressource PractitionerRole in der Telematikinfrastruktur (TI). Es wird verwendet, um die Rolle und Funktion einer Gesundheitsfachperson innerhalb einer Organisation zu definieren. |
| [TI Practitioner](StructureDefinition-ti-practitioner.md) | Dieses Profil beschreibt die Verwendung der FHIR-Ressource Practitioner im Kontext der Telematikinfrastruktur (TI). Es dient der strukturierten Darstellung von Gesundheitsfachpersonen, wie z.B. Ärzt:innen, Zahnärzt:innen, Psychotherapeut:innen oder Apotheker:innen, innerhalb TI-konformer Anwendungen. |

**Tabelle:**Ressourcenprofile

### Datentypen

| | |
| :--- | :--- |
| [Identifikator Profil für E-Rezept-IDs](StructureDefinition-e-prescription-id.md) | Die E-Rezept-ID ist eine generierte und nicht veränderbare Zahlenfolge, die durch Punkte getrennt ist. Die ersten drei Ziffern definieren die Art der Verordnung. Die nächsten zwölf Ziffern stellen die generierte, eindeutige und fortlaufende Sequenz der Verordnung dar. Die letzten beiden Ziffern sind Prüfziffern gemäß ISO 7064. |
| [Profil für den Identifikator eines eMP-Eintrags](StructureDefinition-medication-plan-identifier.md) | Definiert die Struktur des Identifikators für einen Eintrag im elektronischen Medikationsplan (eMP). Der Identifikator ermöglicht die eindeutige technische Referenzierung einzelner eMP-Einträge. |

**Tabelle:**Datentypen

### Verhalten

Dieses Capability Statement Profil dient als TI-weit gültige Referenz für die Definition der RESTful-FHIR-Schnittstellen.

#### Common Capability Statement Profil

| | |
| :--- | :--- |
| [Capability Statement Profil für TI FHIR Data Service](StructureDefinition-ti-capability-statement.md) | Dieses Profil beschreibt die Fähigkeiten eines FHIR Data Service innerhalb der Telematikinfrastruktur (TI) spezifiziert ist. |

**Tabelle:**Capability Statement

#### Common Operation Definition Profil

| | |
| :--- | :--- |
| [OperationDefinition Profil für TI FHIR Data Service](StructureDefinition-ti-operationdefinition.md) | Dieses Profil beschreibt FHIR Operationen des FHIR Data Service innerhalb der Telematikinfrastruktur (TI). Es stellt sicher, dass zustandsverändernde Operationen (`affectsState = true`) nicht über HTTP GET ausgeführt werden dürfen. |

**Tabelle:**Operation Definition

#### Common Capability Statement Extensions

| | |
| :--- | :--- |
| [Base URL der FHIR-API](StructureDefinition-extension-base-url.md) | Gibt die Basis-URL des FHIR-Servers als Zeichenkette an. Beispiel: http://epa4all/epa/medication/api/v1/fhir |
| [HTTP Header](StructureDefinition-extension-http-header.md) | Ermöglicht die Angabe global oder spezifisch geforderter HTTP Header in einem CapabilityStatement oder einer Resource-Interaktion. |
| [HTTP Method for FHIR Operation](StructureDefinition-extension-http-method.md) | Gibt an, ob eine FHIR Operation mit GET, POST oder beidem verwendet werden darf. |
| [HTTP-Antwortinformationen](StructureDefinition-extension-http-response-info.md) | Definiert Informationen zu HTTP-Antworten für FHIR-Interaktionen, inklusive Statuscode, Beschreibung, Beispiel und Response-Schema. |

**Tabelle:**Capability Statement Extensions

### Operation Outcome

#### Ressourcenprofile

| | |
| :--- | :--- |
| [TI Operation Outcome](StructureDefinition-operation-outcome.md) | Das Operation Outcome-Profil für die Telematikinfrastruktur (TI) FHIR Data Services |

**Tabelle:**Operation Outcome - Ressourcenprofile

#### Code Systems

| | |
| :--- | :--- |
| [TI Operation Outcome Details CodeSystem](CodeSystem-operation-outcome-details-codes.md) | Telematikinfrastruktur (TI) Operation Outcome Details CodeSystem |

**Tabelle:**Operation Outcome - Code Systems

#### Value Sets

| | |
| :--- | :--- |
| [TI Operation Outcome Details Value Set](ValueSet-operation-outcome-details-vs.md) | Enthält alle Codes für das Operation Outcome der Telematikinfrastruktur (TI) sowie die in FHIR definierten Operation-Outcome-Codes. |

**Tabelle:**Operation Outcome - Value Sets

### Beispielinstanzen

**Bundle**

* [Example History Bundle](Bundle-example-history-bundle.md)

**OperationOutcome**

* [ExpTIOperationDeleted](OperationOutcome-0dc58d79-1b2e-4c6f-afe0-0a5b721661a2.md)

* [ExpTIOperationOutcomeSuccess](OperationOutcome-468ca07b-7d63-453d-a738-0c35cb9402aa.md)

* [ExpTIOperationOutcomeIdentityMismatch](OperationOutcome-ad48bf90-a664-44f4-af14-ee6e81db3df4.md)

**Patient**

* [Example Patient](Patient-ExampleTIPatient.md)

