# Steckbrief: ePA MHD Service - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**Steckbriefe**](spec-sheet.md)
* **Steckbrief: ePA MHD Service**

## Steckbrief: ePA MHD Service

Die nachstehende Tabelle fasst Anforderungen dieses Implementation Guide für den **ePA MHD Service** zusammen.

| | | |
| :--- | :--- | :--- |
| [IG-TI14253RWM](./query-api-search.md) | Exakte Übereinstimmungen bei Ganzzahlen | MUSS |
| [IG-TI62717R2P](./fhir-format.md) | FHIR-Formatunterstützung XML | MUSS |
| [IG-TI38467S3Q](./general-principles.md) | Bereitstellung des /metadata-Endpunkts durch FHIR Data Service | MUSS |
| [IG-TI28968WCS](./query-api-search.md) | Unterstützung von Präfixen für numerische und Datumsvergleiche | MUSS |
| [IG-TI18063SU7](./fhir-format.md) | Unterstützung des _format-Parameters im FHIR Data Service | MUSS |
| [IG-TI62490PR0-01](./fhir-format.md) | Standardformat für den FHIR Data Service | MUSS |
| [IG-TI94558MGC](./fhir-format.md) | Vorrang des _format-Parameters gegenüber dem Accept Header | MUSS |
| [IG-TI97619U65](./general-principles.md) | Keine Registrierung bei Nutzung inaktiver Codes | MUSS |
| [IG-TI36297YXJ](./query-api-search.md) | Vergleichspräfixe für numerische Werte | MUSS |
| [IG-TI81327UVF](./query-api-search.md) | Umsetzung der Sortierfunktion gemäß FHIR | MUSS |
| [IG-TI57083QMG](./fhir-format.md) | Unterstützung von XML Content Type für FHIR-Data-Schnittstellen | MUSS |
| [IG-TI61163GRT](./query-api-search.md) | Bereichsprüfung für Range- und Period-Typen | MUSS |
| [IG-TI22824X01-02](./fhir-format.md) | Unterstützung von JSON Content Type für FHIR-Data-Schnittstellen | MUSS |
| [IG-TI00141ZJ2](./query-api-search.md) | Sortierung des Datentyps Period | MUSS |
| [IG-TI43409LRQ](./query-api-search.md) | Verwendung von entry.search.mode = match | MUSS |
| [IG-TI31988JEY](./query-api-search.md) | Unterstützung der Präzision bei numerischen und datumsbasierten Suchparametern | MUSS |
| [IG-TI95143N18-02](./query-api-search.md) | Formatierung von Referenzen im fullUrl-Feld | MUSS |
| [IG-TI85276Y4V](./query-api-search.md) | Vergleichspräfixe für Datumswerte | MUSS |
| [IG-TI07252NTV](./query-api-paging.md) | Unterstützung URL-Parameter für Paginierungsfunktion | MUSS |
| [IG-TI96963Y60-01](./fhir-format.md) | Unterstützung des Accept Header für Formatwahl im FHIR Data Service | MUSS |
| [IG-TI40876FQM](./query-api-search.md) | Standardpräfix für Vergleiche | MUSS |
| [IG-TI64797XGV](./query-api-search.md) | Formatierungsvorgaben für das fullUrl-Feld in FHIR-Bundles | MUSS |
| [IG-TI37232GDE-02](./query-api-paging.md) | Unterstützung Seitennavigationslinks für Paginierungsfunktion | MUSS |
| [IG-TI78112H2T-03](./query-api-paging.md) | Verwendung relativer URLs bei der Paginierung von FHIR Bundles | KANN |
| [IG-TI29386S9L-02](./general-principles.md) | UUID für Resource.id | MUSS |
| [IG-TI29911V07](./query-api-search.md) | Konsistente Referenzierung innerhalb eines Bundles | MUSS |
| [IG-TI59271UPX](./fhir-format.md) | FHIR-Formatunterstützung JSON | MUSS |
| [IG-TI19904KM0](./fhir-format.md) | Keine Überschreibung des Content Type Header durch den _format-Parameter bei POST-Nachrichten | MUSS |

**Tabelle:**Anforderungen
*EPA-MHD-Service*

