# TI Operation Outcome Details Value Set - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **TI Operation Outcome Details Value Set**

## ValueSet: TI Operation Outcome Details Value Set 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/ti/ValueSet/operation-outcome-details-vs | *Version*:1.1.1 |
| Active as of 2025-09-12 | *Computable Name*:TIOperationOutcomeDetailsVS |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Enthält alle Codes für das Operation Outcome der Telematikinfrastruktur (TI) sowie die in FHIR definierten Operation-Outcome-Codes. 

 **References** 

* [TI Operation Outcome](StructureDefinition-operation-outcome.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "operation-outcome-details-vs",
  "url" : "https://gematik.de/fhir/ti/ValueSet/operation-outcome-details-vs",
  "version" : "1.1.1",
  "name" : "TIOperationOutcomeDetailsVS",
  "title" : "TI Operation Outcome Details Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-09-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        }
      ]
    }
  ],
  "description" : "Enthält alle Codes für das Operation Outcome der Telematikinfrastruktur (TI) sowie die in FHIR definierten Operation-Outcome-Codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "immutable" : false,
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/operation-outcome"
      },
      {
        "system" : "https://gematik.de/fhir/ti/CodeSystem/operation-outcome-details-codes"
      }
    ]
  }
}

```
