# TI Organization - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **TI Organization**

## Resource Profile: TI Organization 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/ti/StructureDefinition/ti-organization | *Version*:1.1.1 |
| Active as of 2025-09-12 | *Computable Name*:TIOrganization |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Definiert die Datenstruktur für medizinische, regulatorische und technische Organisationen 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.ti|current/StructureDefinition/ti-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ti-organization.csv), [Excel](StructureDefinition-ti-organization.xlsx), [Schematron](StructureDefinition-ti-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ti-organization",
  "url" : "https://gematik.de/fhir/ti/StructureDefinition/ti-organization",
  "version" : "1.1.1",
  "name" : "TIOrganization",
  "title" : "TI Organization",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-09-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Definiert die Datenstruktur für medizinische, regulatorische und technische Organisationen",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.id",
        "path" : "Organization.id",
        "mustSupport" : true
      },
      {
        "id" : "Organization.meta",
        "path" : "Organization.meta",
        "mustSupport" : true
      },
      {
        "id" : "Organization.meta.versionId",
        "path" : "Organization.meta.versionId",
        "mustSupport" : true
      },
      {
        "id" : "Organization.meta.lastUpdated",
        "path" : "Organization.meta.lastUpdated",
        "mustSupport" : true
      },
      {
        "id" : "Organization.extension:ncpehCountryEx",
        "path" : "Organization.extension",
        "sliceName" : "ncpehCountryEx",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/ncpeh-country-extension"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:TelematikID",
        "path" : "Organization.identifier",
        "sliceName" : "TelematikID",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://fhir.de/StructureDefinition/identifier-telematik-id"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:BSNR",
        "path" : "Organization.identifier",
        "sliceName" : "BSNR",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://fhir.de/StructureDefinition/identifier-bsnr"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:KZVA",
        "path" : "Organization.identifier",
        "sliceName" : "KZVA",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://fhir.de/StructureDefinition/identifier-kzva"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:IKNR",
        "path" : "Organization.identifier",
        "sliceName" : "IKNR",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://fhir.de/StructureDefinition/identifier-iknr"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Organization.active",
        "path" : "Organization.active",
        "mustSupport" : true
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Organization.type:providerType",
        "path" : "Organization.type",
        "sliceName" : "providerType",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/directory/ValueSet/OrganizationTypeVS"
        }
      },
      {
        "id" : "Organization.type:profession",
        "path" : "Organization.type",
        "sliceName" : "profession",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/directory/ValueSet/OrganizationProfessionOIDTypeVS"
        }
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.alias",
        "path" : "Organization.alias",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address.use",
        "path" : "Organization.address.use",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address.text",
        "path" : "Organization.address.text",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address.line",
        "path" : "Organization.address.line",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address.city",
        "path" : "Organization.address.city",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address.state",
        "path" : "Organization.address.state",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address.postalCode",
        "path" : "Organization.address.postalCode",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address.country",
        "path" : "Organization.address.country",
        "mustSupport" : true
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "mustSupport" : true
      },
      {
        "id" : "Organization.contact",
        "path" : "Organization.contact",
        "mustSupport" : true
      }
    ]
  }
}

```
