# OperationDefinition Profil für TI FHIR Data Service - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **OperationDefinition Profil für TI FHIR Data Service**

## Resource Profile: OperationDefinition Profil für TI FHIR Data Service 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition | *Version*:1.1.1 |
| Active as of 2025-09-12 | *Computable Name*:TIOperationDefinition |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Dieses Profil beschreibt FHIR Operationen des FHIR Data Service innerhalb der Telematikinfrastruktur (TI). Es stellt sicher, dass zustandsverändernde Operationen (`affectsState = true`) nicht über HTTP GET ausgeführt werden dürfen. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.ti|current/StructureDefinition/ti-operationdefinition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ti-operationdefinition.csv), [Excel](StructureDefinition-ti-operationdefinition.xlsx), [Schematron](StructureDefinition-ti-operationdefinition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ti-operationdefinition",
  "url" : "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition",
  "version" : "1.1.1",
  "name" : "TIOperationDefinition",
  "title" : "OperationDefinition Profil für TI FHIR Data Service",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-09-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Dieses Profil beschreibt FHIR Operationen des FHIR Data Service innerhalb der Telematikinfrastruktur (TI).\nEs stellt sicher, dass zustandsverändernde Operationen (`affectsState = true`) nicht über HTTP GET ausgeführt werden dürfen.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "OperationDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/OperationDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "OperationDefinition",
        "path" : "OperationDefinition",
        "constraint" : [
          {
            "key" : "op-affectsState-vs-method",
            "severity" : "error",
            "human" : "Wenn affectsState = true, darf keine http-method Extension GET enthalten.",
            "expression" : "affectsState != true or extension.where(url = 'https://gematik.de/fhir/ti/StructureDefinition/http-method').all(value != 'GET')",
            "source" : "https://gematik.de/fhir/ti/StructureDefinition/ti-operationdefinition"
          }
        ]
      },
      {
        "id" : "OperationDefinition.extension:method",
        "path" : "OperationDefinition.extension",
        "sliceName" : "method",
        "min" : 0,
        "max" : "2",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "OperationDefinition.kind",
        "path" : "OperationDefinition.kind",
        "mustSupport" : true
      },
      {
        "id" : "OperationDefinition.affectsState",
        "path" : "OperationDefinition.affectsState",
        "mustSupport" : true
      },
      {
        "id" : "OperationDefinition.code",
        "path" : "OperationDefinition.code",
        "mustSupport" : true
      },
      {
        "id" : "OperationDefinition.system",
        "path" : "OperationDefinition.system",
        "mustSupport" : true
      },
      {
        "id" : "OperationDefinition.type",
        "path" : "OperationDefinition.type",
        "mustSupport" : true
      },
      {
        "id" : "OperationDefinition.instance",
        "path" : "OperationDefinition.instance",
        "mustSupport" : true
      },
      {
        "id" : "OperationDefinition.inputProfile",
        "path" : "OperationDefinition.inputProfile",
        "mustSupport" : true
      },
      {
        "id" : "OperationDefinition.outputProfile",
        "path" : "OperationDefinition.outputProfile",
        "mustSupport" : true
      }
    ]
  }
}

```
