# Capability Statement Profil für TI FHIR Data Service - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Capability Statement Profil für TI FHIR Data Service**

## Resource Profile: Capability Statement Profil für TI FHIR Data Service 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/ti/StructureDefinition/ti-capability-statement | *Version*:1.1.1 |
| Active as of 2025-09-12 | *Computable Name*:TICapabilityStatement |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Dieses Profil beschreibt die Fähigkeiten eines FHIR Data Service innerhalb der Telematikinfrastruktur (TI) spezifiziert ist. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.ti|current/StructureDefinition/ti-capability-statement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ti-capability-statement.csv), [Excel](StructureDefinition-ti-capability-statement.xlsx), [Schematron](StructureDefinition-ti-capability-statement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ti-capability-statement",
  "url" : "https://gematik.de/fhir/ti/StructureDefinition/ti-capability-statement",
  "version" : "1.1.1",
  "name" : "TICapabilityStatement",
  "title" : "Capability Statement Profil für TI FHIR Data Service",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-09-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Dieses Profil beschreibt die Fähigkeiten eines FHIR Data Service innerhalb der Telematikinfrastruktur (TI) spezifiziert ist.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CapabilityStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CapabilityStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CapabilityStatement",
        "path" : "CapabilityStatement"
      },
      {
        "id" : "CapabilityStatement.extension:baseUrl",
        "path" : "CapabilityStatement.extension",
        "sliceName" : "baseUrl",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-base-url"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.extension:header",
        "path" : "CapabilityStatement.extension",
        "sliceName" : "header",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.extension:responseInfo",
        "path" : "CapabilityStatement.extension",
        "sliceName" : "responseInfo",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.version",
        "path" : "CapabilityStatement.version",
        "short" : "Die Version der API",
        "min" : 1
      },
      {
        "id" : "CapabilityStatement.contact",
        "path" : "CapabilityStatement.contact",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "CapabilityStatement.format",
        "path" : "CapabilityStatement.format",
        "short" : "Die von der API unterstützten Medientypen, z.B. application/json oder application/fhir+json"
      },
      {
        "id" : "CapabilityStatement.rest.resource.interaction.extension:header",
        "path" : "CapabilityStatement.rest.resource.interaction.extension",
        "sliceName" : "header",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.resource.interaction.extension:responseInfo",
        "path" : "CapabilityStatement.rest.resource.interaction.extension",
        "sliceName" : "responseInfo",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.resource.interaction.extension:expectation",
        "path" : "CapabilityStatement.rest.resource.interaction.extension",
        "sliceName" : "expectation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation|4.0.1"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.resource.operation.extension:header",
        "path" : "CapabilityStatement.rest.resource.operation.extension",
        "sliceName" : "header",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.resource.operation.extension:responseInfo",
        "path" : "CapabilityStatement.rest.resource.operation.extension",
        "sliceName" : "responseInfo",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.resource.operation.extension:method",
        "path" : "CapabilityStatement.rest.resource.operation.extension",
        "sliceName" : "method",
        "min" : 0,
        "max" : "2",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.resource.operation.extension:expectation",
        "path" : "CapabilityStatement.rest.resource.operation.extension",
        "sliceName" : "expectation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation|4.0.1"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.operation",
        "path" : "CapabilityStatement.rest.operation",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.operation.extension:header",
        "path" : "CapabilityStatement.rest.operation.extension",
        "sliceName" : "header",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.operation.extension:responseInfo",
        "path" : "CapabilityStatement.rest.operation.extension",
        "sliceName" : "responseInfo",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.operation.extension:method",
        "path" : "CapabilityStatement.rest.operation.extension",
        "sliceName" : "method",
        "min" : 0,
        "max" : "2",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/ti/StructureDefinition/extension-http-method"
            ]
          }
        ]
      },
      {
        "id" : "CapabilityStatement.rest.operation.extension:expectation",
        "path" : "CapabilityStatement.rest.operation.extension",
        "sliceName" : "expectation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation|4.0.1"
            ]
          }
        ]
      }
    ]
  }
}

```
