# TI Operation Outcome - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **TI Operation Outcome**

## Resource Profile: TI Operation Outcome 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/ti/StructureDefinition/operation-outcome | *Version*:1.1.1 |
| Active as of 2025-09-12 | *Computable Name*:TIOperationOutcome |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Das Operation Outcome-Profil für die Telematikinfrastruktur (TI) FHIR Data Services 

**Usages:**

* Examples for this Profile: [OperationOutcome/0dc58d79-1b2e-4c6f-afe0-0a5b721661a2](OperationOutcome-0dc58d79-1b2e-4c6f-afe0-0a5b721661a2.md), [OperationOutcome/468ca07b-7d63-453d-a738-0c35cb9402aa](OperationOutcome-468ca07b-7d63-453d-a738-0c35cb9402aa.md) and [OperationOutcome/ad48bf90-a664-44f4-af14-ee6e81db3df4](OperationOutcome-ad48bf90-a664-44f4-af14-ee6e81db3df4.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.ti|current/StructureDefinition/operation-outcome)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-operation-outcome.csv), [Excel](StructureDefinition-operation-outcome.xlsx), [Schematron](StructureDefinition-operation-outcome.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "operation-outcome",
  "url" : "https://gematik.de/fhir/ti/StructureDefinition/operation-outcome",
  "version" : "1.1.1",
  "name" : "TIOperationOutcome",
  "title" : "TI Operation Outcome",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-09-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Das Operation Outcome-Profil für die Telematikinfrastruktur (TI) FHIR Data Services",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "OperationOutcome",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/OperationOutcome",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "OperationOutcome",
        "path" : "OperationOutcome"
      },
      {
        "id" : "OperationOutcome.issue.severity",
        "path" : "OperationOutcome.issue.severity",
        "mustSupport" : true
      },
      {
        "id" : "OperationOutcome.issue.code",
        "path" : "OperationOutcome.issue.code",
        "mustSupport" : true
      },
      {
        "id" : "OperationOutcome.issue.details",
        "path" : "OperationOutcome.issue.details",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://gematik.de/fhir/ti/ValueSet/operation-outcome-details-vs"
        }
      }
    ]
  }
}

```
