# HTTP-Antwortinformationen - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **HTTP-Antwortinformationen**

## Extension: HTTP-Antwortinformationen 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info | *Version*:1.1.1 |
| Active as of 2025-09-12 | *Computable Name*:HttpResponseInfo |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Definiert Informationen zu HTTP-Antworten für FHIR-Interaktionen, inklusive Statuscode, Beschreibung, Beispiel und Response-Schema.

**Context of Use**

This extension may be used on the following element(s):

* Element ID CapabilityStatement
* Element ID CapabilityStatement.rest.resource.interaction
* Element ID CapabilityStatement.rest.operation
* Element ID CapabilityStatement.rest.resource.operation

**Usage info**

**Usages:**

* Use this Extension: [Capability Statement Profil für TI FHIR Data Service](StructureDefinition-ti-capability-statement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.ti|current/StructureDefinition/extension-http-response-info)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-extension-http-response-info.csv), [Excel](StructureDefinition-extension-http-response-info.xlsx), [Schematron](StructureDefinition-extension-http-response-info.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "extension-http-response-info",
  "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info",
  "version" : "1.1.1",
  "name" : "HttpResponseInfo",
  "title" : "HTTP-Antwortinformationen",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-09-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Definiert Informationen zu HTTP-Antworten für FHIR-Interaktionen, inklusive Statuscode, Beschreibung, Beispiel und Response-Schema.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CapabilityStatement"
    },
    {
      "type" : "element",
      "expression" : "CapabilityStatement.rest.resource.interaction"
    },
    {
      "type" : "element",
      "expression" : "CapabilityStatement.rest.operation"
    },
    {
      "type" : "element",
      "expression" : "CapabilityStatement.rest.resource.operation"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "HTTP-Antwortinformationen",
        "definition" : "Definiert Informationen zu HTTP-Antworten für FHIR-Interaktionen, inklusive Statuscode, Beschreibung, Beispiel und Response-Schema."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 2
      },
      {
        "id" : "Extension.extension:statusCode",
        "path" : "Extension.extension",
        "sliceName" : "statusCode",
        "short" : "Der HTTP-Statuscode (z.B. 200, 201, 404, 500)",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:statusCode.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:statusCode.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "statusCode"
      },
      {
        "id" : "Extension.extension:statusCode.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:description",
        "path" : "Extension.extension",
        "sliceName" : "description",
        "short" : "Kurze Beschreibung des Antwortfalls",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:description.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:description.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "description"
      },
      {
        "id" : "Extension.extension:description.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:example",
        "path" : "Extension.extension",
        "sliceName" : "example",
        "short" : "Optionales Beispiel für eine Antwortmeldung",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:example.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:example.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "example"
      },
      {
        "id" : "Extension.extension:example.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:format",
        "path" : "Extension.extension",
        "sliceName" : "format",
        "short" : "Format oder Struktur der Antwort, z.B. RFC7807",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:format.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:format.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "format"
      },
      {
        "id" : "Extension.extension:format.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:retryable",
        "path" : "Extension.extension",
        "sliceName" : "retryable",
        "short" : "Gibt an, ob die Antwort auf einen temporären Fehler hinweist und ein erneuter Versuch möglich ist",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:retryable.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:retryable.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "retryable"
      },
      {
        "id" : "Extension.extension:retryable.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Extension.extension:responseType",
        "path" : "Extension.extension",
        "sliceName" : "responseType",
        "short" : "Der erwartete Response-Typ oder Medientyp, z.B. OperationOutcome, application/json",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:responseType.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:responseType.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "responseType"
      },
      {
        "id" : "Extension.extension:responseType.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:errorCode",
        "path" : "Extension.extension",
        "sliceName" : "errorCode",
        "short" : "Ein technischer oder semantischer Fehlercode, z.B. internalError",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:errorCode.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:errorCode.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "errorCode"
      },
      {
        "id" : "Extension.extension:errorCode.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
