# HTTP Header - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **HTTP Header**

## Extension: HTTP Header 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/ti/StructureDefinition/extension-http-header | *Version*:1.1.1 |
| Active as of 2025-09-12 | *Computable Name*:HTTPHeader |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Ermöglicht die Angabe global oder spezifisch geforderter HTTP Header in einem CapabilityStatement oder einer Resource-Interaktion.

**Context of Use**

This extension may be used on the following element(s):

* Element ID CapabilityStatement
* Element ID CapabilityStatement.rest.resource.interaction
* Element ID CapabilityStatement.rest.operation
* Element ID CapabilityStatement.rest.resource.operation

**Usage info**

**Usages:**

* Use this Extension: [Capability Statement Profil für TI FHIR Data Service](StructureDefinition-ti-capability-statement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.ti|current/StructureDefinition/extension-http-header)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-extension-http-header.csv), [Excel](StructureDefinition-extension-http-header.xlsx), [Schematron](StructureDefinition-extension-http-header.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "extension-http-header",
  "url" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-header",
  "version" : "1.1.1",
  "name" : "HTTPHeader",
  "title" : "HTTP Header",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-09-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Ermöglicht die Angabe global oder spezifisch geforderter HTTP Header in einem CapabilityStatement oder einer Resource-Interaktion.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CapabilityStatement"
    },
    {
      "type" : "element",
      "expression" : "CapabilityStatement.rest.resource.interaction"
    },
    {
      "type" : "element",
      "expression" : "CapabilityStatement.rest.operation"
    },
    {
      "type" : "element",
      "expression" : "CapabilityStatement.rest.resource.operation"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "HTTP Header",
        "definition" : "Ermöglicht die Angabe global oder spezifisch geforderter HTTP Header in einem CapabilityStatement oder einer Resource-Interaktion."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 3
      },
      {
        "id" : "Extension.extension:name",
        "path" : "Extension.extension",
        "sliceName" : "name",
        "short" : "Name des HTTP-Headers, z.B. X-Request-ID",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:name.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:name.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "name"
      },
      {
        "id" : "Extension.extension:name.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:type",
        "path" : "Extension.extension",
        "sliceName" : "type",
        "short" : "Datentyp des Header-Werts, z.B. string, boolean",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:type.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:type.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "type"
      },
      {
        "id" : "Extension.extension:type.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:description",
        "path" : "Extension.extension",
        "sliceName" : "description",
        "short" : "Beschreibung und Zweck des Headers",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:description.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:description.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "description"
      },
      {
        "id" : "Extension.extension:description.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:pattern",
        "path" : "Extension.extension",
        "sliceName" : "pattern",
        "short" : "Erwartetes Format als regulärer Ausdruck (Regex)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:pattern.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:pattern.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "pattern"
      },
      {
        "id" : "Extension.extension:pattern.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:format",
        "path" : "Extension.extension",
        "sliceName" : "format",
        "short" : "Formatbeschreibung für Anzeige oder Validierung, z.B. uuid",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:format.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:format.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "format"
      },
      {
        "id" : "Extension.extension:format.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:required",
        "path" : "Extension.extension",
        "sliceName" : "required",
        "short" : "Gibt an, ob der Header verpflichtend ist (true/false)",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:required.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:required.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "required"
      },
      {
        "id" : "Extension.extension:required.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
