# Example History Bundle - Implementation Guide Telematikinfrastruktur (TI) Common v1.2.0

Implementation Guide

Telematikinfrastruktur (TI) Common

Version 1.2.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **Example History Bundle**

## Example Bundle: Example History Bundle



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "example-history-bundle",
  "type" : "history",
  "total" : 2,
  "link" : [
    {
      "relation" : "self",
      "url" : "/epa/medication/api/v1/fhir/MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43/_history"
    }
  ],
  "entry" : [
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43",
      "request" : {
        "method" : "DELETE",
        "url" : "MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43"
      },
      "response" : {
        "status" : "200 OK",
        "lastModified" : "2025-08-22T15:00:00.000Z"
      }
    },
    {
      "fullUrl" : "http://epa4all/epa/medication/api/v1/fhir/MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43",
      "resource" : {
        "resourceType" : "MedicationDispense",
        "id" : "4e6e1623-778e-44a3-b208-8479f5339e43",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2025-08-22T14:43:33.244Z",
          "profile" : [
            "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"
          ]
        },
        "extension" : [
          {
            "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
            "valueIdentifier" : {
              "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
              "value" : "162.153.303.257.459_20250301"
            }
          }
        ],
        "status" : "completed",
        "medicationReference" : {
          "reference" : "Medication/16e5611a-911c-4c0e-a705-43b0e4e79cf6"
        },
        "subject" : {
          "identifier" : {
            "system" : "http://fhir.de/sid/gkv/kvid-10",
            "value" : "X110411319"
          }
        },
        "performer" : [
          {
            "actor" : {
              "reference" : "Organization/a2ce62fc-1f29-4759-863e-1a1ca7f9669e"
            }
          }
        ],
        "authorizingPrescription" : [
          {
            "reference" : "MedicationRequest/f434862b-9bf8-414d-8b94-5eaa0b4bbf01"
          }
        ],
        "whenHandedOver" : "2025-08-22",
        "dosageInstruction" : [
          {
            "text" : "1-0-0-0"
          }
        ],
        "substitution" : {
          "wasSubstituted" : false
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "MedicationDispense"
      },
      "response" : {
        "status" : "201 Created",
        "location" : "MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43/_history/1",
        "lastModified" : "2025-08-22T14:43:33.244Z"
      }
    }
  ]
}

```
