# Referenzen - Implementation Guide ePA MHD Service v1.1.0

Implementation Guide

ePA MHD Service

Version 1.1.0 - release

* [**Table of Contents**](toc.md)
* **Referenzen**

## Referenzen

Die nachfolgenden Tabellen enthalten die Bezeichnung der in diesem Implementation Guide referenzierten Dokumente oder externe Quellen.

### Dokumente & Verweise der gematik

| | |
| :--- | :--- |
| [Anfragenportal] | gematik: ePA-Anfragenportal der gematik.https://service.gematik.de/servicedesk/customer/portal/13 |
| [gemIG_TI_Common#MHD] | gematik: FHIR IG TI Common - Anforderungen an den MHD Service.https://gematik.de/fhir/ti/1.2.0/actor-epa-mhd.html |
| [gemIG_ePA_Basic#MHD] | gematik: FHIR IG EPA Basisfunktionalitäten - Anforderungen an den MHD Service.https://gematik.de/fhir/epa/1.3.0/actor-mhd.html |
| [gemSpec_Aktensystem_ePAfueralle#Legal Policy] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle - Legal Policy gemäß § 341 Absatz 2 SGB V.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0/#3.10 |
| [gemSpec_Aktensystem_ePAfueralle#A_25233] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle - Anforderung: XDS Document Service - erlaubte Formate für PDF-Dokumente.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0/#A_25233 |
| [gemSpec_Aktensystem_ePAfueralle#A_24451] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle - Anforderung: XDS Document Service - Automatisches initales Erzeugen einer versionsübergreifenden ID für Dokumente.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0/#A_24451 |
| [gemSpec_Aktensystem_ePAfueralle#A_24864] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle - Anforderung: XDS Document Service - Prüfen auf zulässiges Format beim Einstellen von Dokumenten.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0/#A_24864 |
| [gemSpec_Aktensystem_ePAfueralle#A_27654] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle - Anforderung: XDS Document Service - Einstellen von neuen Anhängen oder Anhängen an neue Dokumente.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0/#A_27654 |
| [gemSpec_Aktensystem_ePAfueralle#MHDService] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle - MHD Service.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0/#3.13.2.3 |
| [gemILF_PS_ePA] | gematik: Implementierungsleitfaden gemILF_PS_ePA.https://gemspec.gematik.de/docs/gemILF/gemILF_PS_ePA/latest/ |
| [gemILF_PS_ePA#A_14244] | gematik: Implementierungsleitfaden gemILF_PS_ePA - Verarbeitungsvorschrift für eAB im DischargeLetterContainer-Format.https://gemspec.gematik.de/docs/gemILF/gemILF_PS_ePA/latest/#A_14244 |
| [gemILF_PS_ePA#eAB] | gematik: Implementierungsleitfaden gemILF_PS_ePA - Elektronischer Arztbrief im Discharge-Letter-Container-Format.https://gemspec.gematik.de/docs/gemILF/gemILF_PS_ePA/latest/#3.12.2.3 |
| [gemSpec_Krypt] | gematik: Spezifikation gemSpec_Krypt - VAU-Protokoll.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Krypt/latest/#7 |
| [OpenAPI JSON des ePA MHD Service Server] | gematik: OpenAPI JSON des ePA MHD Service Server.epa-mhd-document-responder.openapi.json |
| [OpenAPI YAML des ePA MHD Service Server] | gematik: OpenAPI YAML des ePA MHD Service Server.epa-mhd-document-responder.openapi.yaml |
| [OpenAPI JSON des ePA MHD Service Client] | gematik: OpenAPI JSON des ePA MHD Service Client.epa-mhd-document-cosumer.openapi.json |
| [OpenAPI YAML des ePA MHD Service Client] | gematik: OpenAPI YAML des ePA MHD Service Client.epa-mhd-document-cosumer.openapi.yaml |
| [EPADataCategoryMedicalVS] | gematik: Value Set für medizinische Fachkategorien.https://gematik.de/fhir/terminology/ValueSet/epa-data-category-medical-vs|1.0.6 |
| [EPADataCategoryOtherVS] | gematik: Value Set für nicht-medizinische Fachkategorien.https://gematik.de/fhir/terminology/ValueSet/epa-data-category-other-vs|1.0.6 |
| [gemSpec_Aktensystem_ePAfueralle#A_15159] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle - Anforderung: Anbieter ePA-Aktensystem - Schutzmaßnahmen gegen die OWASP Top 10 Risiken.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0/#A_15159 |
| [gemSpec_Aktensystem_ePAfueralle#A_24783] | gematik: Spezifikation gemSpec_Aktensystem_ePAfueralle - Anforderung: ePA-Aktensystem - Eingabevalidierung von Operationen.https://gemspec.gematik.de/docs/gemSpec/gemSpec_Aktensystem_ePAfueralle/gemSpec_Aktensystem_ePAfueralle_V1.7.0/#A_24783 |

### Weitere Dokumente & Verweise

| | |
| :--- | :--- |
| [FHIR-Spezifikation] | HL7: FHIR R4 Spezifikation.http://hl7.org/fhir/R4/index.html |
| [IHE ITI MHD] | IHE: IHE ITI Mobile access to Health Documents (MHD).https://profiles.ihe.net/ITI/MHD |
| [ITI-67] | IHE: Find Document References [ITI-67].https://profiles.ihe.net/ITI/MHD/4.2.3/ITI-67.html#2-3-67-find-document-references-iti-67 |
| [ITI-68] | IHE: Find Document References [ITI-68].https://profiles.ihe.net/ITI/MHD/4.2.3/ITI-68.html#2-3-68-retrieve-document-iti-68 |
| [FHIR-HTTP] | HL7: FHIR R4 HTTP Spezifikation.http://hl7.org/fhir/R4/http.html |
| [FHIR-HTTP-Search] | HL7: FHIR R4 Spezifikation für HTTP Suche.http://hl7.org/fhir/R4/http.html#search |
| [XDS-ON-FHIR] | IHE: XDS on FHIR Option IHE MHD [ITI-67].https://profiles.ihe.net/ITI/MHD/4.2.3/ITI-67.html#23674131-xds-on-fhir-option |
| [Resource References] | HL7: FHIR R4 Resource References.https://hl7.org/fhir/R4/references.html#Reference |
| [Profil Telematik-ID] | HL7-DE: Identifier-Profil für die Telematik-IDs.http://fhir.de/StructureDefinition/identifier-telematik-id |
| [Profil KVNR] | HL7-DE: Identifier-Profil für die 10-stellige Krankenversichertennummer.http://fhir.de/StructureDefinition/identifier-kvid-10 |
| [FHIR DocumentReference] | HL7: FHIR R4 DocumentReference Ressource.http://hl7.org/fhir/R4/documentreference.html |
| [RFC2616] | IEFT: RFC 2616.https://datatracker.ietf.org/doc/html/rfc2616 |
| [FMC-Blockdiagramm] | FMC Modeling: FMC Blockdiagramm.http://www.fmc-modeling.org/ |
| [OData-Search] | OASIS: OData Version 4.0 Part 1: Protocol.https://docs.oasis-open.org/odata/odata/v4.0/cs01/part1-protocol/odata-v4.0-cs01-part1-protocol.html#_The_$search_System |
| [BM25] | Wikipedia: Okapi BM25, Stand 26. März 2025.https://en.wikipedia.org/wiki/Okapi_BM25 |
| [Stoppwort] | Wikipedia: Stoppwort, Stand 26. März 2025.https://de.wikipedia.org/wiki/Stoppwort |
| [ANTLR] | ANTLR / Terence Parr: ANTLR, Stand 31. März 2025.https://www.antlr.org/ |
| [Levensthein] | Wikipedia: Levensthein-Distanz, Stand 31. März 2025.https://de.wikipedia.org/wiki/Levenshtein-Distanz |
| [FHIR Bundle] | HL7: HL7 FHIR Bundle.https://hl7.org/fhir/R4/bundle.html |
| [Stoppwortliste] | Marco Götze, Steffen Geyer, gematik: GERMAN STOPWORDS../stoppwortliste_de.txt |
| [XML] | W3C: Extensible Markup Language (XML) 1.0 (Fifth Edition).https://www.w3.org/TR/xml/ |
| [RFC8259] | IETF: The JavaScript Object Notation (JSON) Data Interchange Format.https://datatracker.ietf.org/doc/html/rfc8259 |

