# de.gematik.epa.mhd#1.1.0: Implementation Guide ePA MHD Service

## Pages

* [Home](index.md)
* [Steckbriefe](spec-sheet.md)
* [Find Document References](InterfaceFindDocumentReferences.md)
* [FHIR-Artefakte](artifacts.md)
* [Release Notes](release-notes.md)
* [Referenzen](referenced.md)
* [Apache License](license.md)
* [Steckbrief: ePA MHD Service](actor-mhd.md)
* [Versionsvergleiche](comparisons.md)
* [Downloads](downloads.md)
* [OpenAPI: MHD Service](mhd-openapi.md)
* [Steckbrief: ePA PS / ePA-Client-Systeme / ePA-FdV](actor-client.md)
* [Datenschutz und Sicherheit](privacy-security.md)
* [Generelle Prinzipien](general-principles.md)
* [Steckbrief: ePA XDS Document Service](actor-xds.md)
* [Retrieve Document](InterfaceRetrieveDocument.md)

## Resources

### Resource Profiles

* [EPA Document Search Result Bundle](StructureDefinition-epa-document-search-result-bundle.md)
* [EPA MHD DocumentReference](StructureDefinition-epa-mhd-document-reference.md)

### Extensions

* [EPA Match Snippet Extension](StructureDefinition-epa-match-snippet.md)
* [EPA Match Total Hits Extension](StructureDefinition-epa-match-total-hits.md)

### CapabilityStatements

* [EPA MHD Service (Document Consumer - Client)](CapabilityStatement-epa-mhd-document-consumer.md)
* [ePA MHD Service (Document Responder - Server)](CapabilityStatement-epa-mhd-document-responder.md)

### ImplementationGuides

* [Implementation Guide ePA MHD Service](index.md)

### SearchParameters

* [EPAMHDDocumentReferenceTitleSearchParameter](SearchParameter-epa-mhd-documentreference-title.md)

### Examples

* [example-fulltext-search-match (Bundle)](Bundle-example-fulltext-search-match.md)
* [b2d5f8db-48ca-43c4-a540-6c8f2e853913 (DocumentReference)](DocumentReference-b2d5f8db-48ca-43c4-a540-6c8f2e853913.md)
