# Home - Implementation Guide ePA MHD Service v1.1.0

Implementation Guide

ePA MHD Service

Version 1.1.0 - release

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-mhd/ImplementationGuide/de.gematik.epa.mhd | *Version*:1.1.0 |
| Active as of 2025-12-15 | *Computable Name*:gemIG_ePA_MHD |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Die **ePA für alle** unterstützt die Suche auf Dokumenten im XDS Document Service über eine [IHE ITI MHD] kompatible Schnittstelle des MHD Service. Dieser Dienst erweitert die vorhandene IHE XDS-Suchfunktionalität um eine Volltextsuche, die mit einer metadatenbasierten Suche kombinierbar ist. Die Trefferliste einer Volltextsuche enthält u.a.

* die **Dokumentmetadaten** (gemäß Suchkriterien),
* die im Dokument gefundenen Suchbegriffe in Form von Ausschnitten bzw. **Snippets** sowie
* einen **Score**, der ein ungefähres Maß für die Güte des Suchergebnisses angibt.

Neben der Kombination aus dokumentenbasierter Metadaten- und Volltextsuche erlaubt der MHD Service auch das Herunterladen eines Dokuments aus dem XDS Document Service.

### Systemüberblick

Der MHD Service ist als **FHIR Data Service** eine Ausprägung eines **Medical Service** sowie Teil des ePA-Aktensystems. Er wird in einer vertrauenswürdigen Ausführungsumgebung (VAU) betrieben (vgl. nachstehende Abbildung).

Anforderungen an ePA-Client-Systeme zu Lokalisierung und Aufbau einer Verbindung zum ePA-Aktensystem und damit die clientseitige Nutzung des MHD Service sind im Implementierungsleitfaden [gemILF_PS_ePA] sowie [gemSpec_Krypt] einzusehen.

**Abbildung:**Systemüberblick der Fachanwendung ePA mit MHD Service ([FMC-Blockdiagramm])
### Einordnung von IHE MHD-Akteuren in die Fachanwendung ePA

In der nachstehenden Abbildung wird gezeigt, welche IHE Akteure insgesamt in der Fachanwendung ePA wie gruppiert und welche zugehörigen Transaktionen angewendet werden. Akteure unterschiedlicher Integrationsprofile sind im XDS Document Service bzw. MHD Service über zusammengefasste Außenschnittstellen nutzbar, d.h. sie agieren nach außen hin nicht als eigenständige Dienste, sondern sind über feste Pfade adressiert. MHD-Akteure sind ferner farblich hervorgehoben. Kursiv dargestellte Akteure und Transaktionen sind als produkttyp- bzw. komponentenintern anzusehen und setzen lediglich die jeweilige Semantik des IHE-Akteurs um.

**Abbildung:**Überblick über IHE Akteure und assoziierte Transaktionen
### Funktionalitäten

Der MHD Service unterstützt die folgenden Funktionalitäten:

* Die Metadatensuche ermöglicht das Auffinden von Dokumentmetadaten auf Basis der IHE-Transaktion [Find Document References [ITI-67]](./InterfaceFindDocumentReferences.md) - sie kann mit einer volltextbasierten Suche kombiniert werden.
* Nach einer metadatengestützten (Voll-)Textsuche können Dokumente auf Basis der IHE-Transaktion [Retrieve Document [ITI-68]](./InterfaceRetrieveDocument.md) heruntergeladen werden. Der Download ist auch ohne vorhergehende Suche möglich.

#### Rahmenbedingungen für die Volltextsuche

Die Funktionalität der Volltextsuche umfasst die folgenden Rahmenbedingungen:

* Indizierung der Dokumente im XDS Document Service: 
* Indizierung bzw. Indizieren bezeichnet hier die Verfügbarmachung des in den Dokumenten enthaltenen Textes für die Suche. 
* Die technische Umsetzung der Indizierung, d.h. wie festgehalten wird, welche Begriffe in welchen Dokumenten zu finden sind, ist nicht vorgegeben.
 
* Die Dokumente werden beim Einstellen in den XDS Document Service indiziert, d.h. sie stehen für die Metadaten- und Volltextsuche nach kurzer Zeit zur Verfügung.
* Ausschließlich PDF/A-, XML-, JSON- und reine Textdokumente werden indiziert und damit durchsuchbar gemacht. 
* Das schließt die Erkennung von Text in Bildern ein (Optical Character Recognition, OCR) und betrifft auch Bilder, die nicht die komplette Seite einnehmen.
* Das schließt auch die Suche in Dokumenten ein, in denen alle oder einzelne Seiten um 90 oder 180 Grad gedreht sind.
 
* Dokumente werden durch die Indizierung nicht verändert (seiteneffektfrei).
* Die Dokumentmetadaten werden bereits durch den XDS Document Service für die Suche aufbereitet; die entsprechend vorhandenen Mechanismen aus diesem Dienst werden nachgenutzt.
 
* Zugriff auf den MHD-Service 
* Der Zugriff auf den MHD-Service durch Clients erfolgt nur lesend (Dokumente werden nach wie vor über den XDS Document Service eingestellt, der dann die Indizierung anstößt)
* Lesender Zugriff wird auf diejenigen Dokumente (und deren indizierte “Stichwörter”) gewährt, auf die Clients auch via XDS Document Service lesend zugreifen können (Recht “R” in der Legal Policy des Aktensystems)
 
* Unterstützung von Nutzer:innen beim Verfassen einer Suchanfrage: 
* Eine clientseitige Prüfung von Rechtschreib- und Tippfehlern bei der Suchanfrage unterstützt die Nutzer:innen.​
* Das Speichern von gängigen Suchanfragen im ePA-Client-System ist möglich.​
 
* Struktur der Suchanfrage: 
* Ein ePA-Client-System muss als Suchkriterien Dokumentmetadaten und Suchbegriffe angeben können.
* Die wesentlichen Dokumentmetadaten müssen unterstützt werden, um die Menge der potentiellen Trefferdokumente eingrenzen zu können.
* Bei der Volltextsuche sind die folgenden Funktionen und Einschränkungen vorgesehen: 
* Eine Suche kann nach einem oder mehreren Begriffen suchen.
* Diese Begriffe können mit logischen Suchoperatoren (d.h. UND, ODER, NICHT) verknüpft werden.
* Eine Verschachtelung von Suchoperatoren wird nicht unterstützt.
* Das Suchen exakter Phrasen (d.h. das Suchen nach genau den angegebenen Worten in genau dieser Reihenfolge) wird unterstützt.
 
 
* Umsetzen der Suche im MHD Service 
* Syntaktisch ähnliche Begriffe (bspw. durch Tippfehler entstanden) werden aktensystemseitig in einem vorgegebenem Rahmen korrigiert.
 
* Ergebnispräsentation: 
* Jedes Suchergebnis zeigt alle aus der Suche im Dokument gefundenen Begriffe an.
* Zu jedem gefundenen Begriff wird angezeigt, wie oft er in dem jeweiligen Dokument vorkommt.
* Je Suchergebnis wird ein Ausschnitt bzw. Snippet angezeigt, das den Textkontext (d.h. den Begriff und den umgebenden Text) der Suchbegriffe im Dokument wiedergibt.
 
* Nicht-funktionale Anforderungen: 
* Der MHD Service garantiert eine Antwortzeit von wenigen Sekunden.
 
* Der MHD Service stellt die folgenden Funktionalitäten **nicht** bereit: 
* Einstellen der Dokumente - Das Einstellen und Registrieren von Dokumenten erfolgt über den XDS Document Service.
* Suche nach Synonymen und semantisch ähnlichen Begriffen
* Suche in anderen Dokumententypen als PDF/A, XML, JSON oder reinen Textdokumenten
* Suche in Dokumenten, die nicht im XDS Document Service gespeichert sind
 

### Abhängigkeiten







### Sprachliche Konventionen

* Zur besseren Lesbarkeit wird in diesem Implementation Guide das generische Maskulinum verwendet. Die hier verwendeten Personenbezeichnungen beziehen sich stets auf alle Geschlechter.
* Der Begriff “Arzt” wird in diesem Implementation Guide sowohl für Human- als auch für Zahnmediziner verwendet.

### Kontakt

Allgemeine Fragen und Kommentare zum Implementation Guide können Sie über das [Anfragenportal] der gematik einreichen. Falls kein Zugang besteht, senden Sie bitte eine E-Mail an “patientteam [ at ] gematik [ dot ] de” mit dem Betreff “Anfragenportal Zugang”.

