# EPA Match Total Hits Extension - Implementation Guide ePA MHD Service v1.1.0

Implementation Guide

ePA MHD Service

Version 1.1.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA Match Total Hits Extension**

## Extension: EPA Match Total Hits Extension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-match-total-hits | *Version*:1.1.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMatchTotalHitsExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Diese Erweiterung enthält die Gesamtanzahl der Treffer einer Volltextsuche in einem Dokument (z.B. PDF).

**Context of Use**

This extension may be used on the following element(s):

* Element ID Bundle.entry.search

**Usage info**

**Usages:**

* Use this Extension: [EPA Document Search Result Bundle](StructureDefinition-epa-document-search-result-bundle.md)
* Examples for this Extension: [Bundle/example-fulltext-search-match](Bundle-example-fulltext-search-match.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.mhd|current/StructureDefinition/epa-match-total-hits)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-match-total-hits.csv), [Excel](StructureDefinition-epa-match-total-hits.xlsx), [Schematron](StructureDefinition-epa-match-total-hits.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-match-total-hits",
  "url" : "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-match-total-hits",
  "version" : "1.1.0",
  "name" : "EPAMatchTotalHitsExtension",
  "title" : "EPA Match Total Hits Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Diese Erweiterung enthält die Gesamtanzahl der Treffer einer Volltextsuche in einem Dokument (z.B. PDF).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Bundle.entry.search"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "EPA Match Total Hits Extension",
        "definition" : "Diese Erweiterung enthält die Gesamtanzahl der Treffer einer Volltextsuche in einem Dokument (z.B. PDF)."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-match-total-hits"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Gesamtanzahl der in diesem Dokument gefundenen Treffer",
        "definition" : "Gibt die Gesamtanzahl der bei einer Volltextsuche in diesem Dokument gefundenen Treffer an.",
        "min" : 1,
        "type" : [
          {
            "code" : "integer"
          }
        ]
      }
    ]
  }
}

```
