# Datenschutz und Sicherheit - Implementation Guide ePA MHD Service v1.1.0

Implementation Guide

ePA MHD Service

Version 1.1.0 - release

* [**Table of Contents**](toc.md)
* **Datenschutz und Sicherheit**

## Datenschutz und Sicherheit

Das ePA-Aktensystem soll nachstehende Anforderungen erfüllen, um Zugriffe auf den MHD Service zu legitimieren.

Der MHD Service MUSS die gesetzlich verbindlichen Regelungen der Zugriffsrechte bzgl. der Berufsgruppen und Datenkategorien aus der [gemSpec_Aktensystem_ePAfueralle#Legal Policy] berücksichtigen (d.h. er darf Dokumente ohne Leserecht nicht für die Suche und Herausgabe berücksichtigen). Ferner darf der MHD Service Dokumente nicht berücksichtigen, die durch eine
*General Deny Policy*verborgen wurden. Die generelle Ausführung des MHD Service ist ausschließlich für eine im ePA-Aktensystem befugte Leistungserbringerinstitution mit Nutzergruppe aus der nachstehenden Liste durchzuführen:

| |
| :--- |
| oid_institution-arbeitsmedizin |
| oid_institution-pflege |
| oid_institution-geburtshilfe |
| oid_institution-oegd |
| oid_institution-vorsorge-reha |
| oid_krankenhaus |
| oid_öffentliche_apotheke |
| oid_praxis_arzt |
| oid_praxis-ergotherapeut |
| oid_praxis-ernaehrungstherapeut |
| oid_praxis-logopaede |
| oid_praxis-physiotherapeut |
| oid_praxis_psychotherapeut |
| oid_praxis-podologe |
| oid_versicherter |
| oid_zahnarztpraxis |

**Tabelle:**Befugbare Nutzergruppen mit Ausführungsrecht für Suche und Herausgabe von Dokumenten

Der MHD Service MUSS bei einer Suchanfrage durch einen Nutzer alle Zugriffsregeln durchsetzen, die für den Zugriff dieses Nutzers bzgl. des XDS Document Service gelten.
Hinweis zu IG-MHD45146PEW-*: Nutzer dürfen durch den MHD Service keinen Zugriff auf Dokumente erhalten, auf den sie über den XDS Document Service nicht zugreifen dürften. So dürfen Nutzer mittels des MHD Services keinen Zugriff auf Dokumente einer Dokumentenkategorie erhalten, auf die sie nach der Legal Policy nicht zugreifen dürfen. Genauso dürfen sie über den MHD Service keine Dokumente finden, die auf der General Deny Policy stehen.

Der MHD Service MUSS bei einer Suchanfrage bei jedem Dokument einer verborgenen Datenkategorie die Metadaten (bzw. korrespondierende FHIR-Ressource
*DocumentReference*) filtern sowie den Dokumentenabruf aus 
*DocumentReferences.content.attachment.url*verhindern (HTTP Code 404 not found).
### Protokollierung per Audit Event Service

Die Protokollierung erfolgt über den Audit Event Service. Weitere Anforderungen sind [gemIG_ePA_Basic#MHD] zu entnehmen.

