# Generelle Prinzipien - Implementation Guide ePA MHD Service v1.1.0

Implementation Guide

ePA MHD Service

Version 1.1.0 - release

* [**Table of Contents**](toc.md)
* **Generelle Prinzipien**

## Generelle Prinzipien

Dieser Implementation Guide verwendet die Schlüsselwörter **MUSS**, **DARF NICHT**, **SOLL NICHT** und **KANN** als deutsche Pendants des [RFC 2119](https://datatracker.ietf.org/doc/html/rfc2119), um Anforderungen als Ausdruck normativer Festlegungen zu kennzeichnen. Anforderungen werden im Implementation Guide wie folgt dargestellt:

**<IG-ID-Version> - <Titel der Anforderung>**
 Text / Beschreibung
 [<=]

### Übergeordnete Anforderungen

Der MHD Service berücksichtigt als Ausprägung eines FHIR Data Service allgemeingültige [gemIG_TI_Common#MHD] und ePA-spezifische [gemIG_ePA_Basic#MHD] Anforderungen.

### Schnittstellenadressierung

Der MHD Service MUSS sämtliche Schnittstellen unter den folgenden Pfaden verfügbar machen:

* `[base]/epa/mhd/api/v1/fhir/`
* `[base]/epa/mhd/retrieve/v1/content/`
wobei
`[base]`einem gültigen Pfadnamen eines VAU-Kanals nach folgendem Schema entsprechen muss:
`http://epa4all`
### Schnittstellenimplementierung

Der MHD Service MUSS die in diesem Implementation Guide definierten Schnittstellen implementieren und dabei die Vorgaben der [FHIR-Spezifikation] berücksichtigen. Der MHD Service MUSS den logischen IHE ITI Akteur Document Responder mit seinen Schnittstellen
*Find Document References [ITI-67]*und
*Retrieve Document [ITI-68]*implementieren.
Hinweis zu IG-MHD96412M8R-*: Für den MHD Service sind die übergreifenden Anforderungen [gemSpec_Aktensystem_ePAfueralle#A_15159] zum Schutz gegen die OWASP-Risiken und [gemSpec_Aktensystem_ePAfueralle#A_24783] zur Eingabevalidierung zu berücksichtigen, um zu verhindern, dass Schadcode über Suchanfragen ins ePA-Aktensystem eingebracht werden kann.

**Schnittstellen:**

* [Find Document References [ITI-67]](./InterfaceFindDocumentReferences.md)
* [Retrieve Document [ITI-68]](./InterfaceRetrieveDocument.md)

Das Primärsystem bzw. das ePA-FdV MUSS ein ePA-Client-System mit der Nutzung der MHD-Service-Schnittstellen implementieren. Das ePA-Client-System MUSS den logischen IHE ITI Akteur
*Document Consumer*mit den zugehörigen Transaktionen des
*Document Responder*implementieren. Zugriffserfordernisse von Leistungserbringerinstitutionen und damit die Implementierung verschiedener Schnittstellen leiten sich aus [gemSpec_Aktensystem_ePAfueralle#Legal Policy] (Zugriffsrecht "R") ab.
### Datenherausgabe

Der MHD Service unterstützt u.a. die metadatenbasierte Suche von Dokumenten über Autoren- oder Institutionsnamen. Die Herausgabe eines Sucherergebnisses referenziert jedoch den Autor lediglich logisch über eine Telematik-ID oder KVNR. Analoges gilt für die obligatorische Angabe des Versicherten/Akteninhabers (bzw. **Patient** im MHD-Kontext) in den Suchergebnissen.

Im Detail bedeutet dies, dass die FHIR-Elemente **DocumentReference.author** und **DocumentReference.subject** eine indirekte Referenz auf Autoren und des Akteninhabers enthalten. Sollten zusätzliche Informationen benötigt werden (z.B. Telekommunikationsdaten, Rolle, Fachgebiet des Autors) muss das ePA-Client-System die Dokumentmetadaten vom XDS Document Service abrufen. Die besagte Referenz zeigt jedoch neben des Identifikators auch den Namen an.

#### Rückgabe des Capability Statement

Der MHD Service MUSS die Funktion
`GET [base]/epa/mhd/api/v1/fhir/metadata`implementieren. Diese Funktionalität stellt sicher, dass bei einem Aufruf von
`/metadata`das FHIR CapabilityStatement mit dem Namen
*EPAMHDDocumentResponder*des Servers zurückgegeben wird.
Das Capability Statement beschreibt detailliert die Fähigkeiten des MHD Service und ist entscheidend für das Verständnis der unterstützten FHIR-Funktionalitäten.

