# FHIR-Artefakte - Implementation Guide ePA MHD Service v1.1.0

Implementation Guide

ePA MHD Service

Version 1.1.0 - release

* [**Table of Contents**](toc.md)
* **FHIR-Artefakte**

## FHIR-Artefakte

Auf dieser Seite befindet sich eine Liste der FHIR-Artefakte, welche im Rahmen dieses Implementation Guide definiert sind.

### Systemverhalten: Capability Statements

Das **Capability** **Statement** beschreibt die Anforderungen und Fähigkeiten, die ein Server oder Client für die konforme Implementierung im Rahmen des MHD Service umsetzen muss. Es handelt sich um eine Konformitätserklärung, die spezifiziert, welche Ressourcen, Interaktionen und Suchparameter das ePA-Aktensystem unterstützen muss.

*Hinweis:*Die Anfrage eines [FHIR Bundle] wird nicht unterstützt.

| | |
| :--- | :--- |
| [EPA MHD Service (Document Consumer - Client)](CapabilityStatement-epa-mhd-document-consumer.md) | CapabilityStatement für den ePA MHD Service (Document Consumer - Client) |
| [ePA MHD Service (Document Responder - Server)](CapabilityStatement-epa-mhd-document-responder.md) | CapabilityStatement für den ePA MHD Service (Document Responder - Server) |

**Tabelle:**Capability Statements

### Systemverhalten: Suchparameter

| | |
| :--- | :--- |
| [EPAMHDDocumentReferenceTitleSearchParameter](SearchParameter-epa-mhd-documentreference-title.md) | Titel des Dokuments auf Basis von DocumentReference.content.attachment.title |

**Tabelle:**Suchparameter

### Ressourcenprofile

| | |
| :--- | :--- |
| [EPA Document Search Result Bundle](StructureDefinition-epa-document-search-result-bundle.md) | Dieses Profil stellt Suchergebnisse nach Dokumenten inklusive Metadaten und ggf. nach einer Volltextsuche dar. |
| [EPA MHD DocumentReference](StructureDefinition-epa-mhd-document-reference.md) | Dieses Profil erweitert die IHE MHD Minimal DocumentReference-Ressource mit ePA 3.0 Metadaten-Einschränkungen. |

**Tabelle:**Ressourcenprofile

### Erweiterungen (Extension Definitions)

| | |
| :--- | :--- |
| [EPA Match Snippet Extension](StructureDefinition-epa-match-snippet.md) | Diese Erweiterung enthält einen Textausschnitt, der den Kontext eines Suchtreffers beschreibt. Sie hebt relevante Inhalte hervor, die den eingegebenen Suchbegriffen entsprechen und bietet so eine präzise Vorschau auf das Suchergebnis. |
| [EPA Match Total Hits Extension](StructureDefinition-epa-match-total-hits.md) | Diese Erweiterung enthält die Gesamtanzahl der Treffer einer Volltextsuche in einem Dokument (z.B. PDF). |

**Tabelle:**Extension Definitions

### Beispielinstanzen

**Bundle**

* [Example Fulltext Search Match](Bundle-example-fulltext-search-match.md)

**DocumentReference**

* [Example EPA MHD DocumentReference](DocumentReference-b2d5f8db-48ca-43c4-a540-6c8f2e853913.md)

