# EPA MHD DocumentReference - Implementation Guide ePA MHD Service v1.1.0

Implementation Guide

ePA MHD Service

Version 1.1.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA MHD DocumentReference**

## Resource Profile: EPA MHD DocumentReference 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-mhd-document-reference | *Version*:1.1.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMHDDocumentReference |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Dieses Profil erweitert die IHE MHD Minimal DocumentReference-Ressource mit ePA 3.0 Metadaten-Einschränkungen. 

**Usages:**

* Use this Profile: [EPA Document Search Result Bundle](StructureDefinition-epa-document-search-result-bundle.md)
* Examples for this Profile: [DocumentReference/b2d5f8db-48ca-43c4-a540-6c8f2e853913](DocumentReference-b2d5f8db-48ca-43c4-a540-6c8f2e853913.md)
* CapabilityStatements using this Profile: [EPA MHD Service (Document Consumer - Client)](CapabilityStatement-epa-mhd-document-consumer.md) and [ePA MHD Service (Document Responder - Server)](CapabilityStatement-epa-mhd-document-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.mhd|current/StructureDefinition/epa-mhd-document-reference)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-mhd-document-reference.csv), [Excel](StructureDefinition-epa-mhd-document-reference.xlsx), [Schematron](StructureDefinition-epa-mhd-document-reference.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-mhd-document-reference",
  "url" : "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-mhd-document-reference",
  "version" : "1.1.0",
  "name" : "EPAMHDDocumentReference",
  "title" : "EPA MHD DocumentReference",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Dieses Profil erweitert die IHE MHD Minimal DocumentReference-Ressource mit ePA 3.0 Metadaten-Einschränkungen.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "EPADocumentEntryMapping",
      "uri" : "XDS.b",
      "name" : "ePA XDS.b <-> MHD"
    },
    {
      "identity" : "DocumentEntry-Mapping",
      "uri" : "urn:ihe:iti:xds:documententry",
      "name" : "XDS and MHD Mapping"
    },
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.Minimal.DocumentReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference",
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "XDS.b DocumentEntry: Inhaltsgleiche Abbildung zum XDS Document Service"
          }
        ]
      },
      {
        "id" : "DocumentReference.meta.profile",
        "path" : "DocumentReference.meta.profile",
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "Keine Entsprechung zu XDS.b DocumentEntry"
          }
        ]
      },
      {
        "id" : "DocumentReference.masterIdentifier",
        "path" : "DocumentReference.masterIdentifier",
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.uniqueId"
          }
        ]
      },
      {
        "id" : "DocumentReference.identifier",
        "path" : "DocumentReference.identifier",
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.entryUUID"
          }
        ]
      },
      {
        "id" : "DocumentReference.status",
        "path" : "DocumentReference.status",
        "short" : "Status des Dokuments",
        "definition" : "Status des Dokuments (DocumentEntry.availabilityStatus) unter Berücksichtigung des [MHD Mapping](https://profiles.ihe.net/ITI/MHD/ConceptMap/FhirStatusVsStatusCode)",
        "comment" : "Dies ist der Status des DocumentReference-Objekts, das unabhängig vom docStatus-Element ist.\n\nDieses Element wird als Modifier gekennzeichnet, da der Status Codes enthält, die das Dokument oder die Referenz als derzeit nicht gültig markieren.",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.availabilityStatus"
          }
        ]
      },
      {
        "id" : "DocumentReference.docStatus",
        "path" : "DocumentReference.docStatus",
        "short" : "n/a",
        "definition" : "n/a",
        "comment" : "n/a"
      },
      {
        "id" : "DocumentReference.type",
        "path" : "DocumentReference.type",
        "short" : "Art des Dokuments",
        "definition" : "Art des Dokuments (DocumentEntry.typeCode)",
        "comment" : "Das Attribut typeCode ist gemäß IHE XDS zwingend gefordert und kann zusätzlich zu (bzw. zusammen mit) dem classCode zur genaueren Klassifizierung des Dokuments genutzt werden, z.B. kann ein Dokument mit classCode 'Befundberichte' durch den typeCode als 'Pathologiebefundbericht' oder als 'Ergebnisse bildgebender Diagnostik' gekennzeichnet werden. Das Attribut typeCode stellt keine Spezialisierung von classCode dar. Somit kann ein bestimmter typeCode mit verschiedenen classCodes zur Beschreibung unterschiedlicher Dokumente kombiniert werden. Zum Beispiel haben ein Röntgenbild und der dazugehörige Radiologie-Befund den gleichen typeCode 'Ergebnisse bildgebender Diagnostik' aber zwei unterschiedliche classCodes, 'Bilddaten' bzw.'Befundberichte'. Daraus folgt, dass ein Dokument sowohl einem classCode als auch einem typeCode explizit zugeordnet werden muss; die Zuordnung zu einem typeCode allein reicht nicht aus, weil hierüber kein implizites Mapping auf einen einzigen 'übergeordneten' classCode möglich ist.",
        "min" : 1,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.typeCode"
          }
        ]
      },
      {
        "id" : "DocumentReference.type.coding",
        "path" : "DocumentReference.type.coding",
        "definition" : "n/a",
        "comment" : "n/a",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/epa-xds-type-code-vs"
        }
      },
      {
        "id" : "DocumentReference.type.coding.system",
        "path" : "DocumentReference.type.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.type.coding.code",
        "path" : "DocumentReference.type.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.type.coding.display",
        "path" : "DocumentReference.type.coding.display",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.category",
        "path" : "DocumentReference.category",
        "short" : "Grobe Klassifizierung des Dokuments",
        "definition" : "Grobe Klassifizierung des Dokuments (DocumentEntry.classCode)",
        "comment" : "Das Attribut 'classCode' ist gemäß IHE XDS zwingend gefordert und erlaubt eine erste Klassifizierung der Dokumente in der XDS Document Registry in Dokumentenklassen, wie z.B. Briefe, Befundberichte oder Bilddaten. Die Wertemenge für diese Klassen sollte nicht zu detailliert sein, da im Attribut 'typeCode' eine weitere, verfeinerte Beschreibung der Dokumente erfolgt, die allerdings keine Spezialisierung des 'classCode' darstellen muss.",
        "min" : 1,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.classCode"
          }
        ]
      },
      {
        "id" : "DocumentReference.category.coding",
        "path" : "DocumentReference.category.coding",
        "definition" : "n/a",
        "comment" : "n/a",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/epa-xds-class-code-vs"
        }
      },
      {
        "id" : "DocumentReference.category.coding.system",
        "path" : "DocumentReference.category.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.category.coding.code",
        "path" : "DocumentReference.category.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.category.coding.display",
        "path" : "DocumentReference.category.coding.display",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.subject",
        "path" : "DocumentReference.subject",
        "short" : "Systemweit eindeutige Kennung des Patienten",
        "definition" : "Systemweit eindeutige Kennung des Patienten (DocumentEntry.patientId)",
        "comment" : "EPAPatient|1.0.0",
        "min" : 1,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.patientId"
          }
        ]
      },
      {
        "id" : "DocumentReference.subject.identifier",
        "path" : "DocumentReference.subject.identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://fhir.de/StructureDefinition/identifier-kvid-10"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.date",
        "path" : "DocumentReference.date",
        "short" : "Das Erzeugungsdatum wird in content.attachment.creation abgebildet.",
        "definition" : "n/a",
        "comment" : "n/a"
      },
      {
        "id" : "DocumentReference.author",
        "path" : "DocumentReference.author",
        "short" : "Person oder System, welche(s) das Dokument erstellt hat",
        "definition" : "Person oder System, welche(s) das Dokument erstellt hat (DocumentEntry.author)",
        "comment" : "Logical Reference unter Nutzung der KVNR oder Telematik-ID",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Patient",
              "http://hl7.org/fhir/StructureDefinition/Practitioner",
              "http://hl7.org/fhir/StructureDefinition/Organization"
            ]
          }
        ],
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.author"
          }
        ]
      },
      {
        "id" : "DocumentReference.author.identifier",
        "path" : "DocumentReference.author.identifier",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://fhir.de/StructureDefinition/identifier-kvid-10",
              "http://fhir.de/StructureDefinition/identifier-telematik-id",
              "http://fhir.de/StructureDefinition/identifier-lanr",
              "http://fhir.de/StructureDefinition/identifier-zanr"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.author.display",
        "path" : "DocumentReference.author.display",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.authenticator",
        "path" : "DocumentReference.authenticator",
        "short" : "Rechtlich Verantwortlicher für das Dokument",
        "definition" : "Rechtlich Verantwortlicher für das Dokument (DocumentEntry.legalAuthenticator)",
        "comment" : "Logical Reference unter Nutzung der Telematik-ID",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Practitioner",
              "http://hl7.org/fhir/StructureDefinition/Organization"
            ]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.legalAuthenticator"
          }
        ]
      },
      {
        "id" : "DocumentReference.authenticator.identifier",
        "path" : "DocumentReference.authenticator.identifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://fhir.de/StructureDefinition/identifier-telematik-id"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.custodian",
        "path" : "DocumentReference.custodian",
        "short" : "n/a",
        "definition" : "n/a",
        "comment" : "n/a",
        "max" : "0",
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "Keine Entsprechung zu XDS.b DocumentEntry"
          }
        ]
      },
      {
        "id" : "DocumentReference.relatesTo",
        "path" : "DocumentReference.relatesTo",
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "Keine Entsprechung zu XDS.b DocumentEntry"
          }
        ]
      },
      {
        "id" : "DocumentReference.description",
        "path" : "DocumentReference.description",
        "short" : "Ergänzende Hinweise in Freitext",
        "definition" : "Ergänzende Hinweise in Freitext (DocumentEntry.comments)",
        "comment" : "n/a",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.comments"
          }
        ]
      },
      {
        "id" : "DocumentReference.securityLabel",
        "path" : "DocumentReference.securityLabel",
        "short" : "Vertraulichkeitskennzeichnung und Datenkategorie des Dokuments",
        "definition" : "Vertraulichkeitskennzeichnung des Dokuments (DocumentEntry.confidentialityCode)",
        "comment" : "Der Confidentiality Code drückt die Vertraulichkeitsstufe des Dokuments aus. Die Vertraulichkeitsstufe ist üblicherweise die Einschätzung des Autors oder des Einstellenden wie schützenswert das Dokument ist. Die Einschätzung des Autors oder Erstellers sollte erhalten bleiben, auch wenn die des Betroffenen (d.h. des Patienten) davon abweicht. Das heißt, dass man dem Dokument mehrere ConfidentialityCodes zuordnen können sollte. Dies unterstützt IHE XDS auch. Daher enthält das deutsche Value Set neben Codes der Autoreneinschätzung explizite Codes zur Betroffeneneinschätzung, die aus einem separaten, dediziertem Codesystem stammen. Die Datenkategorie des Dokuments entsprechend der ePA Legal Policy ist ebenso Bestandteil dieser Liste.",
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.confidentialityCode sowie zugewiesene Datenkategorien gemäß Legal Policy"
          }
        ]
      },
      {
        "id" : "DocumentReference.securityLabel.coding",
        "path" : "DocumentReference.securityLabel.coding",
        "definition" : "n/a",
        "comment" : "n/a",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/epa-mhd-security-label-vs"
        }
      },
      {
        "id" : "DocumentReference.securityLabel.coding.system",
        "path" : "DocumentReference.securityLabel.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.securityLabel.coding.code",
        "path" : "DocumentReference.securityLabel.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.securityLabel.coding.display",
        "path" : "DocumentReference.securityLabel.coding.display",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.contentType",
        "path" : "DocumentReference.content.attachment.contentType",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/epa-xds-mime-type-vs"
        },
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.mimeType"
          }
        ]
      },
      {
        "id" : "DocumentReference.content.attachment.language",
        "path" : "DocumentReference.content.attachment.language",
        "short" : "Sprache, in der das Dokument abgefasst ist",
        "definition" : "Sprache, in der das Dokument abgefasst ist (DocumentEntry.languageCode)",
        "comment" : "n/a",
        "min" : 1,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.languageCode"
          }
        ]
      },
      {
        "id" : "DocumentReference.content.attachment.url",
        "path" : "DocumentReference.content.attachment.url",
        "short" : "URI für das Dokument",
        "definition" : "URI für das Dokument (DocumentEntry.URI)",
        "comment" : "Dateiname mit Extension ohne Pfadangabe",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "Abweichend zu MHD V4.2.3 vom Document Responder festgelegter Speicherort des Documents"
          }
        ]
      },
      {
        "id" : "DocumentReference.content.attachment.size",
        "path" : "DocumentReference.content.attachment.size",
        "short" : "Größe des Dokuments in Bytes",
        "definition" : "Größe des Dokuments in Bytes (DocumentEntry.size)",
        "comment" : "n/a",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.size"
          }
        ]
      },
      {
        "id" : "DocumentReference.content.attachment.hash",
        "path" : "DocumentReference.content.attachment.hash",
        "short" : "Kryptographische Prüfsumme des Dokuments",
        "definition" : "Kryptographische Prüfsumme des Dokuments (DocumentEntry.hash)",
        "comment" : "n/a",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.hash"
          }
        ]
      },
      {
        "id" : "DocumentReference.content.attachment.title",
        "path" : "DocumentReference.content.attachment.title",
        "short" : "Titel des Dokuments",
        "definition" : "Titel des Dokuments (DocumentEntry.title)",
        "comment" : "n/a",
        "min" : 1,
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.title"
          }
        ]
      },
      {
        "id" : "DocumentReference.content.attachment.creation",
        "path" : "DocumentReference.content.attachment.creation",
        "short" : "Erstellungszeitpunkt des Dokuments",
        "definition" : "Erstellungszeitpunkt des Dokuments (DocumentEntry.creationTime)",
        "comment" : "n/a",
        "min" : 1,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.creationTime"
          }
        ]
      },
      {
        "id" : "DocumentReference.content.format",
        "path" : "DocumentReference.content.format",
        "short" : "Global eindeutiger Code für das Dokumentenformat",
        "definition" : "Global eindeutiger Code für das Dokumentenformat (DocumentEntry.formatCode)",
        "comment" : "Das Attribut 'formatCode' spezifiziert das Format des Dokumentes. Zusammen mit dem typeCode (und ggf. mit dem mimeType) soll der formatCode für hinreichende Information sorgen, um einem Dokument-Konsumenten die Entscheidung zu ermöglichen, ob und wie er das Dokumentenformat verarbeiten kann.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/epa-xds-format-code-vs"
        },
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.formatCode"
          }
        ]
      },
      {
        "id" : "DocumentReference.context.encounter",
        "path" : "DocumentReference.context.encounter",
        "max" : "0",
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "Keine Entsprechung zu XDS.b DocumentEntry"
          }
        ]
      },
      {
        "id" : "DocumentReference.context.event",
        "path" : "DocumentReference.context.event",
        "short" : "Ereignisse, die zur Erstellung des Dokuments geführt haben",
        "definition" : "Ereignisse, die zur Erstellung des Dokuments geführt haben (DocumentEntry.eventCodeList)",
        "comment" : "Die eventCode Liste wurde konzipiert, um den medizinischen Kontext von Dokumenten abzubilden. Jedem Dokument können beliebig viele eventCodes zugeordnet werden. Zum Beispiel kann ein OP-Bericht über die eventCodeList mit je einem kodierten Wert für die durchgeführte Prozedur (z.B. Blinddarmentfernung) und die vorliegende Erkrankung (z.B. Appendizitis) versehen werden. Dies ermöglicht die Suche nach Dokumenten, die mit einer bestimmten Prozedur oder Diagnose zusammenhängen. Über den medizinischen Kontext hinaus kann das Attribut auch allgemein zur Kontextualisierung und zur Inhaltszusammenfassung verwendet werden.",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.eventCodeList"
          }
        ]
      },
      {
        "id" : "DocumentReference.context.event.coding",
        "path" : "DocumentReference.context.event.coding",
        "definition" : "n/a",
        "comment" : "n/a",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/epa-xds-event-code-vs"
        }
      },
      {
        "id" : "DocumentReference.context.event.coding.system",
        "path" : "DocumentReference.context.event.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.event.coding.code",
        "path" : "DocumentReference.context.event.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.event.coding.display",
        "path" : "DocumentReference.context.event.coding.display",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.period.start",
        "path" : "DocumentReference.context.period.start",
        "short" : "Zeitpunkt, an dem das im Dokument dokumentierte (Behandlungs-)Ereignis begonnen wurde",
        "definition" : "Zeitpunkt, an dem das im Dokument dokumentierte (Behandlungs-)Ereignis begonnen wurde (DocumentEntry.serviceStartTime)",
        "comment" : "n/a",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumetEntry.serviceStartTime"
          }
        ]
      },
      {
        "id" : "DocumentReference.context.period.end",
        "path" : "DocumentReference.context.period.end",
        "short" : "Zeitpunkt, an dem das im Dokument dokumentierte (Behandlungs-)Ereignis beendet wurde",
        "definition" : "Zeitpunkt, an dem das im Dokument dokumentierte (Behandlungs-)Ereignis beendet wurde (DocumentEntry.serviceStopTime)",
        "comment" : "n/a",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.serviceStopTime"
          }
        ]
      },
      {
        "id" : "DocumentReference.context.facilityType",
        "path" : "DocumentReference.context.facilityType",
        "short" : "Art der Einrichtung, in der das dokumentierte Ereignis stattgefunden hat",
        "definition" : "Art der Einrichtung, in der das dokumentierte Ereignis stattgefunden hat (DocumentEntry.healthcareFacilityTypeCode)",
        "comment" : "DocumentEntry.healthcareFacilityTypeCode repräsentiert die Art der Einrichtung, in der die Tätigkeit stattfand, die zur Erzeugung des Dokuments führte. Zum Beispiel sollten Dokumente, die während eines ambulanten Falls in einem Krankenhaus entstehen, mit dem healthcareFacilityTypeCode für 'Krankenhaus' gekennzeichnet werden. Dabei ist zu beachten, dass es sich nicht notwendigerweise um die Art der Einrichtung handelt, in der das Dokument erstellt wurde. Beispielsweise ist es bei teleradiologischer Befundung eines Röntgenbildes für den healthcareFacilityTypeCode unerheblich, ob der befundende Radiologe in einem Krankenhaus oder in einer radiologischen Praxis ansässig ist; für den healthcareFacilityTypeCode wird die Einrichtungsart der Untersuchungsstelle (in der das Gerät betrieben wird) herangezogen.",
        "min" : 1,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.healthcareFacilityTypeCode"
          }
        ]
      },
      {
        "id" : "DocumentReference.context.facilityType.coding",
        "path" : "DocumentReference.context.facilityType.coding",
        "definition" : "n/a",
        "comment" : "n/a",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/epa-xds-healthcare-facility-type-code-vs"
        }
      },
      {
        "id" : "DocumentReference.context.facilityType.coding.system",
        "path" : "DocumentReference.context.facilityType.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.facilityType.coding.code",
        "path" : "DocumentReference.context.facilityType.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.facilityType.coding.display",
        "path" : "DocumentReference.context.facilityType.coding.display",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.practiceSetting",
        "path" : "DocumentReference.context.practiceSetting",
        "short" : "Art der Fachrichtung der erstellenden Einrichtung, in der das dokumentiere Ereignis stattgefunden hat",
        "definition" : "Art der Fachrichtung der erstellenden Einrichtung, in der das dokumentiere Ereignis stattgefunden hat (DocumentEntry.practiceSettingCode)",
        "comment" : "DocumentEntry.practiceSettingCode spezifiziert die Fachrichtung der erstellenden Einrichtung. Typische Beispiele hierfür sind ärztliche Fachgebiete wie Allgemeinmedizin oder Radiologie. IHE International empfiehlt, dass die Codeliste zwischen 10 und 100 Codes umfassen sollte, so dass die Fachrichtung hinreichend genau abgebildet werden kann.",
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.practiceSettingCode"
          }
        ]
      },
      {
        "id" : "DocumentReference.context.practiceSetting.coding",
        "path" : "DocumentReference.context.practiceSetting.coding",
        "definition" : "n/a",
        "comment" : "n/a",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://gematik.de/fhir/terminology/ValueSet/epa-xds-practice-setting-code-vs"
        }
      },
      {
        "id" : "DocumentReference.context.practiceSetting.coding.system",
        "path" : "DocumentReference.context.practiceSetting.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.practiceSetting.coding.code",
        "path" : "DocumentReference.context.practiceSetting.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.practiceSetting.coding.display",
        "path" : "DocumentReference.context.practiceSetting.coding.display",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.sourcePatientInfo.reference",
        "path" : "DocumentReference.context.sourcePatientInfo.reference",
        "short" : "Demographische Daten zum Patienten im Quellsystem",
        "definition" : "Demographische Daten zum Patienten im Quellsystem (DocumentEntry.sourcePatientInfo)",
        "comment" : "n/a",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.sourcePatientInfo"
          }
        ]
      },
      {
        "id" : "DocumentReference.context.sourcePatientInfo.identifier",
        "path" : "DocumentReference.context.sourcePatientInfo.identifier",
        "short" : "Kennung des Patienten im Quellsystem",
        "definition" : "Kennung des Patienten im Quellsystem (DocumentEntry.sourcePatientId)",
        "comment" : "n/a",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.sourcePatientId"
          }
        ]
      },
      {
        "id" : "DocumentReference.context.related",
        "path" : "DocumentReference.context.related",
        "short" : "Liste von IDs, mit denen das Dokument assoziiert wird",
        "definition" : "Liste von IDs, mit denen das Dokument assoziiert wird (DocumentEntry.referenceIdList)",
        "comment" : "n/a",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "EPADocumentEntryMapping",
            "map" : "DocumentEntry.referenceIdList"
          }
        ]
      }
    ]
  }
}

```
