# EPA Match Snippet Extension - Implementation Guide ePA MHD Service v1.1.0

Implementation Guide

ePA MHD Service

Version 1.1.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA Match Snippet Extension**

## Extension: EPA Match Snippet Extension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-match-snippet | *Version*:1.1.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAMatchSnippetExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Diese Erweiterung enthält einen Textausschnitt, der den Kontext eines Suchtreffers beschreibt. Sie hebt relevante Inhalte hervor, die den eingegebenen Suchbegriffen entsprechen und bietet so eine präzise Vorschau auf das Suchergebnis.

**Context of Use**

This extension may be used on the following element(s):

* Element ID Bundle.entry.search

**Usage info**

**Usages:**

* Use this Extension: [EPA Document Search Result Bundle](StructureDefinition-epa-document-search-result-bundle.md)
* Examples for this Extension: [Bundle/example-fulltext-search-match](Bundle-example-fulltext-search-match.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.mhd|current/StructureDefinition/epa-match-snippet)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-match-snippet.csv), [Excel](StructureDefinition-epa-match-snippet.xlsx), [Schematron](StructureDefinition-epa-match-snippet.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-match-snippet",
  "url" : "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-match-snippet",
  "version" : "1.1.0",
  "name" : "EPAMatchSnippetExtension",
  "title" : "EPA Match Snippet Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Diese Erweiterung enthält einen Textausschnitt, der den Kontext eines Suchtreffers beschreibt. Sie hebt relevante Inhalte hervor, die den eingegebenen Suchbegriffen entsprechen und bietet so eine präzise Vorschau auf das Suchergebnis.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Bundle.entry.search"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "EPA Match Snippet Extension",
        "definition" : "Diese Erweiterung enthält einen Textausschnitt, der den Kontext eines Suchtreffers beschreibt. Sie hebt relevante Inhalte hervor, die den eingegebenen Suchbegriffen entsprechen und bietet so eine präzise Vorschau auf das Suchergebnis."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "description" : "Extensions are always sliced by (at least) url",
          "rules" : "closed"
        }
      },
      {
        "id" : "Extension.extension:snippet",
        "path" : "Extension.extension",
        "sliceName" : "snippet",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:snippet.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:snippet.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "snippet"
      },
      {
        "id" : "Extension.extension:snippet.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Menschenlesbarer Textausschnitt, der den Kontext des Suchtreffers beschreibt",
        "definition" : "Dieser Wert enthält einen kurzen, menschenlesbaren Textausschnitt, der den Kontext des Suchtreffers beschreibt. Er ermöglicht eine schnelle Orientierung indem relevante Inhalte aus dem gefundenen Dokument oder der Ressource dargestellt werden.",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:pageNumber",
        "path" : "Extension.extension",
        "sliceName" : "pageNumber",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:pageNumber.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:pageNumber.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "pageNumber"
      },
      {
        "id" : "Extension.extension:pageNumber.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Bei Dokumenten mit Seitennummerierung (z.B. PDF) lässt sich hier die genaue Trefferseite der Volltextsuche angeben.",
        "definition" : "Bei Dokumenten mit Seitennummerierung, wie etwa PDF-Dateien, kann hier die konkrete Seite angegeben werden, auf der die Volltextsuche einen Treffer gefunden hat.",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-match-snippet"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
