# EPA Document Search Result Bundle - Implementation Guide ePA MHD Service v1.1.0

Implementation Guide

ePA MHD Service

Version 1.1.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA Document Search Result Bundle**

## Resource Profile: EPA Document Search Result Bundle 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-document-search-result-bundle | *Version*:1.1.0 |
| Active as of 2025-12-15 | *Computable Name*:EPADocumentSearchResultBundle |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
Dieses Profil stellt Suchergebnisse nach Dokumenten inklusive Metadaten und ggf. nach einer Volltextsuche dar. 

**Usages:**

* Examples for this Profile: [Bundle/example-fulltext-search-match](Bundle-example-fulltext-search-match.md)
* CapabilityStatements using this Profile: [EPA MHD Service (Document Consumer - Client)](CapabilityStatement-epa-mhd-document-consumer.md) and [ePA MHD Service (Document Responder - Server)](CapabilityStatement-epa-mhd-document-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.mhd|current/StructureDefinition/epa-document-search-result-bundle)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-document-search-result-bundle.csv), [Excel](StructureDefinition-epa-document-search-result-bundle.xlsx), [Schematron](StructureDefinition-epa-document-search-result-bundle.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-document-search-result-bundle",
  "url" : "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-document-search-result-bundle",
  "version" : "1.1.0",
  "name" : "EPADocumentSearchResultBundle",
  "title" : "EPA Document Search Result Bundle",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Dieses Profil stellt Suchergebnisse nach Dokumenten inklusive Metadaten und ggf. nach einer Volltextsuche dar.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "searchset",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.total",
        "path" : "Bundle.total",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.link",
        "path" : "Bundle.link",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.link.relation",
        "path" : "Bundle.link.relation",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.link.url",
        "path" : "Bundle.link.url",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Bundle.entry:documentReference",
        "path" : "Bundle.entry",
        "sliceName" : "documentReference",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DocumentReference",
            "profile" : [
              "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-mhd-document-reference"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.search",
        "path" : "Bundle.entry.search",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.search.extension:matchSnippet",
        "path" : "Bundle.entry.search.extension",
        "sliceName" : "matchSnippet",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-match-snippet"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.search.extension:matchSnippet.extension:snippet",
        "path" : "Bundle.entry.search.extension.extension",
        "sliceName" : "snippet",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.search.extension:matchSnippet.extension:snippet.value[x]",
        "path" : "Bundle.entry.search.extension.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.search.extension:matchSnippet.extension:pageNumber",
        "path" : "Bundle.entry.search.extension.extension",
        "sliceName" : "pageNumber",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.search.extension:matchSnippet.extension:pageNumber.value[x]",
        "path" : "Bundle.entry.search.extension.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.search.extension:totalHits",
        "path" : "Bundle.entry.search.extension",
        "sliceName" : "totalHits",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-match-total-hits"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.search.extension:totalHits.value[x]",
        "path" : "Bundle.entry.search.extension.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.search.mode",
        "path" : "Bundle.entry.search.mode",
        "short" : "Gibt an, wie ein Dokument in das Suchergebnis der Volltextsuche aufgenommen wurde (d.h. direkt als Treffer, durch Beziehung oder als zusätzliche Information).",
        "definition" : "Dieses Feld beschreibt, wie ein gefundenes Dokument im Rahmen der Volltextsuche in das Suchergebnis einbezogen wurde. Es gibt an, ob das Dokument direkt den Suchkriterien entspricht oder aus anderen Gründen im Ergebnis enthalten ist.\n\nIm Kontext der Volltextsuche auf Dokumenten werden folgende Werte verwendet:\n* match: Das Dokument enthält Inhalte, die direkt mit den angegebenen Suchkriterien übereinstimmen und als relevanter Treffer anzusehen sind.\n* include: Das Dokument wurde aufgrund einer Beziehung zu einem anderen relevanten Treffer oder Kontext in das Ergebnis aufgenommen.\n* outcome: Das Dokument bietet zusätzliche Informationen zur Suchanfrage, wie Hinweise auf die Vollständigkeit der Ergebnisse oder technische Metadaten.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.search.score",
        "path" : "Bundle.entry.search.score",
        "short" : "Bewertet die Relevanz eines Dokuments für die Suchanfrage basierend auf einem berechneten Relevanzwert.",
        "definition" : "Die score-Eigenschaft gibt den Relevanzwert eines Dokuments im Kontext der Volltextsuche an. Dieser Wert wird auf Grundlage der Übereinstimmung zwischen der Suchanfrage und dem Inhalt des Dokuments berechnet. Ein höherer Score zeigt an, dass das Dokument besser mit den Suchkriterien übereinstimmt.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:documentReference.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:documentReference.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.signature",
        "path" : "Bundle.signature",
        "max" : "0"
      }
    ]
  }
}

```
