# Find Document References - Implementation Guide ePA MHD Service v1.1.0

Implementation Guide

ePA MHD Service

Version 1.1.0 - release

* [**Table of Contents**](toc.md)
* **Find Document References**

## Find Document References

Die **Find-Document-References**-Transaktion des MHD Service basiert auf der IHE-Transaktion [ITI-67] der [IHE ITI MHD]-Spezifikation. Sie wird vom ePA-Client-System verwendet, um Dokumente bzw. Dokumentenreferenzen zu finden, die eine Reihe von Suchparametern erfüllen. Als Ergebnis erhält das ePA-Client-System ein vom MHD Service erzeugtes FHIR Bundle mit **DocumentReference**-Ressourcen, die den Anfrageparametern entsprechen. Zusätzlich wird diese IHE-Transaktion um eine Volltextsuche ergänzt.

### Einsatzbereich

Die Transaktion **Find Document References [ITI-67]** wird verwendet, um **DocumentReference**-Ressourcen zu finden, die einer bestimmten Menge von Parametern entsprechen. Sie entspricht den Abfragen **FindDocuments** und **FindDocumentsByReferenceId** sowie den ePA-spezifischen Abfragen **FindDocumentsByTitle** und Query **FindDocumentsByComment** aus der **Registry-Stored-Query**-Transaktion. Das Ergebnis der Abfrage ist ein FHIR Bundle, das die **DocumentReference**-Ressourcen enthält, die mit den Abfrageparametern übereinstimmen.

### Nachricht

**Abbildung:**
*Find-Document-References*-Interaktion


Diese Nachricht wird als HTTP GET- oder HTTP POST-Anfrage an den MHD Service gesendet, um eine Liste von Dokumentmetadaten abzurufen.

#### Auslösung

Wenn das ePA-Client-System eine XDS metadatenbasierte Suche über Dokumente oder eine metadatengestützte Volltextsuche über indizierte Dokumente durchführen und dazu die korrespondierenden **DocumentReference**-Ressourcen ermitteln möchte, sendet er eine **Find-Document-References**-Nachricht.

#### API

Das ePA-Client-System führt eine HTTP-Suche über die **DocumentReference**-URL des MHD Service durch. Das Suchziel richtet sich nach [FHIR-HTTP] und bezieht sich auf die **DocumentReference**-Ressource.

```

      {"resourceType":"CapabilityStatement","id":"epa-mhd-document-responder","meta":{"profile":["https://gematik.de/fhir/ti/StructureDefinition/ti-capability-statement"]},"extension":[{"extension":[{"url":"name","valueString":"X-Request-ID"},{"url":"type","valueString":"string"},{"url":"description","valueString":"UUID of the request message"},{"url":"format","valueString":"uuid"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-insurantid"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Health Record Identifier"},{"url":"pattern","valueString":"^[A-Z]{1}\\d{9}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-useragent"},{"url":"type","valueString":"string"},{"url":"description","valueString":"user agent information"},{"url":"pattern","valueString":"^[a-zA-Z0-9]{20}\\/[a-zA-Z0-9\\-\\.]{1,15}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor not authorized (no user session with valid ID-Token available)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalAuth"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor has no valid entitlement"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"notEntitled"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor role is not in the list of allowed user groups"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalidOid"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Device registration does not exist (if requestor role is oid_versicherter only)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"unregisteredDevice"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Health record is in state UNKNOWN or INITIALIZED"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"noHealthRecord"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Request conflicts with the current state of the health record"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"statusMismatch"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"500"},{"url":"description","valueString":"Any other error"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"internalError"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-base-url","valueString":"http://epa4all/epa/mhd/api/v1/fhir/"}],"url":"https://gematik.de/fhir/epa-mhd/CapabilityStatement/epa-mhd-document-responder","version":"1.1.0","name":"EPAMHDDocumentResponder","title":"ePA MHD Service (Document Responder - Server)","status":"active","date":"2025-12-15","publisher":"gematik GmbH","contact":[{"telecom":[{"system":"url","value":"https://www.gematik.de"}]}],"description":"CapabilityStatement für den ePA MHD Service (Document Responder - Server)","jurisdiction":[{"coding":[{"system":"urn:iso:std:iso:3166","code":"DE"}]}],"copyright":"gematik GmbH / Dieser Implementation Guide ist lizenziert unter [Apache License](./license.html), Version 2.0.","kind":"requirements","imports":["https://gematik.de/fhir/epa/CapabilityStatement/epa-basic-server"],"_imports":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"fhirVersion":"4.0.1","format":["application/fhir+json","application/fhir+xml"],"rest":[{"mode":"server","resource":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"DocumentReference","supportedProfile":["https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-mhd-document-reference"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"DocumentReference"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"}],"versioning":"versioned-update","readHistory":true,"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Aktenweit eindeutige Kennung des Dokuments auf Basis von DocumentReference.entryUUID"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_content","definition":"http://hl7.org/fhir/SearchParameter/Resource-content","type":"string","documentation":"Angaben für inhaltsbasierte Volltextsuche in von DocumentReference referenzierten Dokumenten"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Änderungszeitpunkt der DocumentReference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"author.given","type":"string","documentation":"Vorname der dokumenterstellenden Person auf Basis von DocumentReference.author, welcher dem authorPerson-Slot der DocumentEntry.author-Classification entspricht"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"author.family","type":"string","documentation":"Nachname der dokumenterstellenden Person auf Basis von DocumentReference.author, welcher dem authorPerson-Slot der DocumentEntry.author-Classification entspricht"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"author.organization.name","type":"string","documentation":"Name der dokumenterstellenden Leistungserbringerinstitution auf Basis von DocumentReference.author, welcher dem authorInstitution-Slot der DocumentEntry.author-Classification entspricht"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"category","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-category","type":"token","documentation":"Grobe Klassifizierung des Dokuments auf Basis von DocumentReference.category"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"contenttype","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-contenttype","type":"token","documentation":"MimeType des Dokuments auf Basis von DocumentReference.content.attachment.contentType"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"creation","definition":"https://profiles.ihe.net/ITI/MHD/SearchParameter/DocumentReference-Creation","type":"date","documentation":"Erstellungszeitpunkt des Dokuments auf Basis von DocumentReference.content.attachment.creation"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"date","definition":"https://profiles.ihe.net/ITI/MHD/SearchParameter/DocumentReference-date","type":"date","documentation":"Erstellungszeitpunkt der DocumentReference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"description","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-description","type":"string","documentation":"Ergänzende Hinweise in Freitext auf Basis von DocumentReference.description"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"event","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-event","type":"token","documentation":"Die zur Erstellung des Dokuments geführten Ereignisse auf Basis von DocumentReference.context.event"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"facility","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-facility","type":"token","documentation":"Die auf Basis von DocumentReference.context.facilityTypeArt benannte Art der Einrichtung des dokumentierenden Ereignisses"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"format","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-format","type":"token","documentation":"Global eindeutiger Code für das Dokumentenformat  auf Basis von DocumentReference.content.format"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"Aktenweit eindeutige Kennung des Dokuments auf Basis von DocumentReference.entryUUID"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"language","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-contenttype","type":"token","documentation":"Sprache in der ein Dokument verfasst ist"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"patient","definition":"http://hl7.org/fhir/SearchParameter/clinical-patient","type":"reference","documentation":"Aktenkontoinhaber"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"patient.identifier","type":"token","documentation":"Identifikator des Aktenkontoinhabers"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"period","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-period","type":"date","documentation":"Zeitraum des dokumentierenden Ereignisses auf Basis von DocumentReference.context.period"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"related","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-related","type":"reference","documentation":"ID-Liste mit assoziierten Dokumenten auf Basis von DocumentReference.context.related"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"security-label","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-security-label","type":"token","documentation":"Vertraulichkeitskennzeichnung/Datenkategorie des Dokuments auf Basis von DocumentReference.securityLabel"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"setting","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-setting","type":"token","documentation":"Art der Fachrichtung der erstellenden Einrichtung auf Basis von DocumentReference.context.practiceSetting"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-status","type":"token","documentation":"Status des Dokuments auf Basis von DocumentReference.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"title","definition":"https://gematik.de/fhir/epa-mhd/SearchParameter/epa-mhd-documentreference-title","type":"string","documentation":"Titel des Dokuments auf Basis von DocumentReference.content.attachment.title"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"type","definition":"http://hl7.org/fhir/SearchParameter/clinical-type","type":"token","documentation":"Art des Dokuments auf Basis von DocumentReference.type"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Bundle","supportedProfile":["https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-document-search-result-bundle"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"versioning":"versioned-update","readHistory":true}]}]}
    
```

Beispiel:

```

        GET http://epa4all/epa/mhd/api/v1/fhir/DocumentReference?patient.identifier=http://fhir.de/sid/gkv/kvid-10|G995030566&status=current&status=current&type=http://www.ihe-d.de/fhir/CodeSystem/Dokumententypen|BERI&setting=http://www.ihe-d.de/fhir/CodeSystem/FachrichtungenAerztlich|ALLG&_content=Herz
      
```

```

      {"resourceType":"CapabilityStatement","id":"epa-mhd-document-responder","meta":{"profile":["https://gematik.de/fhir/ti/StructureDefinition/ti-capability-statement"]},"extension":[{"extension":[{"url":"name","valueString":"X-Request-ID"},{"url":"type","valueString":"string"},{"url":"description","valueString":"UUID of the request message"},{"url":"format","valueString":"uuid"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-insurantid"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Health Record Identifier"},{"url":"pattern","valueString":"^[A-Z]{1}\\d{9}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-useragent"},{"url":"type","valueString":"string"},{"url":"description","valueString":"user agent information"},{"url":"pattern","valueString":"^[a-zA-Z0-9]{20}\\/[a-zA-Z0-9\\-\\.]{1,15}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor not authorized (no user session with valid ID-Token available)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalAuth"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor has no valid entitlement"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"notEntitled"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor role is not in the list of allowed user groups"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalidOid"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Device registration does not exist (if requestor role is oid_versicherter only)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"unregisteredDevice"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Health record is in state UNKNOWN or INITIALIZED"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"noHealthRecord"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Request conflicts with the current state of the health record"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"statusMismatch"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"500"},{"url":"description","valueString":"Any other error"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"internalError"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-base-url","valueString":"http://epa4all/epa/mhd/api/v1/fhir/"}],"url":"https://gematik.de/fhir/epa-mhd/CapabilityStatement/epa-mhd-document-responder","version":"1.1.0","name":"EPAMHDDocumentResponder","title":"ePA MHD Service (Document Responder - Server)","status":"active","date":"2025-12-15","publisher":"gematik GmbH","contact":[{"telecom":[{"system":"url","value":"https://www.gematik.de"}]}],"description":"CapabilityStatement für den ePA MHD Service (Document Responder - Server)","jurisdiction":[{"coding":[{"system":"urn:iso:std:iso:3166","code":"DE"}]}],"copyright":"gematik GmbH / Dieser Implementation Guide ist lizenziert unter [Apache License](./license.html), Version 2.0.","kind":"requirements","imports":["https://gematik.de/fhir/epa/CapabilityStatement/epa-basic-server"],"_imports":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"fhirVersion":"4.0.1","format":["application/fhir+json","application/fhir+xml"],"rest":[{"mode":"server","resource":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"DocumentReference","supportedProfile":["https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-mhd-document-reference"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"DocumentReference"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"}],"versioning":"versioned-update","readHistory":true,"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Aktenweit eindeutige Kennung des Dokuments auf Basis von DocumentReference.entryUUID"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_content","definition":"http://hl7.org/fhir/SearchParameter/Resource-content","type":"string","documentation":"Angaben für inhaltsbasierte Volltextsuche in von DocumentReference referenzierten Dokumenten"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Änderungszeitpunkt der DocumentReference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"author.given","type":"string","documentation":"Vorname der dokumenterstellenden Person auf Basis von DocumentReference.author, welcher dem authorPerson-Slot der DocumentEntry.author-Classification entspricht"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"author.family","type":"string","documentation":"Nachname der dokumenterstellenden Person auf Basis von DocumentReference.author, welcher dem authorPerson-Slot der DocumentEntry.author-Classification entspricht"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"author.organization.name","type":"string","documentation":"Name der dokumenterstellenden Leistungserbringerinstitution auf Basis von DocumentReference.author, welcher dem authorInstitution-Slot der DocumentEntry.author-Classification entspricht"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"category","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-category","type":"token","documentation":"Grobe Klassifizierung des Dokuments auf Basis von DocumentReference.category"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"contenttype","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-contenttype","type":"token","documentation":"MimeType des Dokuments auf Basis von DocumentReference.content.attachment.contentType"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"creation","definition":"https://profiles.ihe.net/ITI/MHD/SearchParameter/DocumentReference-Creation","type":"date","documentation":"Erstellungszeitpunkt des Dokuments auf Basis von DocumentReference.content.attachment.creation"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"date","definition":"https://profiles.ihe.net/ITI/MHD/SearchParameter/DocumentReference-date","type":"date","documentation":"Erstellungszeitpunkt der DocumentReference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"description","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-description","type":"string","documentation":"Ergänzende Hinweise in Freitext auf Basis von DocumentReference.description"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"event","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-event","type":"token","documentation":"Die zur Erstellung des Dokuments geführten Ereignisse auf Basis von DocumentReference.context.event"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"facility","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-facility","type":"token","documentation":"Die auf Basis von DocumentReference.context.facilityTypeArt benannte Art der Einrichtung des dokumentierenden Ereignisses"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"format","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-format","type":"token","documentation":"Global eindeutiger Code für das Dokumentenformat  auf Basis von DocumentReference.content.format"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"Aktenweit eindeutige Kennung des Dokuments auf Basis von DocumentReference.entryUUID"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"language","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-contenttype","type":"token","documentation":"Sprache in der ein Dokument verfasst ist"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"patient","definition":"http://hl7.org/fhir/SearchParameter/clinical-patient","type":"reference","documentation":"Aktenkontoinhaber"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"patient.identifier","type":"token","documentation":"Identifikator des Aktenkontoinhabers"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"period","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-period","type":"date","documentation":"Zeitraum des dokumentierenden Ereignisses auf Basis von DocumentReference.context.period"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"related","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-related","type":"reference","documentation":"ID-Liste mit assoziierten Dokumenten auf Basis von DocumentReference.context.related"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"security-label","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-security-label","type":"token","documentation":"Vertraulichkeitskennzeichnung/Datenkategorie des Dokuments auf Basis von DocumentReference.securityLabel"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"setting","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-setting","type":"token","documentation":"Art der Fachrichtung der erstellenden Einrichtung auf Basis von DocumentReference.context.practiceSetting"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-status","type":"token","documentation":"Status des Dokuments auf Basis von DocumentReference.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"title","definition":"https://gematik.de/fhir/epa-mhd/SearchParameter/epa-mhd-documentreference-title","type":"string","documentation":"Titel des Dokuments auf Basis von DocumentReference.content.attachment.title"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"type","definition":"http://hl7.org/fhir/SearchParameter/clinical-type","type":"token","documentation":"Art des Dokuments auf Basis von DocumentReference.type"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Bundle","supportedProfile":["https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-document-search-result-bundle"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"versioning":"versioned-update","readHistory":true}]}]}
    
```

Beispiel:

```

        POST http://epa4all/epa/mhd/api/v1/fhir/DocumentReference/_search?patient.identifier=http://fhir.de/sid/gkv/kvid-10|G995030566&status=current&type=http://www.ihe-d.de/fhir/CodeSystem/Dokumententypen|BERI&setting=http://www.ihe-d.de/fhir/CodeSystem/FachrichtungenAerztlich|ALLG&_content=Herz
      
```
Beispiel:

```

        POST /epa/mhd/api/v1/fhir/DocumentReference/_search HTTP/1.1
        Host: epa4all
        Content-Type: application/x-www-form-urlencoded
        Accept: application/fhir+json

        patient.identifier=http://fhir.de/sid/gkv/kvid-10|G995030566&status=current&setting=http://www.ihe-d.de/fhir/CodeSystem/FachrichtungenAerztlich|ALLG&_content=Kopf OR Zahl
      
```

```

      {"resourceType":"CapabilityStatement","id":"epa-mhd-document-responder","meta":{"profile":["https://gematik.de/fhir/ti/StructureDefinition/ti-capability-statement"]},"extension":[{"extension":[{"url":"name","valueString":"X-Request-ID"},{"url":"type","valueString":"string"},{"url":"description","valueString":"UUID of the request message"},{"url":"format","valueString":"uuid"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-insurantid"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Health Record Identifier"},{"url":"pattern","valueString":"^[A-Z]{1}\\d{9}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-useragent"},{"url":"type","valueString":"string"},{"url":"description","valueString":"user agent information"},{"url":"pattern","valueString":"^[a-zA-Z0-9]{20}\\/[a-zA-Z0-9\\-\\.]{1,15}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor not authorized (no user session with valid ID-Token available)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalAuth"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor has no valid entitlement"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"notEntitled"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor role is not in the list of allowed user groups"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalidOid"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Device registration does not exist (if requestor role is oid_versicherter only)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"unregisteredDevice"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Health record is in state UNKNOWN or INITIALIZED"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"noHealthRecord"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Request conflicts with the current state of the health record"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"statusMismatch"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"500"},{"url":"description","valueString":"Any other error"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"internalError"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-base-url","valueString":"http://epa4all/epa/mhd/api/v1/fhir/"}],"url":"https://gematik.de/fhir/epa-mhd/CapabilityStatement/epa-mhd-document-responder","version":"1.1.0","name":"EPAMHDDocumentResponder","title":"ePA MHD Service (Document Responder - Server)","status":"active","date":"2025-12-15","publisher":"gematik GmbH","contact":[{"telecom":[{"system":"url","value":"https://www.gematik.de"}]}],"description":"CapabilityStatement für den ePA MHD Service (Document Responder - Server)","jurisdiction":[{"coding":[{"system":"urn:iso:std:iso:3166","code":"DE"}]}],"copyright":"gematik GmbH / Dieser Implementation Guide ist lizenziert unter [Apache License](./license.html), Version 2.0.","kind":"requirements","imports":["https://gematik.de/fhir/epa/CapabilityStatement/epa-basic-server"],"_imports":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"fhirVersion":"4.0.1","format":["application/fhir+json","application/fhir+xml"],"rest":[{"mode":"server","resource":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"DocumentReference","supportedProfile":["https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-mhd-document-reference"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"DocumentReference"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"TIOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"}],"versioning":"versioned-update","readHistory":true,"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Aktenweit eindeutige Kennung des Dokuments auf Basis von DocumentReference.entryUUID"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_content","definition":"http://hl7.org/fhir/SearchParameter/Resource-content","type":"string","documentation":"Angaben für inhaltsbasierte Volltextsuche in von DocumentReference referenzierten Dokumenten"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Änderungszeitpunkt der DocumentReference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"author.given","type":"string","documentation":"Vorname der dokumenterstellenden Person auf Basis von DocumentReference.author, welcher dem authorPerson-Slot der DocumentEntry.author-Classification entspricht"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"author.family","type":"string","documentation":"Nachname der dokumenterstellenden Person auf Basis von DocumentReference.author, welcher dem authorPerson-Slot der DocumentEntry.author-Classification entspricht"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"author.organization.name","type":"string","documentation":"Name der dokumenterstellenden Leistungserbringerinstitution auf Basis von DocumentReference.author, welcher dem authorInstitution-Slot der DocumentEntry.author-Classification entspricht"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"category","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-category","type":"token","documentation":"Grobe Klassifizierung des Dokuments auf Basis von DocumentReference.category"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"contenttype","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-contenttype","type":"token","documentation":"MimeType des Dokuments auf Basis von DocumentReference.content.attachment.contentType"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"creation","definition":"https://profiles.ihe.net/ITI/MHD/SearchParameter/DocumentReference-Creation","type":"date","documentation":"Erstellungszeitpunkt des Dokuments auf Basis von DocumentReference.content.attachment.creation"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"date","definition":"https://profiles.ihe.net/ITI/MHD/SearchParameter/DocumentReference-date","type":"date","documentation":"Erstellungszeitpunkt der DocumentReference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"description","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-description","type":"string","documentation":"Ergänzende Hinweise in Freitext auf Basis von DocumentReference.description"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"event","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-event","type":"token","documentation":"Die zur Erstellung des Dokuments geführten Ereignisse auf Basis von DocumentReference.context.event"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"facility","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-facility","type":"token","documentation":"Die auf Basis von DocumentReference.context.facilityTypeArt benannte Art der Einrichtung des dokumentierenden Ereignisses"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"format","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-format","type":"token","documentation":"Global eindeutiger Code für das Dokumentenformat  auf Basis von DocumentReference.content.format"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"Aktenweit eindeutige Kennung des Dokuments auf Basis von DocumentReference.entryUUID"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"language","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-contenttype","type":"token","documentation":"Sprache in der ein Dokument verfasst ist"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"patient","definition":"http://hl7.org/fhir/SearchParameter/clinical-patient","type":"reference","documentation":"Aktenkontoinhaber"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"patient.identifier","type":"token","documentation":"Identifikator des Aktenkontoinhabers"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"period","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-period","type":"date","documentation":"Zeitraum des dokumentierenden Ereignisses auf Basis von DocumentReference.context.period"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"related","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-related","type":"reference","documentation":"ID-Liste mit assoziierten Dokumenten auf Basis von DocumentReference.context.related"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"security-label","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-security-label","type":"token","documentation":"Vertraulichkeitskennzeichnung/Datenkategorie des Dokuments auf Basis von DocumentReference.securityLabel"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"setting","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-setting","type":"token","documentation":"Art der Fachrichtung der erstellenden Einrichtung auf Basis von DocumentReference.context.practiceSetting"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/DocumentReference-status","type":"token","documentation":"Status des Dokuments auf Basis von DocumentReference.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"title","definition":"https://gematik.de/fhir/epa-mhd/SearchParameter/epa-mhd-documentreference-title","type":"string","documentation":"Titel des Dokuments auf Basis von DocumentReference.content.attachment.title"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"type","definition":"http://hl7.org/fhir/SearchParameter/clinical-type","type":"token","documentation":"Art des Dokuments auf Basis von DocumentReference.type"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Bundle","supportedProfile":["https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-document-search-result-bundle"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"versioning":"versioned-update","readHistory":true}]}]}
    
```

Das ePA-Client-System MUSS mindestens eine der beiden HTTP-Methoden (GET oder POST) für Suchanfragen implementieren. Die parallele Unterstützung beider Methoden ist möglich, aber nicht zwingend erforderlich.

Der MHD Service MUSS sowohl GET- als auch POST-basierte Suchanfragen unterstützen, wie in der [FHIR-HTTP-Search] festgelegt.
##### Suchparameter

Die Suchparameter für die FHIR MHD **DocumentReference**-Ressource sind im **CapabilityStatement** mit dem Namen **EPAMHDDocumentResponder** definiert. Sie ermöglichen eine präzise Suche nach relevanten Dokumenten innerhalb eines MHD-kompatiblen Systems. Der MHD-Service erweitert die von der MHD-Spezifikation definierten Suchparameter um **author.organization.name**, **_content**, **language** sowie **title**.

Das ePA-Client-System MUSS mindestens die Suchparameter
`patient.identifier`und
`status`in der Suchanfrage belegen.

Der MHD Service MUSS die Suchparameter, die in dem
*[CapabilityStatement](./CapabilityStatement-epa-mhd-document-responder.md)*mit dem Namen
*EPAMHDDocumentResponder*verarbeiten können.
#### Volltextsuche

Neben der Angabe von XDS-Metadaten für das Auffinden von Dokumenten soll ein ePA-Client-System in der Benutzerschnittstelle ein oder mehrere Eingabefelder für die Volltextsuche zur Verfügung stellen.

Das ePA-Client-System KANN die Volltextsuche über mehrere Eingabesuchfelder in der Benutzerschnittstelle implementieren. In diesem werden die Suchkriterien separat eingegeben. Das ePA-Client-System ist dafür verantwortlich, die Werte der Felder zu einer Zeichenkette zu kombinieren, die dem Parameterformat des MHD Service entspricht. Die Eingabefelder können sein:

* ein oder mehrere Wörter (oder Wortteile) getrennt mit Leerzeichen, die alle im potentiellen Trefferdokument enthalten sein müssen (*UND*-Funktion)
* ein oder mehrere Wörter (oder Wortteile) getrennt mit Leerzeichen, von denen mindestens eines im potentiellen Trefferdokument enthalten sein muss (*ODER*-Funktion)
* einzelne Wörter (oder Wortgruppen, jeweils in Anführungszeichen), getrennt voneinander mit Leerzeichen, die exakt wie zwischen den Anführungszeichen angegeben im potentiellen Trefferdokument enthalten sein müssen
* einzelne Wörter (oder Wortteile), oder ganze Wortgruppen (jeweils in Anführungszeichen), getrennt voneinander mit Leerzeichen, die nicht im potentiellen Trefferdokument enthalten sein dürfen (*NICHT*-Funktion)

Das ePA-Client-System SOLL clientseitig erweiterte Suchfunktionen für die Volltextsuche implementieren. Dazu zählen z.B. eine (abschaltbare) Rechtschreibkorrektur, das Speichern von Suchanfragen, die Umsetzung weiterer Filtermöglichkeiten und Sortierungen der Suchergebnisse.
**Hinweis:** Auf Mobilsystemen (Android und iOS) reicht es aus, für die Rechtschreibkorrektur auf die Bordmittel des jeweiligen Betriebssystems zurückzugreifen. Dies kann auch auf weiteren Betriebssystemen der Fall sein, wenn diese eine sinnvolle Unterstützung bei der Eingabe bieten können. Die Abschaltbarkeit wird deshalb gefordert, um eine erzwungene Rechtschreibkorrektur zu verhindern, die das Eingeben exakter Worte oder Phrasen aktiv verhindert. Wenn die gewählte Rechtschreibkorrektur beispielwiese vorschlagsbasiert arbeitet und Änderungen durch den Benutzer bestätigen lässt, ist die Abschaltbarkeit damit abgegolten. Insgesamt ist es das Ziel, einfache Tippfehler bei der Eingabe schnell erkennen und ggf. korrigieren zu können, aber es gleichzeitig dem Benutzer zu ermöglichen, bequem die Vorschläge der Rechtschreibkorrektur zu ignorieren.

Das ePA-Client-System MUSS bei Volltextsuchen mit dem Parameter
`_content`und den Schlüsselwörtern
*AND*,
*OR*sowie
*NOT*die Vorgaben aus [OData-Search] berücksichtigen.
Zur Bildung des Suchstrings kommt eine vereinfachte Grammatik (siehe unten IG-MHD72948GYM) zum Einsatz. Zudem ist es nicht erlaubt, Suchanfragen zu verschachteln (d.h. “Klammerungstiefe” 1).

Das ePA-Client-System KANN die Volltextsuche über ein einzelnes Eingabesuchfeld in der Benutzerschnittstelle implementieren. In diesem wird die Suchanfrage manuell über eine Zeichenkette eingegeben.

Der MHD Service MUSS für den Suchparameter
*content*der Volltextsuche die folgende Syntax akzeptieren und verarbeiten können (und MUSS nicht passende Anfragen mit einem Fehler ablehnen):
* Alle zu suchenden Begriffen werden über eine einzelne Zeichenkette (Suchstring) kodiert.
* Jeder Suchbegriff darf alle Groß- und Kleinbuchstaben (inkl. Umlaute), Ziffern, Bindestrich sowie den Buchstaben "ß" beinhalten.
* Jeder Suchbegriff (und der gesamte Suchstring) wird in UTF-8 kodiert (etwaiges Escaping für die Übertragung nicht mit eingerechnet).
* Suchbegriffe werden "case-insensitive" gesucht, d.h. die Groß-Kleinschreibung wird vom MHD Service ignoriert.
* Suchbegriffe werden an jeder Stelle des Worts gefunden (Beginn, Mitte, Ende).
* Statt eines einfachen Suchbegriffes können mehrere Suchbegriffe als sogenannte "Phrase" mit Leerzeichen getrennt in hohe Anführungszeichen (") gesetzt werden. Wenn ein Dokument die Suchbegriffe in der Phrase in der darin abgelegten Schreibweise und Reihenfolge (ebenfalls über Leerzeichen getrennt) enthält, gilt das Dokument als Treffer. Der Inhalt einer Phrase wird ebenfalls "case-insensitive" gesucht.
* Suchbegriffe (inklusive Phrasen als ganzes) können über die booleschen Operatoren (und Schlüsselwörter) mittels *AND* und *OR* miteinander zu einem logischen Ausdruck verbunden werden und bei Bedarf mit NOT negiert werden: 
* *AND*: Beide Suchbegriffe/Phrasen müssen in einem Dokument gefunden werden, damit das Dokument als Treffer gilt.
* *OR*: Einer von beiden Suchbegriffen/Phrasen muss in einem Dokument gefunden werden, damit das Dokument als Treffer gilt.
* *NOT*: Jeder Suchbegriff/Phrase kann über ein vorangestelltes *NOT* negiert werden und das Dokument gilt dann als Treffer, wenn der Suchbegriff/die Phrase nicht im Dokument gefunden werden kann. Das gilt auch für einzelne Begriffe, die nicht über *AND*/*OR* verknüpft sind.
* Boolesche Schlüsselwerte gelten innerhalb von Phrasen als reguläre Suchbegriffe. Phrasen können wie einzelne Suchbegriffe als Ganzes mit den erwähnten booleschen Operatoren verknüpft werden.
* Die Bindungsstärke der booleschen Operatoren ist wie folgt: *NOT* (am stärksten) > *AND* > *OR* (am schwächsten).
* Mit einfacher runder Klammerung "(" und ")" kann die Auswertereihenfolge (Bindung) der einzelnen Suchbegriffe/Phrasen in einem booleschen Ausdruck angepasst werden. Eine verschachtelte Klammerung ist nicht erlaubt.
 
* Mehrere Suchbegriffe/Phrasen müssen immer über *AND* oder *OR* verknüpft werden.

Das ePA-Client-System MUSS die Volltextsuche über die in IG-MHD72948GYM beschriebene Syntax und Semantik umsetzen.

Das ePA-Client-System SOLL die Find-Document-References-Transaktion derartig umsetzen, dass Volltextsuche und Metadatenfilterung innerhalb derselben Suchanfrage kombiniert werden können.
Die Anforderung ist keine harte (“MUSS”-)Verpflichtung, da es ePA-Client-Systeme geben kann, für die eine Kombination beider Sucharten nicht sinnvoll in das Gesamtkonzept zu integrieren ist. Andere Client-Systeme setzen möglicherweise nur sehr ausgewählte Anwendungsfälle um, bei denen diese Kombination nicht sinnvoll oder notwendig ist.

##### Beispiele für gültige Suchanfragen

* **Einzelne Begriffe**: 
* `Diabetes`: Sucht im Dokument nach Worten, die die Buchstabenfolge "Diabetes" enthalten (case-insensitive, mögliche Treffer z. B. 'Diabetes', 'Diabetesuntersuchung', 'Altersdiabetessymptom', 'TYP-1-DIABETES').
* `Bluthochdruck`: Sucht im Dokument nach Worten, die die Buchstabenfolge "Bluthochdruck" enthalten (case-insensitive, s.o.).
 
* **Phrasen mit Anführungszeichen**: 
* `"Diabetes"`: Sucht im Dokument das Wort Diabetes (case-insensitive), einige mögliche Trefferwörter: 'Diabetes', 'diabetes', 'DIAbetES'.
* `"Chronische Schmerzen"`: Sucht im Dokument nach der genauen Buchstabenfolge (Phrase) "Chronische Schmerzen", inklusive des Leerzeichens (case-insensitive, d.h. auch andere Groß/Kleinschreibung möglich).
* `"Herz-Kreislauf-Erkrankungen"`: Sucht im Dokument nach der genauen Buchstabenfolge (Phrase) "Herz-Kreislauf-Erkrankungen" (case-insensitive).
 
* **Verwendung von booleschen Operatoren**: 
* `Diabetes AND Bluthochdruck`: Sucht im Dokument nach Worten, die die Buchstabenfolge "Diabetes" und "Bluthochdruck" enthalten (case-insensitive) und liefert nur dann einen Treffer, wenn beide gefunden werden.
* `Asthma OR "Chronische Schmerzen"`: Sucht im Dokument nach Worten, die die Buchstabenfolge "Asthma" (case-insensitive) oder die Phrase "Chronische Schmerzen" (case-insensitive) enthalten und liefert dann einen Treffer, eins von beiden gefunden wird.
* `NOT Krebs`: Sucht im Dokument nach der Wortfolge "Krebs" (case-insensitive), und liefert einen Treffer, wenn das Wort nicht gefunden wird.
 
* **Verwendung von Klammern zur Anpassung der Auswertereihenfolge**: 
* `(Diabetes OR Bluthochdruck) AND Asthma`Ähnlich wie oben, zwingt nur den MHD Service, die "OR"-Verknüpfung vor dem "AND" auszuwerten.
* `("Chronische Schmerzen" OR Asthma) AND NOT Krebs`Weiteres Beispiel für Klammerung.
 
* **Suchanfrage ohne Klammern mit relevanter Bindungsstärke**: 
* `NOT Diabetes AND Asthma OR Bluthochdruck`
* **Erklärung**: 
* `NOT Diabetes AND Asthma OR Bluthochdruck`
* **Erklärung**: 
* Der `NOT`-Operator hat die höchste Bindungsstärke und wird zuerst ausgewertet, sodass überprüft wird, ob das Dokument den Begriff "Diabetes" nicht enthält.
* Der `AND`-Operator hat die nächste höchste Bindungsstärke. Die Suchanfrage prüft, ob "Asthma" im Dokument enthalten ist und "Diabetes" nicht enthalten ist.
* Der `OR`-Operator wird zuletzt ausgewertet. Ein Dokument gilt als Treffer, wenn entweder "Asthma" enthalten ist und "Diabetes" nicht enthalten ist, oder wenn "Bluthochdruck" im Dokument enthalten ist.
* Eine äquivalente Suchanfrage wäre:`(NOT Diabetes AND Asthma) OR Bluthochdruck`
 
 
 

##### Beispiele für ungültige Suchanfragen

* **Ungültige Verwendung von Operatoren**: 
* `Diabetes AND OR Bluthochdruck` 
**Grund**: Die Kombination von `AND` und `OR` ohne Suchbegriff dazwischen ist nicht erlaubt.
 
* **Fehlende Anführungszeichen für Phrasen**: 
* `Chronische Schmerzen AND Asthma` 
**Grund**: Eine Phrase wie "Chronische Schmerzen" muss in Anführungszeichen gesetzt werden, um als zusammenhängender Begriff erkannt zu werden. Alternativ könnte zwischen "Chronische" und "Schmerzen" ein AND oder OR gesetzt werden. Die vorliegende Suche hingegen würde einen Fehler zurückgeben.
 
* **Unzulässige Verschachtelung von Klammern**: 
* `(Diabetes OR (Bluthochdruck AND Asthma))` 
**Grund**: Verschachtelte Klammerung ist nicht erlaubt. Die Grammatik erlaubt nur eine Ebene der Klammerung.
 
* **Unvollständige logische Ausdrücke**: 
* `NOT AND Diabetes` 
**Grund**: `NOT` muss einem spezifischen Suchbegriff oder einer Phrase vorangestellt sein, nicht einem Operator.
 
* **Falsche Platzierung von Klammern**: 
* `Diabetes OR )Bluthochdruck AND Asthma(` 
**Grund**: Die Klammern sind falsch platziert. Klammern müssen korrekt geöffnet und geschlossen werden.
 

#### Verarbeitung

Der MHD Service verarbeitet die Anfrage, um die **DocumentReference**-Einträge zu ermitteln, die den angegebenen Suchparametern entsprechen. Darüber hinaus gibt er einen zur Verarbeitung passenden HTTP Status Code sowie ein [FHIR Bundle](./StructureDefinition-epa-document-search-result-bundle.md) der passenden [DocumentReference](./StructureDefinition-epa-mhd-document-reference.md)-Ressourcen zurück.

Der MHD Service MUSS mit dem Akteur
*XDS Document Consumer*gruppiert sein, um die
*XDS on FHIR*-Unterstützung zu verarbeiten. Der MHD Service MUSS die Option [XDS-ON-FHIR] implementieren.
Diese Anforderung stellt insbesondere sicher, dass MHD-Anfragen korrekt auf die entsprechenden XDS-Metadaten abgebildet werden.

Der MHD Service MUSS den Wert des FHIR-Elements
*DocumentReferences.content.attachment.url*nach dem Muster

`http://epa4all/epa/mhd/retrieve/v1/content/fb202c64-ff3f-4109-836e-0bbc75e246d3.pdf`
aufbauen und die URL zum Abruf des Dokuments somit festlegen. Dabei wird nach dem Pfad das Dokument über den
*DocumentReference.identifier*zuzüglich der Dateiendung des MIME-Types adressiert. Zulässige Dateiendungen in Kombination zum MIME-Type sind in der Anforderung [gemSpec_Aktensystem_ePAfueralle#A_24864] definiert.
Der **DocumentReference.identifier** ist gemäß [MHD-Metadaten-Mapping](./StructureDefinition-epa-mhd-document-reference-mappings.md) mit der **DocumentEntry.entryUUID** des dazugehörigen XDS-Dokuments belegt.

Der MHD Service DARF Instanzen von
*Practitioner*,
*Organization*sowie
*Patient*NICHT in den FHIR-Elementen
*DocumentReference.subject*und
*DocumentReference.author*erzeugen und referenzieren. Stattdessen MUSS der MHD Service eine [Resource References] erzeugen und deren FHIR-Elemente wie folgt belegen:

* *Reference.display:* Nachname, Vorname(n), Namenszusatz bzw. Institutionsname des *DocumentEntry*-Metadatenattributs *author* (hier *authorPerson*)
* *Reference.identifier:* [Profil Telematik-ID] bzw. [Profil KVNR] bzw. [Profil LANR] bzw. [Profil ZANR]

Der MHD Service MUSS das FHIR-Element
*DocumentReference.meta.lastUpdated*initial inhaltsgleich mit den Elementen
*DocumentReference.lastUpdated*sowie
*DocumentReference.content.attachment.creation*belegen. Nach einer Änderung von Metadaten per
*Restricted Metadata Update (RMU)*MUSS der MHD Service das FHIR-Element
*DocumentReference.meta.lastUpdated*mit dem Aktualisierungszeitpunkt neu belegen.

Der MHD Service MUSS eine Root Document Unique ID gemäß [gemSpec_Aktensystem_ePAfueralle#A_24451] in der Liste des FHIR-Elements
*DocumentReference.context.related*wie folgt kodieren:

* *Reference.identifier.system:* `urn:gematik:iti:xds:2023:rootDocumentUniqueId`
* `http://epa4all/epa/mhd/retrieve/v1/content/fb202c64-ff3f-4109-836e-0bbc75e246d3.pdf`

Der MHD Service DARF NICHT die Liste des FHIR-Elements
*DocumentReference.context.related.identifier.value*mit HL7 V2 Identifier-Werte belegen, sondern MUSS sie wie folgt kodieren:

* *Reference.identifier.assigner.display:* Feld *CXi.4* (Assigning Authority) des HL7 V2 Identifier der Reference-ID aus *DocumentEntry.referenceIdList*
* *Reference.identifier.system:* Feld *CXi.5* (Identifier Type Code) des HL7 V2 Identifier der Reference-ID aus *DocumentEntry.referenceIdList*
* *Reference.identifier.value:* Feld *CXi.1* (Identifier Type Code) des HL7 V2 Identifier der Reference-ID aus *DocumentEntry.referenceIdList*

Der MHD Service MUSS
*Bundle*- sowie
*DocumentReference*-Instanzen konform zu
*[EPADocumentSearchResultBundle](./StructureDefinition-epa-document-search-result-bundle.md)*bzw.
*[EPAMHDDocumentReference](./StructureDefinition-epa-mhd-document-reference.md)*zurückgeben. Ferner MUSS das
*[MHD-Metadaten-Mapping](./StructureDefinition-epa-mhd-document-reference-mappings.md)*berücksichtigt werden. Außerdem MUSS der MHD Service die Datenkategorie des zugehörigen XDS-Dokuments mit einem Wert aus den Value Sets
*[EPADataCategoryMedicalVS]</a>*bzw.
*[EPADataCategoryOtherVS]*in das Element
*DocumentReference.securityLabel*hinzufügen.

Der MHD Service MUSS bei Belegung des Elements
*DocumentReference.context.sourcePatientInfo*die folgenden Abbildungsvorschriften berücksichtigen:

* *Reference.reference:* PID-5 aus *DocumentEntry.sourcePatientInfo; wenn mehrere Namen per PID-5 hinterlegt sind, muss nur der Name des ersten Listeneintrags berücksichtigt werden*
* *Reference.identifier.system:* URN-kodierte OID der Assigning Authority des HL7 V2 CX-Datentyps aus *DocumentEntry.sourcePatientId*
* *Reference.identifier.value:* Id Number des HL7 V2 CX-Datentyps aus *DocumentEntry.sourcePatientId*

Der MHD Service MUSS in der Operation Find Document References die Paginierung unterstützen, um eine Verarbeitung und Navigation großer Datenmengen zu ermöglichen. Die Implementierung der Paginierung erfolgt gemäß den allgemeinen Paginierungsanforderungen des FHIR Data Service.
In der Operation Find Document References können neben den Standardpaginierungsparametern wie *_count* und *_offset* weitere Parameter enthalten sein, die die Paginierung erleichtern. Ein Beispiel hierfür ist der Parameter *stateid*, der den aktuellen Zustand der Ergebnisliste repräsentiert. Dies ermöglicht es dem MHD Service, die Navigation durch die Ergebnisse effizient zu verwalten, indem der Kontext oder Zustand der Suche erhalten bleibt.

Der MHD Service MUSS Ergebnisse in der Ergebnisliste standardmäßig nach
*DocumentReference.content.attachment.creation*beziehungs such den Suchparameter
*creation*sortieren. Die Reihenfolge MUSS in absteigender Sortierung (desc) sein, sodass die neuesten Daten zuerst angezeigt werden.

Der MHD Service MUSS beim Abgleich der Suchbegriffe mit dem Dokumentenindex auch syntaktisch leicht abweichende Wörter finden (und als "passend" bewerten) können. Dazu zählt mindestens die Umsetzung einer Levensthein-Distanz ("Editierdistanz") [Levensthein] von 1 pro Wort (Suchphrasen ausgenommen).
Die Auswertung mit größeren Editierdistanzen (>=2) kann unterstützt werden. Sie kann auch variabel eingesetzt werden (z. B. je nach Wortlänge der Suchbegriffe). Dieselbe Suchanfrage sollte aber bei unverändertem Dokumentenindex immer verlässlich dieselben Treffer liefern.

##### Snippet- und Trefferanzahl-Erweiterungen

Die **Match Snippet Extension** und die **Match Total Hits Extension** sind Erweiterungen, die im Rahmen der Volltextsuche verwendet werden, um die Ergebnisse der Suche detaillierter darzustellen. Die **Match Snippet Extension** dient dazu, relevante Textausschnitte (Snippets) aus einem Dokument zu extrahieren, die den gesuchten Begriff enthalten. Diese Snippets werden im **value** der Erweiterung bereitgestellt und markieren den gefundenen Begriff durch das Tag *<match> </match>*. Zusätzlich wird die Seitenzahl des Dokuments angegeben, auf der der Treffer gefunden wurde. Die **Match Total Hits Extension** bietet eine Gesamtübersicht der Treffer im Dokument. Es gibt an, wie viele Treffer insgesamt im gesamten Dokument gefunden wurden, basierend auf der Volltextsuche.

Der MHD Service MUSS die Erweiterung
*EPA Match Total Hits Extension*innerhalb des
*search*-Elements der
*entry*-Liste im
*Bundle*, das die Ergebnisliste der Volltextsuche enthält, befüllen. Die Erweiterung
*EPA Match Total Hits Extension*MUSS den Wert der Gesamtzahl der Treffer im Dokument als
*integer*angeben, wobei dieser Wert die Gesamtzahl der Treffer im gesamten Dokument widerspiegelt und nicht nur die Anzahl der zurückgegebenen Snippets.

Der MHD Service MUSS die Erweiterung
*EPA Match Snippet Extension*innerhalb des
*search*-Elements der
*entry*-Liste im
*Bundle*(Ergebnisliste) befüllen. Die Erweiterung
*EPA Match Snippet Extension*MUSS für jedes relevante Snippet einen Ausschnitt des Dokuments im
*value*enthalten, wobei der gefundene Suchbegriff im Text durch das Tag
*<match> </match>*hervorgehoben wird.

Wenn der Treffer eine PDF/A-Datei mit DocumentEntry.mimeType="application/pdf" betrifft oder ein indiziertes PDF/A gemäß IG-MHD02507JFH (Elektronischer Arztbrief) muss der MHD Service innerhalb der Erweiterung
*EPA Match Snippet Extension*in
*pageNumber*die Seitenzahl angeben, auf welcher Treffer im Dokument gefunden wurde.

Der MHD Service MUSS für jeden Treffer im Dokument ein Snippet zurückgeben. Sollte die Anzahl der gefundenen Snippets mehr als 10 betragen, MUSS der MHD Service nur die ersten 10 Snippets zurückgeben.
**Beispiel Snippets und Trefferanzeige**

```
{
  "url": "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-match-snippet",
  "extension": [
    {
      "url": "snippet",
      "valueString": "Das ist ein <match>Test</match>."
    },
    {
      "url": "pageNumber",
      "valueString": "1"
    }
  ]
}

```

**Beispiel Gesamtzahl der Treffer pro Dokument**

```
{
  "url": "https://gematik.de/fhir/epa-mhd/StructureDefinition/epa-match-total-hits",
  "valueInteger": 2
}

```

Der MHD Service SOLL den
*score*-Wert für jeden Treffer in der Ergebnisliste auf Basis des Okapi BM 25-Verfahrens [BM25] angegeben. Dabei dürfen für den Anfragenden nicht sichtbare Dokumente nicht in die Berechnung eingehen.

```
{
  "resourceType": "Bundle",
  "entry": [
    {
      "search": {
        "mode": "match",
        "score": 0.9
      }
      ...
    }
  ],
  "type": "searchset",
  "total": 1
}

```

### Sicherheitsanforderungen

Generelle Sicherheitsanforderungen werden [hier](./privacy-security.md) festgehalten.

