# Technische Anwendungsfälle - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **Technische Anwendungsfälle**

## Technische Anwendungsfälle

Der Medication Service hält sämtliche erfasste Medikationsdaten eines Versicherten dauerhaft vor. Schnittstellen und Datenformate basieren auf den **Fast Healthcare Interoperability Resources** (**FHIR**) Standard Release R4 (v4.0.1). Die beiden kontextbezogenen Sichten für die Prozessunterstützung des dgMP **elektronische Medikationsliste (eML)** und **elektronischer Medikationsplan (eMP)** basieren auf verknüpfte Medikationsdaten im Datenraum des Medication Service. Dieser ist ein **FHIR Data Service** und damit Teil der **Medical Services** des ePA-Aktensystems. Er wird in einer vertrauenswürdigen Ausführungsumgebung (VAU) betrieben (vgl. nachstehende Abbildung).

Anforderungen an ePA-Client-Systeme zu Lokalisierung und Aufbau einer Verbindung zum ePA-Aktensystem und damit die clientseitige Nutzung des Medication Service sind im Implementierungsleitfaden [gemILF_PS_ePA] sowie [gemSpec_Krypt] einzusehen.

**Abbildung:**Systemüberblick der Fachanwendung ePA (
[FMC-Blockdiagramm](http://www.fmc-modeling.org/))


Nachfolgend werden technische Anwendungsfälle des dgMP näher erläutert. Im Medication Service gespeicherte Medikationsdaten werden über die in diesen Anwendungsfällen entstehenden FHIR-Ressourcen verknüpft. In den zugehörigen beschreibenden UML-Diagrammen bedeuten die benannten Kanten die jeweilige Verknüpfung der FHIR-Ressourcen über im FHIR-Standard definierten FHIR-Elemente untereinander. Über die Query API können anhand dieses Modells sämtliche Medikationsdaten vollständig abgefragt werden.

### Grundlagen der eMP-Modellierung

Die Modellierung des eMP basiert auf einem prozessorientierten Ansatz, der sich von einer rein dokumentarischen Sichtweise unterscheidet. Ziel ist es, die Medikationsinformationen nicht als statische Momentaufnahme abzubilden, sondern als Abbild eines Medikationsprozesses, der sich über längere Zeiträume hinweg entwickeln und verändern kann.

#### Die prozessuale Sicht des eMP

In vielen traditionellen Modellen wird der (elektronische) Medikationsplan als eine Art Dokument verstanden, das den aktuellen Stand der verordneten und eingenommenen Medikamente abbildet. Dies führt zu einer statischen Repräsentation (typischerweise einem Dokument), die regelmäßig als vollständige Momentaufnahme neu erstellt werden muss, sobald sich Änderungen ergeben. Der hier gewählte Ansatz verfolgt dagegen den Gedanken eines fortlaufend geführten Medikationsplans, der über längere Zeiträume Bestand hat und dessen Veränderungen nachvollziehbar dokumentiert werden. Anpassungen der Medikation (z.B. Ergänzungen oder das Absetzen von Arzneimitteln) werden direkt im Prozessmodell abgebildet und nicht in einer davon getrennten Dokumentationsschicht festgehalten. Der Plan ist damit nicht als Dokument zu verstehen, sondern als eine Sicht auf einen medizinischen Prozess, der durch Ärzt:innen, Apotheker:innen und weitere an der Versorgung beteiligte Personen beeinflusst wird.

#### MedicationRequest als zentrale Ressource

Die Wahl fiel bewusst auf die FHIR-Ressource **MedicationRequest**, da sie als **Request**-Ressource Teil des FHIR-Workflow-Modells ist, eine klare Prozesslogik abbildet und für jede Medikation den Ausgangspunkt eines Therapieprozesses beschreibt. Im Gegensatz zu **MedicationStatement**, das eine Feststellung über eine Medikation beschreibt (also den Fakt, dass jemand ein Medikament einnimmt oder eingenommen hat), beschreibt **MedicationRequest** eine Intention, die einen geplanten oder angeordneten medizinischen Vorgang initiiert.

Im Kontext des eMP wird **MedicationRequest.intent = plan** verwendet, um auszudrücken, dass die Medikation

* als Bestandteil eines längerfristigen Behandlungsplans vorgesehen ist,
* noch nicht zwingend verschrieben wurde (dies geschieht ggf. später durch eine konkrete Verschreibung via E-Rezept),
* den geplanten Medikationsstatus eines Versicherten über einen längeren Zeitraum repräsentiert.

Das bedeutet hierbei nicht, dass jeder **MedicationRequest** mit **intent = plan** automatisch zu einer aktiven Verschreibung führt. Vielmehr handelt es sich um den medizinischen Planungsstand, der als Grundlage für zukünftige Verschreibungen oder Änderungen dient. Eine explizite Dokumentation über die Bereitstellung oder Abgabe eines Arzneimittels als Antwort des Service Request erfolgt nicht. Es erfolgt lediglich die Verknüpfung mit einem optionalen Verordnungs- und Abgabegeschehen per E-Rezept.

#### Unterstützung von Langzeitprozessen

Durch diesen Ansatz kann ein **MedicationRequest** im Kontext des eMP über viele Jahre hinweg Bestand haben und als Referenz für zugehörige Verschreibungs- und Abgabedaten dienen. Die Ressource bildet den Ausgangspunkt für Verschreibungen, Dispensierungen oder Medikationsprotokolle (Nachträge) und kann jederzeit angepasst, erweitert oder beendet werden. Auf diese Weise bildet der eMP nicht nur den aktuellen Stand ab, sondern spiegelt die Entwicklung und Anpassung langfristiger Medikationstherapien wider, die sich über verschiedene Arztkontakte, Fachrichtungen und Versorgungsbereiche hinweg erstrecken.

### Anwendungsfall: Verordnung, Verschreibung und Dispensierung mit dem eMP

Dieser technische Anwendungsfall subsumiert die Schritte **Verschreibung und Dispensierung**. Zuallererst erfolgt ausgehend von der eMP-basierten Verordnung eines Arzneimittels ein Eintrag im eMP des Medication Service (d.h. **Medication**-Instanz des Profils **EMPMedication** und **MedicationRequest**-Instanz des Profils **EMPMedicationRequest**). Hierbei werden zusätzlich Dosierungsanweisung, Einnahmezeitraum, die Diagnose (ICD-10-GM) sowie ein möglicher Kommentar angegeben.

**Schnittstelle:** *[Operation API: eMP-Eintrag hinzufügen](./op-add-emp-entry.md)*

Anschließend erfolgt die Verschreibung (d.h. **Medication**-Instanz des Profils **EPAMedication** und **MedicationRequest**-Instanz des Profils **EPAMedicationRequest**) dieses Arzneimittels über das E-Rezept. Hinweis: Eine Folgeverordnung kann aus Nutzersicht analog eMP-basiert erfolgen (z.B. ausgehend vom markierten eMP-Eintrag), bedeutet jedoch primärsystemintern lediglich eine Wiederverschreibung des bereits verknüpften E-Rezepts. Nach der Verschreibung erfolgen die Abgabe des Arzneimittels sowie die Dokumentation der Dispensierung (d.h. **MedicationDispense**-Instanz des Profils **EPAMedicationDispense**) im Medication Service.

**Der eMP-Identifier**

Der *eMP-Identifier* ist ein systemgenerierter, eindeutiger Identifikator für jeden eMP-Eintrag. Er wird durch den Medication Service bei der erstmaligen Erstellung eines eMP-Eintrags erzeugt und bleibt über die gesamte Lebensdauer des Eintrags unverändert, auch wenn neue Versionen desselben eMP-Eintrags angelegt werden.

**Automatische Verknüpfungslogik von eML- und eMP-Einträgen**

Die Verknüpfung eines eMP-Eintrags mit einer Verschreibung erfolgt durch die primärsystemseitige, optionale Übergabe einer Referenz des eMP-Eintrags an das E-Rezept. Diese Referenz erfolgt als logische Referenz unter Verwendung des eindeutigen *eMP-Identifiers*. Der E-Rezept-Fachdienst gibt bei der nachfolgenden Übergabe der Verschreibung an den Medication Service diese optional vorhandene Referenz ebenso mit. Intern erzeugt der Medication Service bei Erhalt der Verschreibung eine Medikationsinformation (d. h. *MedicationStatement*-Instanz des Profils *EPAMedicationStatement*) für den entstehenden eML-Eintrag und verknüpft sie über *MedicationStatement.derivedFrom*. Die Dosierinformation aus der Verschreibung wird in die Medikationsinformation kopiert, da dies die zentrale Stelle für die Aktualisierung und das Auslesen strukturierter Dosierinformationen darstellt.

Der nun vorhandene eML-Eintrag und der assoziierte eMP-Eintrag werden verbunden (*MedicationRequest.activity* des Profils *EMPMedicationRequest* → *MedicationStatement* sowie *MedicationStatement.basedOn* → *MedicationRequest*).

Nach Erhalt einer Dispensierinformation wird die dispensierte *Medication* als neue *medicationReference* für den eMP-Eintrag herangezogen. Dadurch verweist der eMP-Eintrag stets auf das aktuell dispensierte Arzneimittel. Die bei der Erstellung des eMP-Eintrags ursprünglich referenzierte *Medication*-Instanz bleibt dennoch erhalten. Hierfür steht im Profil *EMPMedicationRequest* die Erweiterung *originMedication* zur Verfügung.

Eine Ausnahme bilden Kombipackungen (*kbvDarreichungsform = KPG*): diese werden im Rahmen einer Dispensierung nicht automatisch als neue *medicationReference* in den eMP-Eintrag übernommen.

Im Falle einer Substitution wird zusätzlich – sofern vorhanden – die veränderte Dosierinformation aus der Dispensierung an den eMP-Eintrag übergeben. So wird erkennbar, dass das substituierte Arzneimittel in einer anderen Form einzunehmen ist.

**Verlaufsinformationen**

Sämtliche Veränderungen der Medikationsdaten werden über Änderungseinträge (d.h. **Provenance**-Instanz des Profils **EPAActivityProvenance**) erfasst. Die Erzeugung und Aktualisierung von eMP-Einträgen führt zur Fortschreibung eines eMP-Chronologieeintrags (d.h. **Provenance**-Instanz des Profils **EMPChronologyProvenance**). Auch hier belegt dies jeweils ein Änderungseintrag.

Am Prozess beteiligte und erfasste Akteure sind:

* Der/die eMP-verordnende Leistungserbringerinstitution (d.h. **Organization**-Instanz des Profils **TIOrganization**)
* Der/die verschreibende Leistungserbringer(-in) (d.h. **Practitioner**-Instanz des Profils **PractitionerDirectory**) sowie die verschreibende Leistungserbringerinstitution (d.h. **Organization**-Instanz des Profils **OrganizationDirectory**) - beide sind über die Rolle **PractitionerRole** miteinander verbunden
* Die abgebende Apotheke als Leistungserbringerinstitution (d.h. **Organization**-Instanz des Profils **OrganizationDirectory**)

Das nachstehende UML-Modell zeigt die entstandenen und verknüpften Daten dieses dgMP-Anwendungsfalls.

**Abbildung:**Anwendungsfall
*Verordnung, Verschreibung und Dispensierung mit dem eMP*
#### Verschreibung und Dispensierung

Dieser technische Anwendungsfall beschreibt die verknüpften Daten, welche während der Rezeptierung/ Verschreibung eines Arzneimittels sowie Abgabe in der Apotheke und den damit entstehenden Dispensierdatensatz im Medication Service entstehen. Trigger für die Entstehung und Verknüpfung dieser Daten sind die Anwendungsfälle des E-Rezepts [E-Rezept-Anwendungsfälle].

**Abbildung:**Abbildung: Anwendungsfall Verschreibung und Dispensierung


**Prozessübergänge bei Übertragung von Verschreibungs- und Dispensierdaten**

Bei der Übertragung von Verschreibungs- und Dispensierdaten aus dem E-Rezept-Fachdienst an den Medication Service werden jeweils passende Statuswerte für die beteiligten Ressourcen gesetzt. Diese Statusangaben beschreiben, in welchem fachlichen Zustand sich die einzelnen Ressourcen befinden und ermöglichen eine eindeutige Einordnung der aktuellen Situation im Medikationsprozess. Damit wird nachvollziehbar, welche Schritte im Verschreibungs- und Abgabeprozess bereits erfolgt sind und welche noch ausstehen.

**Verschreibungsdaten einstellen**

Wenn eine neue Verschreibung an den Medication Service übermittelt wird, erhält die Verschreibung (**MedicationRequest**) den Status **active**, was bedeutet, dass sie gültig und für eine Abgabe bereit ist. Das verschriebene Arzneimittel (**Medication**) wird zunächst mit dem Status **inactive** geführt, da es noch nicht abgegeben wurde. Die zugehörige Medikationsinformation (**MedicationStatement**) wird mit dem Status **intended** gekennzeichnet, da die Einnahme des Arzneimittels geplant, aber noch nicht erfolgt ist.

**Dispensierinformationen einstellen**

Bei der Übermittlung von Dispensierinformationen wird zunächst die Dispensierung (**MedicationDispense**) mit dem Status **in-progress** angelegt. In diesem Zustand kann die Abgabe noch bearbeitet oder korrigiert werden. Erst wenn der Abgabeprozess vollständig abgeschlossen ist und der Dispensierdatensatz den Status **completed** erhält, wird auch der Status der Verschreibung (**MedicationRequest**) auf **completed** gesetzt. Damit wird angezeigt, dass alle mit der Verschreibung verbundenen Maßnahmen abgeschlossen wurden. Das verschriebene Arzneimittel (**Medication**) wechselt in den Status **active**, wodurch deutlich wird, dass es dem Patienten zur Verfügung steht. Die Medikationsinformation (**MedicationStatement**) erhält den Status **unknown**, da keine Informationen über die tatsächliche Einnahme durch den Patienten vorliegen. Basierend auf dem Ablauf des Prozesses wird jedoch angenommen, dass das Medikament eingenommen wird.

**Verschreibungsdaten stornieren**

Wird eine Verschreibung storniert, erhalten alle beteiligten Ressourceninstanzen den Status **entered-in-error**. Damit wird kenntlich gemacht, dass die Verschreibung sowie die damit verbundenen Arzneimittel- und Medikationsinformationen fehlerhaft oder ungültig sind. Das gilt auch dann, wenn bereits einzelne Maßnahmen durchgeführt wurden.

**Dispensierung stornieren**

Wenn eine Dispensierinformation storniert wird, wird die ursprüngliche Verschreibung wieder auf **active** gesetzt, sodass sie weiterhin für eine neue Abgabe genutzt werden kann. Die betroffene Dispensierung (**MedicationDispense**) erhält den Status **entered-in-error**, um die Stornierung zu dokumentieren. Das Arzneimittel (**Medication**) wird wieder als **inactive** geführt, da es dem Patienten nach der Stornierung der Abgabe nicht mehr zur Verfügung steht. Der Status der Medikationsinformation (**MedicationStatement**) wechselt zurück auf den Wert **intended**, da die Einnahme weiterhin geplant, aber noch nicht umgesetzt ist.

**Abbildung:**Statusübergänge bei Verschreibung und Dispensierung


**Interne Abläufe zur Verknüpfung der Medikationsdaten**

Wie weiter oben beschrieben, werden die Daten aus Verschreibung (*EPAMedicationRequest*) und Abgabe (*EPAMedicationDispense*) in einem durchgängigen Prozess miteinander verknüpft. Beim Empfang einer Verschreibung führt der Medication Service dazu mehrere Schritte aus.

Zunächst wird die übermittelte Verschreibung als Instanz des Profils *EPAMedicationRequest* gespeichert und die logische Referenz in *MedicationRequest.subject* auf die entsprechende *EPAPatient*-Instanz gesetzt. Anschließend wird eine neue Medikationsinformation erzeugt, repräsentiert durch eine Instanz des Profils *EPAMedicationStatement*. Auch hier wird die logische Referenz in *MedicationStatement.subject* auf den *EPAPatient* gesetzt, während die Referenz in *MedicationStatement.derivedFrom* auf die ursprüngliche *MedicationRequest*-Instanz verweist. Die Angabe der verordneten Medikation erfolgt über *MedicationStatement.medicationReference*, das auf die *Medication*-Instanz gesetzt wird.

Darüber hinaus werden Zeit- und Dosierungsinformationen übernommen: *MedicationStatement.dateAsserted* erhält den Wert aus *MedicationRequest.authoredOn*, *MedicationStatement.dosage* wird mit den Angaben aus *MedicationRequest.dosageInstruction* gefüllt, der Status des *MedicationStatement* wird auf *intended* gesetzt, und *MedicationStatement.effective[x].start* wird ebenfalls mit dem Wert aus *MedicationRequest.authoredOn* belegt.

Zur Nachvollziehbarkeit wird zusätzlich eine Provenance-Instanz des Profils *EPAActivityProvenance* erzeugt, die das erzeugte *MedicationStatement* als Ziel (*Provenance.target*) referenziert und als Aktivität den Wert *CREATE* trägt.

Liegt im Kontext der Verschreibung bereits eine eMP-Verknüpfung vor, wird diese ebenfalls berücksichtigt: In diesem Fall erhält das *MedicationStatement* über *MedicationStatement.basedOn* eine Referenz auf die zugehörige *EMPMedicationRequest*-Instanz.

Das nachstehende UML-Sequenzdiagramm verdeutlicht die Ausstellung des E-Rezepts durch ein verordnendes Praxisverwaltungssystem (PVS) oder Krankenhausinformationssystem (KIS) mit anschließender Übertragung in den Medication Service.

**Abbildung:**Anwendungsfall
*Verschreibungsdaten einstellen*


**Schnittstelle:** *[Operation API: Verschreibungsdaten einstellen](./op-provide-prescription-erp.md)*

Beim Empfang von Dispensierinformationen werden diese als *MedicationDispense*-Instanz des Profils *EPAMedicationDispense* gespeichert. Die logische Referenz in *MedicationDispense.subject* wird auf den *EPAPatient* gesetzt und *MedicationDispense.authorizingPrescription* verweist auf die zugehörige *MedicationRequest*-Instanz. Das bestehende *MedicationStatement* wird über *MedicationStatement.derivedFrom* mit der neuen *MedicationDispense* verknüpft. Liegt eine Dosierungsanweisung in *MedicationDispense.dosageInstruction* vor, so wird diese in das *MedicationStatement.dosage* übernommen.

Besteht eine eMP-Verknüpfung, wird die dispensierte *Medication* als neue *medicationReference* im zugehörigen *EMPMedicationRequest* gesetzt (KPG/Kombipackungen sind hiervon ausgenommen). Ab diesem Zeitpunkt wird das *MedicationStatement* zusätzlich über *EMPMedicationRequest.activity* mit dem eMP-Eintrag verknüpft. Durch die Änderung der referenzierten *Medication* wird in jedem Fall eine neue Version des eMP erzeugt und in *EMPChronologyProvenance* dokumentiert (inkl. *EPAActivityProvenance* mit *activity=UPDATE*).

Nur im Falle einer Substitution wird darüber hinaus die angepasste Dosierinformation aus der Dispensierung in den *EMPMedicationRequest* übernommen und dort ebenfalls versioniert.

Das nachstehende UML-Sequenzdiagramm verdeutlicht den Übertrag von Dispensierinformationen des E-Rezepts durch eine abgebende Apotheke über ein Apothekenverwaltungssystem (AVS) mit anschließender Übertragung in den Medication Service.

**Abbildung:**Anwendungsfall
*Dispensierinformationen einstellen*


**Schnittstelle:** *[Operation API: Dispensierinformationen einstellen](./op-provide-dispensation-erp.md)*

##### Übertragung von Löschinformationen zu E-Rezepten in den ePA Medication Service

**1. Gelöschtes, verschriebenes E-Rezept ohne Einlösung (durch Arzt oder Versicherte/n)**

Wird ein verschriebenes E-Rezept gelöscht, bevor es eingelöst wurde, wird diese Löschinformation an den Medication Service übertragen. Die betroffene Verschreibung erscheint weder in der gerenderten eML, noch wird sie von der Operation *[Operation API: Medikationsliste abrufen (eML)](./op-get-medication-list.md)* zurückgegeben.

**2. Gelöschtes, verschriebenes E-Rezept durch die Apotheke**

Wenn ein Apothekenverwaltungssystem (AVS) ein verschriebenes, aber nicht eingelöstes E-Rezept löscht, wird der Löschvorgang an den Medication Service übermittelt. Die Verschreibung wird folglich weder in der eML dargestellt noch durch die *[Operation API: Medikationsliste abrufen (eML)](./op-get-medication-list.md)* bereitgestellt.

**3. Gelöschtes, eingelöstes (abgegebenes) E-Rezept durch Versicherte/n**

Wird ein bereits eingelöstes und damit abgegebenes E-Rezept durch Versicherte/n gelöscht, wird diese Löschinformation **nicht** an den Medication Service übertragen. In diesem Fall bleiben die entsprechenden Einträge weiterhin Bestandteil der eML und werden auch von der *[Operation API: Medikationsliste abrufen (eML)](./op-get-medication-list.md)* geliefert.

##### Substitution eines Arzneimittels bei Abgabe

Im Falle einer Substitution bleibt die ursprüngliche Verschreibung, also die Ressource *MedicationRequest*, unverändert bestehen. Sie verweist weiterhin über *medicationReference* auf das ursprünglich verschriebene Arzneimittel und enthält die Angaben zur verschreibenden Person (*PractitionerDirectory*-Profil) sowie zur verschreibenden Leistungserbringerinstitution (*OrganizationDirectory*-Profil).

Die Abgabe wird durch eine Instanz des Profils *EPAMedicationDispense* dokumentiert. Hier wird das tatsächlich abgegebene, substituierte Arzneimittel angegeben, das an die Stelle des ursprünglich verordneten tritt. Um die Abweichung kenntlich zu machen, wird das Attribut *substitution.wasSubstituted* auf den Wert *true* gesetzt. Gleichzeitig bleibt die Verbindung zur ursprünglichen Verschreibung über *MedicationDispense.authorizingPrescription* erhalten. Die abgebende Apotheke, also eine *Organization*-Instanz des Profils *OrganizationDirectory*, wird über *performer.actor* referenziert.

Das zugehörige *MedicationStatement*, das die Medikationsinformation im eML repräsentiert, wird im Zuge der Substitution angepasst: Die Referenz in *MedicationStatement.medicationReference* zeigt nicht länger auf das ursprünglich verschriebene Arzneimittel, sondern auf die substituierte *Medication*. Dadurch wird im eML unmittelbar sichtbar, welches Arzneimittel der Patient tatsächlich erhalten hat.

Auf diese Weise bildet der Datensatz die Unterscheidung zwischen Verschreibung und Abgabe klar ab: Während die Verschreibung (*MedicationRequest*) unverändert bleibt und weiterhin das ursprünglich verordnete Arzneimittel beschreibt, dokumentiert die Abgabe (*MedicationDispense*) eindeutig das substituierte Präparat. Das Feld *wasSubstituted* zeigt zusätzlich an, dass es sich hierbei nicht um das ursprünglich verschriebene Arzneimittel handelt.

**Abbildung:**Anwendungsfall
*Substitution eines Arzneimittels*


In Fällen, in denen eine Substitution mehrere abgegebene Arzneimittel umfasst – beispielsweise bei der Abgabe mehrerer kleinerer Packungsgrößen anstelle einer ursprünglich verordneten größeren Packung – wird für jedes abgegebene Arzneimittel eine eigene *MedicationStatement*-Ressourceninstanz des Profils *EPAMedicationStatement* erzeugt. Jede dieser *MedicationStatement*-Ressourceninstanzen verweist auf das jeweilige substituierte Arzneimittel und stellt somit sicher, dass die tatsächliche Abgabe vollständig und strukturiert abgebildet wird. Auf diese Weise kann der eMP bzw. eML mehrere abgegebene Arzneimittel im Rahmen einer Substitution korrekt und nachvollziehbar darstellen.

**Abbildung:**Anwendungsfall
*Substitution mit mehreren abgegebenen Arzneimitteln*


##### Stornieren einer Verschreibung

Dem Anwendungsfall “Stornieren einer Verschreibung” geht das Löschen einer Verschreibung bzw. des E-Rezepts im E-Rezept-Fachdienst voraus. Das nachstehende UML-Modell zeigt das Aktualisieren der Medikationsdaten innerhalb dieses dgMP-Anwendungsfalls.

**Abbildung:**Anwendungsfall
*Verschreibung stornieren*


Im Falle der Stornierung einer Verschreibung wird der betroffene eML-Eintrag zunächst über den in der Verschreibung enthaltenen *RxPrescriptionProcessIdentifier* eindeutig identifiziert. Anschließend werden die relevanten Ressourcen in den Fehlerstatus überführt: Die *MedicationRequest*-Instanz wird auf den Status *entered-in-error* gesetzt, ebenso alle zugehörigen *MedicationDispense*, *Medication* und *EPAMedicationStatement*-Instanzen, die denselben Identifier tragen.

Besteht eine eMP-Verknüpfung, also verweist das *MedicationStatement* über *basedOn* auf einen *EMPMedicationRequest*, wird diese Verknüpfung aufgelöst. Dazu werden die entsprechenden Referenzen entfernt und die *medicationReference* des eMP-Eintrags angepasst: Liegen noch weitere gültige Activity-Einträge vor, wird die zuletzt hinzugefügte Referenz übernommen; existieren keine weiteren Activities, verweist der eMP-Eintrag wieder auf die ursprüngliche *originMedication*.

Alle Änderungen werden durch Instanzen des Profils *EPAActivityProvenance* mit der Aktivität *UPDATE* dokumentiert. Falls Änderungen am eMP-Eintrag erfolgt sind, wird zusätzlich eine neue *EMPChronologyProvenance* erzeugt, um die Historie des eMP nachvollziehbar fortzuführen.

**Schnittstelle:** *[Operation API: Verschreibungsdaten stornieren](./op-cancel-prescription-erp.md)*

##### Stornieren einer Dispensierung

Dem Anwendungsfall “Stornieren einer Dispensierung” geht das Löschen einer Dispensierung im E-Rezept-Fachdienst voraus. Das nachstehende UML-Modell zeigt das Aktualisieren der Medikationsdaten innerhalb dieses dgMP-Anwendungsfalls.

**Abbildung:**Anwendungsfall
*Dispensierung stornieren*


Im Falle der Stornierung einer Dispensierinformation wird der betroffene eML-Eintrag über den *RxPrescriptionProcessIdentifier* identifiziert. Der Status der beteiligten Instanzen wird so angepasst, dass eine erneute Dispensierung auf Basis der ursprünglichen Verschreibung wieder möglich ist.

Besteht eine Verknüpfung mit einem eMP-Eintrag, wird das die *MedicationStatement*-Instanz Referenzierung aus *EMPMedicationRequest.extension[activity]* entfernt und die *medicationReference* des eMP-Eintrags aktualisiert: Entweder auf die zuletzt gültige Aktivität oder – falls keine mehr existiert – zurück auf die ursprüngliche *originMedication*.

Alle Änderungen werden durch Instanzen des Profils *EPAActivityProvenance* nachvollziehbar dokumentiert. Falls der eMP betroffen ist, wird zusätzlich eine neue *EMPChronologyProvenance* erzeugt, um die Historie des Eintrags fortzuführen.

**Schnittstelle:** *[Operation API: Dispensierinformationen stornieren](./op-cancel-dispensation-erp.md)*

### Anwendungsfall: Nachtrag in der eML

Bei diesen Anwendungsfall werden bei manuellem Hinzufügen eines eingenommen Arzneimittels mitsamt Dosierung und optionalen Einnahmezeitraum als Medikationsinformation ein eML-Eintrag mit dem Status “unbekannt” im Medication Service registriert. Das nachstehende UML-Modell zeigt das Aktualisieren der Medikationsdaten innerhalb dieses dgMP-Anwendungsfalls.

**Abbildung:**Anwendungsfall
*Nachtrag in der eML*


Beim Nachtrag in der eML werden die übermittelten Daten geprüft und gespeichert. Zunächst wird das Arzneimittel als Instanz des Profils *EPAMedication* angelegt. Darauf aufbauend wird eine Medikationsinformation erzeugt, dargestellt durch eine Instanz des Profils *EPAMedicationStatement*. Diese verweist auf die zuvor gespeicherte *Medication* und übernimmt die übermittelten Angaben wie Status, Datum, Wirksamkeitszeitraum, Dosierung sowie die aufbereitete Dosierungsdarstellung.

Die aufbereitete Dosierungsdarstellung wurde vom Primärsystem anhand eines vorgegebenen Algorithmus erzeugt und in der Extension *renderedDosageInstruction* übermittelt. Der Medication Service validiert diese Angabe lediglich formal gegen das definierte Format, um sicherzustellen, dass die Darstellung den Vorgaben des Impementation Guide der HL7Deutschland entspricht.

Zur Nachvollziehbarkeit wird zusätzlich eine *Provenance*-Instanz des Profils *EPAActivityProvenance* erzeugt, die das neu erstellte *MedicationStatement* als Ziel referenziert und die Aktivität mit dem Wert *CREATE* dokumentiert. Damit wird der Nachtrag revisionssicher festgehalten und eindeutig der anfragenden Organisation zugeordnet.

**Schnittstelle:** *[Operation API: eML-Eintrag hinzufügen](./op-add-eml-entry.md)*

### Anwendungsfall: Stornierung eines eML-Eintrags

Dieser Anwendungsfall berücksichtigt die Art des zu stornierenden eML-Eintrags. Eine Stornierung ist ausschließlich für manuell hinzugefügte eML-Nachträge zulässig. In diesem Fall wird die entsprechende *MedicationStatement*-Instanz sowie die zugehörige *Medication*-Instanz auf den Status “inkorrekt” (**entered-in-error**) gesetzt und durch eine *Provenance*-Instanz dokumentiert. eML-Einträge aus dem Verschreibungs- oder Abgabeprozess können mit dieser Operation nicht storniert werden.

Besteht eine Verknüpfung zu einem eMP-Eintrag, so wird diese im Zuge der Stornierung ebenfalls entfernt: Die Referenz vom *MedicationStatement* auf den *EMPMedicationRequest* wird aufgelöst und der Verweis in *EMPMedicationRequest.extension[activity]* entsprechend bereinigt. Die *medicationReference* des eMP-Eintrags wird anschließend automatisch angepasst, entweder auf die zuletzt gültige Aktivität oder – falls keine mehr vorhanden ist – auf die ursprüngliche *originMedication*.

Auf diese Weise wird sichergestellt, dass eMP und eML auch nach einer Stornierung konsistent bleiben und die Chronologie des eMP über eine neue *EMPChronologyProvenance* korrekt fortgeschrieben wird.

**Schnittstelle:** *[Operation API: eML-Eintrag stornieren](./op-cancel-eml-entry.md)*

### Anwendungsfall: Hinzufügen und Entfernen einer eML-eMP-Verknüpfung

Im Regelfall sollte die Verknüpfung zwischen eML und eMP in der [oben](#anwendungsfall-verordnung-verschreibung-und-dispensierung-mit-dem-emp) beschriebenen Verknüpfungslogik automatisiert durch die primärsystemseitige Übergabe des *eMP-Identifier* an das E-Rezept erfolgen. Soll eine Verknüpfung jedoch nachträglich manuell durch den Nutzer hergestellt werden – beispielsweise nach der Registrierung von Nachträgen in eML, kann dies durch Übermittlung des *eMP-Identifier* zusammen mit dem zu verknüpfenden eML-Eintrag erfolgen. In diesem Fall wird in der Instanz des Profils *EMPMedicationRequest* eine Referenz in *MedicationRequest.activity* auf das zugehörige *EPAMedicationStatement* gesetzt, während gleichzeitig die inverse Referenz in *MedicationStatement.basedOn* auf den *EMPMedicationRequest* verweist. Zudem wird die *medicationReference* des eMP-Eintrags auf die *Medication* aus dem verknüpften *MedicationStatement* gesetzt. Durch diese Änderungen entsteht eine neue Version des eMP-Eintrags, die in der *EMPChronologyProvenance* dokumentiert wird.

Das Entfernen einer bestehenden Verknüpfung ist nur möglich, wenn der betroffene eMP-Eintrag nicht im Status *entered-in-error* vorliegt. Dabei wird die Referenzierung zwischen eML- und eMP-Ressourcen entsprechend aufgehoben: Die Verknüpfung in *MedicationRequest.activity* wird entfernt, die inverse Referenz in *MedicationStatement.basedOn* wird zurückgesetzt, und die *medicationReference* des eMP-Eintrags wird erneut angepasst – entweder auf die zuletzt gültige Aktivität oder, falls keine mehr vorhanden ist, auf die ursprüngliche *originMedication*. Der *EMPMedicationRequest* wird als neue Version fortgeschrieben und ebenfalls in der *EMPChronologyProvenance* nachgehalten. Für die Identifizierung der Verknüpfung genügt die Übergabe des *eMP-Identifier*.

**Schnittstellen:**

* *[Operation API: Hinzufügen einer eML-eMP-Verknüpfung](./op-link-emp.md)*
* *[Operation API: Entfernen einer eML-eMP-Verknüpfung](./op-unlink-emp.md)*

### Anwendungsfall: Nachtrag im eMP

Der Anwendungsfall *Nachtrag im eMP* beschreibt, wie zusätzliche Medikationsinformationen direkt im eMP erfasst werden. Ziel ist es, planungsmäßige Arzneimittel unabhängig von Verschreibungs- oder Abgabeprozessen im eMP zu dokumentieren. Damit können auch Arzneimittel berücksichtigt werden, die beispielsweise im Rahmen einer langfristigen Therapieplanung oder eines ärztlichen Hinweises ergänzt werden. Eine spätere Verknüpfung mit eML-Einträgen ist möglich, um die Konsistenz zwischen eML und eMP sicherzustellen.

Für den *Nachtrag im eMP* übermittelt das Primärsystem die Angaben zur Medikation (z. B. Einnahmezeitraum, Dosierung, Status, Indikation und Kommentar) zusammen mit einem Arzneimittel an den Medication Service. Dies kann auf zwei Arten erfolgen:

**1. Erstellung mit neuer Medication-Ressource**

Das Primärsystem übergibt eine neue *Medication*-Ressource des Profils *EMPMedication*. Diese wird im Medication Service gespeichert und anschließend von der neu erzeugten *MedicationRequest*-Instanz referenziert.

**Abbildung:**Anwendungsfall
*Nachtrag im eMP*


**2. Erstellung durch Referenz auf bestehende Medication**

Alternativ kann das Primärsystem auf eine bereits im Medication Service vorhandene *Medication*-Instanz verweisen. In diesem Fall wird keine neue *Medication*-Ressource übergeben, sondern nur die Referenz dieser bestehenden Instanz.

**Abbildung:**Anwendungsfall
*Nachtrag im eMP durch Referenz auf bestehende Medication*


Unabhängig von der gewählten Variante wird eine neue *MedicationRequest*-Instanz des Profils *EMPMedicationRequest* erzeugt und die übergebenen Angaben aufnimmt. Zur Nachvollziehbarkeit wird außerdem eine *Provenance*-Instanz des Profils *EPAActivityProvenance* erstellt, die das neue *MedicationRequest*-Instanz referenziert und die Aktivität mit dem Wert *CREATE* dokumentiert. Gleichzeitig entsteht durch eine neue Instanz des Profils *EMPChronologyProvenance* eine aktualisierte Version des eMP, sodass die fortlaufende Historie des Medikationsplans vollständig nachvollziehbar bleibt.

**Schnittstelle:** *[Operation API: eMP-Eintrag hinzufügen](./op-add-emp-entry.md)*

### Anwendungsfall: Aktualisierung eines eMP-Eintrags

Der Anwendungsfall *Aktualisierung eines eMP-Eintrags* ermöglicht es, bestehende Medikationsangaben im eMP zu ändern, z. B. Einnahmezeitraum, Dosierung, Status, Indikation oder Kommentar. Damit lässt sich der komplette Lebenszyklus eines eMP-Eintrags verwalten. Das Statusmodell umfasst die Werte “aktiv” (*active*), “beendet” (*completed*), “inkorrekt” (*entered-in-error*), “abgebrochen” (*stopped*) sowie “pausiert” (*on-hold*).

Bei einer Aktualisierung übermittelt das Primärsystem die angepassten Angaben an den Medication Service. Dieser speichert die Änderung als neue Version der *MedicationRequest*-Instanz des Profils *EMPMedicationRequest*. Parallel wird eine neue Instanz des Profils *EMPChronologyProvenance* erstellt, um die fortgeschriebene Version des eMP-Eintrags revisionssicher zu dokumentieren. Die Aktualisierung der *MedicationRequest*-Instanz wird zusätzlich durch eine *EPAActivityProvenance*-Instanz mit *activity = UPDATE* nachvollziehbar festgehalten.

In diesem Anwendungsfall erfolgt keine automatische Anpassung von eML-Enträgen.

**Schnittstelle:** *[Operation API: eMP-Eintrag aktualisieren](./op-update-emp-entry.md)*

### Stappelverarbeitung eMP

Die Stapelverarbeitung kann vom Primärsystem genutzt werden, um mehrere Änderungen am eMP in einem Schritt zu übermitteln. Anstatt jede Anpassung einzeln durchzuführen, lassen sich mehrere Änderungen gemeinsam prüfen und übernehmen. So bleibt der eMP konsistent, unnötige Zwischenschritte werden vermieden und am Ende entsteht automatisch eine neue Version des eMP, in der alle Änderungen nachvollziehbar zusammengefasst sind.

**Schnittstelle:** *[Operation API: Batch eMP-Einträge](./op-batch-emp.md)*

### Lesezugriffe

Neben der Nutzung der Query API für den gezielten Abruf einzelner Medikationsdaten bietet der Medication Service standardisierte Abrufmöglichkeiten für die kontextbezogenen Sichten eML und eMP.

**Abruf der eML**

Über die eML kann durch optionale Eingabe eines Datumsbereichs eine verlaufsbasierte Einsicht auf Medikationsdaten vorgenommen werden. Basis für die eML sind primär Arzneimittelverordnungsdaten (oder Verschreibungsdaten) sowie Dispensierinformationen, welche ein Apothekenverwaltungssystem (AVS) dem E-Rezept-Fachdienst zur Verfügung stellt. Weiterhin werden Nachträge zu aktuellen Einnahmen von Arzneimitteln aus der eML berücksichtigt. Stornierte Daten werden ignoriert.

Die genannten Medikationsdaten der eML werden über eine Operation vom Medication Service zusammengestellt und als FHIR searchSet-Bundle zurückgegeben. Zusätzlich wird die zugehörige Versicherteninformation (**Patient**-Instanz) aus dem Patient Service beigefügt.

**Schnittstelle:** *[Operation API: Medikationsliste abrufen (eML)](./op-get-medication-list.md)*

**Abruf des eMP**

Diese Operation ermöglicht den gezielten Abruf des eMP. Er besteht aus einer Sammlung relevanter Ressourceninstanzen, die zu einem bestimmten Zeitpunkt gemeinsam gültig waren, sowie die zugehörige Versicherteninformation (**Patient**-Instanz) aus dem Patient Service. Der Zeitpunkt wird über einen eMP-Chronologieeintrag festgehalten, welcher als FHIR **Provenance** umgesetzt ist. Optional kann durch eine **Provenance**-Referenz.id der Abruf des eMP somit zeitgesteuert erfolgen. Ohne **Provenance**-Indikator gibt die Operation den aktuellsten Stand des Medikationsplans zurück - also die derzeit gültige Kombination aus aktiven, vorgesehenen und pausierten Medikationsdaten. Das Ergebnis ist ein Bundle vom Typ collection, das alle zugehörigen Ressourcendaten enthält.

**Schnittstelle:** *[Operation API: Medikationsplan abrufen (eMP)](./op-get-medication-plan.md)*

**Abruf von eMP-Chronologieeinträgen**

Jede Änderung am eMP wird über einen eMP-Chronologieeintrag festgehalten, welcher eine versionierte Referenz zum eMP-Eintrag speichert. Über die entsprechende Operation (oder der Query API) kann gezielt nach **Provenance**-Instanzen über bestimmte Zeiträume gesucht werden. Mit einer gegebenen **Provenance**-Instanz kann anschließend gezielt ein eMP-Abruf erfolgen.

**Schnittstelle:** *[Operation API: eMP-Chronologie abrufen](./op-medication-plan-log.md)*

