# Render API: Medikationsplan abrufen (eMP) - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**Render API**](render-api.md)
* **Render API: Medikationsplan abrufen (eMP)**

## Render API: Medikationsplan abrufen (eMP)

Der Medication Service unterstützt die aufbereitete Generierung eines elektronischen Medikationsplans (eMP) im Datenformat PDF/A (d.h. hier kommt ****kein**** FHIR zum Einsatz). Intention ist eine für Versicherte verständliche und übersichtliche Darstellung des eMP, spezifisch an Leistungserbringer gerichtete Daten sind in der Ausgabe nicht enthalten.

### Nachricht

Die Nachricht zum Abruf des eMP im Format PDF/A wird als HTTP GET-Anfrage an den Medication Service gesendet, um den Medikationsplan im Format PDF/A zu erhalten.

#### Auslösung

Zum Abruf des eMP im Format PDF/A sendet ein ePA-Client-System eine **Render API: Medikationsplan abrufen (eMP)**-Nachricht an den Medication Service.

#### Render API

Das Primärsystem MUSS die
*Render API: Medikationsplan abrufen (eMP)*implementieren, um den Medikationsplan anzuzeigen.

Das ePA-FdV MUSS es dem Nutzer ermöglichen, den Medikationsplan für sein Aktenkonto oder für das Aktenkonto des zu Vertretenden unter Verwendung von
*Render API: Medikationsplan abrufen (eMP)*anzuzeigen.
Ein ePA-Client-System kann über den folgenden URL-Aufruf den eMP im PDF/A abrufen:

```

    {"resourceType":"CapabilityStatement","id":"epa-medication-service-server","meta":{"profile":["https://gematik.de/fhir/ti/StructureDefinition/ti-capability-statement"]},"extension":[{"extension":[{"url":"name","valueString":"X-Request-ID"},{"url":"type","valueString":"string"},{"url":"description","valueString":"UUID of the request message"},{"url":"format","valueString":"uuid"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-insurantid"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Health Record Identifier"},{"url":"pattern","valueString":"^[A-Z]{1}\\d{9}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-useragent"},{"url":"type","valueString":"string"},{"url":"description","valueString":"user agent information"},{"url":"pattern","valueString":"^[a-zA-Z0-9]{20}\\/[a-zA-Z0-9\\-\\.]{1,15}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor not authorized (no user session with valid ID-Token available)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalAuth"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor has no valid entitlement"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"notEntitled"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor role is not in the list of allowed user groups"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalidOid"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Device registration does not exist (if requestor role is oid_versicherter only)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"unregisteredDevice"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Health record is in state UNKNOWN or INITIALIZED"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"noHealthRecord"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Request conflicts with the current state of the health record"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"statusMismatch"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"500"},{"url":"description","valueString":"Any other error"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"internalError"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-base-url","valueString":"http://epa4all/epa/medication/api/v1/fhir"},{"extension":[{"url":"statusCode","valueString":"423"},{"url":"description","valueString":"If the insurant objected to the medication process or objected to the submission of prescription and dispensation data into the ePA system, the Medication Service is locked."},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"locked"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"url":"https://gematik.de/fhir/epa-medication/CapabilityStatement/epa-medication-service-server","version":"1.3.0","name":"EPAMedicationServiceServer","title":"EPA CapabilityStatement für den Medication Service","status":"active","date":"2025-12-15","publisher":"gematik GmbH","contact":[{"telecom":[{"system":"url","value":"https://www.gematik.de"}]}],"description":"EPA CapabilityStatement für den Medication Service","jurisdiction":[{"coding":[{"system":"urn:iso:std:iso:3166","code":"DE"}]}],"copyright":"gematik GmbH / Dieser Implementation Guide ist lizenziert unter [Apache License](./license.html), Version 2.0.","kind":"requirements","imports":["https://gematik.de/fhir/epa/CapabilityStatement/epa-basic-server"],"_imports":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"fhirVersion":"4.0.1","format":["application/fhir+json","application/fhir+xml"],"rest":[{"mode":"server","resource":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Medication","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication","https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pharmaceutical-product","https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pzn-ingredient"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["MedicationRequest:medication","MedicationDispense:medication","MedicationStatement:medication"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"Medication.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"code","definition":"http://hl7.org/fhir/SearchParameter/clinical-code","type":"token","documentation":"Medication.code"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/Medication-status","type":"token","documentation":"Medication.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"ingredient-code","definition":"http://hl7.org/fhir/SearchParameter/Medication-ingredient-code","type":"token","documentation":"Medication.ingredient.item as CodeableConcept"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"Medication.extension"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"Medication.extension:context"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationRequest","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationRequest:medication","MedicationRequest:requester","MedicationRequest:activity"],"searchRevInclude":["MedicationDispense:prescription","MedicationStatement:derived-from"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"MedicationRequest.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"authoredon","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-authoredon","type":"date","documentation":"MedicationRequest.authoredOn"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"intent","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-intent","type":"token","documentation":"MedicationRequest.intent"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationRequest.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"requester","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-requester","type":"reference","documentation":"MedicationRequest.requester"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationRequest.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"MedicationRequest.extension:context"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"activity","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/medication-statement-activity-sp","type":"reference","documentation":"MedicationRequest.extension:activity"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"effective-dose-period","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/medicationrequest-effective-dose-period-sp","type":"date","documentation":"MedicationRequest.extension:effectiveDosePeriod"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationDispense","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationDispense:medication","MedicationDispense:performer","MedicationDispense:prescription"],"searchRevInclude":["MedicationStatement:derived-from"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"MedicationDispense.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"whenhandedover","definition":"http://hl7.org/fhir/SearchParameter/MedicationDispense-whenhandedover","type":"date","documentation":"MedicationDispense.whenHandedOver"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"prescription","definition":"http://hl7.org/fhir/SearchParameter/medications-prescription","type":"reference","documentation":"MedicationDispense.authorizingPrescription"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"performer","definition":"http://hl7.org/fhir/SearchParameter/MedicationDispense-performer","type":"reference","documentation":"MedicationDispense.performer.actor"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationDispense.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationDispense.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"MedicationDispense.extension"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationStatement","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationStatement:medication","MedicationStatement:derived-from","MedicationStatement:based-on-emp"],"searchRevInclude":["Provenance:target"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationStatement.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationStatement.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"effective","definition":"http://hl7.org/fhir/SearchParameter/MedicationStatement-effective","type":"date","documentation":"MedicationStatement.effective"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"Medication.extension"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"derived-from","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/derived-from-sp","type":"reference","documentation":"MedicationStatement.derivedFrom as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"MedicationStatement.extension:context"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"based-on-emp","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/based-on-emp-sp","type":"reference","documentation":"MedicationStatement.basedOn mit Extension:is-emp = true"}],"operation":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"add-eml-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/add-eml-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"Operation %s not allowed for resource %s"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_OP_NOT_ALLOWED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-eml-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-eml-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"MedicationStatement could not be linked to an eMP-Entry successfully"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"LINKING_NOT_SUCCESSFUL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Already linked to another instance"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_ALREADY_LINKED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"link-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/link-emp-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"Operation %s not allowed for resource %s"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_OP_NOT_ALLOWED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"MedicationStatement could not be unlinked from an eMP-Entry successfully"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"UNLINKING_NOT_SUCCESSFUL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"unlink-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/unlink-emp-op"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Organization","supportedProfile":["https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory","https://gematik.de/fhir/ti/StructureDefinition/ti-organization"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["MedicationDispense:performer","PractitionerRole:organization","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/Organization-identifier","type":"token","documentation":"Organization.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"name","definition":"http://hl7.org/fhir/SearchParameter/Organization-name","type":"string","documentation":"Organization.name | Organization.alias"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Practitioner","supportedProfile":["https://gematik.de/fhir/directory/StructureDefinition/PractitionerDirectory","https://gematik.de/fhir/ti/StructureDefinition/ti-practitioner"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["PractitionerRole:practitioner","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/Practitioner-identifier","type":"token","documentation":"Practitioner.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"name","definition":"http://hl7.org/fhir/SearchParameter/Practitioner-name","type":"string","documentation":"Practitioner.name"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"PractitionerRole","interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["PractitionerRole:practitioner","PractitionerRole:organization"],"searchRevInclude":["MedicationDispense:performer","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-identifier","type":"token","documentation":"PractitionerRole.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"practitioner","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner","type":"reference","documentation":"PractitionerRole.practitioner"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"organization","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-organization","type":"reference","documentation":"PractitionerRole.organization"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Provenance","supportedProfile":["https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["Provenance:agent","Provenance:target"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"agent","definition":"http://hl7.org/fhir/SearchParameter/Provenance-agent","type":"reference","documentation":"Who participated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"agent-identifier","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/provenance-agent-identifier-sp","type":"token","documentation":"Provenance.agent.who.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"target","definition":"http://hl7.org/fhir/SearchParameter/Provenance-target","type":"reference","documentation":"Target References - usually version specific"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"recorded","definition":"http://hl7.org/fhir/SearchParameter/Provenance-recorded","type":"date","documentation":"When the activity was recorded / updated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"when","definition":"http://hl7.org/fhir/SearchParameter/Provenance-when","type":"date","documentation":"Provenance.occurred as dateTime"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"is-emp-chronology","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/is-emp-chronology-sp","type":"token","documentation":"Provenance.extension:isEMPChronology"}]}],"operation":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"provide-prescription-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/provide-prescription-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-prescription-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-prescription-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"provide-dispensation-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/provide-dispensation-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-dispensation-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-dispensation-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"No Resource found matching the query"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_NO_MATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-list","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-list-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"No Resource found matching the query"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_NO_MATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"eMP does not exist"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_NO_EXIST"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-plan","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-plan-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-plan-log","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/medication-plan-log-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"eMP entry already exists"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_ENTRY_ALREADY_EXISTS"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"add-emp-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/add-emp-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Update Conflict (server current version = %s, client version referenced = %s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_VERSION_AWARE_CONFLICT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"update-emp-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/update-emp-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Update Conflict (server current version = %s, client version referenced = %s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_VERSION_AWARE_CONFLICT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"batch-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/batch-emp-entries-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"The operation can only be executed within a batch context"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_OPERATION_OUTSIDE_BATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"emp-commit","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/emp-commit-op"}]}]}
    
```

Successful operation

Rendering led to empty list

#### Rückgabeformat

Der Medication Service MUSS bei der Erzeugung des eMP im Format PDF/A den Media Type (Content-Type)
*application/pdf*setzen.

Der Medication Service MUSS für die
*Render API: Medikationsplan abrufen*die folgenden HTTP Status Codes zurückgeben, um den Erfolg oder mögliche Fehler bei der Verarbeitung einer Anfrage klar zu kommunizieren:

| | | | |
| :--- | :--- | :--- | :--- |
| 200 | Successful operation |  |  |
| 404 | Rendering led to empty list | noEntries |  |

**Tabelle:**HTTP Status Codes für die Antwortnachricht
#### Schematischer Aufbau

Der Medication Service MUSS bei der Erzeugung des eMP im Format PDF/A folgendes berücksichtigen:

* die Ausrichtung im DIN A4 Querformat,
* alle Elemente in schwarzer Farbe,
* ringsherum ein Seitenrand von 0,85 cm,
* Abstand links- und rechtsseitig von jedem Spaltentrennstrich von 1,00 – 1,25 mm (um ein Verschmelzen von vertikalem Spaltentrennstrich und angrenzendem Text zu verhindern),
* Umrandungen als durchgehende gerade schwarze Linien mit einer Dicke von 0,5 pt, sofern nicht anders angegeben,
* weißer Hintergrund ohne Bilder, Muster, Wasserzeichen o.ä.,
* Schriftart Arial (ggf. artverwandt) einheitlich im gesamten Plan, sofern nicht anders angegeben,
* Text linksbündig, sofern nicht anders angegeben,
* zwei direkt aneinanderliegende Umrandungslinien werden durch eine Linie ersetzt (ggf. die mit der höheren Strichstärke).

Der Medication Service MUSS sicherstellen, dass die folgenden Toleranzen eingehalten werden:

* Für die Spaltenbreite und Feldhöhe der Medikationstabelle wird eine Abweichungstoleranz von +/-1 mm festgelegt.
* Für die Gesamtbreite und die maximale Gesamthöhe der Blöcke gilt ebenfalls eine Abweichungstoleranz von +/-1 mm.
* Bei gestrichelten Linien ist eine Toleranz von +/- 1 pt für die Strichlänge, und +/- 0,5 pt für den Strichabstand einzuhalten.
* Abstände zwischen eMP-Einträgen +1 mm. Abstände pro Seite jedoch einheitlich.

**Hinweis:** Untereinander stehende Spaltentrennstriche müssen dennoch vertikal ausgerichtet und untereinander angeglichen bleiben. Abstände zwischen eMP-Einträgen sollen nicht unterschiedlich groß sein.

Der Medication Service MUSS bei der Erzeugung des eMP im Format PDF/A den Medikationsplan in folgende logische Abschnitte unterteilen:

* Identifikationsblock,
* Administrationsblock,
* Medikationstabelle,
* Fußbereich,
die es pro Seite genau nur einmal gibt.
Nachstehend ist die Aufteilung der Blöcke dargestellt. Die Aufteilung ist auch in Originalgröße als [PDF](./emp-block-layout.pdf) und [HTML](./emp-block-layout.md) herunterlad- bzw. anzeigbar. Normativ sind die Festlegungen in den Anforderungen. Diese Dateien erfüllen nur illustrative Zwecke.

**Abbildung:**Aufteilung der Blöcke des eMP

Der Medication Service MUSS bei der Erzeugung des eMP im Format PDF/A den Identifikationsblock wie folgt erstellen:

* Höhe von 2,25 cm,
* Breite von 7,0 cm,
* linksbündig oben auf der Seite,
* Block mit einem umlaufenden Strich umrandet,
* enthält die folgenden Bestandteile:

Der Medication Service MUSS bei der Erzeugung des eMP im Format PDF/A den Administrationsblock wie folgt erstellen:

* Anordung des Blocks unmittelbar rechts neben dem Identifikationsblock,
* Höhe von 2,25 cm,
* Breite von 21 cm,
* unterteilt in vier Zeilen,
* Schriftgröße 14 pt,
* enthält die folgenden Bestandteile:
* Links und rechts angeordnete Texte in einer Zeile müssen so umgebrochen werden, dass ein deutlich durchgehender Trennungsbereich von ca. 1 cm Breite verbleibt.
* Wird der Name des Versicherten umgebrochen, so muss die neue Zeile so eingerückt werden, dass sie mit dem Namen nach dem einleitenden "Für:" der ersten Zeile auf gleicher Breite beginnt. Worttrennungen müssen dabei vermieden werden.

Der Medication Service MUSS bei der Erzeugung des eMP im Format PDF/A die Medikationstabelle wie folgt erstellen:

* vertikaler Abstand zwischen Kopfbereich (Identifikations- und Administrationsblock) und der Medikationstabelle von mindestens 3 mm,
* alle Felder mit Umrandung,
* Text in Tabellenfeldern vertikal zentriert,
* Schriftgröße von 12 pt falls nicht anders angegeben,
* Höhe von (21,0- 2 x 0,85 - 4,0 - 0,3 - 1,0 =) 15,75 cm,
* Breite von (29,7 - 2 x 0,85) 28,0 cm,
* Höhe der Felder einer Medikationstabellenzeile von 0,875 cm,
* vertikale Gliederung in Spalten,
* erste Zeile, fett formatiert, in der Schrifthöhe 14 pt, als Tabellenüberschriftzeile mit folgenden Spaltenüberschriften:
* Es folgen die eMP-Einträge mit folgenden Festlegungen:

**Hinweis:** Die Texte “mor-gens”, “mit-tags”, “abends” und “zur-Nacht” in der Überschriftenzeile werden in je einer Zelle aufgebracht. Der in “eMP-PDF/A: Grundlegendes Layout” vorgeschriebene Abstand links- und rechtsseitig von jedem Spaltentrennstrich hat hier daher keine Gültigkeit.

Der Medication Service MUSS im Feld Stärke
* falls vorhanden, *Stärke-Numerator* und *Stärke-Denominator* mit jeweils den Belegungen zu *value* und *unit* getrennt durch einen Schrägstrich " / ",
* ansonsten, wenn vorhanden, *Stärke-Text*,
angeben. Andernfalls bleib das Feld unbefüllt.
**Hinweis:** Wenn strukturierte Daten (**Stärke-Numerator**, **Stärke-Denominator**) und unstrukturierte Daten (**Stärke-Text**) gemeinsam vorliegen, dann werden für die Ausgabe nur die strukturierten Daten verwendet.

Der Medication Service MUSS im Feld Form die Formatierung eines langen Textes für die Angabe der Form eines Medikaments so ausführen, dass durch diese Formatierung keine Anpassung der Höhe des Feldes erfolgt. Dafür MUSS die Formatierung auf maximal einen Zeilenumbruch, bzw. zweizeile Darstellung, eingeschränkt werden. Texte, die aufgrund ihrer Länge einen weiteren Zeilenumbruch benötigen würden, MÜSSEN zur Einhaltung dieser Einschränkung vom Ende her gekürzt und mit der Zeichenkette "..." ergänzt werden.
**Hinweis:** Die Formatierung des Textes im Feld **Form** folgt ansonsten den Regeln in “eMP-PDF/A: Zeilenumbrüche in Tabellenfeldern”.

Der Medication Service MUSS:
* falls *Anwendungszeitraum-Start* vorhanden, und *Anwendungszeitraum-Ende* nicht vorhanden ist, den Text "Anwendungszeitraum: ab " + den Wert von *Anwendungszeitraum-Start* + ".",
* falls *Anwendungszeitraum-Ende* vorhanden, und *Anwendungszeitraum-Start* nicht vorhanden ist, den Text "Anwendungszeitraum: bis " + den Wert von *Anwendungszeitraum-Ende* + ".",
* falls beide Element *Anwendungszeitraum-Start* und *Anwendungszeitraum-Ende* vorhanden sind, den Text "Anwendungszeitraum: von " + den Wert von *Anwendungszeitraum-Start* + " bis " + *Anwendungszeitraum-Ende* + ".",
in der zugehörigen Zusatzzeile darstellen. Dieser Text MUSS die erste Textzeile in der Zusatzzeile sein.

Die Werte von
*Anwendungszeitraum-Start*und
*Anwendungszeitraum-Ende*müssen dabei in der Form "DD.MM.YYYY hh:mm Uhr" dargestellt werden, sofern diese vorhanden sind.

Für reine Datumsangaben entfällt der Teil " hh:mm Uhr".

Falls Zeitzonen angebeben sind, MUSS eine Umrechnung auf die deutsche Zeit erfolgen (MEZ bzw. MESZ).

Der Medication Service MUSS:
* die Dosierangaben für einen eMP-Eintrag tabellarisch darstellen, wenn jede Dosierungsanweisung eine tägliche Einnahme morgens, mittags, abends und/oder zur Nacht, ohne Angabe von Uhrzeit, Wochentag oder Zeitraum beschreibt, und die gleiche Einheit verwendet. Dies trifft zu, wenn für alle *MedicationRequest.dosageInstructions* gilt: 
* *timing.repeat.when* ist vorhanden und
* *timing.repeat.frequency* ist vorhanden und
* *timing.repeat.period* hat den Wert 1 und
* *timing.repeat.periodUnit* hat den Wert 'd' und
* *timing.repeat.timeOfDay* ist nicht vorhanden und
* *timing.repeat.dayOfWeek* ist nicht vorhanden und 
* *timing.repeat.bounds* ist nicht vorhanden.
* Und zusätzlich bei allen *dosageInstructions* die Angabe *dosageAndRate.doseQuantity.unit* vorhanden und gleich ist.
 
* Andernfalls werden die Dosierangaben als Text in der zugehörigen Zusatzzeile dargestellt.

**Beispiel für o.g. Prüfung als FHIR-Path-Ausdruck**

```
dosageInstruction.all(
    timing.repeat.when.exists()
    and timing.repeat.frequency.exists()
    and timing.repeat.period = 1
    and timing.repeat.periodUnit = 'd'
    and timing.repeat.timeOfDay.empty()
    and timing.repeat.dayOfWeek.empty()
    and timing.repeat.bounds.empty()
)
and dosageInstruction.doseAndRate.dose.unit.distinct().count() = 1

```

Der Medication Service MUSS die
*Dosierungstabelle*(Spalte fünf) wie folgt befüllen:
* erste Zelle ("morgens"): *Tabellendosierung-morgens*
* zweite Zelle ("mittags"): *Tabellendosierung-mittags*
* dritte Zelle ("abends"): *Tabellendosierung-abends*
* vierte Zelle ("zur Nacht"): *Tabellendosierung-zur-Nacht*
und dazu das Feld in Spalte sechs mit
*Einheit*.

Zellen der Spalte fünf, für die keine Dosierung vorliegt, MÜSSEN mit '0' befüllt werden.

Die Zusatzzeile entfällt.

Der Medication Service MUSS
* eine Zusatzzeile anlegen und den Text "Dosierung: " gefolgt von *Dosierinformation* darin darstellen,
* den gesamten Text zur Dosierung mit dem Satzzeichen Punkt (".") abschließen,
* falls dieser Text zu lang für die Darstellung in einer Zeile ist, ihn unter Beibehaltung der Schriftgröße 12 pt passend umbrechen und die neue(n) Zeile(n) so einrücken, dass sie mit dem Beginn der Dosierinformation nach dem einleitenden "Dosierung:" der ersten Zeile bündig auf gleicher Breite beginnt/beginnen,
* die Felder der Spalten fünf (inklusive aller Zellen) und sechs der Medikationszeile zusammenfassen und mit dem Text "siehe nächste Zeile" befüllen.

Der Medication Service MUSS bei mehr als einer vorhanden Dosierinformation diese durch ";" und einen Zeilenumbruch voneinander getrennt darstellen. Die neue Zeile, bzw. neuen Zeilen, MÜSSEN eingerückt werden, so dass sie mit dem Beginn der ersten Dosierinformation nach dem einleitenden "Dosierung:" der ersten Zeile bündig auf gleicher Breite beginnen.

Der Medication Service MUSS bei der Erzeugung des eMP im Format PDF/A die folgenden Formatvorgaben umsetzen:

* Ist der Inhalt so lang, dass er nicht in die vorgebene Breite eines Feldes passt, MUSS die Schriftgröße auf 10 pt verringert werden, sofern nicht anders angegeben.
* Ist der Inhalt anschließend immer noch zu lang, MUSS er in zwei Zeilen innerhalb desselben Feldes dargestellt werden.
* Die Höhe des entsprechenden Feldes MUSS dabei unverändert bleiben.
* Ist der Inhalt anschließend immer noch zu lang, ist die Höhe des Feldes proportional zu den benötigten weiteren Zeilen zu vergrößern. Horizontal angrenzende Felder müssen auch entsprechend vergrößert werden.
* Bei mehrzeiliger Darstellung MÜSSEN Satzzeichen am Zeilenanfang und Worttrennungen vermieden werden.
* Die Schriftgröße innerhalb eines Feldes MUSS immer einheitlich sein.

Der Medication Service MUSS bei der Befüllung von
*Wirkstoff*und
*Stärke*folgende Regeln berücksichtigen:

Für Kombinationspräparate (= Arzneimittel, die mehrere Wirkstoffe enthalten, d.h.
`Medication.ingredient.count() > 1`) gilt:

Die Reihenfolge der Wirkstoffe im Feld
*Wirkstoff*eines eMP-Eintrags muss identisch sein mit der Reihenfolge der Wirkstärkenangaben (
*Stärke*) in diesem eMP-Eintrag. Das bedeutet, dass jedem Wirkstoff genau eine nicht leere Wirkstärkenangabe an derselben Position zugeordnet ist und umgekehrt.

Die Wirkstoffe und somit die Wirkstärkeangaben werden im Ausdruck jeweils in einer Zeile innerhalb des Feldes untereinander dargestellt, sodass Wirkstoff und Wirkstärkeangabe horizontal auf einer Höhe liegen. Enthält ein Kombinationspräparat mehr als drei Wirkstoffe, so wird dies durch "Kombipräparat" in der Spalte des Wirkstoffes dargestellt, die Spalte der Wirkstoffstärke (
*Stärke*) bleibt in diesem Fall leer.

**Hinweis:** Muss für einzelne Wirkstoffe oder Stärken eine Zeilenumbruch gemäß eMP-PDF/A: Zeilenumbrüche in Tabellenfeldern eingefügt werden, so müssen im Resultat Wirkstoff- und Stärkeangaben weiterhin horizontal auf einer Höhe liegen.

Der Medication Service MUSS bei der Erzeugung des eMP im Format PDF/A die eMP-Einträge fortlaufend auf einer Seite, beginnend bei der Seite mit der Seitenzahl 1, im Bereich der Medikationstabelle darstellen. Ist der zur Verfügung stehende Platz dafür nicht ausreichend, MUSS jeweils eine weitere Seite, mit fortlaufender Seitennummerierung, ergänzt werden.
**Hinweis:** Ein eMP im Format PDF/A enthält keine Seiten mit einem unbefüllten Bereich für die Medikationstabelle.

Der Medication Service MUSS sicherstellen, dass das Ergebnis der Operation ausschließlich auf Daten basiert, die durch den aktuellen eMP-Chronologieeintrag referenziert werden. Für jeden durch den aktuellen eMP-Chronologieeintrag referenzierte Instanz des Profils
*EMPMedicationRequest*sind u.a. Instanzen von folgenden Profilen relevant:

* *EMPMedicationRequest* im Status *active*,
* die vom ausgewählten *EMPMedicationRequest* referenzierte *EMPMedication*,
* aktuelle *EPAPatient*-Instanz.

Der Medication Service MUSS sicherstellen, dass der eMP im Format PDF/A keine doppelten Einträge enthält.

Der Medication Service MUSS für den Medikationsplan im PDF/A-Format Daten aus den folgenden Quellen verwenden:

| | | |
| :--- | :--- | :--- |
| Präfix | [EPAPatient]`Patient.name:Name.prefix` | "Dr." |
| Vorname | [EPAPatient]`Patient.name:Name.given` | "Horst" |
| Nachname | [EPAPatient]`Patient.name:Name.family` | "Graf van Himmelblau" |
| Erstellungszeitpunkt | *Aktueller Systemzeitpunkt* | "04.11.2025 10:13" |
| Geburtsdatum | [EPAPatient]`Patient.birthDate` |  |
| Versichertennummer | [EPAPatient]`Patient.identifier:KVNR` |  |
| Verfassungsdatum | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)`MedicationRequest.authoredOn` |  |
| Wirkstoff | [EMPMedication](./StructureDefinition-emp-medication.md)`Medication.ingredient.item[x]:itemCodeableConcept.text` |  |
| Handelsname | [EMPMedication](./StructureDefinition-emp-medication.md)`Medication.code.text`*in*`MedicationRequest.medicationReference` |  |
| Stärke-Numerator | [EMPMedication](./StructureDefinition-emp-medication.md)`Medication.ingredient.strength.numerator`*in*`MedicationRequest.medicationReference` |  |
| Stärke-Denominator | [EMPMedication](./StructureDefinition-emp-medication.md)`Medication.ingredient.strength.denominator`*in*`MedicationRequest.medicationReference` |  |
| Stärke-Text | [EMPMedication](./StructureDefinition-emp-medication.md)`Medication.ingredient.strength.extension:amountText`*in*`MedicationRequest.medicationReference` |  |
| Form | [EMPMedication](./StructureDefinition-emp-medication.md)*Falls vorhanden:*`Medication.form.coding.display`,*ansonsten:*`Medication.form.coding.code` |  |
| Hinweise | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)`MedicationRequest.extension:patientNote.valueAnnotation.text` |  |
| Grund | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)`MedicationRequest.extension:reasonPatientInstruction.valueString` |  |
| Anwendungszeitraum-Start | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)`MedicationRequest.extension:effectiveDosePeriod.start` |  |
| Anwendungszeitraum-Ende | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)`MedicationRequest.extension:effectiveDosePeriod.end` |  |
| Dosierinformation | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)*Falls vorhanden:*`MedicationRequest.extension:renderedDosageInstruction.valueMarkdown`,*ansonsten, falls vorhanden:*`MedicationRequest.dosageInstruction.text` |  |
| Tabellendosierung-morgens | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)`MedicationRequest.dosageInstruction.doseAndRate.doseQuantity.value`aus derjenigen Dosierung in`MedicationRequest.dosageInstruction`, welche in`MedicationRequest.dosageInstruction.timing.repeat.when`den Wert 'MORN' enthält. |  |
| Tabellendosierung-mittags | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)`MedicationRequest.dosageInstruction.doseAndRate.doseQuantity.value`aus derjenigen Dosierung in`MedicationRequest.dosageInstruction`, welche in`MedicationRequest.dosageInstruction.timing.repeat.when`den Wert 'NOON' enthält. |  |
| Tabellendosierung-abends | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)`MedicationRequest.dosageInstruction.doseAndRate.doseQuantity.value`aus derjenigen Dosierung in`MedicationRequest.dosageInstruction`, welche in`MedicationRequest.dosageInstruction.timing.repeat.when`den Wert 'EVE' enthält. |  |
| Tabellendosierung-zur-Nacht | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)`MedicationRequest.dosageInstruction.doseAndRate.doseQuantity.value`aus derjenigen Dosierung in`MedicationRequest.dosageInstruction`, welche in`MedicationRequest.dosageInstruction.timing.repeat.when`den Wert 'NIGHT' enthält. |  |
| Einheit | [EMPMedicationRequest](./StructureDefinition-emp-medication-request.md)`MedicationRequest.dosageInstruction.doseAndRate.doseQuantity.unit.distinct()` |  |

**Tabelle:**Datenherkünfte des generierten elektronischen Medikationsplans (eMP)

Der Medication Service MUSS bei der Erzeugung des eMP im Format PDF/A den Fußbereich wie folgt erstellen:

* Der Fußbereich befindet sich unmittelbar über dem unteren Seitenrand,
* obere Umrandungslinie,
* Höhe 1,0 cm,
* Breite 28 cm,
* Schriftgröße 8 pt,
* in dieser Reihenfolge sind folgende Inhalte auf einer Zeile darzustellen:

Nachstehend ist ein Beispiel des eMP abgebildet. Dieses Beispiel ist auch in Originalgröße als [PDF](./emp-example.pdf) und [HTML](./emp-example.md) herunterlad- bzw. anzeigbar. Normativ sind die Festlegungen in den Anforderungen. Die Beispiele erfüllen nur illustrative Zwecke.

**Abbildung:**Beispiel des eMP im Format PDF/A
### Sicherheitsanforderungen

Generelle Sicherheitsanforderungen werden [hier](./privacy-security.md) festgehalten.

