# Render API: Medikationsliste abrufen (eML) - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**Render API**](render-api.md)
* **Render API: Medikationsliste abrufen (eML)**

## Render API: Medikationsliste abrufen (eML)

Der Medication Service unterstützt die aufbereitete Generierung einer elektronische Medikationsliste (eML) in den Datenformaten XHTML und PDF/A (d.h. hier kommt ****kein**** FHIR zum Einsatz).

### Nachricht

Die Nachricht zum Abruf der eML wird als HTTP GET-Anfrage an den Medication Service gesendet, um die Liste im Format PDF/A oder XHTML zu erhalten.

#### Auslösung

Wenn das ePA-Client-System die aufbereitete eML im Format PDF/A oder XHTML abrufen möchte, sendet es eine **Render API: Medikationsliste abrufen (eML)**-Nachricht an den Medication Service.

#### Render API

Das ePA-FdV MUSS es dem Nutzer ermöglichen, die Medikationsliste für sein Aktenkonto oder für das Aktenkonto des zu Vertretenden unter Verwendung von
*Render API: Medikationsliste abrufen (eML)*anzuzeigen.

Das Primärsystem KANN die
*Render API: Medikationsliste abrufen (eML)*implementieren, um die Medikationsliste anzuzeigen.
Ein ePA-Client-System kann über die folgenden URL-Aufrufe die o.g. Formate anfordern:

```

    {"resourceType":"CapabilityStatement","id":"epa-medication-service-server","meta":{"profile":["https://gematik.de/fhir/ti/StructureDefinition/ti-capability-statement"]},"extension":[{"extension":[{"url":"name","valueString":"X-Request-ID"},{"url":"type","valueString":"string"},{"url":"description","valueString":"UUID of the request message"},{"url":"format","valueString":"uuid"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-insurantid"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Health Record Identifier"},{"url":"pattern","valueString":"^[A-Z]{1}\\d{9}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-useragent"},{"url":"type","valueString":"string"},{"url":"description","valueString":"user agent information"},{"url":"pattern","valueString":"^[a-zA-Z0-9]{20}\\/[a-zA-Z0-9\\-\\.]{1,15}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor not authorized (no user session with valid ID-Token available)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalAuth"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor has no valid entitlement"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"notEntitled"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor role is not in the list of allowed user groups"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalidOid"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Device registration does not exist (if requestor role is oid_versicherter only)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"unregisteredDevice"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Health record is in state UNKNOWN or INITIALIZED"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"noHealthRecord"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Request conflicts with the current state of the health record"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"statusMismatch"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"500"},{"url":"description","valueString":"Any other error"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"internalError"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-base-url","valueString":"http://epa4all/epa/medication/api/v1/fhir"},{"extension":[{"url":"statusCode","valueString":"423"},{"url":"description","valueString":"If the insurant objected to the medication process or objected to the submission of prescription and dispensation data into the ePA system, the Medication Service is locked."},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"locked"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"url":"https://gematik.de/fhir/epa-medication/CapabilityStatement/epa-medication-service-server","version":"1.3.0","name":"EPAMedicationServiceServer","title":"EPA CapabilityStatement für den Medication Service","status":"active","date":"2025-12-15","publisher":"gematik GmbH","contact":[{"telecom":[{"system":"url","value":"https://www.gematik.de"}]}],"description":"EPA CapabilityStatement für den Medication Service","jurisdiction":[{"coding":[{"system":"urn:iso:std:iso:3166","code":"DE"}]}],"copyright":"gematik GmbH / Dieser Implementation Guide ist lizenziert unter [Apache License](./license.html), Version 2.0.","kind":"requirements","imports":["https://gematik.de/fhir/epa/CapabilityStatement/epa-basic-server"],"_imports":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"fhirVersion":"4.0.1","format":["application/fhir+json","application/fhir+xml"],"rest":[{"mode":"server","resource":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Medication","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication","https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pharmaceutical-product","https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pzn-ingredient"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["MedicationRequest:medication","MedicationDispense:medication","MedicationStatement:medication"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"Medication.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"code","definition":"http://hl7.org/fhir/SearchParameter/clinical-code","type":"token","documentation":"Medication.code"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/Medication-status","type":"token","documentation":"Medication.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"ingredient-code","definition":"http://hl7.org/fhir/SearchParameter/Medication-ingredient-code","type":"token","documentation":"Medication.ingredient.item as CodeableConcept"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"Medication.extension"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"Medication.extension:context"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationRequest","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationRequest:medication","MedicationRequest:requester","MedicationRequest:activity"],"searchRevInclude":["MedicationDispense:prescription","MedicationStatement:derived-from"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"MedicationRequest.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"authoredon","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-authoredon","type":"date","documentation":"MedicationRequest.authoredOn"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"intent","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-intent","type":"token","documentation":"MedicationRequest.intent"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationRequest.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"requester","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-requester","type":"reference","documentation":"MedicationRequest.requester"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationRequest.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"MedicationRequest.extension:context"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"activity","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/medication-statement-activity-sp","type":"reference","documentation":"MedicationRequest.extension:activity"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"effective-dose-period","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/medicationrequest-effective-dose-period-sp","type":"date","documentation":"MedicationRequest.extension:effectiveDosePeriod"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationDispense","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationDispense:medication","MedicationDispense:performer","MedicationDispense:prescription"],"searchRevInclude":["MedicationStatement:derived-from"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"MedicationDispense.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"whenhandedover","definition":"http://hl7.org/fhir/SearchParameter/MedicationDispense-whenhandedover","type":"date","documentation":"MedicationDispense.whenHandedOver"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"prescription","definition":"http://hl7.org/fhir/SearchParameter/medications-prescription","type":"reference","documentation":"MedicationDispense.authorizingPrescription"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"performer","definition":"http://hl7.org/fhir/SearchParameter/MedicationDispense-performer","type":"reference","documentation":"MedicationDispense.performer.actor"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationDispense.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationDispense.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"MedicationDispense.extension"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationStatement","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationStatement:medication","MedicationStatement:derived-from","MedicationStatement:based-on-emp"],"searchRevInclude":["Provenance:target"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationStatement.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationStatement.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"effective","definition":"http://hl7.org/fhir/SearchParameter/MedicationStatement-effective","type":"date","documentation":"MedicationStatement.effective"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"Medication.extension"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"derived-from","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/derived-from-sp","type":"reference","documentation":"MedicationStatement.derivedFrom as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"MedicationStatement.extension:context"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"based-on-emp","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/based-on-emp-sp","type":"reference","documentation":"MedicationStatement.basedOn mit Extension:is-emp = true"}],"operation":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"add-eml-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/add-eml-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"Operation %s not allowed for resource %s"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_OP_NOT_ALLOWED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-eml-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-eml-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"MedicationStatement could not be linked to an eMP-Entry successfully"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"LINKING_NOT_SUCCESSFUL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Already linked to another instance"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_ALREADY_LINKED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"link-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/link-emp-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"Operation %s not allowed for resource %s"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_OP_NOT_ALLOWED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"MedicationStatement could not be unlinked from an eMP-Entry successfully"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"UNLINKING_NOT_SUCCESSFUL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"unlink-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/unlink-emp-op"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Organization","supportedProfile":["https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory","https://gematik.de/fhir/ti/StructureDefinition/ti-organization"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["MedicationDispense:performer","PractitionerRole:organization","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/Organization-identifier","type":"token","documentation":"Organization.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"name","definition":"http://hl7.org/fhir/SearchParameter/Organization-name","type":"string","documentation":"Organization.name | Organization.alias"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Practitioner","supportedProfile":["https://gematik.de/fhir/directory/StructureDefinition/PractitionerDirectory","https://gematik.de/fhir/ti/StructureDefinition/ti-practitioner"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["PractitionerRole:practitioner","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/Practitioner-identifier","type":"token","documentation":"Practitioner.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"name","definition":"http://hl7.org/fhir/SearchParameter/Practitioner-name","type":"string","documentation":"Practitioner.name"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"PractitionerRole","interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["PractitionerRole:practitioner","PractitionerRole:organization"],"searchRevInclude":["MedicationDispense:performer","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-identifier","type":"token","documentation":"PractitionerRole.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"practitioner","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner","type":"reference","documentation":"PractitionerRole.practitioner"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"organization","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-organization","type":"reference","documentation":"PractitionerRole.organization"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Provenance","supportedProfile":["https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["Provenance:agent","Provenance:target"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"agent","definition":"http://hl7.org/fhir/SearchParameter/Provenance-agent","type":"reference","documentation":"Who participated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"agent-identifier","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/provenance-agent-identifier-sp","type":"token","documentation":"Provenance.agent.who.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"target","definition":"http://hl7.org/fhir/SearchParameter/Provenance-target","type":"reference","documentation":"Target References - usually version specific"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"recorded","definition":"http://hl7.org/fhir/SearchParameter/Provenance-recorded","type":"date","documentation":"When the activity was recorded / updated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"when","definition":"http://hl7.org/fhir/SearchParameter/Provenance-when","type":"date","documentation":"Provenance.occurred as dateTime"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"is-emp-chronology","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/is-emp-chronology-sp","type":"token","documentation":"Provenance.extension:isEMPChronology"}]}],"operation":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"provide-prescription-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/provide-prescription-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-prescription-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-prescription-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"provide-dispensation-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/provide-dispensation-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-dispensation-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-dispensation-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"No Resource found matching the query"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_NO_MATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-list","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-list-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"No Resource found matching the query"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_NO_MATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"eMP does not exist"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_NO_EXIST"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-plan","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-plan-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-plan-log","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/medication-plan-log-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"eMP entry already exists"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_ENTRY_ALREADY_EXISTS"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"add-emp-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/add-emp-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Update Conflict (server current version = %s, client version referenced = %s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_VERSION_AWARE_CONFLICT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"update-emp-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/update-emp-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Update Conflict (server current version = %s, client version referenced = %s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_VERSION_AWARE_CONFLICT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"batch-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/batch-emp-entries-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"The operation can only be executed within a batch context"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_OPERATION_OUTSIDE_BATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"emp-commit","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/emp-commit-op"}]}]}
    
```

Successful operation

Unknown or invalid search parameter(s)

Rendering led to empty list

```

    {"resourceType":"CapabilityStatement","id":"epa-medication-service-server","meta":{"profile":["https://gematik.de/fhir/ti/StructureDefinition/ti-capability-statement"]},"extension":[{"extension":[{"url":"name","valueString":"X-Request-ID"},{"url":"type","valueString":"string"},{"url":"description","valueString":"UUID of the request message"},{"url":"format","valueString":"uuid"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-insurantid"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Health Record Identifier"},{"url":"pattern","valueString":"^[A-Z]{1}\\d{9}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"name","valueString":"x-useragent"},{"url":"type","valueString":"string"},{"url":"description","valueString":"user agent information"},{"url":"pattern","valueString":"^[a-zA-Z0-9]{20}\\/[a-zA-Z0-9\\-\\.]{1,15}$"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor not authorized (no user session with valid ID-Token available)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalAuth"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor has no valid entitlement"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"notEntitled"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Requestor role is not in the list of allowed user groups"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"invalidOid"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"Device registration does not exist (if requestor role is oid_versicherter only)"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"unregisteredDevice"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Health record is in state UNKNOWN or INITIALIZED"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"noHealthRecord"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Request conflicts with the current state of the health record"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"statusMismatch"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"500"},{"url":"description","valueString":"Any other error"},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"internalError"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-base-url","valueString":"http://epa4all/epa/medication/api/v1/fhir"},{"extension":[{"url":"statusCode","valueString":"423"},{"url":"description","valueString":"If the insurant objected to the medication process or objected to the submission of prescription and dispensation data into the ePA system, the Medication Service is locked."},{"url":"responseType","valueString":"application/json"},{"url":"errorCode","valueString":"locked"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"url":"https://gematik.de/fhir/epa-medication/CapabilityStatement/epa-medication-service-server","version":"1.3.0","name":"EPAMedicationServiceServer","title":"EPA CapabilityStatement für den Medication Service","status":"active","date":"2025-12-15","publisher":"gematik GmbH","contact":[{"telecom":[{"system":"url","value":"https://www.gematik.de"}]}],"description":"EPA CapabilityStatement für den Medication Service","jurisdiction":[{"coding":[{"system":"urn:iso:std:iso:3166","code":"DE"}]}],"copyright":"gematik GmbH / Dieser Implementation Guide ist lizenziert unter [Apache License](./license.html), Version 2.0.","kind":"requirements","imports":["https://gematik.de/fhir/epa/CapabilityStatement/epa-basic-server"],"_imports":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"fhirVersion":"4.0.1","format":["application/fhir+json","application/fhir+xml"],"rest":[{"mode":"server","resource":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Medication","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication","https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pharmaceutical-product","https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pzn-ingredient"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["MedicationRequest:medication","MedicationDispense:medication","MedicationStatement:medication"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"Medication.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"code","definition":"http://hl7.org/fhir/SearchParameter/clinical-code","type":"token","documentation":"Medication.code"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/Medication-status","type":"token","documentation":"Medication.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"ingredient-code","definition":"http://hl7.org/fhir/SearchParameter/Medication-ingredient-code","type":"token","documentation":"Medication.ingredient.item as CodeableConcept"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"Medication.extension"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"Medication.extension:context"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationRequest","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-request","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-medication-request"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationRequest:medication","MedicationRequest:requester","MedicationRequest:activity"],"searchRevInclude":["MedicationDispense:prescription","MedicationStatement:derived-from"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"MedicationRequest.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"authoredon","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-authoredon","type":"date","documentation":"MedicationRequest.authoredOn"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"intent","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-intent","type":"token","documentation":"MedicationRequest.intent"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationRequest.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"requester","definition":"http://hl7.org/fhir/SearchParameter/MedicationRequest-requester","type":"reference","documentation":"MedicationRequest.requester"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationRequest.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"MedicationRequest.extension:context"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"activity","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/medication-statement-activity-sp","type":"reference","documentation":"MedicationRequest.extension:activity"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"effective-dose-period","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/medicationrequest-effective-dose-period-sp","type":"date","documentation":"MedicationRequest.extension:effectiveDosePeriod"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationDispense","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-dispense"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationDispense:medication","MedicationDispense:performer","MedicationDispense:prescription"],"searchRevInclude":["MedicationStatement:derived-from"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/clinical-identifier","type":"token","documentation":"MedicationDispense.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"whenhandedover","definition":"http://hl7.org/fhir/SearchParameter/MedicationDispense-whenhandedover","type":"date","documentation":"MedicationDispense.whenHandedOver"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"prescription","definition":"http://hl7.org/fhir/SearchParameter/medications-prescription","type":"reference","documentation":"MedicationDispense.authorizingPrescription"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"performer","definition":"http://hl7.org/fhir/SearchParameter/MedicationDispense-performer","type":"reference","documentation":"MedicationDispense.performer.actor"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationDispense.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationDispense.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"MedicationDispense.extension"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"MedicationStatement","supportedProfile":["https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["MedicationStatement:medication","MedicationStatement:derived-from","MedicationStatement:based-on-emp"],"searchRevInclude":["Provenance:target"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"medication","definition":"http://hl7.org/fhir/SearchParameter/medications-medication","type":"reference","documentation":"MedicationStatement.medication as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"status","definition":"http://hl7.org/fhir/SearchParameter/medications-status","type":"token","documentation":"MedicationStatement.status"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"effective","definition":"http://hl7.org/fhir/SearchParameter/MedicationStatement-effective","type":"date","documentation":"MedicationStatement.effective"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"rx-prescription","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/rx-prescription-process-sp","type":"token","documentation":"Medication.extension"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"derived-from","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/derived-from-sp","type":"reference","documentation":"MedicationStatement.derivedFrom as Reference"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"context","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/context-sp","type":"token","documentation":"MedicationStatement.extension:context"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"based-on-emp","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/based-on-emp-sp","type":"reference","documentation":"MedicationStatement.basedOn mit Extension:is-emp = true"}],"operation":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"add-eml-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/add-eml-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"Operation %s not allowed for resource %s"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_OP_NOT_ALLOWED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-eml-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-eml-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"MedicationStatement could not be linked to an eMP-Entry successfully"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"LINKING_NOT_SUCCESSFUL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Already linked to another instance"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_ALREADY_LINKED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"link-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/link-emp-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"Operation %s not allowed for resource %s"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_OP_NOT_ALLOWED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"MedicationStatement could not be unlinked from an eMP-Entry successfully"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"UNLINKING_NOT_SUCCESSFUL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"unlink-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/unlink-emp-op"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Organization","supportedProfile":["https://gematik.de/fhir/directory/StructureDefinition/OrganizationDirectory","https://gematik.de/fhir/ti/StructureDefinition/ti-organization"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["MedicationDispense:performer","PractitionerRole:organization","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/Organization-identifier","type":"token","documentation":"Organization.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"name","definition":"http://hl7.org/fhir/SearchParameter/Organization-name","type":"string","documentation":"Organization.name | Organization.alias"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Practitioner","supportedProfile":["https://gematik.de/fhir/directory/StructureDefinition/PractitionerDirectory","https://gematik.de/fhir/ti/StructureDefinition/ti-practitioner"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchRevInclude":["PractitionerRole:practitioner","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/Practitioner-identifier","type":"token","documentation":"Practitioner.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"name","definition":"http://hl7.org/fhir/SearchParameter/Practitioner-name","type":"string","documentation":"Practitioner.name"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"PractitionerRole","interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"history-instance"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"vread"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["PractitionerRole:practitioner","PractitionerRole:organization"],"searchRevInclude":["MedicationDispense:performer","MedicationRequest:requester"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"identifier","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-identifier","type":"token","documentation":"PractitionerRole.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"practitioner","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner","type":"reference","documentation":"PractitionerRole.practitioner"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"organization","definition":"http://hl7.org/fhir/SearchParameter/PractitionerRole-organization","type":"reference","documentation":"PractitionerRole.organization"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"type":"Provenance","supportedProfile":["https://gematik.de/fhir/epa/StructureDefinition/epa-activity-provenance","https://gematik.de/fhir/epa-medication/StructureDefinition/emp-chronology-provenance"],"_supportedProfile":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}]}],"interaction":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"search-type"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Unknown resource type"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_UNKNOWN_TYPE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"code":"read"}],"versioning":"versioned-update","readHistory":true,"searchInclude":["Provenance:agent","Provenance:target"],"searchParam":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_id","definition":"http://hl7.org/fhir/SearchParameter/Resource-id","type":"token","documentation":"Resource.id"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_lastUpdated","definition":"http://hl7.org/fhir/SearchParameter/Resource-lastUpdated","type":"date","documentation":"Resource.meta.lastUpdated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"_has","type":"string","documentation":"Return resources linked to by the given target"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"agent","definition":"http://hl7.org/fhir/SearchParameter/Provenance-agent","type":"reference","documentation":"Who participated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"agent-identifier","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/provenance-agent-identifier-sp","type":"token","documentation":"Provenance.agent.who.identifier"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"target","definition":"http://hl7.org/fhir/SearchParameter/Provenance-target","type":"reference","documentation":"Target References - usually version specific"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"recorded","definition":"http://hl7.org/fhir/SearchParameter/Provenance-recorded","type":"date","documentation":"When the activity was recorded / updated"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"when","definition":"http://hl7.org/fhir/SearchParameter/Provenance-when","type":"date","documentation":"Provenance.occurred as dateTime"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"}],"name":"is-emp-chronology","definition":"https://gematik.de/fhir/epa-medication/SearchParameter/is-emp-chronology-sp","type":"token","documentation":"Provenance.extension:isEMPChronology"}]}],"operation":[{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"provide-prescription-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/provide-prescription-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-prescription-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-prescription-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"provide-dispensation-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/provide-dispensation-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"cancel-dispensation-erp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/cancel-dispensation-erp-OP"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"No Resource found matching the query"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_NO_MATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-list","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-list-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Unknown search parameter"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_PARAM_UNKNOWN"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid query parameter(s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_SYNTAX"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"No Resource found matching the query"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_NO_MATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"eMP does not exist"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_NO_EXIST"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-plan","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/get-medication-plan-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"medication-plan-log","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/medication-plan-log-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"410"},{"url":"description","valueString":"Resource was deleted"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_DELETED"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"eMP entry already exists"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_ENTRY_ALREADY_EXISTS"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"add-emp-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/add-emp-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"403"},{"url":"description","valueString":"ID-Token or Insurant-ID mismatch"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_IDENTITY_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Update Conflict (server current version = %s, client version referenced = %s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_VERSION_AWARE_CONFLICT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"update-emp-entry","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/update-emp-entry-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"name","valueString":"X-Requesting-Organization"},{"url":"type","valueString":"string"},{"url":"description","valueString":"Base64 encoded FHIR Organization resource in JSON format used to identify the originator of the request"},{"url":"format","valueString":"base64(fhir+json:Organization)"},{"url":"required","valueBoolean":true}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-header"},{"extension":[{"url":"statusCode","valueString":"431"},{"url":"description","valueString":"Requesting Organization Header exceeds maximum size"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_TOO_LARGE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Bundle"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid request"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_BAD_FORMAT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Invalid dosage structure or content"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_DOSAGE_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Invalid Data Structure in Medication Service"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_NO_VALID_STRUCTURE"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"422"},{"url":"description","valueString":"Profile mismatch in header Organization"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"SVC_ORG_HEADER_PROFILE_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"400"},{"url":"description","valueString":"Parameter with wrong status"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_STATUS_INVALID"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Update Conflict (server current version = %s, client version referenced = %s)"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_VERSION_AWARE_CONFLICT"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"404"},{"url":"description","valueString":"Resource is not known"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MSG_RESOURCE_ID_FAIL"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"batch-emp","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/batch-emp-entries-op"},{"extension":[{"url":"http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation","valueCode":"SHALL"},{"extension":[{"url":"statusCode","valueString":"200"},{"url":"description","valueString":"Successful operation"},{"url":"responseType","valueString":"Parameters"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"405"},{"url":"description","valueString":"The operation can only be executed within a batch context"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_OPERATION_OUTSIDE_BATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"},{"extension":[{"url":"statusCode","valueString":"409"},{"url":"description","valueString":"Mismatch between acknowledged and current eMP chronology ID"},{"url":"responseType","valueString":"EPAMSOperationOutcome"},{"url":"errorCode","valueString":"MEDSVC_EMP_CHRONOLOGY_ID_MISMATCH"}],"url":"https://gematik.de/fhir/ti/StructureDefinition/extension-http-response-info"}],"name":"emp-commit","definition":"https://gematik.de/fhir/epa-medication/OperationDefinition/emp-commit-op"}]}]}
    
```

Successful operation

Unknown or invalid search parameter(s)

Rendering led to empty list

#### Rückgabeformate

Der Medication Service MUSS die Media Types (Content-Types)
*text/html*und
*application/pdf*setzen, um eine erfolgreiche Ausgabe der aufbereiteten, elektronischen Medikationsliste zu gewährleisten.

Der Medication Service MUSS für die
*Render API: Medikationsliste abrufen*die folgenden HTTP Status Codes zurückgeben, um den Erfolg oder mögliche Fehler bei der Verarbeitung einer Anfrage klar zu kommunizieren:

| | | | |
| :--- | :--- | :--- | :--- |
| 200 | Successful operation |  |  |
| 400 | Unknown or invalid search parameter(s) |  |  |
| 404 | Rendering led to empty list | noEntries |  |

**Tabelle:**HTTP Status Codes für die Antwortnachricht
#### Schematischer Aufbau

Der Medication Service MUSS zur Generierung der aufbereiteten eML in den Formaten PDF/A und XHTML die Medikationsdaten der letzten 12 Monate aus den relevanten FHIR-Ressourcen heranziehen. Dabei sind sowohl Verordnungen, Dispensierungen als auch Medikationsnachträge zu berücksichtigen. Die Sortierung erfolgt absteigend (
*desc*) nach dem Datum der Medikationsinformation. Grundlage hierfür ist das Element
*MedicationStatement.effective*, das sowohl das ursprüngliche Verordnungsdatum als auch ein Nachtragsdatum abbildet. Bei mehreren
*MedicationStatement*-Instanzen mit demselben
*effective*-Wert ist zusätzlich das Element
*MedicationStatement.meta.lastUpdated*in absteigender Reihenfolge zu berücksichtigen.

Der Medication Service MUSS sicherstellen, dass die generierte elektronische Medikationsliste (eML) in den Formaten PDF/A und XHTML alle für die korrekte Anzeige und Nachvollziehbarkeit relevanten Informationen enthält. Grundlage der gerenderten eML sind
*MedicationStatement*-Instanzen.

Die gerenderte eML enthält folgende Inhalte:

* Alle relevanten *MedicationStatement*-Instanzen des Profils *EPAMedicationStatement*.
* Die zugehörigen *Medication*-Instanzen, die in der *medicationReference* des *MedicationStatement* oder in den über *derivedFrom* referenzierten *MedicationRequest*- und *MedicationDispense*-Instanzen verwendet werden.
* Alle *MedicationRequest*-Instanzen, die über *MedicationStatement.derivedFrom* referenziert sind, zur Darstellung der ursprünglichen Verordnungsinformationen.
* Alle *MedicationDispense*-Instanzen, die über *MedicationStatement.derivedFrom* referenziert sind, zur Darstellung der Abgabeinformationen.
* Alle *PractitionerRole*- und *Organization*-Instanzen, die in den *MedicationRequest*- und *MedicationDispense*-Instanzen als Akteure referenziert werden.
* Alle *Practitioner*- und *Organization*-Instanzen, die von *PractitionerRole*-Instanzen referenziert werden, um die Akteure vollständig darzustellen.
* Alle relevanten *Provenance*-Instanzen des Profils *EPAActivityProvenance*, die als *target* auf die jeweilige Version der *MedicationStatement*-Instanz zeigen. Diese *Provenance*-Instanzen dokumentieren die Entstehungshistorie.
* Alle *Organization*-Instanzen, die in den *Provenance.agent.who*-Referenzen enthalten sind.

Der Medication Service MUSS sicherstellen, dass in der gerenderten elektronischen Medikationsliste (eML) nur gültige und relevante Medikationsinformationen angezeigt werden. Medikationsdaten, die fehlerhaft sind oder storniert wurden, dürfen nicht in die eML aufgenommen werden. Dazu sind
*MedicationStatement*-Instanzen auszuschließen, wenn ihr Status den Wert
*entered-in-error*hat. Ebenso dürfen
*MedicationRequest*- und
*MedicationDispense*-Instanzen nicht berücksichtigt werden, wenn sie ausschließlich von ausgeschlossenen
*MedicationStatement*-Instanzen über
*derivedFrom*referenziert werden. Darüber hinaus sind
*MedicationDispense*-Instanzen auszuschließen, deren Status auf
*cancelled*oder
*declined*gesetzt ist
*Medication*-Instanzen dürfen nicht in der eML erscheinen, wenn sie ausschließlich von ausgeschlossenen oder stornierten
*MedicationRequest*- oder
*MedicationDispense*-Instanzen referenziert werden. Wird eine
*Medication*-Instanz jedoch zusätzlich von gültigen Instanzen referenziert, bleibt sie in der eML enthalten.

Der Medication Service MUSS die Medikationsliste in beiden Ausgabeformaten (d.h. PDF/A und XHTML) generieren können. Verbindliche Vorgaben für den schematischen Aufbau und die Benennung der Datenherkunft innerhalb des Medication Service erfolgen nachstehend. Liegen substituierte Arzneimittel vor, müssen diese pro Substitution als Listeneintrag für die Quelle herangezogen werden. Der identifizierenden Werte des Aktenkontoinhabers müssen unter Hinzuziehung der aktuellen Instanz von [EPAPatient] belegt werden.

* Name: Geburtsdatum
  * `Patient.name:Name.prefix``Patient.name:Name.given``Patient.name:Name.family`: `Patient.birthDate`im Format [TT.MM.JJJJ]
* Name: KVNR
  * `Patient.name:Name.prefix``Patient.name:Name.given``Patient.name:Name.family`: `Patient.identifier:KVNR`

* Spaltenkopf: Verordnung
  * FHIR-Profil FHIR Element-ID: [EPAMedicationRequest](./StructureDefinition-epa-medication-request.md)`MedicationRequest.authoredOn`*und**Beide Datenquellen aus der Verordnung sind zu verknüpfen:*[PractitionerDirectory] bzw. [OrganizationDirectory]`Practitioner.name` + " " +`Organization.name`
  * Bemerkung: Bleibt leer bei Nachträgen
* Spaltenkopf: Dispensierung
  * FHIR-Profil FHIR Element-ID: [EPAMedicationDispense](./StructureDefinition-epa-medication-dispense.md)`MedicationDispense.whenHandedOver`*und*[OrganizationDirectory]`Organization.name`in`MedicationDispense.performer.actor`
  * Bemerkung: Bleibt leer bei Nachträgen
* Spaltenkopf: Bearbeitung
  * FHIR-Profil FHIR Element-ID: [EPAActivityProvenance]`Provenance.recorded`*und*[TIOrganization]`Organization.name`*in*`Provenance.agent.who`
  * Bemerkung: Bleibt leer, wenn`Provenance.agent.who`der Medication Service
* Spaltenkopf: Wirkstoffname
  * FHIR-Profil FHIR Element-ID: *Wenn vorhanden, dann wie folgt zu belegen:*[EPAMedicationStatement](./StructureDefinition-epa-medication-statement.md)*bzw.*[EPAMedication](./StructureDefinition-epa-medication.md)`Medication.ingredient.item[x]:itemCodeableConcept.text`*in*`MedicationStatement.medicationReference`
  * Bemerkung: 
* Spaltenkopf: Wirkstärke
  * FHIR-Profil FHIR Element-ID: *Wenn vorhanden, dann wie folgt zu belegen:*[EPAMedicationStatement](./StructureDefinition-epa-medication-statement.md)*bzw.*[EPAMedication](./StructureDefinition-epa-medication.md)`Medication.ingredient.strength`*in*`MedicationStatement.medicationReference`*Falls vorhanden, sind`Numerator`und`Denominator`mit jeweils den Belegungen zu`value`und`unit`getrennt mit Bruchstrich anzugeben.*
  * Bemerkung: 
* Spaltenkopf: Arzneimittelbezeichnung
  * FHIR-Profil FHIR Element-ID: *Wenn vorhanden, dann bei Nicht-Wirkstoffverordnungen wie folgt zu belegen:*[EPAMedicationStatement](./StructureDefinition-epa-medication-statement.md)*bzw.*[EPAMedication](./StructureDefinition-epa-medication.md)`Medication.code.text`*in*`MedicationStatement.medicationReference`
* Spaltenkopf: Form
  * FHIR-Profil FHIR Element-ID: *Wenn vorhanden, dann wie folgt zu belegen:*[EPAMedicationStatement](./StructureDefinition-epa-medication-statement.md)*bzw.*[EPAMedication](./StructureDefinition-epa-medication.md)`Medication.form.coding`
  * Bemerkung: 
* Spaltenkopf: Dosierangabe
  * FHIR-Profil FHIR Element-ID: [DosageDgMP]*Wenn vorhanden, dann wie folgt zu belegen:*`MedicationStatement.extension:renderedDosageInstruction.valueMarkdown`*ansonsten, falls vorhanden:*`Dosage.text`*in*`MedicationStatement.dosage`
* Spaltenkopf: PZN
  * FHIR-Profil FHIR Element-ID: *Bei PZN-Verordnung wie folgt zu belegen:*[EPAMedicationStatement](./StructureDefinition-epa-medication-statement.md)*bzw.*[EPAMedication](./StructureDefinition-epa-medication.md)`Medication.code.coding:pznCode`in`MedicationStatement.medicationReference`*Bei PZN-basierter Abgabe zu einer Rezepturverordnung wie folgt zu belegen:*[EPAMedicationStatement](./StructureDefinition-epa-medication-statement.md)*bzw.*[EPAMedication](./StructureDefinition-epa-medication.md)`Medication.ingredient.item[x]:itemCodeableConcept.coding:pznCode.code`*in*`MedicationStatement.medicationReference`
  * Bemerkung: 
* Spaltenkopf: eMP
  * FHIR-Profil FHIR Element-ID: *Sofern ein Eintrag in*[EPAMedicationStatement](./StructureDefinition-epa-medication-statement.md)*mit*`MedicationStatement.baseOn`*und*`.extension:isEmp.valueBoolean = true`*existiert, wird hier ein*X*dargestellt.*
  * Bemerkung: 

**Tabelle:**Schematischer Aufbau und Datenherkunft der generierten elektronischen Medikationsliste (eML)
Der Medication Service MUSS beim Rendern der elektronischen Medikationsliste (eML) Substitution und Mehrfachverordnung in dem Dokument erkennbar markieren.

* Eine Substitution muss dem Dispensierdatum mittels einem vorrangestellten *(S)* gekennzeichnet werden.
* Eine Mehrfachverordnung muss dem Verordnungsdatum mittels einem vorrangestellten *(M)* gekennzeichnet werden.

Auf jeder Seite muss diese Information in einer Legende wie folgt dargestellt werden:
*Legende: (S) Substitution, (M) Mehrfachverordnung*
### Sicherheitsanforderungen

Generelle Sicherheitsanforderungen werden [hier](./privacy-security.md) festgehalten.

