# Release Notes - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **Release Notes**

## Release Notes

### Version 1.3.0

* Optionale Umsetzung der lokalen Volltextsuche über eMP-Einträge im ePA-FdV (IG-MED18064ZBJ)
* Arzneimittelkodierung im eMP-Eintrag soll sich an E-Rezept orientieren (IG-MED34123VCX)
* Übergabe des eMP-Identifer an E-Rezept (IG-MED61049U29)
* Nachtrag von fehlenden Versionen in ATC-Codes (IG-MED00545NYB)
* Konkretisierung über die Sortierreihenfolge von eML- und eMP-Einträgen (IG-MED03188C0X, IG-MED07144WB0)

#### Operations

* Der bisher spezifizierte HTTP Code “400 Bad Request” bei einer fehlschlagenden FHIR-Profilvalidierung wurde auf “422 Unprocessable Entity” angepasst. Die folgenden Operationen wurden entsprechend aktualisiert: *addEMLEntry_MedicationSvc*, *addEMPEntry_MedicationSvc*, *linkEMP_MedicationSvc*, *unlinkEMP_MedicationSvc*, *updateEMPEntry_MedicationSvc* und *batchEMPEntries_MedicationSvc*.
* In der Geschäftslogik der Operationen **$add-emp-entry** (**eMP-Eintrag hinzufügen** und **$update-emp-entry** (**eMP-Eintrag aktualisieren**) wurde eine redaktionelle Bereinigung vorgenommen: Die bisher enthaltene Prüfung auf das Vorhandensein des Elements **dosageInstruction** im eMP-Eintrag wurde entfernt, da diese bereits durch die Profildefinition der Input-Parameter sichergestellt wird. Diese Anpassung hat keinen Einfluss auf das Ergebnis oder den Ablauf der fachlichen Verarbeitung.
* Die eML-Nachtrags- und eMP-Bearbeitungs-Operationen prüfen nun die Größe des HTTP Header *X-Requesting-Organization*. Bei Überschreitung des Limits wird der HTTP Status Code 431 Request Header Fields Too Large zurückgegeben.
* Im Rahmen der Verarbeitung der Operationen *Dispensierinformationen einstellen* und *eMP-Eintrag aktualisieren* wurde die Logik zur Behandlung von bestehenden *MedicationStatement*-Instanzen erweitert, um bei einem Statuswechsel auf *entered-in-error* die betroffenen Einträge für eine spätere Löschung vorzubereiten und alle zugehörigen *basedOn*-Referenzen konsistent zu bereinigen.
* Die Validierungslogik der Operationen *addEMLEntry_MedicationSvc*, *addEMPEntry_MedicationSvc* und *updateEMPEntry_MedicationSvc* wurde angepasst, um die Vorgaben des HL7 Deutschland-Profils *DosageDgMP* umzusetzen.

#### Abhängigkeiten

* Die Abhängigkeit zum Terminologiepaket `de.gematik.terminology` wurde auf Version 1.0.8 aktualisiert.
* Die Abhängigkeit zum Medication IG DE `de.fhir.medication` wurde auf Version 1.0.3 aktualisiert.

#### EPAMedicationRequest

* Das Profil EPAMedicationRequest wurde vollständig an das aktualisierte KBV-Profil angeglichen.

##### Im Zuge dieser Angleichung wurden fünf neue FHIR-Extensions ergänzt

* **narcotics-extension** Abbildung der Angaben zur Verordnung eines Betäubungsmittels gemäß Betäubungsmittelgesetz (BtMG).
* **patient-id-extension** Patienten-ID, die bei der Verordnung bestimmter Arzneimittel angegeben werden kann.
* **prescriber-id-extension** Verschreiber-ID, die bei bestimmten Präparaten erforderlich ist, damit die Apotheke das Rezept beliefern darf.
* **teratogenic-extension** Angaben zur Verordnung eines teratogenen Arzneimittels (T-Rezept).
* **indicator-ser-extension** Kennzeichnung, ob die Verordnung im Zusammenhang mit dem Sozialen Entschädigungsrecht nach SGB XIV (SER) steht.

#### Anforderungen

Neue Anforderungen wurden hinzugefügt, bestehende geändert und nicht mehr benötigte gelöscht. Die folgenden Release Notes geben einen detaillierten Überblick über alle Anpassungen.

| | | |
| :--- | :--- | :--- |
| **ÄND** | [IG-MED22047NEW-01](./op-update-emp-entry.md) | Ausführung der Geschäftlogik der Operation eMP-Eintrag aktualisieren |
| **NEU** | [IG-MED18064ZBJ](./op-get-medication-plan.md) | Lokale Volltextsuche und Filterfunktionen in eMP-Einträgen im ePA-FdV |
| **NEU** | [IG-MED72454UMG](./privacy-security.md) | Medication Service - Erzeugung eines XHTML-Exports |
| **VERS** | [IG-MED99454XPV](./render-api-emp.md) | Medikationsplan (durch das Aktensystem gerendert) im Primärsystem anzeigen |
| **VERS** | [IG-MED71916JAU](./render-api-emp.md) | Medikationsplan (durch das Aktensystem gerendert) im ePA-FdV anzeigen |
| **ÄND** | [IG-MED11670DEY-01](./op-cancel-prescription-erp.md) | Ausführung der Geschäftlogik der Operation Verschreibungsdaten stornieren |
| **NEU** | [IG-MED95718ERJ](./op-get-medication-list.md) | Medikationsliste abrufen (eML) |
| **ÄND** | [IG-MED43098L7G-01](./general-principles.md) | Medikationsplan anzeigen (FHIR-Schnittstelle/Query API) |
| **ÄND** | [IG-MED94460V8J-01](./privacy-security.md) | Zugriffsrechte gemäß Legal Policy |
| **VERS** | [IG-MED55496HS1-02](./render-api-eml.md) | Medikationsliste (durch das Aktensystem gerendert) im ePA-FdV anzeigen |
| **ÄND** | [IG-MED93348UAJ-01](./op-add-emp-entry.md) | Ausführung der Geschäftlogik der Operation eMP-Eintrag hinzufügen |
| **DEL** | IG-MED87181PL5-01 | Löschen fehlerhafter oder stornierter Medikationsdaten |
| **ÄND** | [IG-MED59929SZJ-01](./op-unlink-emp.md) | Ausführung der Geschäftlogik der Operation Entfernen einer eML-eMP-Verknüpfung |
| **ÄND** | [IG-MED17706LL3-01](./op-add-emp-entry.md) | Setzen des MedicationPlanIdentifier beim Erstellen eines eMP-Eintrags |
| **NEU** | [IG-MED04839P1M](./general-principles.md) | Anwenderinformation bei vorliegender eMP-Verknüpfung und eMP-Aktualisierung |
| **ÄND** | [IG-MED05461W2P-03](./general-principles.md) | Medikationsliste anzeigen (FHIR-Schnittstelle/Query API) |
| **ÄND** | [IG-MED17281DXD-01](./op-cancel-eml-entry.md) | Ausführung der Geschäftlogik der Operation eML-Eintrag stornieren |
| **NEU** | [IG-MED87998DMA](./op-provide-dispensation-erp.md) | Aufruf der Operation Verschreibungsdaten einstellen |
| **NEU** | [IG-MED34123VCX](./op-add-emp-entry.md) | Arzneimittel- und Wirkstoffkodierung im eMP-Eintrag bei anschließender Ausstellung eines E-Rezepts |
| **ÄND** | [IG-MED03188C0X-04](./op-get-medication-list.md) | Sortierung des Suchergebnisses in der Operation Medikationsliste abrufen (eML) |
| **NEU** | [IG-MED31287N4W](./privacy-security.md) | Medication Service - Ablehnung von Request bei vorliegendem Widerspruch |
| **DEL** | IG-MED48887L6V | Implementierung ePA-spezifischer Anforderungen an FHIR Data Services |
| **ÄND** | [IG-MED94401KPF-01](./op-cancel-dispensation-erp.md) | Ausführung der Geschäftlogik der Operation Dispensierinformationen stornieren |
| **ÄND** | [IG-MED32621WGJ-01](./op-add-emp-entry.md) | eMP-Eintrag hinzufügen |
| **VERS** | [IG-MED50594P2K](./render-api-eml.md) | Medikationsliste (durch das Aktensystem gerendert) im Primärsystem anzeigen |
| **ÄND** | [IG-MED98977HQ9-01](./migration.md) | Migrationsschritte Version 1.3.0 |
| **NEU** | [IG-MED29796HBG](./privacy-security.md) | Medication Service - Nutzung der FHIR-Operationen durch den E-Rezept-Fachdienst |
| **NEU** | [IG-MED00545NYB](./migration.md) | Nachtrag von Versionen in ATC-Codes |
| **ÄND** | [IG-MED46271FNY-01](./render-api-emp.md) | eMP-PDF/A: Identifikationsblock |
| **ÄND** | [IG-MED12459N5S-01](./render-api-emp.md) | eMP-PDF/A: Toleranzen |
| **NEU** | [IG-MED52218NLA](./op-cancel-prescription-erp.md) | Aufruf der Operation Verschreibungsdaten stornieren |
| **NEU** | [IG-MED82270JFF](./op-get-medication-plan.md) | Medikationsplan abrufen (eMP) |
| **ÄND** | [IG-MED88626YDT-01](./migration.md) | Korrektur von Berufsbezeichnungen in Practitioner-Instanzen bei Verschreibungsdaten |
| **ÄND** | [IG-MED71604H2P-02](./op-get-medication-plan.md) | Anzeige von eMP-Einträgen |
| **NEU** | [IG-MED61049U29](./op-add-emp-entry.md) | Übergabe des eMP-Identifier an E-Rezept |
| **NEU** | [IG-MED16095T3Y](./op-get-medication-list.md) | Medikationsliste abrufen (eML) |
| **NEU** | [IG-MED24600WA1](./privacy-security.md) | Medication Service - Schemavalidierung |
| **DEL** | IG-MED39936JQ6 | Implementierung allgemeingültiger Anforderungen an FHIR Data Services |
| **NEU** | [IG-MED89670ET5](./op-provide-prescription-erp.md) | Aufruf der Operation Verschreibungsdaten einstellen |
| **NEU** | [IG-MED01459D3P](./op-medication-plan-log.md) | eMP-Chronologie abrufen |
| **ÄND** | [IG-MED57011GPN-03](./general-principles.md) | Zusammenstellung der Hashwerte des EPAMedicationUniqueIdentifier |
| **ÄND** | [IG-MED07144WB0-01](./op-get-medication-plan.md) | Sortierung des Suchergebnisses in der Operation Medikationsplan abrufen (eMP) |
| **NEU** | [IG-MED09591LK4](./op-cancel-dispensation-erp.md) | Aufruf der Operation Dispensierinformationen stornieren |
| **ÄND** | [IG-MED23887CCD-01](./op-add-emp-entry.md) | Durchführung der Operation eMP-Eintrag hinzufügen nach der FHIR OperationDefinition |
| **NEU** | [IG-MED62934UX3](./op-get-medication-plan.md) | Medikationsplan abrufen (eMP) |
| **ÄND** | [IG-MED72420NF6-02](./op-get-medication-plan.md) | Lokale Volltextsuche und Filterfunktionen in eMP-Einträgen im Primärsystem |
| **DEL** | IG-MED89781ZZT-02 | Nutzung der FHIR-Operationen durch den E-Rezept-Fachdienst |
| **NEU** | [IG-MED47084VL5](./op-emp-commit.md) | eMP commit |
| **NEU** | [IG-MED25363BKT](./privacy-security.md) | Medication Service - Ablehnung von Request bei vorliegendem Widerspruch gegen die Nutzung durch eine spezifische LEI |
| **NEU** | [IG-MED29593UZM](./privacy-security.md) | Medication Service - Löschen der Daten des Medication Service |
| **ÄND** | [IG-MED04026M9H-04](./general-principles.md) | Medikationsliste u. -plan (FHIR-Schnittstelle/Query API) anzeigen |
| **NEU** | [IG-MED67431CY7](./privacy-security.md) | Medication Service - Ablehnung neuer Daten bei vorliegendem Widerspruch |
| **ÄND** | [IG-MED97198KBW-01](./op-add-emp-entry.md) | HTTP Header X-Requesting-Organization bei Operation eMP-Eintrag hinzufügen |
| **ÄND** | [IG-MED78473ZXQ-01](./op-provide-dispensation-erp.md) | Ausführung der Geschäftlogik der Operation Dispensierinformationen einstellen |
| **ÄND** | [IG-MED75797HAU-01](./op-add-emp-entry.md) | HTTP Header X-Requesting-Organization bei Operation eMP-Eintrag hinzufügen |

Legende:
**NEU**= Hinzugefügt|
**ÄND**= Geändert|
**VERS**= Verschoben|
**DEL**= Entfernt

### Version 1.2.0

* Nutzung des [Medication_IG_DE] mit den Datentypprofilen [DosageDgMP] und [TimingDgMP]
* Unterstützung für Nachtrag von Medikationen in der eML
* Unterstützung des eMP
* Unterstützung für Verknüpfungen zwischen eML- und eMP-Einträgen

#### EPAMedication

* Wegfall der SNOMED-CT- und EDQM-Kodierung

#### EPAMedicationRequest

* Setzen von **code** und **system** als optional in **.dispenseRequest.quantity** zur Herstellung der zukünftigen Kompabtibilät zum KBV-Profil 1.3.2

#### Provenance

* Das Provenance Profile eMP-Chronologieeintrag (EMPChronologyProvenance) wurde hinzugefügt.

#### Operation Verschreibungsdaten einstellen (eRP)

* Der eMP-Identifier wird durch die Geschäftslogik der Operation verarbeitet, um die Verknüpfung einer Verschreibung mit einem Medikationsplaneintrag herzustellen.

#### Abhängigkeiten

* Die Abhängigkeit zum ePA Basisfunktionalitäten Paket wurde auf Version 1.2.0 aktualisiert. [gemIG_ePA_Basic#Medication]
* Die Abhängigkeit zum Telematikinfrastruktur (TI) Common Paket wurde auf Version 1.1.1 aktualisiert. [gemIG_TI_Common#Medication]

#### Capability Statement

* Unterstützung des Profils **TIPractitioner** für die Ressource **Practitioner**
* Unterstützung des Profils **TIOrganization** für die Ressource **Organization**
* Mit dieser Version unterstützen die CapabilityStatements **EPAMedicationServiceServer** und **EPAMedicationServiceClient** jetzt die FHIR-Resource **MedicationStatement**, basierend auf dem Profil **EPAMedicationStatement**.
* Mit dieser Version unterstützen die CapabilityStatements **EPAMedicationServiceServer** und **EPAMedicationServiceClient** jetzt die FHIR-Resource **Provenance**, basierend auf dem Profil **EPAActivityProvenance**.

#### Suchparameter

* Neuer Suchparameter **RxPrescriptionProcessSP** für **Medication**, **MedicationDispense** und **MedicationStatement**.
* Neuer Suchparameter **DerivedFromSP** für **MedicationStatement**.
* Neuer Suchparameter **BasedOnEMPSP** für **MedicationStatement**.
* Neuer Suchparameter **IsEMPChronologySP** für **Provenance**.
* Neuer Suchparameter **MedicationQuestActivitySP** für **MedicationRequest**.

#### Render API: Medikationsliste abrufen (eML)

* Die Darstellungshinweise für die Render API zur Medikationsliste (eML) wurden überarbeitet

#### Anforderungen

| | | |
| :--- | :--- | :--- |
| **NEU** | IG-MED97245ECM | eMP-PDF/A: Grundlegendes Layout |
| **NEU** | IG-MED86167Z7G | Einmalige Durchführung der Migration |
| **ÄND** | IG-MED27473S8B-02 | Verarbeitung der Operation Verschreibungsdaten stornieren durch den Medication Service |
| **NEU** | IG-MED22047NEW | Ausführung der Geschäftlogik der Operation eMP-Eintrag aktualisieren |
| **NEU** | IG-MED99873AG4 | Atomare Ausführung der Operation API Batch eMP-Einträge |
| **NEU** | IG-MED53837PHV | Antwortverhalten der Operation API Batch eMP-Einträge |
| **ÄND** | IG-MED72042KWR-03 | Abruf der Medikationsliste (eML) ohne Datumsfilter |
| **NEU** | IG-MED04646V85 | ePA-PS: eMP-Eintrag aktualisieren |
| **NEU** | IG-MED99454XPV | ePA-PS: Medikationsplan (durch das Aktensystem gerendert) anzeigen |
| **NEU** | IG-MED71916JAU | ePA-FdV: Medikationsplan (durch das Aktensystem gerendert) anzeigen |
| **NEU** | IG-MED35195DPV | Reihenfolge der Verarbeitung in der Operation API Batch eMP-Einträge |
| **ÄND** | IG-MED91552N6U-02 | Verarbeitung der Operation Dispensierinformationen stornieren durch den Medication Service |
| **ÄND** | IG-MED39684YEU-03 | Standardsortierung für Practitioner |
| **NEU** | IG-MED11670DEY | Ausführung der Geschäftlogik der Operation Verschreibungsdaten stornieren |
| **NEU** | IG-MED41440L4D | Ausschluss fehlerhafter oder stornierter Daten in der gerenderten Medikationsliste (eML) |
| **NEU** | IG-MED43098L7G | ePA-PS: Medikationsplan anzeigen |
| **ÄND** | IG-MED55496HS1-02 | ePA-FdV: Medikationsliste (durch das Aktensystem gerendert) anzeigen |
| **NEU** | IG-MED99966BUK | HTTP-Header X-Requesting-Organization bei Operation eMP-Eintrag aktualisieren |
| **NEU** | IG-MED93348UAJ | Ausführung der Geschäftlogik der Operation eMP-Eintrag hinzufügen |
| **NEU** | IG-MED91662SNC | Rückgabe eines FHIR Bundle vom Typ searchset für die Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED87181PL5 | Löschen fehlerhafter oder stornierter Medikationsdaten |
| **NEU** | IG-MED65720GKQ | Fehlerbehandlung bei Aufruf der Operation API eMP commit außerhalb einer Batch-Verarbeitung |
| **NEU** | IG-MED59929SZJ | Ausführung der Geschäftlogik der Operation Entfernen einer eML-eMP-Verknüpfung |
| **NEU** | IG-MED54535LJP | ePA-PS: eMP-Chronologie abrufen |
| **NEU** | IG-MED08038M2V | Operation API Batch eMP-Einträge – Serverinternes Ausführungskontext‑Flag |
| **NEU** | IG-MED98922HV4 | HTTP-Header X-Requesting-Organization bei Operation Hinzufügen einer eML-eMP-Verknüpfung |
| **NEU** | IG-MED11815X3Q | eMP-PDF/A: Administrationsblock |
| **NEU** | IG-MED37997J2U | Standardsortierung für MedicationStatement |
| **NEU** | IG-MED18027VAP | ePA-PS: Hinzufügen einer eML-eMP-Verknüpfung |
| **NEU** | IG-MED03955ENL | Durchführung der Operation eML-Eintrag stornieren |
| **NEU** | IG-MED17706LL3 | Setzen des MedicationPlanIdentifier beim Erstellen eines eMP-Eintrags |
| **NEU** | IG-MED72972QGC | eMP-PDF/A: Darstellung der Dosierung in einer Zusatzzeile |
| **NEU** | IG-MED02895QQP | Verarbeitung von Suchparametern für Provenance |
| **NEU** | IG-MED23860M4B | eMP-PDF/A: Unterstützung der Media Types |
| **NEU** | IG-MED12861P6W | Verwerfen übermittelter Ressource-IDs bei Operationen |
| **ÄND** | IG-MED54433PBV-02 | Ausschluss der KBV-Schlüsseltabellen-Validierung für FHIR-Operationen des E-Rezept-Fachdienstes |
| **NEU** | IG-MED91744QDR | Rückgabe eines FHIR Bundle vom Typ searchset für die Operation eMP-Chronologie abrufen |
| **NEU** | IG-MED18735RJF | eMP-PDF/A: FHIR-Daten für die Operation |
| **ÄND** | IG-MED05461W2P-02 | ePA-PS: Medikationsliste anzeigen |
| **NEU** | IG-MED20374GEG | eMP-PDF/A: tabellarische Darstellung der Dosierung |
| **NEU** | IG-MED17281DXD | Ausführung der Geschäftlogik der Operation eML-Eintrag stornieren |
| **NEU** | IG-MED44250WUY | eMP-PDF/A: Bereiche |
| **NEU** | IG-MED14869UQV | Durchführung der Operation eMP Chronologie abrufen nach der FHIR OperationDefinition |
| **ÄND** | IG-MED07754P5P-02 | Partial Success für die Operation Verschreibungsdaten stornieren |
| **ÄND** | IG-MED03188C0X-03 | Sortierung des Suchergebnisses in der Operation Medikationsliste abrufen (eML) |
| **ÄND** | IG-MED07036EKU-03 | Standardsortierung für MedicationRequest |
| **ÄND** | IG-MED20855WKX-03 | Bereitstellung von Statusmeldungen als EPAOperationOutcome durch den Medication Service |
| **NEU** | IG-MED14428K6S | eMP-FHIR: Fehlerantwort bei nicht existierender Version des Medikationsplans (eMP) |
| **NEU** | IG-MED84431U1K | eMP-PDF/A: Darstellung mehrerer Dosierinformationen in einer Zusatzzeile |
| **NEU** | IG-MED07551L72 | ePA-PS: Operation API Batch eMP-Einträge |
| **NEU** | IG-MED71271QKC | Durchführung der Operation eMP-Eintrag aktualisieren nach der FHIR OperationDefinition |
| **NEU** | IG-MED94401KPF | Ausführung der Geschäftlogik der Operation Dispensierinformationen stornieren |
| **NEU** | IG-MED77591TGH | Sortierung des Suchergebnisses in der Operation eMP-Chronologie abrufen |
| **NEU** | IG-MED32621WGJ | ePA-PS: eMP-Eintrag hinzufügen |
| **NEU** | IG-MED45106BK4 | Durchführung der Operation API Batch eMP-Einträge nach der FHIR OperationDefinition |
| **NEU** | IG-MED50594P2K | ePA-PS: Medikationsliste (durch das Aktensystem gerendert) anzeigen |
| **NEU** | IG-MED30756HWV | HTTP-Header X-Requesting-Organization bei Operation eML-Eintrag hinzufügen |
| **NEU** | IG-MED15823A2P | ePA-PS: HTTP-Header X-Requesting-Organization bei Operation eMP-Eintrag aktualisieren |
| **ÄND** | IG-MED30750BK0-02 | Ausschluss stornierter Instanzen in der Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED54318LJQ | eMP-PDF/A: Darstellung der Stärke |
| **NEU** | IG-MED18070Y2W | ePA-PS: Hinweis auf Komma als Dezimaltrennzeichen |
| **NEU** | IG-MED06281JMT | Keine Übernahme von Referenzen bei übermittelten Ressourcen in Operationen |
| **NEU** | IG-MED98977HQ9 | Migrationsschritte Version 1.2.0 |
| **ÄND** | IG-MED98996PR0-03 | Verarbeitung des Datumsfilters in der Operation Medikationsliste abrufen (eML) |
| **DEL** | IG-MED03259ULC-02 | Schnittstellenimplementierung des Medication Service gemäß FHIR-Spezifikation im ePA-Aktensystem |
| **NEU** | IG-MED20540Q9L | Durchführung der Operation eMP commit nach der FHIR OperationDefinition |
| **ÄND** | IG-MED06578PNW-03 | ePA-FdV: Medikationsliste oder Medikationsplan anzeigen bei Widerspruch |
| **NEU** | IG-MED72792GXE | Durchführung der Operation Hinzufügen einer eML-eMP-Verknüpfung nach der FHIR OperationDefinition |
| **NEU** | IG-MED68008AH6 | ePA-PS: HTTP-Header X-Requesting-Organization bei Operation Hinzufügen einer eML-eMP-Verknüpfung |
| **ÄND** | IG-MED59111MZT-03 | Standardsortierung für Organization |
| **ÄND** | IG-MED75135Q7B-02 | Status Codes der Render API für das Abrufen der aufbereiteten elektronische Medikationsliste (eML) |
| **NEU** | IG-MED93814QXJ | Inhalte der gerenderten Medikationsliste (eML) in PDF/A und XHTML |
| **NEU** | IG-MED50059JZB | Durchführung der Operation eML-Eintrag hinzufügen |
| **NEU** | IG-MED75912NBU | Durchführung der Operation Entfernen einer eML-eMP-Verknüpfung nach der FHIR OperationDefinition |
| **NEU** | IG-MED63198EH0 | Rückgabe eines leeren Bundles bei fehlenden eMP-Chronologieeinträgen |
| **NEU** | IG-MED35894UP4 | eMP-FHIR: Fehlerantwort bei nicht existierendem Medikationsplan (eMP) |
| **NEU** | IG-MED76653G6V | ePA-PS: HTTP-Header X-Requesting-Organization bei Operation Entfernen einer eML-eMP-Verknüpfung |
| **NEU** | IG-MED46271FNY | eMP-PDF/A: Identifikationsblock |
| **NEU** | IG-MED66689BZJ | eMP-PDF/A: Darstellung des Anwendungszeitraums |
| **NEU** | IG-MED12459N5S | eMP-PDF/A: Toleranzen |
| **NEU** | IG-MED02076B84 | ePA-FdV: Verknüpfen von Diagnosen in eMP-Elementen mit Informationen des Nationalen Gesundheitsportals |
| **ÄND** | IG-MED06437XCT-03 | Datenquelle und Aufbereitung der gerenderten elektronischen Medikationsliste (eML) in PDF/A und XHTML im Medication Service |
| **ÄND** | IG-MED07348YLU-02 | Partial Success für die Operation Dispensierung stornieren |
| **NEU** | IG-MED20994Z5N | eMP-PDF/A: Zeilenumbrüche in Tabellenfeldern |
| **NEU** | IG-MED88626YDT | Korrektur von Berufsbezeichnungen in Practitioner-Instanzen bei Verschreibungsdaten |
| **NEU** | IG-MED18505C38 | Durchführung der Operation Medikationsplan abrufen (eMP) nach der FHIR OperationDefinition |
| **NEU** | IG-MED85114G5M | HTTP-Header X-Requesting-Organization bei Operation eML-Eintrag stornieren |
| **NEU** | IG-MED81255FHZ | eMP-PDF/A: Seitenbefüllung |
| **NEU** | IG-MED71604H2P | ePA-PS/ePA-FdV: Lokale Volltextsuche und Filterfunktionen in eMP-Einträgen |
| **NEU** | IG-MED73200HNW | Rückgabe eines FHIR Bundle vom Typ collection für die Operation Medikationsplan abrufen (eMP) |
| **NEU** | IG-MED03519KYL | eMP-PDF/A: Darstellung von Kombipräparaten |
| **ÄND** | IG-MED68581A3P-03 | Standardsortierung für MedicationDispense |
| **NEU** | IG-MED51601THQ | Validierung der aufbereitete Dosierungsdarstellung gemäß HL7 Deutschland DosageDgMP-Profil |
| **NEU** | IG-MED20676FFH | eMP-PDF/A: Darstellung der Dosierung (dosageInstruction) |
| **NEU** | IG-MED39764RR6 | Operation API Batch eMP-Einträge – Konformität zu FHIR R4 batch/transaction |
| **NEU** | IG-MED09759K35 | ePA-PS/ePA-FdV: Darstellung von eMP-Einträgen nach Status |
| **ÄND** | IG-MED00206H71-02 | Verarbeitung der Operation Dispensierinformationen einstellen durch den Medication Service |
| **ÄND** | IG-MED16008ST8-02 | Integrität der Suchergebnisseite bei Abruf der Medikationsliste (eML) |
| **NEU** | IG-MED90648H2W | HTTP-Header X-Requesting-Organization bei Operation Entfernen einer eML-eMP-Verknüpfung |
| **NEU** | IG-MED78911M80 | Komma als Dezimaltrennzeichen in Render APIs |
| **ÄND** | IG-MED45859RPQ-02 | Durchführung der Operation Dispensierinformationen einstellen nach der FHIR OperationDefinition |
| **NEU** | IG-MED37917AKV | ePA-PS: eML-Eintrag stornieren |
| **ÄND** | IG-MED55163NJS-02 | Durchführung der Operation Dispensierinformationen stornieren nach der FHIR OperationDefinition |
| **NEU** | IG-MED33555SSQ | ePA-PS: HTTP-Header X-Requesting-Organization bei Operation API Batch eMP-Einträge |
| **NEU** | IG-MED99233F7E | Suchergebnis und Datenmenge für die Operation eMP-Chronologie abrufen |
| **ÄND** | IG-MED36764UB7-02 | Verarbeitung der Operation Verschreibungsdaten einstellen durch den Medication Service |
| **ÄND** | IG-MED32071XZW-02 | Durchführung der Operation Verschreibungsdaten einstellen nach der FHIR OperationDefinition |
| **NEU** | IG-MED16176F73 | Kennzeichnung neuer MedicationStatement-Instanz mit PRESCRIPTION bei der Operation Verschreibungsdaten einstellen |
| **NEU** | IG-MED46774KZV | Ausführung der Geschäftlogik der Operation Hinzufügen einer eML-eMP-Verknüpfung |
| **ÄND** | IG-MED71384CP6-03 | Standardsortierung für Medication |
| **NEU** | IG-MED61434W6C | eMP-PDF/A: Medikationstabelle |
| **ÄND** | IG-MED60410V23-02 | Durchführung der Operation Verschreibungsdaten stornieren nach der FHIR OperationDefinition |
| **NEU** | IG-MED03974KZQ | Durchführungszeitpunkt |
| **NEU** | IG-MED24331WH3 | Unterstützung der Paginierung in der Operation eMP-Chronologie abrufen |
| **NEU** | IG-MED14935D6N | Ausführung der Geschäftlogik der Operation eML-Eintrag hinzufügen |
| **NEU** | IG-MED55518RUD | ePA-PS: Entfernen einer eML-eMP-Verknüpfung |
| **ÄND** | IG-MED47869JD8-02 | Erkennung und Verarbeitung von Substitutionen bei der Operation Dispensierinformationen einstellen |
| **ÄND** | IG-MED73987WSL-02 | Partial Success für die Operation Verschreibungsdaten einstellen |
| **NEU** | IG-MED07144WB0 | eMP-FHIR: Sortierung des Suchergebnisses in der Operation Medikationsplan abrufen (eMP) |
| **NEU** | IG-MED11340RGW | ePA-PS: HTTP-Header X-Requesting-Organization bei Operation eML-Eintrag hinzufügenn |
| **NEU** | IG-MED23887CCD | Durchführung der Operation eMP-Eintrag hinzufügen nach der FHIR OperationDefinition |
| **ÄND** | IG-MED64473BLY-02 | Schematischer Aufbau und Datenherkunft der generierten elektronischen Medikationsliste (eML) |
| **NEU** | IG-MED06688ZUT | Verarbeitung von Suchparametern für MedicationStatement |
| **ÄND** | IG-MED67446E6Y-02 | Partial Success für die Operation Dispensierinformationen einstellen |
| **NEU** | IG-MED72420NF6 | ePA-PS/ePA-FdV: Lokale Volltextsuche und Filterfunktionen in eMP-Einträgen |
| **NEU** | IG-MED98676XV4 | Ausführung der Geschäftlogik der Operation API Batch eMP-Einträge |
| **NEU** | IG-MED60219YNT | Status Codes der Render API für das Abrufen des aufbereiteten elektronischen Medikationsplans (eMP) |
| **NEU** | IG-MED61563Z4Y | Auflösung von Organization-Referenzen in Provenance.agent.who für die Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED44820T9V | Standardsortierung für Provenance |
| **ÄND** | IG-MED25166HZB-03 | Standardsortierung für PractitionerRole |
| **ÄND** | IG-MED89781ZZT-02 | Nutzung der FHIR-Operationen durch den E-Rezept-Fachdienst |
| **ÄND** | IG-MED98457Y57-02 | Konsistenz der referenzierten Instanzen innerhalb einer Ergebnisseite in der Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED19844CVF | eMP-PDF/A: Zeilenumbruch im Feld Form |
| **NEU** | IG-MED80730R7R | eMP-PDF/A: Datenherkunft Tabelleninhalte |
| **NEU** | IG-MED93441Y6A | eMP-PDF/A: Fußbereich |
| **ÄND** | IG-MED40417H68-02 | Rückgabe von Diagnosedaten beim Einstellen von Daten durch E-Rezept-Fachdienst |
| **ÄND** | IG-MED04026M9H-03 | ePA-FdV: Medikationsliste u. -plan (FHIR-Schnittstelle) anzeigen |
| **NEU** | IG-MED47906P9L | ePA-PS: HTTP-Header X-Requesting-Organization bei Operation eML-Eintrag stornieren |
| **NEU** | IG-MED83410GLG | Kennzeichnung neuer MedicationStatement-Instanz mit MANUAL bei der Operation eML-Eintrag hinzufügen |
| **ÄND** | IG-MED98416U4Q-02 | Suchergebnis und Datenmenge für die Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED97198KBW | HTTP-Header X-Requesting-Organization bei Operation eMP-Eintrag hinzufügen |
| **NEU** | IG-MED90507DCV | Ausführung der Geschäftlogik der Operation Operation API eMP commit |
| **NEU** | IG-MED70442FNC | eMP-PDF/A: Verbot von Dubletten |
| **NEU** | IG-MED84886NXL | ePA-PS: Anfrageformat der Operation API Batch eMP-Einträge |
| **NEU** | IG-MED77392SBV | eMP-FHIR: Ergebnis und Datenmenge für die Operation Medikationsplan abrufen (eMP) |
| **NEU** | IG-MED53251YE4 | Ausführung der Geschäftlogik der Operation Verschreibungsdaten einstellen |
| **NEU** | IG-MED49098H1E | ePA-PS: eML-Eintrag hinzufügen |
| **NEU** | IG-MED78473ZXQ | Ausführung der Geschäftlogik der Operation Dispensierinformationen einstellen |
| **NEU** | IG-MED41381ZKR | HTTP-Header X-Requesting-Organization bei Operation API Batch eMP-Einträge |
| **NEU** | IG-MED75797HAU | ePA-PS: HTTP-Header X-Requesting-Organization bei Operation eMP-Eintrag hinzufügen |

Legende:
**NEU**= Hinzugefügt|
**ÄND**= Geändert|
**VERS**= Verschoben|
**DEL**= Entfernt

### Version 1.1.5

#### EPAMedication

* Die Versionsangabe einer ATC-de-Kodierung ist verpflichtend, da die Eindeutigkeit einer Kodierung über Versionen nicht sichergestellt werden kann.

#### EPAMedicationPharmaceuticalProduct

* Der Slice **Medication.code.coding:product-key** wurde entfernt, da das Kodiersystem nicht definiert ist.

#### Abhängigkeiten

* Die Abhängigkeit zum Telematikinfrastruktur (TI) Common Paket wurde auf Version 1.1.0 aktualisiert: [gemIG_TI_Common#Medication]
* Die Abhängigkeit zum ePA Basisfunktionalitäten Paket wurde auf Version 1.1.5 aktualisiert: [gemIG_ePA_Basic#Medication]

#### CapabilityStatement

* Im CapabilityStatement **EPAMedicationServiceServer** wurde der Suchparameter **has für die Ressourcen _Medication**, **MedicationRequest**, **MedicationDispense**, **Organization**, **Practitioner** und **PractitionerRole** hinzugefügt.

#### Operations

* Die Operation **Dispensierinformationen einstellen** wurde angepasst, sodass nun die fachliche Information zur Substitution einer Dispensierung bei der Erstellung einer neuen **Medication**-Instanz berücksichtigt wird.
* Die Operation **Dispensierinformationen einstellen** wurde angepasst, sodass **MedicationDispense**-Instanzen nicht mehr auf **declined** gesetzt, sondern gelöscht werden – außer sie haben den Status **cancelled**. Diese bleiben weiterhin bestehen. Da die FHIR-Instanzversionierung eine physische Löschung nicht vorsieht, können gelöschte Instanzen über die FHIR-Historienansicht abgerufen werden.
* Die Operation **Dispensierinformationen einstellen** wurde angepasst, sodass Daten von vorläufigen Abgaben übertragbar sind.

#### Anforderungen

| | | |
| :--- | :--- | :--- |
| **NEU** | IG-MED97505ZEG | Gewährleistung der Profilkonformität |
| **NEU** | IG-MED25360QCP | Patient-Instanz als erstes Element der ersten Ergebnisseite im Suchergebnis der Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED23573F00 | Darstellung von Substitution und Mehrfachverordnung in der gerenderten elektronischen Medikationsliste (eML) |
| **NEU** | IG-MED32282ZGM | Ignorierung von FHIR-Profilangaben |
| **ÄND** | IG-MED03188C0X-02 | Sortierung des Suchergebnisses in der Operation Medikationsliste abrufen (eML) |
| **ÄND** | IG-MED20855WKX-02 | Bereitstellung von Statusmeldungen als EPAOperationOutcome durch den Medication Service |
| **ÄND** | IG-MED06578PNW-02 | ePA-FdV: Medikationsliste anzeigen bei Widerspruch |
| **ÄND** | IG-MED06437XCT-02 | Datenquelle und Aufbereitung der gerenderten elektronischen Medikationsliste (eML) in PDF/A und XHTML im Medication Service |
| **NEU** | IG-MED87542J43 | Implementierung der /metadata Funktion im Medication Service |
| **NEU** | IG-MED69057S0X | Einbindung der Patient-Instanz aus dem Patient Service in das Suchergebnis der Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED16008ST8 | Integrität der Suchergebnisseite bei Abruf der Medikationsliste (eML) |
| **ÄND** | IG-MED57011GPN-02 | Zusammenstellung der Hashwerte des EPAMedicationUniqueIdentifier |
| **NEU** | IG-MED47869JD8 | Erkennung und Verarbeitung von Substitutionen bei der Operation Dispensierinformationen einstellen (E-Rezept-Fachdienst) |
| **NEU** | IG-MED64473BLY | Schematischer Aufbau und Datenherkunft der generierten elektronischen Medikationsliste (eML) |
| **NEU** | IG-MED40417H68 | Rückgabe von Diagnosedaten beim Einstellen von Daten durch E-Rezept-Fachdienst |
| **ÄND** | IG-MED04026M9H-02 | ePA-FdV: Medikationsliste (FHIR-Schnittstelle) anzeigen |
| **NEU** | IG-MED16217P4A | Fehlerantwort bei leerer Medikationsliste (eML) |

Legende:
**NEU**= Hinzugefügt|
**ÄND**= Geändert|
**VERS**= Verschoben|
**DEL**= Entfernt

### Version 1.0.6-2

#### Extension

* Die **medication-is-vaccine** Extension wurde wieder in **medication-id-vaccine** umbenannt, um Breaking Changes zu vermeiden.

#### Capability Statement

* Der **revinclude Parameter _MedicationDispense:performer** wurde aus der **Query API Practitioner** entfernt, da **MedicationDispense.performer.actor** nicht direkt auf **Practitioner**, sondern auf **PractitionerRole** oder **Organization** verweist.

### Version 1.0.6-1

#### Abhängigkeiten

* Die Abhängigkeit zum TI Terminology Paket wurde auf Version 1.0.5-4 aktualisiert.
* Die Abhängigkeit zum ePA Basisfunktionalitäten Paket wurde auf Version 1.0.6-1 aktualisiert.

### Version 1.0.6

#### Render API

* HTTP Request Header wurden in der Schnittstellenbeschreibung ergänzt.

#### EPAMedicationRequest

* Der searchInclude **MedicationRequest:performer** wurde ersetzt durch **MedicationRequest:requester**.

#### Suchparameter

* Die Unterstützung für *_include=Medication:ingredient* und *_revinclude=Medication:ingredient* wurde entfernt, da diese in dieser Version nicht benötigt werden.

#### Operation API: Medikationsliste abrufen

* Die URL zum Beispiel für Datumsfilterung wurde korrigiert.

#### Abhängigkeiten

* Die Abhängigkeit zum Telematikinfrastruktur (TI) Common Paket wurde auf Version 1.0.1 aktualisiert.
* Die Abhängigkeit zum ePA-Basisfunktionalitäten-Paket wurde auf Version 1.0.6 aktualisiert.

#### Anforderungen

| | | |
| :--- | :--- | :--- |
| **ÄND** | IG-MED72042KWR-02 | Abruf der Medikationsliste (eML) ohne Datumsfilter |
| **ÄND** | IG-MED39684YEU-02 | Standardsortierung für Practitioner |
| **ÄND** | IG-MED07036EKU-02 | Standardsortierung für MedicationRequest |
| **ÄND** | IG-MED98996PR0-02 | Verarbeitung des Datumsfilters in der Operation Medikationsliste abrufen (eML) |
| **ÄND** | IG-MED59111MZT-02 | Standardsortierung für Organization |
| **DEL** | IG-MED87542J43 | Implementierung der /metadata Funktion im Medication Service |
| **ÄND** | IG-MED68581A3P-02 | Standardsortierung für MedicationDispense |
| **ÄND** | IG-MED71384CP6-02 | Standardsortierung für Medication |
| **ÄND** | IG-MED25166HZB-02 | Standardsortierung für PractitionerRole |

Legende:
**NEU**= Hinzugefügt|
**ÄND**= Geändert|
**VERS**= Verschoben|
**DEL**= Entfernt

### Version 1.0.5-1

#### Suchparameter

* Der Custom-Search-Parameter **rx-prescription** sowie der Suchparameter **ingredient** für **Medication.ingredient.item.reference** wurden entfernt, da sie in dieser Version nicht relevant sind.

### Version 1.0.5

#### EPAMedication, EPAMedicationPharmaceuticalProduct

* Die Constraints **epa-2** und **epa-3** zur Kombipackung wurden entfernt.
* Die Kardinalität von **Medication.code.coding:product-key** wurde auf 0..1 reduziert.
* **EPAMedication.ingredient:pznCode** ist jetzt zulässig.
* **Medication.batch** wurde als Must Support (MS) gekennzeichnet.
* Die Kardinalität von **EPAMedication.ingredient.strength.numerator** wurde auf 0..1 gesetzt.
* Der Absent Reason für **EPAMedication.ingredient.strength.numerator.code** wurde entfernt.
* Die Kardinalität von **EPAMedication.ingredient.strength.numerator.code** wurde auf 0..1 gesetzt.
* Die Kardinalität der Elemente **EPAMedication.drugCategory.code** und **EPAMedication.drugCategory.system** wurde von 0..1 auf 1..1 angepasst. Diese Felder sind nun verpflichtend.
* Aufgrund von Validierungsfehlern wurden alle **context**-Elemente aus allen Extensions der **EPAMedication** entfernt.

#### EPAMedicationDispense

* Das Element **EPAMedicationDispense.performer.actor** erlaubt eine Referenz auf **Organization** oder **PractitionerRole**.
* Das Element **EPAMedicationDispense.dosageInstruction.text** wurde als Must Support(MS) deklariert.

#### EPAMedicationRequest

* Das Element **EPAMedicationRequest.requester** erlaubt eine Referenz auf **Organization**, **Practitioner** oder **PractitionerRole**.
* Das Element **EPAMedicationRequest.dosageInstruction.text** wurde als Must Support (MS) deklariert.

#### Anforderungen

| | | |
| :--- | :--- | :--- |
| **NEU** | IG-MED27473S8B | Verarbeitung der Operation Verschreibungsdaten stornieren (E-Rezept-Fachdienst) durch den Medication Service |
| **NEU** | IG-MED72042KWR | Abruf der Medikationsliste (eML) ohne Datumsfilter |
| **NEU** | IG-MED31793UJS | Non-FHIR HTTP Status Codes für Schnittstellen des Medciation Service |
| **NEU** | IG-MED22121MHS | Unterstützung der Media Types für die aufbereitete elektronische Medikationsliste (eML) |
| **NEU** | IG-MED97456XU7 | Verarbeitung von Suchparametern für Practitioner |
| **NEU** | IG-MED91552N6U | Verarbeitung der Operation Dispensierung stornieren (E-Rezept-Fachdienst) durch den Medication Service |
| **NEU** | IG-MED39684YEU | Standardsortierung für Practitioner |
| **NEU** | IG-MED94460V8J | Zugriffsrechte gemäß Legal Policy |
| **NEU** | IG-MED55496HS1 | ePA-FdV: Medikationsliste (durch das Aktensystem gerendert) anzeigen |
| **NEU** | IG-MED30597ZJA | Erforderliche Benutzerinformationen für Medication Service Schnittstellen |
| **NEU** | IG-MED54433PBV | Ausschluss der KBV-Schlüsseltabellen-Validierung für FHIR-Operationen des E-Rezept-Fachdienstes |
| **NEU** | IG-MED05461W2P | ePA-PS: Medikationsliste anzeigen |
| **NEU** | IG-MED03194N37 | Durchführung der Operation Medikationsliste abrufen (eML) nach der FHIR OperationDefinition |
| **NEU** | IG-MED07754P5P | Partial Success für die Operation Verschreibungsdaten stornieren (E-Rezept-Fachdienst) |
| **NEU** | IG-MED48361BE0 | Generierung des EPAMedicationUniqueIdentifier |
| **NEU** | IG-MED03188C0X | Sortierung des Suchergebnisses in der Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED07036EKU | Standardsortierung für MedicationRequest |
| **NEU** | IG-MED20855WKX | Bereitstellung von Statusmeldungen als EPAOperationOutcome durch den Medication Service |
| **NEU** | IG-MED48887L6V | Implementierung ePA-spezifischer Anforderungen an FHIR Data Services |
| **NEU** | IG-MED40234G89 | Erzeugung und Zuweisung des RxPrescriptionProcessIdentifier |
| **NEU** | IG-MED30750BK0 | Ausschluss stornierter Instanzen in der Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED98996PR0 | Verarbeitung des Datumsfilters in der Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED03259ULC | Schnittstellenimplementierung des Medication Service gemäß FHIR-Spezifikation im ePA-Aktensystem |
| **NEU** | IG-MED06578PNW | ePA-FdV: Medikationsliste anzeigen bei Widerspruch |
| **NEU** | IG-MED59111MZT | Standardsortierung für Organization |
| **NEU** | IG-MED75135Q7B | Status Codes der Render API für das Abrufen der aufbereitete elektronische Medikationsliste (eML) |
| **NEU** | IG-MED89895TXC | Keine EPAMedicationUniqueIdentifier für Contained Medications |
| **NEU** | IG-MED59646EXK | Erzeugung und Zuweisung des RxOriginatorProcessIdentifier |
| **NEU** | IG-MED06437XCT | Datenquelle und Aufbereitung der gerenderten elektronischen Medikationsliste (eML) in PDF/A und XHTML im Medication Service |
| **NEU** | IG-MED07348YLU | Partial Success für die Operation Dispensierung stornieren (E-Rezept-Fachdienst) |
| **NEU** | IG-MED66902Z2U | Verarbeitung von Suchparametern für MedicationDispense |
| **NEU** | IG-MED87542J43 | Implementierung der /metadata Funktion im Medication Service |
| **NEU** | IG-MED55122C60 | Verarbeitung von Suchparametern für MedicationRequest |
| **NEU** | IG-MED68581A3P | Standardsortierung für MedicationDispense |
| **NEU** | IG-MED68233Q6E | Verarbeitung von Suchparametern für Medication |
| **NEU** | IG-MED00206H71 | Verarbeitung der Operation Dispensierinformationen einstellen (E-Rezept-Fachdienst) durch den Medication Service |
| **NEU** | IG-MED45859RPQ | Durchführung der Operation Dispensierinformationen einstellen (E-Rezept-Fachdienst) nach der FHIR OperationDefinition |
| **NEU** | IG-MED55163NJS | Durchführung der Operation Dispensierung stornieren (E-Rezept-Fachdienst) nach der FHIR OperationDefinition |
| **NEU** | IG-MED36764UB7 | Verarbeitung der Operation Verschreibungsdaten einstellen (E-Rezept-Fachdienst) durch den Medication Service |
| **NEU** | IG-MED32071XZW | Durchführung der Operation Verschreibungsdaten einstellen (E-Rezept-Fachdienst) nach der FHIR OperationDefinition |
| **NEU** | IG-MED39936JQ6 | Implementierung allgemeingültiger Anforderungen an FHIR Data Services |
| **NEU** | IG-MED28501PRA | Verarbeitung von Suchparametern für Organization |
| **NEU** | IG-MED71384CP6 | Standardsortierung für Medication |
| **NEU** | IG-MED60410V23 | Durchführung der Operation Verschreibungsdaten stornieren (E-Rezept-Fachdienst) nach der FHIR OperationDefinition |
| **NEU** | IG-MED57011GPN | Zusammenstellung der Hashwerte des EPAMedicationUniqueIdentifier |
| **NEU** | IG-MED73987WSL | Partial Success für die Operation Verschreibungsdaten einstellen (E-Rezept-Fachdienst) |
| **NEU** | IG-MED10129K1D | Verwaltung des EPAMedicationUniqueIdentifier |
| **NEU** | IG-MED17488MTF | Medication-Service-Schnittstellen: Bereitstellung auf vordefinierten Pfaden im VAU-Kanal |
| **NEU** | IG-MED67446E6Y | Partial Success für die Operation Dispensierinformationen einstellen (E-Rezept-Fachdienst) |
| **NEU** | IG-MED25166HZB | Standardsortierung für PractitionerRole |
| **NEU** | IG-MED89781ZZT | Nutzung der FHIR-Operationen durch den E-Rezept-Fachdienst |
| **NEU** | IG-MED98457Y57 | Konsistenz der referenzierten Instanzen innerhalb einer Ergebnisseite in der Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED56911ZM0 | Unterstützung der Paginierung in der Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED04026M9H | ePA-FdV: Medikationsliste (FHIR-Schnittstelle) anzeigen |
| **NEU** | IG-MED98416U4Q | Suchergebnis und Datenmenge für die Operation Medikationsliste abrufen (eML) |
| **NEU** | IG-MED88881HWN | Verarbeitung von Suchparametern für PractitionerRole |

Legende:
**NEU**= Hinzugefügt|
**ÄND**= Geändert|
**VERS**= Verschoben|
**DEL**= Entfernt

