# Verarbeitungsregeln - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **Verarbeitungsregeln**

## Verarbeitungsregeln

Der Medication Service stellt die elektronische Medikationsliste (eML) über die FHIR API bereit. Primärsysteme und ePA-FdV können diese Schnittstelle nutzen, um die eML-Daten in ihre Systemumgebung zu integrieren.

Diese Beschreibung konzentriert sich auf die Struktur der FHIR-Ressourceninstanzen sowie auf die zugehörigen Verarbeitungsregeln. Vorgaben zur Darstellung der eML-Daten in den Benutzeroberflächen der Primärsysteme oder ePA-FdV sind nicht Bestandteil dieser Spezifikation.

### Umgang mit Code/Bezeichnung beziehungsweise CodeableConcept

Es gibt an vielen Stellen die Möglichkeit ein Konzept, also den Wert eines Elementes, über eine Anzahl von Codes und/oder einem Freitext abzubilden (z.B. bei **Medication.code**). Dies heißt im Informationsmodell in der Regel Code/Bezeichnung und entspricht in FHIR dem Datentyp [CodeableConcept]. Dieser kann, vereinfacht gesagt, entweder aus einer textuellen Beschreibung des Konzeptes bestehen (nur Text), der Kodierung mithilfe eines in einem Code System definiertem Code mit dazugehörigem Anzeigenamen (nur Code/mehrere Codes) oder aber aus einer Kombination aus beidem (Text und Codes). Die Verwendung mehrerer Codes aus unterschiedlichen Code Systems und eines Freitextes für ein und dasselbe Konzept ist explizit erlaubt und je nach Kontext auch fachlich sinnvoll. Hierbei ist zu beachten, dass alle Repräsentationen genau dasselbe Konzept abbilden und sich in der Granularität unterscheiden können, jedoch inhaltlich keine andere Bedeutung haben dürfen.

Technisch kann (ohne zugrundeliegendes Mapping) nicht überprüft werden, ob die Unterelemente des Konzeptes (Codes und/oder Text) inhaltlich zusammenpassen. Daher liegt die Verantwortung der Prüfung und gegebenenfalls Anpassung oder Entfernung, dieser Elemente bei der bearbeitenden Leistungserbringerinstitution. Technisch können Funktionen des Primärsystems hierbei unterstützen. Um die Zahl der Fehlzuordnungen möglichst gering zu halten, sollte bei der Bearbeitung des Konzepts oder dazugehörigen Unterelementen ein entsprechender Hinweis an die bearbeitende Person ausgegeben werden.

### Auslesen der Dosierungsangaben

Für die Darstellung und Verarbeitung der Dosierungsangaben im ePA Medication Service wird das Datentyp-Profil [DosageDgMP]von HL7 Deutschland verwendet. Dieses Datentyp-Profil definiert die strukturierte Abbildung der Dosierung auf Basis des FHIR-Datentyps Dosage und legt die zulässigen Felder sowie deren Wertebereiche fest.

Die Verarbeitungsregeln für die Dosierungsdaten sind im [Medication_IG_DE] bzw. den darin befindlichen [DosageDgMP] und [TimingDgMP]-Datentypprofile für den dgMP beschrieben. Diese Vorgaben sind verbindlich für alle Dosierungsangaben im Kontext des ePA Medication Service anzuwenden – sowohl für Dosierungen, die aus dem Verschreibungs- und Abgabeprozess des E-Rezepts stammen, als auch für nachträglich eingetragene Informationen.

Mit dem Datentyp-Profil [DosageDgMP] von HL7 Deutschland ist ein verbindlicher Render-Algorithmus spezifiziert. Dieser Algorithmus wird vom ePA Medication Service sowie vom E-Rezept-Fachdienst angewendet, um die aufbereitete Dosierungsdarstellung zu prüfen bzw. zu validieren.

Die aufbereitete Dosierungsdarstellung wird in der Extension *.extension[renderedDosageInstruction]* hinterlegt. Ist dieses Element in einer Instanz nicht vorhanden, gilt der Inhalt von *dosage.text* (falls vorhanden) bzw. *dosageInstruction.text*.

**Beispiel .extension[renderedDosageInstruction]**

```
"extension": [
  {
    "url": "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationStatement.renderedDosageInstruction",
    "valueMarkdown": "1-0-1-0 Stück"
  },
  {
    "extension": [
      {
        "url": "algorithmVersion",
        "valueString": "1.0.1"
      },
      {
        "url": "language",
        "valueCode": "de-DE"
      }
    ],
    "url": "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
  }
],

```

**Beispiel dosageInstruction.text**

```
"dosageInstruction": [
  {
    "text": "morgens und abends 1 Messlöffel"
  }
],

```

#### eML

In der aktuellen Version muss die Dosierinformation für die eML aus den **MedicationStatement**-Instanzen des Medication Service ausgelesen werden. Dies gilt sowohl für Daten, die aus dem Verschreibungs- und Abgabeprozess des E-Rezept-Fachdienstes stammen, als auch für nachträglich hinzugefügte Einträge (Nachtrag). Der Medication Service stellt sicher, dass beim Einstellen oder Aktualisieren von Daten stets die jeweils aktuellste Dosierinformation übernommen wird. Wenn die Dosierung im Abgabeprozess durch die Apotheke konkretisiert oder angepasst wurde oder ein Nachtrag vorliegt, ist diese aktualisierte Information im MedicationStatement enthalten. Die Dosierinformationen werden dabei aus dem Dosage-Element des **MedicationStatement.dosage** entnommen.

Es gilt somit:

* Für die Verarbeitung ist die Dosierinformation aus dem **MedicationStatement.dosage** maßgeblich.
* Frühere Stellen wie MedicationRequest.dosageInstruction.text oder MedicationDispense.dosageInstruction.text sollen nicht mehr direkt ausgewertet werden.

##### Ausleselogik der Dosierungsangaben in eML und eMP

Für Primärsysteme gilt folgende Regelung:

* Die Dosierungsangaben eines eMP-Eintrags werden stets aus der zugehörigen Instanz des eMP-Eintrags ausgelesen.
* Die Dosierungsangaben der eML werden stets aus der entsprechenden eML-Instanz ausgelesen.

In den jeweiligen Geschäftslogiken der entsprechenden Operationen im eMP und der Operationen in der eML wird sichergestellt, dass die aktuellen und gültigen Informationen in den jeweiligen Instanzen hinterlegt sind. Dadurch ist eine konsistente und eindeutige Auslesung der Dosierungsangaben gewährleistet.

### Angaben bei Kombipackungen (Darreichungsform “KPG”)

Kombipackungen sind Arzneimittelprodukte, die aus mehreren Teilpräparaten bestehen. Typische Beispiele sind Präparate mit unterschiedlichen Wirkstoffen oder unterschiedlichen Stärken, die gemeinsam unter einer PZN vertrieben werden.

1. Angabe der Darreichungsform
* Für die Gesamtpackung ist als Darreichungsform ausschließlich der Wert *KPG* (Kombipackung) in *Medication.form.coding[kbvDarreichungsform]* anzugeben.
* Die Darreichungsformen der einzelnen Teilpräparate werden nicht separat erfasst.

1. Angabe der Wirkstoffe
* In *Medication.ingredient* müssen die Wirkstoffe aller in der Kombipackung enthaltenen Teilpräparate vollständig angegeben werden, sofern die zugrunde liegenden Arzneimitteldaten entsprechende Wirkstoffinformationen enthalten.

### Auslesen der Verschreibung (MedicationRequest)

#### Auslesen des Verordnungsdatums

Die Ressource **MedicationRequest** enthält ein Element namens *authoredOn* (*MedicationRequest.authoredOn*). Der Wert dieses Elements gibt das Ausstellungsdatum der Verordnung an und soll für die Darstellung des Verordnungsdatums verwendet werden.

```
{
    "resourceType": "MedicationRequest",
    ...
    "authoredOn": "2025-01-22",
    ...
}

```

#### Einfach- und Mehrfachverordnungen

Das Profil **EPAMedicationRequest** enthält die Erweiterung **MultiplePrescription**, deren Struktur der Extension _KBV_EX_ERP_Multiple_Prescription_ aus dem E-Rezept **MedicationRequest**-Profil _KBV_PR_ERP_Prescription_ der KBV entspricht.

* MultiplePrescription (ePA Medication): [Extension: MultiplePrescription](./StructureDefinition-multiple-prescription-extension.md)
* KBV_EX_ERP_Multiple_Prescription (Projekt eRezept): [Simplifier-Projekt eRezept](https://simplifier.net/erezept/kbv_ex_erp_multiple_prescription)

Innerhalb der **MultiplePrescription**-Erweiterung befindet sich das Element **indicator**, das als Boolean definiert ist. Dieses Element gibt an, ob die betreffende **MedicationRequest**-Instanz Teil einer Mehrfachverordnung ist. Beim Auslesen des Datensatzes muss das **indicator**-Element zwingend interpretiert werden. Es reicht nicht aus, lediglich das Vorhandensein der Extension-Elemente zu prüfen.

```
{
    "extension":  [
        {
            "url": "indicator",
            "valueBoolean": true
        }
    ],
    "url": "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
}

```

##### Die Erweiterung MultiplePrescription

Die Erweiterung **MultiplePrescription** umfasst zusätzlich weitere Elemente wie **counter**, **period** und **id**.

Das Element **counter** zeigt an, die wievielte Verordnung einer Mehrfachverordnung gemeint ist. Zum Beispiel: Bei “2 von 4” steht der **numerator** für die 2 und der **denominator** für die 4.

```
{
    "url": "counter",
    "valueRatio": {
        "numerator": {
            "value": 2
        },
        "denominator": {
            "value": 4
        }
    }
},

```

Das Element **period** gibt den Zeitraum der Einlösefrist an. Der Wert **start** markiert den Beginn der Frist, während der Wert **end** das Ende der Frist beschreibt.

```
{
    "url": "period",
    "valuePeriod": {
        "start": "2024-06-15"
    }
},

```

Das Element **id** steht für die ID der Mehrfachverordnung. Diese ID ist bei allen Teilverordnungen einer Mehrfachverordnung identisch und wird als UUID angegeben.

```
{
    "url": "id",
    "valueIdentifier": {
        "system": "urn:ietf:rfc:3986",
        "value": "urn:uuid:33bff9fb-75dc-43b4-8593-f6c7937fc10e"
    }
}

```

###### Vollständiges Beispiel

```
{
    "extension":  [
        {
            "url": "indicator",
            "valueBoolean": true
        },
        {
            "url": "counter",
            "valueRatio": {
                "numerator": {
                    "value": 2
                },
                "denominator": {
                    "value": 4
                }
            }
        },
        {
            "url": "period",
            "valuePeriod": {
                "start": "2024-06-15"
            }
        },
        {
            "url": "id",
            "valueIdentifier": {
                "system": "urn:ietf:rfc:3986",
                "value": "urn:uuid:33bff9fb-75dc-43b4-8593-f6c7937fc10e"
            }
        }
    ],
    "url": "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
}

```

### Auslesen der Abgabe (MedicationDispense)

#### Auslesen des Dispensierdatums

Die Ressource **MedicationDispense** enthält ein Element namens *whenHandedOver* (*MedicationDispense.whenHandedOver*). Der Wert dieses Elements gibt das Datum der Abgabe an und soll für die Darstellung des Dispensierdatums verwendet werden.

```
{
    "resourceType": "MedicationDispense",
    ...
    "whenHandedOver": "2025-01-22",
    ...
}

```

#### Prüfen, ob eine Substitution vorliegt

In der Resource **MedicationDispense** gibt es das boolesche Element **substitution.wasSubstituted**, das anzeigt, ob bei der Abgabe ein anderes Medikament als das ursprünglich verschriebene verwendet wurde. Ein Wert von true bedeutet, dass eine Substitution stattgefunden hat, während false zeigt, dass das verschriebene Medikament abgegeben wurde.

Im Profil **EPAMedicationDispense** wird der Bereich substitution mit “Must Support” markiert, was bedeutet, dass dieses Element beim Lesen des Datensatzes berücksichtigt und interpretiert werden muss, um sicherzustellen, dass Substitutionen korrekt erfasst werden.

```
{
    "resourceType": "MedicationDispense",
    ...
    "substitution": {
        "wasSubstituted": false
    },
    ...
}

```

#### Verarbeitung des Abgabestatus

In der Resource `MedicationDispense` gibt es das Element `MedicationDispense.status`, das den Bearbeitungsstatus einer Abgabe beschreibt:

* `completed`: Abgeschlossen - Die Abgabe ist final abgeschlossen und quittiert.

```
{
    "resourceType": "MedicationDispense",
    ...
    "status": "completed"
    ...
}

```

### Auslesen der Medikation (Medication)

#### Auslesen der Arzneimittelbezeichnung

Um die Arzneimittelbezeichnung auszulesen, muss das Element **Medication.code.text** aus der **Medication**-Ressourceninstanz verwendet werden. Sollte das **text**-Element nicht vorhanden sein, sollte der Wert aus **Medication.code.coding.display** für das System *http://fhir.de/CodeSystem/ifa/pzn* ausgelesen werden.

> **Wichtig**: Die im Abgabedatensatz referenzierte*Medication*(*MedicationDispense.medicationReference*) hat Vorrang gegenüber der in der*MedicationRequest*referenzierten Medication und sollte für die Darstellung verwendet werden, wenn eine Abgabe durchgeführt wurde. Die*MedicationStatement*, die den jeweiligen Verschreibungs- und Abgabeprozess oder einen Medikationsnachtrag dokumentiert, verweist stets auf die fachlich korrekte*Medication*-Instanz. Die Geschäftslogik des Medication Service stellt durch ein definiertes Regelwerk sicher, dass jederzeit die korrekte Arzneimittelinformation referenziert wird.

Für eine einfache Ausleselogik empfiehlt es sich, die jeweilige*MedicationStatement*-Instanz als zentrale Quelle zu verwenden, da diese bereits die korrekte*Medication*referenziert und somit keine zusätzliche Prüfung zwischen Verschreibung und Abgabe notwendig ist.

**Abbildung:**Ausleselogik für die Arzneimittelbezeichnung
#### Beispiel

```
{
  "resourceType": "Medication",
  "code": {
    "coding": [
      {
        "code": "03852301",
        "system": "http://fhir.de/CodeSystem/ifa/pzn"
      }
    ],
    "text": "Tamoxifen AL 20 Tabletten N1"
  },
 ...
}

```

##### Beispiel ohne code.text

```
{
  "resourceType": "Medication",
  "code": {
    "coding": [
      {
        "code": "03852301",
        "system": "http://fhir.de/CodeSystem/ifa/pzn",
        "display": "TAMOXIFEN AL 20 Tabletten 30 St Tabletten"
      }
    ],
  },
 ...
}

```

#### Auslesen der Pharmazentralnummer (PZN)

Zum Auslesen der Pharmazentralnummer (PZN) muss das Element *Medication.code.coding:pzn* verwendet werden. Dabei ist zu beachten, dass PZN-Codes immer das System *http://fhir.de/CodeSystem/ifa/pzn* nutzen. Wenn dieses System nicht in *Medication.code.coding* angegeben ist, liegt kein PZN-Code vor.

> **Wichtig**: Die im Abgabedatensatz referenzierte*Medication*(*MedicationDispense.medicationReference*) hat Vorrang gegenüber der in der*MedicationRequest*referenzierten Medication und sollte für die Darstellung verwendet werden, wenn eine Abgabe durchgeführt wurde. Die*MedicationStatement*, die den jeweiligen Verschreibungs- und Abgabeprozess oder einen Medikationsnachtrag dokumentiert, verweist stets auf die fachlich korrekte*Medication*-Instanz. Die Geschäftslogik des Medication Service stellt durch ein definiertes Regelwerk sicher, dass jederzeit die korrekte Arzneimittelinformation referenziert wird.

Für eine einfache Ausleselogik empfiehlt es sich, die jeweilige*MedicationStatement*-Instanz als zentrale Quelle zu verwenden, da diese bereits die korrekte*Medication*referenziert und somit keine zusätzliche Prüfung zwischen Verschreibung und Abgabe notwendig ist.

**Abbildung:**Ausleselogik für die Pharmazentralnummer (PZN)
##### Beispiel

```
{
    "resourceType": "Medication",
    ...
    "code": {
        "coding":  [
            {
                "system": "http://fhir.de/CodeSystem/ifa/pzn",
                "code": "08545331",
                "display": "IBU-ratiopharm 800mg akut Schmerztabletten"
            },
            {
                "system": "http://fhir.de/CodeSystem/bfarm/atc",
                "code": "M01AE01",
                "display": "Ibuprofen",
                "version": "2022"
            }
        ]
    },
    ...
}

```

#### Abrufen der Darreichungsform (Form)

Für die Darstellung der Darreichungsform wird das Element *Medication.form.coding* aus der *Medication*-Ressourceninstanz verwendet. Dabei sollte primär der Display Name (*Medication.form.coding.display*) für die Darstellung herangezogen werden. Ist kein Display Name verfügbar, wird der Code (*Medication.form.coding.code*) verwendet.

Falls mehrere Kodierungen in unterschiedlichen Systemen für die Darreichungsform angegeben sind, ist die Kodierung mit dem System *https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM* zu bevorzugen.

> **Wichtig**: Die im Abgabedatensatz referenzierte*Medication*(*MedicationDispense.medicationReference*) hat Vorrang gegenüber der in der*MedicationRequest*referenzierten Medication und sollte für die Darstellung verwendet werden, wenn eine Abgabe durchgeführt wurde. Die*MedicationStatement*, die den jeweiligen Verschreibungs- und Abgabeprozess oder einen Medikationsnachtrag dokumentiert, verweist stets auf die fachlich korrekte*Medication*-Instanz. Die Geschäftslogik des Medication Service stellt durch ein definiertes Regelwerk sicher, dass jederzeit die korrekte Arzneimittelinformation referenziert wird.

Für eine einfache Ausleselogik empfiehlt es sich, die jeweilige*MedicationStatement*-Instanz als zentrale Quelle zu verwenden, da diese bereits die korrekte*Medication*referenziert und somit keine zusätzliche Prüfung zwischen Verschreibung und Abgabe notwendig ist.

**Abbildung:**Ausleselogik für die Darreichungsform
##### Beispiel

```
{
    "resourceType": "Medication",
    ...
    "form": {
        "coding": [
            {
                "display": "Tabletten",
                "code": "TAB",
                "system": "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM"
            }
        ]
    }
    ...
}

```

##### Beispiel ohne “display”

```
{
    "resourceType": "Medication",
    ...
    "form": {
        "coding": [
            {
                "code": "TAB",
                "system": "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM"
            }
        ]
    }
    ...
}

```

##### Beispiel mehrere Codierungen

```
{
    "resourceType": "Medication",
    ...
    "form": {
        "coding":  [
            {
                "system": "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
                "code": "TAB",
                "display": "Tabletten",
            },
            {
                "system": "http://standardterms.edqm.eu",
                "code": "12200",
                "display": "Tablet"
            },
            {
                "system": "http://snomed.info/sct",
                "code": "385055001",
                "display": "Tablet (basic dose form)",
            }
        ]
    },
    ...
}

```

#### Auslesen der Wirkstoffnamen und Wirkstärke

Die Wirkstoffnamen werden über das Element *Medication.ingredient.itemCodeableConcept.text* ausgelesen. Ist das *text*-Element nicht vorhanden, wird stattdessen der Display Name aus *Medication.ingredient.itemCodeableConcept.coding.display* verwendet. Dabei hat das *text*-Element stets Vorrang.

Die Wirkstärke wird über das Element *Medication.ingredient.strength* ausgelesen, das als FHIR *Ratio* modelliert ist. Dieses besteht aus zwei *Quantity*-Elementen: *numerator* und *denominator*. Der *numerator* beschreibt die Menge des Wirkstoffs (z. B. 400 mg), während der *denominator* sich auf die Bezugsmenge bezieht (z. B. 1 ml oder 1 Tablette). Beide enthalten jeweils Werte (*value*) und Einheiten (*unit* oder *code*), die gemeinsam die vollständige Wirkstärke beschreiben – etwa 500 mg pro 1 ml.

> **Wichtig**: Die im Abgabedatensatz referenzierte*Medication*(*MedicationDispense.medicationReference*) hat Vorrang gegenüber der in der*MedicationRequest*referenzierten Medication und sollte für die Darstellung verwendet werden, wenn eine Abgabe durchgeführt wurde. Die*MedicationStatement*, die den jeweiligen Verschreibungs- und Abgabeprozess oder einen Medikationsnachtrag dokumentiert, verweist stets auf die fachlich korrekte*Medication*-Instanz. Die Geschäftslogik des Medication Service stellt durch ein definiertes Regelwerk sicher, dass jederzeit die korrekte Arzneimittelinformation referenziert wird.

Für eine einfache Ausleselogik empfiehlt es sich, die jeweilige*MedicationStatement*-Instanz als zentrale Quelle zu verwenden, da diese bereits die korrekte*Medication*referenziert und somit keine zusätzliche Prüfung zwischen Verschreibung und Abgabe notwendig ist.

**Abbildung:**Ausleselogik für die Wirkstoffnamen und Wirkstärken
#### Beispiel

```
{
    "resourceType": "Medication",
    ...
    "ingredient":[
        {
            "itemCodeableConcept": {
                "text": "Tamoxifen"
            },
            ...
        }
    ],
    ...
}

```

##### Beispiel mit itemCodeableConcept.coding

```
{
  "resourceType": "Medication",
  ...
  "ingredient": [
    {
      "itemCodeableConcept": {
        "coding": [
          {
            "code": "387207008",
            "system": "http://snomed.info/sct",
            "display": "Ibuprofen (substance)"
          }
        ]
      },
      ...
    }
  ]
}

```

##### Beispiel mit Medication.ingredient.strength

```
{
    "resourceType": "Medication",
    ...
    "ingredient":
    [
        {
            "itemCodeableConcept":
            {
                "coding":
                [
                    {
                        "code": "387207008",
                        "system": "http://snomed.info/sct",
                        "display": "Ibuprofen (substance)"
                    }
                ],
                "text": "Ibuprofen"
            },
            "strength":
            {
                "numerator":
                {
                    "value": 400,
                    "code": "mg",
                    "system": "http://unitsofmeasure.org",
                },
                "denominator":
                {
                    "value": 1,
                    "unit": "Tbl."
                }
            }
        }
    ]
}

```

#### Auslesen der Wirkstoffe mit PZN-Arzneimitteln (Medication-Instanz) als Zutaten (Ingredients)

Die Arzneimittelbezeichnung und die PZN werden aus der referenzierten **Medication**-Instanz im **contained**-Element ausgelesen (*Medication.contained*), die über das Element *Medication.ingredient.itemReference.reference* angegeben ist.

Die Arzneimittelbezeichnung wird zuerst über das Element *Medication.code.text* extrahiert. Ist das **text**-Element nicht vorhanden, wird stattdessen der Display Name aus *Medication.code.coding.display* verwendet. Dabei hat das *text*-Element stets Vorrang.

Die PZN wird aus dem Element *Medication.code.coding* extrahiert. Hierbei wird die Kodierung mit dem System *http://fhir.de/CodeSystem/ifa/pzn* verwendet. Der Wert wird aus *Medication.code.coding.code* entnommen und stellt die Pharmazentralnummer (PZN) dar.

**Abbildung:**Ausleselogik für die PZN-Arzneimittel-Wirkstoffe und Wirkstärken (Medication-Instanz)
##### Beispiel für eine Medication mit Wirkstoffen als PZN-Arzneimittel

```
{
  "resourceType": "Medication",
  ...
  "form": {
    "coding": [
      {
        "system": "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_DARREICHUNGSFORM",
        "code": "SAL",
        "display": "Salbe"
      }
    ]
  },
  "contained": [
    {
      "resourceType": "Medication",
      "id": "MedicationHydrocortison",
      "meta": {
        "profile": [
          "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pzn-ingredient"
        ]
      },
      "extension": [
        {
          "url": "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
          "valueCoding": {
            "code": "781405001",
            "system": "http://snomed.info/sct",
            "display": "Medicinal product package (product)"
          }
        }
      ],
      "code": {
        "coding": [
          {
            "system": "http://fhir.de/CodeSystem/ifa/pzn",
            "code": "03424249",
            "display": "Hydrocortison 1% Creme"
          }
        ]
      },
      "batch": {
        "lotNumber": "56498416854"
      }
    },
    {
      "resourceType": "Medication",
      "id": "MedicationDexpanthenol",
      "meta": {
        "profile": [
          "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-pzn-ingredient"
        ]
      },
      "extension": [
        {
          "url": "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-type-extension",
          "valueCoding": {
            "code": "781405001",
            "system": "http://snomed.info/sct",
            "display": "Medicinal product package (product)"
          }
        }
      ],
      "code": {
        "coding": [
          {
            "system": "http://fhir.de/CodeSystem/ifa/pzn",
            "code": "16667195",
            "display": "Dexpanthenol 5% Creme"
          }
        ]
      },
      "batch": {
        "lotNumber": "0132456"
      }
    }
  ],
  "code": {
    "text": "Hydrocortison-Dexpanthenol-Salbe"
  },
  "ingredient": [
    {
      "itemReference": {
        "reference": "#MedicationHydrocortison"
      },
      "isActive": true,
      "strength": {
        "numerator": {
          "value": 50,
          "system": "http://unitsofmeasure.org",
          "code": "g",
          "unit": "g"
        },
        "denominator": {
          "value": 100,
          "system": "http://unitsofmeasure.org",
          "code": "g",
          "unit": "g"
        }
      }
    },
    {
      "itemReference": {
        "reference": "#MedicationDexpanthenol"
      },
      "isActive": true,
      "strength": {
        "numerator": {
          "value": 50,
          "system": "http://unitsofmeasure.org",
          "code": "g",
          "unit": "g"
        },
        "denominator": {
          "value": 100,
          "system": "http://unitsofmeasure.org",
          "code": "g",
          "unit": "g"
        }
      }
    }
  ]
}

```

### Auslesen der Medikationsinformation (MedicationStatement)

#### Kennzeichnung des Ursprungs von Medikationsinformationen

Um die Herkunft einer Medikationsinformation (**MedicationStatement**) innerhalb der eML zu identifizieren, wird im **EPAMedicationStatement**-Profil eine Extension verwendet. Diese gibt an, ob es sich bei dem jeweiligen **MedicationStatement** um eine Information aus dem Verschreibungs- und Abgabeprozess oder um einen nachträglich hinzugefügten Eintrag handelt.

Die Extension: `https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension

Es werden zwei mögliche Werte unterschieden:

* **PRESCRIPTION**: Die Medikationsinformation stammt aus dem E-Rezept-Prozess, also aus der Verschreibung oder Abgabe.
* **MANUAL**: Die Medikationsinformation wurde nachträglich manuell hinzugefügt (Nachtrag).

##### Beispiel für eine MedicationStatement-Instanz mit einem Nachtrag

```
{
  "resourceType": "MedicationStatement",
  "id": "35017f05-ce62-4aa4-95ed-99c2fe0be22e",
  "meta": {
    "profile": [
      "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-medication-statement"
    ]
  },
  "extension": [
    {
      "url": "https://gematik.de/fhir/epa-medication/StructureDefinition/context-extension",
      "valueCode": "MANUAL"
    }
  ],
  ...
}


```

#### Verwendung von MedicationStatement.derivedFrom

Das Element **derivedFrom** der FHIR-Resource **MedicationStatement** dient im ePA Medication Service dazu, die Herkunft der Medikationsinformation nachzuvollziehen. Es stellt eine Referenz auf die ursprünglichen FHIR-Ressourceninstanzen dar, aus denen das **MedicationStatement** abgeleitet wurde.

Bei Medikationsinformationen aus dem Verschreibungs- und Abgabeprozess verweist **derivedFrom** auf die zugehörigen Instanzen:

* **MedicationRequest**: enthält die ursprüngliche Verschreibungsinformation.
* **MedicationDispense**: enthält die Daten zur Abgabe durch die Apotheke.

Damit wird transparent dokumentiert, aus welchen Quelldaten die Medikationsinformation in der eML entstanden ist. Bei nachträglich manuell erfassten Medikationsinformationen (Nachträgen) enthält **derivedFrom** keine Referenzen, da diese nicht aus einer Verschreibung oder Abgabe abgeleitet sind.

##### Beispielhafte Struktur

```
"derivedFrom": [
  {
    "reference": "MedicationRequest/de2245cb-91e4-45a6-a0ec-cae2e4297787"
  },
  {
    "reference": "MedicationDispense/4192d9a4-3762-4be7-b911-68b5f1b46413"
  }
]


```

#### Verwendung von MedicationStatement.dateAsserted

Das Element **dateAsserted** der FHIR-Resource **MedicationStatement** gibt an, wann die jeweilige Medikationsinformation vom verantwortlichen Leistungserbringerinstitution im Medication Service dokumentiert wurde. Dieses Datum beschreibt den Zeitpunkt, zu dem die Information in die elektronische Medikationsliste (eML) eingestellt oder zuletzt geändert wurde. Es handelt sich nicht um den Zeitpunkt der Verschreibung, Abgabe oder Einnahme, sondern um den Zeitpunkt der Dokumentation bzw. der Übermittlung an den Medication Service.

#### Zeitliche Einordnung einer Medikationsinformation

Das Element **effectiveDateTime** oder **effectivePeriod** der FHIR-Resource **MedicationStatement** beschreibt wann eine Medikationsinformation gültig ist bzw. war. Im ePA Medication Service wird hierfür der Typ dateTime verwendet und gibt an (ab) wann eine Medikation gilt bzw. gegolten hat.

Verarbeitungsregeln im ePA Medication Service:

* Es kann vorkommen, dass: 
* **effectiveDateTime** gesetzt ist (z. B. bei bekannter zeitlicher Information über die Medikationen),
* **effectivePeriod** mit **start** und **end** gesetzt ist (z. B. wenn Beginn und Ende der Medikation bekannt sind),
* **effectivePeriod** nur mit **start** gesetzt ist (z. B. wenn lediglich der Beginn der Medikation bekannt ist),
* oder das Element nicht befüllt ist (z. B. wenn zeitliche Informationen nicht dokumentiert wurden).
 
* Bei Medikationsinformationen aus dem Verschreibungs- oder Abgabeprozess wird das Verschreibungsdatum als **effectivePeriod.start** Wert übernommen.
* Bei Nachträgen werden die Zeitangaben durch den erfassenden Leistungserbringer angegeben – sofern diese bekannt sind.

##### Beispielhafte Struktur:

```
"effectiveDateTime": "2026-08-01"

```

```
"effectivePeriod": {
  "start": "2025-05-29"
},

```

```
"effectivePeriod": {
  "start": "2025-05-29",
  "end": "2025-08-21"
},

```

### Auslesen von effectiveDosePeriod eines eMP-Eintrags

Die Extension **effectiveDosePeriod** beschreibt den Zeitraum, über den eine Medikation eingenommen werden soll. Für das Auslesen durch Primärsysteme gilt: Der Beginn des Zeitraums entspricht dem frühesten Startdatum aller im eMP-Eintrag vorhandenen Dosierungsanweisungen. Das Ende des Zeitraums entspricht dem spätesten Enddatum aller Dosierungsanweisungen, sofern in jeder Anweisung ein Enddatum angegeben ist. Ist nur ein Startdatum vorhanden, ohne dass ein Enddatum für alle Anweisungen vorliegt, bleibt das Enddatum leer, sodass lediglich ein Beginn (ab Startdatum) dargestellt wird.

Damit liefert **effectiveDosePeriod** eine konsolidierte Sicht auf die zeitliche Gültigkeit der Dosierungsangaben, ersetzt aber nicht die detaillierte Darstellung der einzelnen Dosierungszeilen. In der Benutzeroberfläche soll daher der Zeitraum aus der Extension als Rahmeninformation angezeigt werden, während die Dosierungsdetails weiterhin aus den jeweiligen **dosageInstruction**-Elementen hervorgehen.

#### Beispielhafte Struktur:

```
{
  "resourceType": "MedicationRequest",
  "extension": [
    {
      "valuePeriod": {
        "start": "2027-02-01"
      },
      "url": "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod"
    }
  ],
  ...
}

```

```
{
  "resourceType": "MedicationRequest",
  "extension": [
    {
      "valuePeriod": {
        "start": "2026-02-01",
        "end": "2026-02-20"
      },
      "url": "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationRequest.effectiveDosePeriod"
    }
  ],
  ...
}

```

### Auslesen der Patienteninformationen

Die Patienteninformationen werden aus der **Patient**-Ressource gemäß dem Profil `https://gematik.de/fhir/epa/StructureDefinition/epa-patient` extrahiert. Dieses Profil basiert auf dem TI-Common **TIPatient** und ergänzt insbesondere Mindestvorgaben für Identifier.

#### Name

Der aktuelle Name der versicherten Person wird aus dem Slice `Patient.name:Name` entnommen. Dieser ist durch das Element `use = official` gekennzeichnet. Für die Darstellung werden folgende Bestandteile verwendet:

* Titel oder akademische Grade aus dem Element `prefix`
* Vornamen aus dem Element `given`
* Nachname aus dem Element `family` 
* Namenszusätze wie Gräfin, Prinz oder Fürst über die Extension `http://fhir.de/StructureDefinition/humanname-namenszusatz` am Element `family`
* Vorsatzwörter (z. B. von, zu) über die Extension `http://hl7.org/fhir/StructureDefinition/humanname-own-prefix` am Element `family`
* Strukturierter Nachname über die Extension `http://hl7.org/fhir/StructureDefinition/humanname-own-name"` am Element `family`
 

Das Auslesen kann durch Kombination der Bestandteile in folgender Reihenfolge erfolgen: `prefix`, `given[]`, `namenszusatz`, `vorsatzwort`, `family`. Erweiterungen wie `nachname` können zur strukturierten Darstellung verwendet werden, beeinflussen aber nicht zwingend die Darstellung des angezeigten Nachnamens.

Wenn das zusammengesetzte Textfeld `name.text` vorhanden ist, kann dieses vorrangig verwendet werden. Es enthält eine vollständig formatierte Namensdarstellung, die vom System zur Anzeige aufbereitet wurde. Fehlt dieses Feld, erfolgt die Darstellung durch Kombination der oben genannten Bestandteile.

#### Geburtsname

Der Geburtsname wird aus dem Slice `Patient.name:Geburtsname` extrahiert. Dieser ist durch das Element `use = maiden` gekennzeichnet. Laut Profil dürfen in diesem Slice ausschließlich Angaben zum Nachnamen gemacht werden. Die folgenden Bestandteile werden berücksichtigt:

* Nachname aus dem Element `family`
* Namenszusatz, Vorsatzwort und strukturierter Nachname als Erweiterungen, analog zum aktuellen Namen

Angaben zu `given`, `prefix` und `suffix` sind laut Profil ausgeschlossen (max = 0) und werden bei der Verarbeitung ignoriert.

#### Geburtsdatum

Das Geburtsdatum wird aus dem Element `birthDate` übernommen. Der Wert liegt im ISO-Format (JJJJ-MM-TT) vor und wird zur Anzeige in das Format TT.MM.JJJJ konvertiert.

#### Krankenversichertennummer (KVNR)

Die Krankenversichertennummer wird aus dem Identifier mit dem Slice `KVNR` entnommen. Dieser ist Bestandteil des `identifier`-Arrays und über das System `http://fhir.de/sid/gkv/kvid-10` sowie das zugehörige Profil `http://fhir.de/StructureDefinition/identifier-kvid-10` eindeutig identifizierbar. Der darzustellende Wert befindet sich im `value`-Element dieses Identifiers.

##### Beispiel 1

```
{
  "resourceType" : "Patient",
  "id" : "df6f1d2a-f647-4d10-b898-7300e568c2f4",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa/StructureDefinition/epa-patient"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "G995030566"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "Gundlach",
      "given" : [
        "Monika"
      ],
      "prefix" : [
        "Dr."
      ],
      "_prefix" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier",
              "valueCode" : "AC"
            }
          ]
        }
      ]
    },
    {
      "use" : "maiden",
      "family" : "Blohm",
      "_family" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-name",
            "valueString" : "Blohm"
          }
        ]
      }
    }
  ],
  "gender" : "female",
  "birthDate" : "1954-02-27"
}


```

##### Beispiel 2

```
{
  "resourceType": "Patient",
  "id" : "45ac917c-2206-46ee-b241-a398de9d0b68",
  "meta" : {
    "profile" : [
      "https://gematik.de/fhir/epa/StructureDefinition/epa-patient"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.de/sid/gkv/kvid-10",
      "value" : "G995030333"
    }
  ],
  "name": [
    {
      "use": "official",
      "text": "Prof. Dr. med. Dr. rer. nat. Fritz Julius Karl Freiherr von und zu Rathenburg vor der Isar, MdB",
      "family": "Freiherr von und zu Rathenburg vor der Isar",
      "_family": {
        "extension": [
          {
            "url": "http://fhir.de/StructureDefinition/humanname-namenszusatz",
            "valueString": "Freiherr"
          },
          {
            "url": "http://hl7.org/fhir/StructureDefinition/humanname-own-prefix",
            "valueString": "von und zu"
          },
          {
            "url": "http://hl7.org/fhir/StructureDefinition/humanname-own-name",
            "valueString": "Rathenburg vor der Isar"
          }
        ]
      },
      "given": [
        "Fritz",
        "Julius",
        "Karl"
      ],
      "prefix": [
        "Prof. Dr. med. Dr. rer. nat."
      ],
      "_prefix": [
        {
          "extension": [
            {
              "url": "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier",
              "valueCode": "AC"
            }
          ]
        }
      ],
      "suffix": [
        "MdB"
      ]
    }
  ],
  "gender" : "male",
  "birthDate" : "1964-02-14"
}

```

