# de.gematik.epa.medication#1.3.0: Implementation Guide ePA Medication Service

## Pages

* [Home](index.md)
* [Steckbriefe](spec-sheet.md)
* [Operation API: eMP-Eintrag aktualisieren](op-update-emp-entry.md)
* [FHIR-Artefakte](artifacts.md)
* [dgMP-Szenarien](dgmp-scenarios.md)
* [Operation API](operation-api.md)
* [Query API: MedicationStatement (Medikationsinformation)](query-api-medicationstatement.md)
* [Release Notes](release-notes.md)
* [Referenzen](referenced.md)
* [Operation API: eMP Chronologie abrufen](op-medication-plan-log.md)
* [Query API: Practitioner (Leistungserbringer)](query-api-practitioner.md)
* [Render API: Medikationsliste abrufen (eML)](render-api-eml.md)
* [Query API](query-api.md)
* [Steckbrief: E-Rezept-Fachdienst](actor-erp-fd.md)
* [Operation API: Dispensierinformationen einstellen](op-provide-dispensation-erp.md)
* [Operation API: Medikationsliste abrufen (eML)](op-get-medication-list.md)
* [Apache License](license.md)
* [Steckbrief: E-Rezept PS](actor-erp-ps.md)
* [Technische Anwendungsfälle](technical-use-cases.md)
* [Render API](render-api.md)
* [Query API: Provenance (Änderungseintrag, eMP-Chronologieeintrag)](query-api-provenance.md)
* [Operation API: Verschreibungsdaten einstellen](op-provide-prescription-erp.md)
* [Operation API: Hinzufügen einer eML-eMP-Verknüpfung](op-link-emp.md)
* [Operation API: Entfernen einer eML-eMP-Verknüpfung](op-unlink-emp.md)
* [Versionsvergleiche](comparisons.md)
* [Downloads](downloads.md)
* [Steckbrief: ePA Medication Service](actor-medication.md)
* [Steckbrief: ePA PS / ePA-Client-Systeme / ePA-FdV](actor-client.md)
* [OpenAPI: Medication Service](medication-openapi.md)
* [Render API: Medikationsplan abrufen (eMP)](render-api-emp.md)
* [Query API: Medication (Medikation, eMP-Medikation)](query-api-medication.md)
* [Query API: Organization (Leistungserbringerinstitution)](query-api-organization.md)
* [Datenschutz und Sicherheit](privacy-security.md)
* [Operation API: Verschreibungsdaten stornieren](op-cancel-prescription-erp.md)
* [Operation API: eML-Eintrag stornieren](op-cancel-eml-entry.md)
* [Operation API: eMP commit](op-emp-commit.md)
* [Operation API: Medikationsplan abrufen (eMP)](op-get-medication-plan.md)
* [Operation API: eMP-Eintrag hinzufügen](op-add-emp-entry.md)
* [Verarbeitungsregeln](processing-rules.md)
* [eMP Beispiel](emp-example.md)
* [Migrationsvorgaben](migration.md)
* [Darstellung von Dosierungsinformationen](dosage-examples.md)
* [Generelle Prinzipien](general-principles.md)
* [Query API: MedicationRequest (Verschreibung, eMP-Eintrag)](query-api-medicationrequest.md)
* [Operation API: Dispensierung stornieren](op-cancel-dispensation-erp.md)
* [Query API: PractitionerRole](query-api-practitioner-role.md)
* [Operation API: eML-Eintrag hinzufügen](op-add-eml-entry.md)
* [Überblick zum digital gestützten Medikationsprozess](dgmp-overview.md)
* [dgMP-Anwendungsfälle](dgmp-use-cases.md)
* [eMP Layout der Blöcke](emp-block-layout.md)
* [Query API: MedicationDispense (Abgabe)](query-api-medicationdispense.md)
* [Operation API: Batch eMP-Einträge](op-batch-emp.md)

## Resources

### CodeSystems

* [Context Codes](CodeSystem-context-code.md)
* [EPA MedicationStatement Processing Codes](CodeSystem-epa-medicationstatement-processing-event-code.md)
* [EPA Medication Service OperationOutcome Code System](CodeSystem-epa-ms-operation-outcome-details.md)

### ValueSets

* [Context Codes](ValueSet-context-code.md)
* [eMP MedicationRequest Status Value Set](ValueSet-emp-medicationrequest-status-vs.md)
* [ePA MedicationStatement Status Value Set](ValueSet-epa-medication-statement-status-vs.md)
* [ePA MedicationStatement Context Codes](ValueSet-epa-medicationstatement-context-code.md)
* [EPA MedicationStatement Processing Codes](ValueSet-epa-medicationstatement-processing-event-code.md)
* [EPA Medication Service Operation Outcome ValueSet](ValueSet-epa-ms-operation-outcome-details.md)
* [EPA Statuswerte Dispensierinformationen einstellen (E-Rezept-Fachdienst)](ValueSet-epa-provide-dispensation-status-vs.md)

### Complex-type Profiles

* [Medication Unique Identifier](StructureDefinition-epa-medication-unique-identifier.md)
* [RxOriginatorProcessIdentifier](StructureDefinition-rx-originator-process-identifier.md)
* [RxPrescriptionProcessIdentifier](StructureDefinition-rx-prescription-process-identifier.md)

### Resource Profiles

* [eMP Chronology Provenance](StructureDefinition-emp-chronology-provenance.md)
* [eMP MedicationRequest](StructureDefinition-emp-medication-request.md)
* [eMP Medication](StructureDefinition-emp-medication.md)
* [Batch API eMP-Einträge - Request-Bundle](StructureDefinition-epa-batch-emp-request-bundle.md)
* [EPA MedicationDispense](StructureDefinition-epa-medication-dispense.md)
* [EPA Pharmaceutical Product Medication](StructureDefinition-epa-medication-pharmaceutical-product.md)
* [EPA Medication PZN Ingredient](StructureDefinition-epa-medication-pzn-ingredient.md)
* [EPA MedicationRequest](StructureDefinition-epa-medication-request.md)
* [EPA MedicationStatement](StructureDefinition-epa-medication-statement.md)
* [EPA Medication](StructureDefinition-epa-medication.md)
* [EPA Medication Service Operation Outcome](StructureDefinition-epa-ms-operation-outcome.md)
* [EPA Operation addEMLEntry Input-Parameters](StructureDefinition-epa-op-add-eml-entry-input-parameters.md)
* [EPA Operation addEMPEntry Input-Parameters](StructureDefinition-epa-op-add-emp-entry-input-parameters.md)
* [EPA Operation CancelDispensation ERP Input-Parameters](StructureDefinition-epa-op-cancel-dispensation-erp-input-parameters.md)
* [EPA Operation CancelPrescription ERP Input-Parameters](StructureDefinition-epa-op-cancel-prescription-erp-input-parameters.md)
* [EPA Operation EMLEntry Output-Parameters](StructureDefinition-epa-op-eml-entry-output-parameters.md)
* [EPA Operation EMPEntry Output-Parameters](StructureDefinition-epa-op-emp-entry-output-parameters.md)
* [EPA Operation Link eMP Output Parameters](StructureDefinition-epa-op-link-emp-entry-output-parameters.md)
* [EPA Operation Link eMP Parameters](StructureDefinition-epa-op-link-emp-entry-parameters.md)
* [EPA Operation ProvideDispensation ERP Input-Parameters](StructureDefinition-epa-op-provide-dispensation-erp-input-parameters.md)
* [EPA Operation ProvidePrescription ERP Input-Parameters](StructureDefinition-epa-op-provide-prescription-erp-input-parameters.md)
* [EPA eMP Commit Operation Input-Parameters](StructureDefinition-epa-op-rmp-commit-input-parameters.md)
* [EPA Operation RxDispensation ERP Output-Parameters](StructureDefinition-epa-op-rx-dispensation-erp-output-parameters.md)
* [EPA Operation RxPrescription ERP Output-Parameters](StructureDefinition-epa-op-rx-prescription-erp-output-parameters.md)
* [EPA Operation UpdateEMPEntry Input-Parameters](StructureDefinition-epa-op-update-emp-entry-input-parameters.md)

### Extensions

* [ContextExtension](StructureDefinition-context-extension.md)
* [DrugCategoryExtension](StructureDefinition-drug-category-extension.md)
* [EMPMedicationRequestActitvityExtension](StructureDefinition-emp-medicationrequest-activity-extension.md)
* [Origin Medication Reference (eMP)](StructureDefinition-emp-origin-medication-extension.md)
* [Medication Type](StructureDefinition-epa-medication-type-extension.md)
* [EPAMedicationStatementProcessingEventExtension](StructureDefinition-epa-medicationstatement-processing-event-extension.md)
* [IndicatorBVGExtension](StructureDefinition-indicator-bvg-extension.md)
* [IndicatorSERExtension](StructureDefinition-indicator-ser-extension.md)
* [IsEMPChronologyExtension](StructureDefinition-is-emp-chronology-extension.md)
* [IsEMPExtension](StructureDefinition-is-emp-extension.md)
* [MedicationFormulationPackagingExtension](StructureDefinition-medication-formulation-packaging-extension.md)
* [MedicationIsVaccineExtension](StructureDefinition-medication-id-vaccine-extension.md)
* [MedicationIngredientAmountExtensions](StructureDefinition-medication-ingredient-amount-extension.md)
* [MedicationIngredientDarreichungsformExtension](StructureDefinition-medication-ingredient-darreichungsform-extension.md)
* [MedicationManufacturingInstructionsExtension](StructureDefinition-medication-manufacturing-instructions-extension.md)
* [MedicationPackagingSizeExtension](StructureDefinition-medication-packaging-size-extension.md)
* [MedicationTotalQuantityFormulationExtension](StructureDefinition-medication-total-quantity-formulation-extension.md)
* [MultiplePrescription](StructureDefinition-multiple-prescription-extension.md)
* [NarcoticsExtension](StructureDefinition-narcotics-extension.md)
* [PatientIDExtension](StructureDefinition-patient-id-extension.md)
* [PatientNoteExtension](StructureDefinition-patient-note-extension.md)
* [PrescriberIDExtension](StructureDefinition-prescriber-id-extension.md)
* [ReasonPatientInstructionExtension](StructureDefinition-reason-patient-instruction-extension.md)
* [RxPrescriptionProcessIdentifierExtension](StructureDefinition-rx-prescription-process-identifier-extension.md)
* [TeratogenicExtension](StructureDefinition-teratogenic-extension.md)

### CapabilityStatements

* [EPA Capability Statement für Clients des ePA Medication Service](CapabilityStatement-epa-medication-service-client.md)
* [EPA CapabilityStatement für den Medication Service](CapabilityStatement-epa-medication-service-server.md)

### ImplementationGuides

* [Implementation Guide ePA Medication Service](index.md)

### OperationDefinitions

* [Add Medication List Entry](OperationDefinition-add-eml-entry-op.md)
* [eMP-Eintrag hinzufügen](OperationDefinition-add-emp-entry-op.md)
* [Batch eMP Einträge](OperationDefinition-batch-emp-entries-op.md)
* [Cancel Dispensation eRP](OperationDefinition-cancel-dispensation-erp-OP.md)
* [Cancel Medication List Entry](OperationDefinition-cancel-eml-entry-op.md)
* [Cancel Prescription eRP](OperationDefinition-cancel-prescription-erp-OP.md)
* [eMP Commit Operation](OperationDefinition-emp-commit-op.md)
* [Get Medication List](OperationDefinition-get-medication-list-op.md)
* [Get Medication Plan (eMP)](OperationDefinition-get-medication-plan-op.md)
* [eMP-Eintrag verknüpfen](OperationDefinition-link-emp-op.md)
* [Medication Plan Chronology Log](OperationDefinition-medication-plan-log-op.md)
* [Provide Dispensation eRP](OperationDefinition-provide-dispensation-erp-OP.md)
* [Provide Prescription eRP](OperationDefinition-provide-prescription-erp-OP.md)
* [eMP-Verknüpfung entfernen](OperationDefinition-unlink-emp-op.md)
* [eMP-Eintrag aktualisieren](OperationDefinition-update-emp-entry-op.md)

### SearchParameters

* [IsEMPSP](SearchParameter-based-on-emp-sp.md)
* [ContextSP](SearchParameter-context-sp.md)
* [DerivedFromSP](SearchParameter-derived-from-sp.md)
* [IsEMPChronologySP](SearchParameter-is-emp-chronology-sp.md)
* [MedicationRequestActivitySP](SearchParameter-medication-statement-activity-sp.md)
* [MedicationRequestEffectiveDosePeriodSP](SearchParameter-medicationrequest-effective-dose-period-sp.md)
* [ProvenanceAgentIdentifierSP](SearchParameter-provenance-agent-identifier-sp.md)
* [RxPrescriptionProcessParameter](SearchParameter-rx-prescription-process-sp.md)

### Examples

* [example-epa-batch-emp-request-bundle (Bundle)](Bundle-example-epa-batch-emp-request-bundle.md)
* [example-epa-batch-emp-response-bundle (Bundle)](Bundle-example-epa-batch-emp-response-bundle.md)
* [example-get-medication-list-bundle1 (Bundle)](Bundle-example-get-medication-list-bundle1.md)
* [example-get-medication-plan-bundle-1 (Bundle)](Bundle-example-get-medication-plan-bundle-1.md)
* [example-searchset-medication (Bundle)](Bundle-example-searchset-medication.md)
* [example-searchset-medicationdispense (Bundle)](Bundle-example-searchset-medicationdispense.md)
* [example-searchset-medicationrequest (Bundle)](Bundle-example-searchset-medicationrequest.md)
* [example-searchset-medicationstatement (Bundle)](Bundle-example-searchset-medicationstatement.md)
* [medication-plan-chronology-log-bundle (Bundle)](Bundle-medication-plan-chronology-log-bundle.md)
* [1254591a-dd2d-4d17-b8f8-ee3155da0699 (Medication)](Medication-1254591a-dd2d-4d17-b8f8-ee3155da0699.md)
* [13c66845-d0ce-43e1-9b0b-884cbbe8df7f (Medication)](Medication-13c66845-d0ce-43e1-9b0b-884cbbe8df7f.md)
* [1412aa4f-a9ed-45f2-8916-063fee7eb025 (Medication)](Medication-1412aa4f-a9ed-45f2-8916-063fee7eb025.md)
* [19549515-60a8-4e1c-b86a-49518053fe9f (Medication)](Medication-19549515-60a8-4e1c-b86a-49518053fe9f.md)
* [2571d29b-e213-40ec-b817-a1490718f491 (Medication)](Medication-2571d29b-e213-40ec-b817-a1490718f491.md)
* [312d581c-f5e7-4faa-9de5-c4e1568c6db2 (Medication)](Medication-312d581c-f5e7-4faa-9de5-c4e1568c6db2.md)
* [3f0b0cb0-e8cf-4aaf-bad8-01a51619417b (Medication)](Medication-3f0b0cb0-e8cf-4aaf-bad8-01a51619417b.md)
* [4B5557E5-4900-47FE-A8D9-407611E05BD2 (Medication)](Medication-4B5557E5-4900-47FE-A8D9-407611E05BD2.md)
* [56ca34f1-a3f3-42f7-95a2-f5a6423c2031 (Medication)](Medication-56ca34f1-a3f3-42f7-95a2-f5a6423c2031.md)
* [659c0be1-2ec8-4137-9698-dcffee811934 (Medication)](Medication-659c0be1-2ec8-4137-9698-dcffee811934.md)
* [83d7ad1c-47d1-4524-829a-5b86ce333bbc (Medication)](Medication-83d7ad1c-47d1-4524-829a-5b86ce333bbc.md)
* [87f08ba2-da7e-467e-86aa-404d9035297c (Medication)](Medication-87f08ba2-da7e-467e-86aa-404d9035297c.md)
* [CortisonDexpantenol (Medication)](Medication-CortisonDexpantenol.md)
* [Technical-Exp-EPAMedicationMax (Medication)](Medication-Technical-Exp-EPAMedicationMax.md)
* [Technical-Exp-NachtragEmlMedication (Medication)](Medication-Technical-Exp-NachtragEmlMedication.md)
* [Technical-Exp-NachtragEmpMedicationEml (Medication)](Medication-Technical-Exp-NachtragEmpMedicationEml.md)
* [Technical-Exp-NachtragEmpMedicationEmp (Medication)](Medication-Technical-Exp-NachtragEmpMedicationEmp.md)
* [a2aa2baf-c37d-40e0-bff5-f6e8a58dc2c3 (Medication)](Medication-a2aa2baf-c37d-40e0-bff5-f6e8a58dc2c3.md)
* [ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e (Medication)](Medication-ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e.md)
* [bb91cde8-0426-4f4b-a766-5d818d0605bd (Medication)](Medication-bb91cde8-0426-4f4b-a766-5d818d0605bd.md)
* [deecd514-235d-41df-a664-e3672208f410 (Medication)](Medication-deecd514-235d-41df-a664-e3672208f410.md)
* [ef5d5baf-0c42-4240-9604-7fba9cea926d (Medication)](Medication-ef5d5baf-0c42-4240-9604-7fba9cea926d.md)
* [fc7b28e8-05ac-4ac8-86d7-7677d9c6134e (Medication)](Medication-fc7b28e8-05ac-4ac8-86d7-7677d9c6134e.md)
* [3c10c1ad-1d7a-47e8-abab-00b8299b49b8 (MedicationDispense)](MedicationDispense-3c10c1ad-1d7a-47e8-abab-00b8299b49b8.md)
* [4e6e1623-778e-44a3-b208-8479f5339e43 (MedicationDispense)](MedicationDispense-4e6e1623-778e-44a3-b208-8479f5339e43.md)
* [5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad (MedicationDispense)](MedicationDispense-5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad.md)
* [6250569a-3505-4db7-aebc-45dba1f98acc (MedicationDispense)](MedicationDispense-6250569a-3505-4db7-aebc-45dba1f98acc.md)
* [b2911d1e-fc63-47bb-8887-63b701bc49c4 (MedicationDispense)](MedicationDispense-b2911d1e-fc63-47bb-8887-63b701bc49c4.md)
* [c0b553bd-2542-49d7-b5e1-0a770185e39f (MedicationDispense)](MedicationDispense-c0b553bd-2542-49d7-b5e1-0a770185e39f.md)
* [c3a353f0-c61a-4d6b-affa-daf8c0f6e77c (MedicationDispense)](MedicationDispense-c3a353f0-c61a-4d6b-affa-daf8c0f6e77c.md)
* [f7240e05-01a1-4ce6-a8bb-edb71b6b5104 (MedicationDispense)](MedicationDispense-f7240e05-01a1-4ce6-a8bb-edb71b6b5104.md)
* [fa0c29e1-c4e7-4f08-91ab-598a2233867c (MedicationDispense)](MedicationDispense-fa0c29e1-c4e7-4f08-91ab-598a2233867c.md)
* [0435e19e-ed9a-4b5b-a9e9-70924c5922a0 (MedicationRequest)](MedicationRequest-0435e19e-ed9a-4b5b-a9e9-70924c5922a0.md)
* [08cb8487-2758-406c-999a-e23a05e63c0b (MedicationRequest)](MedicationRequest-08cb8487-2758-406c-999a-e23a05e63c0b.md)
* [0e7f16e4-d879-4a2c-8292-41c55201bbdd (MedicationRequest)](MedicationRequest-0e7f16e4-d879-4a2c-8292-41c55201bbdd.md)
* [266620a9-2c26-41c1-b0cb-a10947b867f5 (MedicationRequest)](MedicationRequest-266620a9-2c26-41c1-b0cb-a10947b867f5.md)
* [2a794a78-8a72-46ca-bb81-09f702f94e11 (MedicationRequest)](MedicationRequest-2a794a78-8a72-46ca-bb81-09f702f94e11.md)
* [3191d752-3adf-4c7f-848d-8d43766fed72 (MedicationRequest)](MedicationRequest-3191d752-3adf-4c7f-848d-8d43766fed72.md)
* [3ffb5c34-81e7-45ec-842c-82a2422cb8c8 (MedicationRequest)](MedicationRequest-3ffb5c34-81e7-45ec-842c-82a2422cb8c8.md)
* [40df19aa-40e2-4ebc-a11d-9d232dcb0f67 (MedicationRequest)](MedicationRequest-40df19aa-40e2-4ebc-a11d-9d232dcb0f67.md)
* [4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8 (MedicationRequest)](MedicationRequest-4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8.md)
* [6461edff-13ec-4dc7-b9f3-aea66bcb0643 (MedicationRequest)](MedicationRequest-6461edff-13ec-4dc7-b9f3-aea66bcb0643.md)
* [71b66f1b-8032-4886-b7bf-e775daee22fb (MedicationRequest)](MedicationRequest-71b66f1b-8032-4886-b7bf-e775daee22fb.md)
* [7efae80a-a4d9-4e26-a1b9-92c72e79cfaa (MedicationRequest)](MedicationRequest-7efae80a-a4d9-4e26-a1b9-92c72e79cfaa.md)
* [Technical-Exp-NachtragEmpMedicationRequestEmp (MedicationRequest)](MedicationRequest-Technical-Exp-NachtragEmpMedicationRequestEmp.md)
* [ed2eeb8c-9ab6-4f4f-be9d-7e1a3784045e (MedicationRequest)](MedicationRequest-ed2eeb8c-9ab6-4f4f-be9d-7e1a3784045e.md)
* [f14498f0-4932-490a-91a2-9de8616e133b (MedicationRequest)](MedicationRequest-f14498f0-4932-490a-91a2-9de8616e133b.md)
* [f6b1d9ab-4ff0-405e-8d2d-7a181d9fdbdd (MedicationRequest)](MedicationRequest-f6b1d9ab-4ff0-405e-8d2d-7a181d9fdbdd.md)
* [0fc1f006-5793-4501-81b6-fe3918fcfa2d (MedicationStatement)](MedicationStatement-0fc1f006-5793-4501-81b6-fe3918fcfa2d.md)
* [133c8159-6398-4937-984a-d741e24556ad (MedicationStatement)](MedicationStatement-133c8159-6398-4937-984a-d741e24556ad.md)
* [1b88713c-64cc-40ad-9665-70ca5f7dfb08 (MedicationStatement)](MedicationStatement-1b88713c-64cc-40ad-9665-70ca5f7dfb08.md)
* [1cb0f018-178d-4488-a6b4-2be32dbda784 (MedicationStatement)](MedicationStatement-1cb0f018-178d-4488-a6b4-2be32dbda784.md)
* [405ff43e-bc8e-4109-b370-3e31431c5fe0 (MedicationStatement)](MedicationStatement-405ff43e-bc8e-4109-b370-3e31431c5fe0.md)
* [71601cdb-8a53-4f26-b5d5-e5457b498e76 (MedicationStatement)](MedicationStatement-71601cdb-8a53-4f26-b5d5-e5457b498e76.md)
* [Technical-Exp-NachtragEmlMedicationStatement (MedicationStatement)](MedicationStatement-Technical-Exp-NachtragEmlMedicationStatement.md)
* [Technical-Exp-NachtragEmpMedicationStatementEml (MedicationStatement)](MedicationStatement-Technical-Exp-NachtragEmpMedicationStatementEml.md)
* [ab495b80-c9d2-4ed6-a076-b44b8dfae75a (MedicationStatement)](MedicationStatement-ab495b80-c9d2-4ed6-a076-b44b8dfae75a.md)
* [b87b0908-7765-4ec0-8662-7d3daff08f6e (MedicationStatement)](MedicationStatement-b87b0908-7765-4ec0-8662-7d3daff08f6e.md)
* [cfb84928-15d6-468c-8e17-e77f1ed44904 (MedicationStatement)](MedicationStatement-cfb84928-15d6-468c-8e17-e77f1ed44904.md)
* [f29f1d0c-be05-4b0d-a335-3e508da39c0c (MedicationStatement)](MedicationStatement-f29f1d0c-be05-4b0d-a335-3e508da39c0c.md)
* [f3988023-2313-4645-bd6b-f9e37cfb6fc7 (MedicationStatement)](MedicationStatement-f3988023-2313-4645-bd6b-f9e37cfb6fc7.md)
* [0a30eb5d-289f-44cf-a0bd-ec4ec38edaa8 (OperationOutcome)](OperationOutcome-0a30eb5d-289f-44cf-a0bd-ec4ec38edaa8.md)
* [0b476e35-02d5-4fb0-ad60-79f5eb05e2b4 (OperationOutcome)](OperationOutcome-0b476e35-02d5-4fb0-ad60-79f5eb05e2b4.md)
* [0b967346-00bf-412c-8e05-077ed13e873e (OperationOutcome)](OperationOutcome-0b967346-00bf-412c-8e05-077ed13e873e.md)
* [12f5513f-3eef-41ad-baca-826627c890f2 (OperationOutcome)](OperationOutcome-12f5513f-3eef-41ad-baca-826627c890f2.md)
* [1a5a1db0-7bab-4d25-a43d-3ad1efb29cb5 (OperationOutcome)](OperationOutcome-1a5a1db0-7bab-4d25-a43d-3ad1efb29cb5.md)
* [1e5838dd-ec29-4f68-9739-dfa717db515d (OperationOutcome)](OperationOutcome-1e5838dd-ec29-4f68-9739-dfa717db515d.md)
* [24b64018-89f4-4a52-8e9c-c0af279c4e86 (OperationOutcome)](OperationOutcome-24b64018-89f4-4a52-8e9c-c0af279c4e86.md)
* [255002c7-aa1b-4163-bdd4-ede482453cca (OperationOutcome)](OperationOutcome-255002c7-aa1b-4163-bdd4-ede482453cca.md)
* [2b34898e-a9d1-4fa6-9959-5ff6033cfcb0 (OperationOutcome)](OperationOutcome-2b34898e-a9d1-4fa6-9959-5ff6033cfcb0.md)
* [41d25882-4a02-47e3-a367-f5b5fe8c8015 (OperationOutcome)](OperationOutcome-41d25882-4a02-47e3-a367-f5b5fe8c8015.md)
* [446e77ff-9fcb-4232-8de3-74986f78d85f (OperationOutcome)](OperationOutcome-446e77ff-9fcb-4232-8de3-74986f78d85f.md)
* [52c59e99-eba0-4488-b829-39983b9169f5 (OperationOutcome)](OperationOutcome-52c59e99-eba0-4488-b829-39983b9169f5.md)
* [912a5e81-6274-439e-9d79-5172c4855a70 (OperationOutcome)](OperationOutcome-912a5e81-6274-439e-9d79-5172c4855a70.md)
* [98ca7dff-aa8d-47d0-a074-4055f55cb4db (OperationOutcome)](OperationOutcome-98ca7dff-aa8d-47d0-a074-4055f55cb4db.md)
* [98ca7dff-aa8d-47d0-a074-4055f55cb4dc (OperationOutcome)](OperationOutcome-98ca7dff-aa8d-47d0-a074-4055f55cb4dc.md)
* [a1dc2bb2-1776-4ccd-929f-355472077cf6 (OperationOutcome)](OperationOutcome-a1dc2bb2-1776-4ccd-929f-355472077cf6.md)
* [a4da96e5-84d6-4883-8789-5df2e1363c40 (OperationOutcome)](OperationOutcome-a4da96e5-84d6-4883-8789-5df2e1363c40.md)
* [a94b020a-2f34-4013-83ea-cf1bd0a92cdd (OperationOutcome)](OperationOutcome-a94b020a-2f34-4013-83ea-cf1bd0a92cdd.md)
* [b29880f0-6c99-4fe2-aae2-007e8cb4d9cf (OperationOutcome)](OperationOutcome-b29880f0-6c99-4fe2-aae2-007e8cb4d9cf.md)
* [bef62761-7eea-4daa-a992-36c532232679 (OperationOutcome)](OperationOutcome-bef62761-7eea-4daa-a992-36c532232679.md)
* [c03670fe-eaf2-4a38-a333-4dc1470072a2 (OperationOutcome)](OperationOutcome-c03670fe-eaf2-4a38-a333-4dc1470072a2.md)
* [c146f801-8f50-4ca4-8578-514d5938e3c3 (OperationOutcome)](OperationOutcome-c146f801-8f50-4ca4-8578-514d5938e3c3.md)
* [dc558008-4fbd-4e51-a16a-0cbc382a529f (OperationOutcome)](OperationOutcome-dc558008-4fbd-4e51-a16a-0cbc382a529f.md)
* [e4f1ed42-7741-40f5-a84e-fd688ac74d3e (OperationOutcome)](OperationOutcome-e4f1ed42-7741-40f5-a84e-fd688ac74d3e.md)
* [e69228bf-6f07-4055-8190-e832d2c670dc (OperationOutcome)](OperationOutcome-e69228bf-6f07-4055-8190-e832d2c670dc.md)
* [e730e451-3a44-4842-a8ed-1517a3334465 (OperationOutcome)](OperationOutcome-e730e451-3a44-4842-a8ed-1517a3334465.md)
* [ee1e0518-02f2-4d3a-99ae-bae8e91c382d (OperationOutcome)](OperationOutcome-ee1e0518-02f2-4d3a-99ae-bae8e91c382d.md)
* [fc3e8ea4-41ec-4de2-906e-97871b34adcb (OperationOutcome)](OperationOutcome-fc3e8ea4-41ec-4de2-906e-97871b34adcb.md)
* [gematik Apotheke (Organization)](Organization-151f1697-7512-4e21-9466-1b75207475d8.md)
* [Die Hausarztpraxis (Organization)](Organization-450a9511-53e5-4af7-be36-a18444bb8dd2.md)
* [Die Apotheke (Organization)](Organization-8B421590-9F7F-46BE-BD1E-C987063AC4F5.md)
* [TestLEI (Organization)](Organization-Technical-Exp-NachtragEmlLEI.md)
* [TestLEI (Organization)](Organization-Technical-Exp-NachtragEmpLEI.md)
* [Praxis Dr. med. Max Mustermann (Organization)](Organization-ad7dc0e7-cb44-4740-ba67-cb573e29d596.md)
* [gematik GmbH (Organization)](Organization-be51e0d2-783d-4e21-b16b-1a4cd7403515.md)
* [7ccb2670-7178-4f82-912a-de70f68ecd51 (Parameters)](Parameters-7ccb2670-7178-4f82-912a-de70f68ecd51.md)
* [example-epa-op-add-eml-entry-input-parameters-1 (Parameters)](Parameters-example-epa-op-add-eml-entry-input-parameters-1.md)
* [example-epa-op-add-emp-entry-input-parameters-1 (Parameters)](Parameters-example-epa-op-add-emp-entry-input-parameters-1.md)
* [example-epa-op-add-emp-entry-with-reference-input-parameters-1 (Parameters)](Parameters-example-epa-op-add-emp-entry-with-reference-input-parameters-1.md)
* [example-epa-op-cancel-dispensation-erp-input-parameters-1 (Parameters)](Parameters-example-epa-op-cancel-dispensation-erp-input-parameters-1.md)
* [example-epa-op-cancel-prescription-erp-input-parameters-1 (Parameters)](Parameters-example-epa-op-cancel-prescription-erp-input-parameters-1.md)
* [example-epa-op-eml-entry-cancelled-output-parameters-1 (Parameters)](Parameters-example-epa-op-eml-entry-cancelled-output-parameters-1.md)
* [example-epa-op-eml-entry-output-parameters-1 (Parameters)](Parameters-example-epa-op-eml-entry-output-parameters-1.md)
* [example-epa-op-emp-entry-output-parameters-1 (Parameters)](Parameters-example-epa-op-emp-entry-output-parameters-1.md)
* [example-epa-op-emp-entry-output-parameters-2 (Parameters)](Parameters-example-epa-op-emp-entry-output-parameters-2.md)
* [example-epa-op-link-emp-entry-output-parameters-1 (Parameters)](Parameters-example-epa-op-link-emp-entry-output-parameters-1.md)
* [example-epa-op-link-emp-entry-parameters-1 (Parameters)](Parameters-example-epa-op-link-emp-entry-parameters-1.md)
* [example-epa-op-provide-dispensation-erp-input-parameters-1 (Parameters)](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-1.md)
* [example-epa-op-provide-dispensation-erp-input-parameters-2 (Parameters)](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-2.md)
* [example-epa-op-provide-dispensation-erp-input-parameters-3 (Parameters)](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-3.md)
* [example-epa-op-provide-prescription-erp-input-parameters-1 (Parameters)](Parameters-example-epa-op-provide-prescription-erp-input-parameters-1.md)
* [example-epa-op-provide-prescription-erp-input-parameters-2 (Parameters)](Parameters-example-epa-op-provide-prescription-erp-input-parameters-2.md)
* [example-epa-op-rmp-commit-input-parameters-1 (Parameters)](Parameters-example-epa-op-rmp-commit-input-parameters-1.md)
* [example-epa-op-rx-dispensation-erp-output-parameters-1 (Parameters)](Parameters-example-epa-op-rx-dispensation-erp-output-parameters-1.md)
* [example-epa-op-rx-prescription-erp-output-parameters-1 (Parameters)](Parameters-example-epa-op-rx-prescription-erp-output-parameters-1.md)
* [example-epa-op-unlink-emp-entry-output-parameters-1 (Parameters)](Parameters-example-epa-op-unlink-emp-entry-output-parameters-1.md)
* [example-epa-op-unlink-emp-entry-parameters-1 (Parameters)](Parameters-example-epa-op-unlink-emp-entry-parameters-1.md)
* [example-epa-op-update-emp-entry-input-parameters-1 (Parameters)](Parameters-example-epa-op-update-emp-entry-input-parameters-1.md)
* [Technical-Exp-NachtragEmlPatient (Patient)](Patient-Technical-Exp-NachtragEmlPatient.md)
* [Technical-Exp-NachtragEmpPatient (Patient)](Patient-Technical-Exp-NachtragEmpPatient.md)
* [498c345f-31f5-4da6-9f04-00fa2bc8af7c (Practitioner)](Practitioner-498c345f-31f5-4da6-9f04-00fa2bc8af7c.md)
* [73a551f8-d8cd-4b44-823d-ab5f8aeab1aa (PractitionerRole)](PractitionerRole-73a551f8-d8cd-4b44-823d-ab5f8aeab1aa.md)
* [b9eb9668-b61e-43b5-b3ea-485234836d59 (PractitionerRole)](PractitionerRole-b9eb9668-b61e-43b5-b3ea-485234836d59.md)
* [0b383501-f078-464b-b984-9fdb6751601b (Provenance)](Provenance-0b383501-f078-464b-b984-9fdb6751601b.md)
* [168ec791-45ca-434c-8ba8-cbc855a3ca90 (Provenance)](Provenance-168ec791-45ca-434c-8ba8-cbc855a3ca90.md)
* [176eec9c-8d5a-46a7-96e3-7af3f68c49ed (Provenance)](Provenance-176eec9c-8d5a-46a7-96e3-7af3f68c49ed.md)
* [1a93c378-435e-437e-8c7c-6e84b788a3eb (Provenance)](Provenance-1a93c378-435e-437e-8c7c-6e84b788a3eb.md)
* [20335453-d103-4957-a370-03c9007db2f6 (Provenance)](Provenance-20335453-d103-4957-a370-03c9007db2f6.md)
* [2e112cb5-3b9f-4434-848e-26e27756cd30 (Provenance)](Provenance-2e112cb5-3b9f-4434-848e-26e27756cd30.md)
* [2e1ba746-1aef-4eef-b741-2dfc771c7001 (Provenance)](Provenance-2e1ba746-1aef-4eef-b741-2dfc771c7001.md)
* [319fcc6e-049d-4eb1-9a5c-82c33438cf94 (Provenance)](Provenance-319fcc6e-049d-4eb1-9a5c-82c33438cf94.md)
* [39475183-3444-4b63-bfed-ae0741f4496b (Provenance)](Provenance-39475183-3444-4b63-bfed-ae0741f4496b.md)
* [850ef590-34ff-469a-8c0d-13b6751a029b (Provenance)](Provenance-850ef590-34ff-469a-8c0d-13b6751a029b.md)
* [8faa45dd-b2dc-4a80-8956-94aeab1db04b (Provenance)](Provenance-8faa45dd-b2dc-4a80-8956-94aeab1db04b.md)
* [9090b28c-e165-4823-b82b-15bb63012123 (Provenance)](Provenance-9090b28c-e165-4823-b82b-15bb63012123.md)
* [Technical-Exp-NachtragEmlProvenance (Provenance)](Provenance-Technical-Exp-NachtragEmlProvenance.md)
* [Technical-Exp-NachtragEmpProvenanceEml (Provenance)](Provenance-Technical-Exp-NachtragEmpProvenanceEml.md)
* [Technical-Exp-NachtragEmpProvenanceEmp (Provenance)](Provenance-Technical-Exp-NachtragEmpProvenanceEmp.md)
* [a36b3ae8-1c1d-4dbb-b209-ee2ee9fc31e6 (Provenance)](Provenance-a36b3ae8-1c1d-4dbb-b209-ee2ee9fc31e6.md)
* [a99c2849-de82-4a43-98f4-8d6a4caa6038 (Provenance)](Provenance-a99c2849-de82-4a43-98f4-8d6a4caa6038.md)
* [b467ce05-e0e5-4d71-9a0b-d824dbb492ef (Provenance)](Provenance-b467ce05-e0e5-4d71-9a0b-d824dbb492ef.md)
* [b5ad3b05-1174-415f-8f43-555160862b25 (Provenance)](Provenance-b5ad3b05-1174-415f-8f43-555160862b25.md)
* [cf988182-fd13-4f1f-a35c-d045c57c28d0 (Provenance)](Provenance-cf988182-fd13-4f1f-a35c-d045c57c28d0.md)
* [de42aa65-f84e-4e96-acfb-b9fd5e104b2d (Provenance)](Provenance-de42aa65-f84e-4e96-acfb-b9fd5e104b2d.md)
* [f2e5c91f-4aed-484f-b313-7332ac2677c8 (Provenance)](Provenance-f2e5c91f-4aed-484f-b313-7332ac2677c8.md)
* [f35a13e2-d82c-4826-97d7-b7e32721c4af (Provenance)](Provenance-f35a13e2-d82c-4826-97d7-b7e32721c4af.md)
