# Home - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/ImplementationGuide/de.gematik.epa.medication | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:gemIG_ePA_Medication |
| **Copyright/Legal**: gematik GmbH / Dieser Implementation Guide ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Die **ePA für alle** stärkt den **digital gestützten Medikationsprozess (dgMP)** in dem sie an den Versorgungsschnittstellen Medikationsinformationen für Medikationsanalyse und -management bereitstellt. Dies wird vornehmlich durch

* die automatische Befüllung der **elektronischen Medikationsliste (eML)** mit verordneten und abgegebenen Arzneimitteln,
* die Möglichkeit der Dokumentation von geplanten Arzneimittelanwendungen inkl. Dosierinformation,
* die Bereitstellung einer Übersicht über aktuelle und zukünftig einzunehmende Arzneimittel auf dem **elektronischen Medikationsplan (eMP)**,
* die Bearbeitung von Statuswerten zu geplanten Arzneimittelanwendungen auf dem eMP sowie
* das Ändern von Dosierangaben zu eMP-Medikationen

erreicht. Der **ePA Medication Service** (kurz Medication Service) des dgMP unterstützt diese Funktionalitäten über eine HL7 FHIR-basierte Verarbeitung.

### Organisation dieses Implementation Guide

Dieser Implementation Guide sollte “von links nach rechts” gelesen werden. Ausgehend von der Fachlichkeit wird anschließend die dazugehörige FHIR-Modellierung über technische Anwendungsfälle beschrieben, die schließlich in FHIR-Ressourcen und -APIs aufgehen:

* Fachlichkeit: Technische Umsetzung
  * In einem[Überblick](./dgmp-overview.md)werden fachliche Zusammenhänge des dgMP mitsamt den Sichtkonzepten eML und eMP erläutert. Weiterhin werden idealtypische[Szenarien](./dgmp-scenarios.md)des dgMP für verschiedene Sektoren und diesbezügliche[fachliche Anwendungsfälle](./dgmp-use-cases.md)beschrieben.: Die technische Umsetzung der Prozessunterstützung wird anhand[technischer Anwendungsfälle](./technical-use-cases.md)erläutert. Diese sind:* Verordnung, Verschreibung und Dispensierung (inkl. Arzneimittelsubstitution bei Abgabe) mit dem eMP
* Nachtrag in der eML
* Nachtrag im eMP
* Aktualisierung eines eMP-Eintrags
* Hinzufügen und Entfernen einer eML-eMP-Verknüpfung
* Lesezugriffe für eML und eMP
Diesen Beschreibungen schließen sich[Verarbeitungsregeln](./processing-rules.md)zum FHIR-basierten Auslesen und der folgenden Anzeige in Benutzungsoberflächen für die eML als auch den eMP an. Zuletzt wird die[Datenmigration](./migration.md)beschrieben, die beim Aktualisieren des Medication Service auf eine neue Version durchgeführt werden müssen.
* Fachlichkeit: Schnittstellen
  * In einem[Überblick](./dgmp-overview.md)werden fachliche Zusammenhänge des dgMP mitsamt den Sichtkonzepten eML und eMP erläutert. Weiterhin werden idealtypische[Szenarien](./dgmp-scenarios.md)des dgMP für verschiedene Sektoren und diesbezügliche[fachliche Anwendungsfälle](./dgmp-use-cases.md)beschrieben.: Die Schnittstellen des Medication Service setzen sich aus[Query API](./query-api.md),[Operation API](./operation-api.md)sowie[Render API](./render-api.md)zusammen. Allgemeingültige und ePA-spezifische[Anforderungen](./general-principles.md)an FHIR Data Services als auch[Datenschutz- und Datensicherheitsaspekte](./privacy-security.md)werden in diesem Abschnitt dargelegt.
* Fachlichkeit: FHIR-Artefakte
  * In einem[Überblick](./dgmp-overview.md)werden fachliche Zusammenhänge des dgMP mitsamt den Sichtkonzepten eML und eMP erläutert. Weiterhin werden idealtypische[Szenarien](./dgmp-scenarios.md)des dgMP für verschiedene Sektoren und diesbezügliche[fachliche Anwendungsfälle](./dgmp-use-cases.md)beschrieben.: Hier findet sich eine tabellarische Übersicht aller in diesem Implementation Guide verwendeten[FHIR-Artefakte](./artifacts.md)zu Schnittstellen und Inhaltsdaten für Abruf und Verwaltung von Medikationsdaten.
* Fachlichkeit: Anhänge
  * In einem[Überblick](./dgmp-overview.md)werden fachliche Zusammenhänge des dgMP mitsamt den Sichtkonzepten eML und eMP erläutert. Weiterhin werden idealtypische[Szenarien](./dgmp-scenarios.md)des dgMP für verschiedene Sektoren und diesbezügliche[fachliche Anwendungsfälle](./dgmp-use-cases.md)beschrieben.: Diesem Implementation Guide werden[Download-Artefakte](./downloads.md)(u.a. Paketdatei, Beispiele, Schematron-Dateien, dieser Guide im ZIP-Format),[OpenAPI-Spezifikationen](./medication-openapi.md),[Release Notes](./release-notes.md)sowie[Steckbriefe](./spec-sheet.md)angehängt.

**Tabelle:**Organisation dieses Implementation Guide

### Vorgehensweise bei FHIR-Profil-Spezifikation

Der Medication Service ist Teil des FHIR-basierten Datenraums des ePA-Aktensystems. Grundsätzlich sollen die FHIR-Profile größtmöglich wiederverwendet und damit so wenig wie möglich eingeschränkt werden. Anforderungen an eine FHIR-basierte Verarbeitung werden auf unterschiedlichen Ebenen festgehalten:

* auf Ebene der Telematikinfrastruktur (TI),
* auf Ebene des Datenraums des ePA-Aktensystems sowie
* auf Ebene des spezifischen Dienstes zur Unterstütztung einer Funktionalität oder eines Versorgungsprozesses.

Hierfür wurden die dedizierten FHIR Implemenation Guides (IGs) **TI Common**, **ePA Basic** sowie in diesem Fall **Medication Service** geschrieben. Die ersten beiden FHIR IGs ermöglichen die Nachnutzung wiederkehrerender Anforderungen auf Ebene anderer, zukünftiger Produkttypen der TI und anderen FHIR Data Services des ePA-Aktensystems, um letztlich ein gleichartiges Verhalten gegenüber Client-Implementierungen, wie Primärsystemen, zu gewährleisten. Übergreifende Terminologien werden separat als FHIR Package Dependency verwaltet.

Die Auswahl geeigneter FHIR-Ressourcen für die Verarbeitung strukturierter Daten und die inhaltlichen Festlegungen der Profile orientieren sich vornehmlich an den Deutschen Basisprofilen von HL7 Deutschland e.V. sowie dem HL7 FHIR-Standard selbst. Aber auch die enge Kombatibilität zum E-Rezept als auch die teilweise inhaltlich verwandten FHIR-Profile von ISiK (Abk. für **Informationstechnische Systeme in Krankenhäusern**) waren ausschlaggebend für die Profilierung dieser FHIR-Ressourcen. Die Gewährleistung einer clientseitigen Weiterverarbeitung (auch Ableitung) ist ebenso Bestreben bei der FHIR-Profilierung. In der Regel wurden daher Kardinalitäten nicht eingeschränkt, das **Must Support**-Konzept wo notwendig platziert. Begründungen für die Auswahl und inhaltliche Belegung von FHIR-Elementen erfolgen prosaisch nur in Ausnahmefällen. Hier sei auf die inhaltlichen Beschreibungen und Definition des FHIR-Standards verwiesen. Sämtliche FHIR-Elemente wurden in englischer Sprache, Erklärungen und Kommentare innerhalb eines Profils in deutscher Sprache definiert.

Zu den Prinzipien der integren Datenverarbeitung im Medication Service gehört u.a. die vollständige Kontrolle über die gespeicherten FHIR-Daten. Das bedeutet, dass jedwede übergebene FHIR-Instanz von außen niemals direkt gespeichert wird, sondern lediglich als Data Transfer Object (DTO) dient. Nach entsprechenden Prüfungen in den Geschäftslogiken (Validierung, Einhaltung von Regeln etc.) werden jeweils ausschließlich mit **Must Support** gekennzeichnete Elemente in eine neu erzeugte oder zu aktualisierende FHIR-Instanz übernommen. Auch Referenzen werden intern erzeugt. Somit obliegt diesem FHIR Data Service auch die Vergabe von **Resource.id** und Versionsnummer innerhalb einer Transaktion. Die Nachweisbarkeit von Änderungen in Schreibvorgängen wird über intern erzeugte **Provenance**-Instanzen sichergestellt. Sämtliche Zugriffsaktiviäten werden darüber hinaus über **AuditEvent**-Instanzen festgehalten, welche dem oder der Versicherten über das ePA-FdV oder über die Ombudsstelle seiner/ihrer Krankenkasse zu Verfügung gestellt werden.

Bestandteil jeder FHIR Data-Service-Spezifikation des ePA-Aktensystems ist das **Capability Statement**. FHIR-Ressourcentypen und -profile, Interaktionen (CRUD), Suchparameter und Operations werden darüber definiert und können programmatisch weiterverarbeitet werden. Zu den FHIR IGs der ePA gehören zudem beigestellte **OpenAPI**-Spezifikationen, welche allerdings im Vergleich zu den besagten Statements aufgrund der nicht deckungsgleichen Repräsentation aller FHIR-Konzepte (u.a. Constraints) nicht verbindlich im Sinne einer Zulassung der gematik sind. Ferner stellt ein FHIR IG der ePA Beispiele zum Download zur Verfügung.

### Abhängigkeiten








### Sprachliche Konventionen

* Zur besseren Lesbarkeit wird in diesem Implementation Guide das generische Maskulinum verwendet. Die hier verwendeten Personenbezeichnungen beziehen sich stets auf alle Geschlechter.
* Der Begriff “Arzt” wird in diesem Implementation Guide sowohl für Human- als auch für Zahnmediziner verwendet.

### Weitere Hinweise

* Bitte die [Ausführungen des Medication IG DE bezüglich des defekten Constraints tim-9](https://build.fhir.org/ig/hl7germany/medication-ig-de-r4/branches/main/StructureDefinition-TimingDgMP.html#hinweise-zur-verwendung) beachten!

### Kontakt

Allgemeine Fragen und Kommentare zum Implementation Guide können Sie über das [Anfragenportal] der gematik einreichen. Falls kein Zugang besteht, senden Sie bitte eine E-Mail an “patientteam [ at ] gematik [ dot ] de” mit dem Betreff “Anfragenportal Zugang”.

