# Generelle Prinzipien - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **Generelle Prinzipien**

## Generelle Prinzipien

Dieser Implementation Guide verwendet die Schlüsselwörter **MUSS**, **DARF NICHT**, **SOLL NICHT** und **KANN** als deutsche Pendants des [RFC 2119], um Anforderungen als Ausdruck normativer Festlegungen zu kennzeichnen. Anforderungen werden im Implementation Guide wie folgt dargestellt:

**<IG-ID-Version> - <Titel der Anforderung>**
 Text / Beschreibung
 [<=]

### Übergeordnete Anforderungen

Der Medication Service berücksichtigt als Ausprägung eines FHIR Data Service allgemeingültige [gemIG_TI_Common#Medication] und ePA-spezifische [gemIG_ePA_Basic#Medication] Anforderungen.

### Schnittstellenadressierung

Der Medication Service MUSS sämtliche FHIR-Schnittstellen unter den folgenden Pfaden verfügbar machen:

* `[base]/epa/medication/api/v1/fhir/`
* `[base]/epa/medication/render/`
wobei
`[base]`einem gültigen Pfadnamen eines VAU-Kanals nach folgendem Schema entsprechen muss:
`http://epa4all`
### Schnittstellenimplementierung

Der Medication Service MUSS zusätzlich folgende HTTP Status Codes unterstützen:

| | | | |
| :--- | :--- | :--- | :--- |
| 423 | If the insurant objected to the medication process or objected to the submission of prescription and dispensation data into the ePA system, the Medication Service is locked. | locked |  |

**Tabelle:**HTTP Status Codes für die Medication-Service-Antwortnachrichten

Falls der Versicherte der Teilnahme am digital gestützten Medikationsprozess widersprochen hat (d.h. "medication = deny") und dem Einstellen von Verordnungsdaten und Dispensierinformation durch den E-Rezept-Fachdienst nicht widersprochen hat (d.h. "erp-submission = permit") MUSS das ePA-FdV dem Versicherten beim Aufruf der elektronischen Medikationsliste (eML) oder des elektronischen Medikationsplans (eMP) erkenntlich machen, dass die eML oder der eMP aufgrund des derzeitigen Widerspruchs durch Leistungserbringer nicht eingesehen und zur Behandlung des Versicherten genutzt werden kann.

Das ePA-FdV KANN es dem Nutzer ermöglichen für sein Aktenkonto oder für das Aktenkonto des zu Vertretenden unter Verwendung von der
*Query API*die Medikationsliste oder den Medikationsplan oder deren Details anzuzeigen bzw. nach Details zu suchen.

Das Primärsystem MUSS die
*Query API*implementieren, um die Medikationsliste oder deren Details anzuzeigen bzw. nach Details zu suchen.

Das Primärsystem MUSS die
*Query API*implementieren, um den Medikationsplan oder deren Details anzuzeigen bzw. nach Details zu suchen.

Das Primärsystem SOLL den Benutzer darauf hinweisen, dass bei der Freitexteingabe von Dezimalzahlen bei einem vorhandenen Dezimalbruchteil (insbesondere bei der Formulierung einer Freitextdosierungsanweisung) ein Komma als Dezimaltrennzeichen verwendet werden soll, um die Lesbarkeit auf dem Medikationsplan zu erhöhen.
Das heißt, dass potentielle “Nachkommastellen” mit einem Komma und insbesondere nicht mit einem Punkt abgetrennt werden sollen. Ein entsprechender Hinweis kann in einer Hilfeseite unter der Eingabezeile oder auf anderem Wege angebracht werden, der sich gut in die Ergonomie des Primärsystems integriert.

Das Primärsystem MUSS den Anwender darüber informieren, dass eine automatisierte Aktualisierung des Eintrags im elektronischen Medikationsplan (eMP) anhand des Dispensierdatensatzes nicht erfolgen kann, wenn bei der Abgabe auf Basis eines E-Rezepts mit hinterlegtem eMP-Identifier zu einem verschriebenen Arzneimittel mehrere Arzneimittel abgegeben werden. Darüber hinaus MUSS dem Anwender die Anzeige des eMP angeboten werden, damit eine manuelle Aktualisierung vorgenommen werden kann.
### FHIR-spezifische Anforderungen

#### Server-spezifische Festlegungen

Die folgenden Rahmenbedingungen hinsichtlich der FHIR-Spezifikation sind für den Medication Service festgelegt.

* Der E-Rezept-Fachdienst muss sich bei jeder Übertragung von Daten in den Medication Service auf einen bestimmten Versicherten beziehen. Dazu böte es sich an, eine im Medication Service hinterlegte FHIR Patient-Ressourceninstanz direkt zu referenzieren. Aufgrund der gesetzlich intendierten, fehlenden Leseberechtigung des E-Rezept-Fachdienstes ist das jedoch nicht möglich, sodass stattdessen lediglich ein KVNR-Identifier für die Zuordnung zu einem bestimmten Versicherten übertragen wird. Konkret MÜSSEN E-Rezept-Fachdienst sowie Medication Service deshalb sicherstellen, dass die FHIR-Elemente **MedicationRequest.subject.identifier** sowie **MedicationDispense.subject.identifier** an den von HL7 Deutschland e.V. definierten Datentyp **[Identifier für Patient](http://fhir.de/StructureDefinition/identifier-kvid-10)** gebunden sind.
* Das Löschen von Verschreibungsdaten oder Dispensierinformationen innerhalb des E-Rezept-Fachdienstes wird im Medication Service über ein Ändern des Status (d.h. Status = “cancelled”) der jeweiligen Ressourceninstanz umgesetzt.
* Für die FHIR Operations ist es erforderlich, dass eine Referenzierung der Ressourcen innerhalb der Parameter-Instanz möglich ist.

**Wichtig**: Gelöschte Instanzen bleiben über die FHIR-Versionshistorie weiterhin abrufbar, da keine physikalische Löschung erfolgt.

Der Medication Service MUSS sicherstellen, dass bei der Verarbeitung übermittelter Ressourcen im Rahmen einer Operation keine enthaltenen Referenzen wie
*subject*,
*medicationReference*,
*basedOn*oder
*derivedFrom*übernommen werden. Die Referenzierung innerhalb der resultierenden Ressource erfolgt ausschließlich durch die Geschäftslogik des Medication Service.

Der Medication Service MUSS übermittelte
*id*-Werte von Ressourcen im Rahmen einer Operation verwerfen und stattdessen eine neue ID vergeben, die im weiteren Verlauf der Operation verwendet wird.

Der Medication Service MUSS bei der Darstellung von Dezimalzahlen in Resultaten der Render-APIs das Dezimaltrennzeichen Komma "," verwenden.
**Hinweis:** Dies betrifft Situationen, in denen Daten, die die Repräsentation einer Dezimalzahl darstellen, als Text ausgegeben werden. Dezimalzahlen in Freitextfeldern sind davon nicht betroffen.

#### De-Duplizierung

Die zentrale De-Duplizierung bei inhaltlich identischen Ressourcen im Medication Service ist von entscheidender Bedeutung, um sowohl den Nutzen als auch die Qualität der Daten im Medication Service zu gewährleisten. Durch den nachstehenden Ansatz wird vermieden, dass ePA-Clients eigene, möglicherweise unterschiedliche Aggregierungsalgorithmen dezentral implementieren, was zu Inkonsistenzen in den Daten des Medication Service führen könnte. Zusätzlich verbessert eine zentrale De-Duplizierung die Verknüpfbarkeit und Integration der vorhandenen FHIR-Ressourcen.

Zur eindeutigen Identifizierung werden im Rahmen einer Verschreibung und ihr zugeordnete Dispensierinformationen die folgenden Identifier erzeugt und den notwendigen FHIR-Ressourcen hinzugefügt:

Der Medication Service MUSS für jede MedicationRequest-, MedicationDispense- und Medication-Ressource einen
*RxPrescriptionProcessIdentifier*erzeugen und dieser hinzufügen. Der
*RxPrescriptionProcessIdentifier*MUSS nach dem Schema (E-Prescription-ID + "_" + authoredOn[YYYYMMDD]) generiert werden. Die Erzeugung dieses Identifiers MUSS durch den Medication Service erfolgen.
Beispiel-Extension für die Ressourcen **Medication** und **MedicationDispense**

```
  "extension" : [
    {
      "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
      "valueIdentifier" : {
        "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
        "value" : "160.153.303.257.459_20250122"
      }
    }
  ],

```

Beispiel-Identifier für die Ressource **MedicationRequest**

```
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-prescription-process-identifier",
      "value" : "160.153.303.257.459_20250122"
    }
  ],

```

Der Medication Service MUSS für jede
*MedicationRequest*-,
*MedicationDispense*- und
*Medication*-Ressource einen
*RxOriginatorProcessIdentifier*erzeugen und dieser hinzufügen. Der
*RxOriginatorProcessIdentifier*MUSS nach dem Schema (Resource-ID + "_" + Prescription-ID) generiert werden. Dieser Identifier MUSS jede Prescription-ID mit der ursprünglichen Resource-ID des Erstellungssystems verknüpfen, um eine präzise Nachverfolgung und Koordination der Arzneimitteldaten zu gewährleisten. Die Erzeugung dieses Identifier MUSS durch den Medication Service erfolgen.
**Beispiel**

```
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/rx-originator-process-identifier",
      "value" : "dc810e53-c26b-47bc-8c78-c7f79ea5f7ae_160.153.303.257.459"
    }
  ],

```

##### Anforderungen an den EPAMedicationUniqueIdentifier

Dieser im Medication Service erzeugte Identifier an **Medication**-Ressourcen stellt die Eindeutigkeit anhand von Hashwerten über Pharmazentralnummer (PZN), Wirkstoff oder Freitext sicher. Von der Hashwertbildung ausgenommen sind die FHIR-Elemente **id**, **identifier**, **meta**, **amount**, **batch** sowie **status**.

Die Erzeugung des
*EPAMedicationUniqueIdentifier*MUSS für jede Medication beim Einstellen in den Medication Service durch die Geschäftslogik der entsprechenden FHIR-Operation generiert und der entsprechenden Medication hinzugefügt werden. Falls beim Hinzufügen einer Medication in den Medication Service ein Wert für den
*EPAMedicationUniqueIdentifier*vorhanden ist, MUSS dieser durch den Medication Service ersetzt werden.

Der Medication Service MUSS vermeiden, contained
*Medication*-Elemente einer
*Medication*-Instanz einen
*EPAMedicationUniqueIdentifier*hinzuzufügen. Die contained
*Medication*-Ressourcen müssen jedoch bei der Generierung des
*EPAMedicationUniqueIdentifier*der übergeordneten
*Medication*-Instanz berücksichtigt werden. Die enthaltene
*Medication*bleibt innerhalb der Hauptinstanz ohne eigenständige Identifizierung.

Der Medication Service MUSS die einzelnen Bestandteile in folgender Reihenfolge in die Hash-Berechnung einfließen lassen:

1. *Medication.code*– Alle Kodierungen in der Reihenfolge ihrer Angabe in der*Medication*-Instanz.
1. *Medication.code.text*– Nach Entfernung von Leerzeichen und Umwandlung in Kleinbuchstaben.
1. *Medication.form*– Alle Kodierungen in der Reihenfolge ihrer Angabe in der*Medication*-Instanz.
1. *Medication.ingredient[x]*– Alphabetisch sortierte Kombination aus:
* Falls ein *ingredient.itemCodeableConcept* vorhanden ist, werden die Kodierungen und der Text extrahiert.
* Falls eine *ingredient.strength* vorhanden ist, werden die numerischen Werte und Einheiten verarbeitet.
* Falls *ingredient.itemReference* vorhanden ist, wird die Referenz gespeichert und erst nach der Verarbeitung von *ingredient.itemCodeableConcept* behandelt.

1. Alphabetische Sortierung der Ingredients – Nach der Kombination der Werte müssen alle Ingredients alphabetisch sortiert werden.
1. Enthaltene Medications (*contained*) – Falls eine über*ingredient.itemReference*referenzierte*contained*Medication existiert, wird sie rekursiv verarbeitet und alphabetisch sortiert.
1. Extensions – Berücksichtigung spezifischer Extensions mit der entsprechenden URL, wobei die Werte in Kleinbuchstaben umgewandelt, Leerzeichen entfernt und alphabetisch sortiert werden. Spezifische Extensions sind:
* Extension: *MedicationManufacturingInstructionsExtension* URL: *https://gematik.de/fhir/epa-medication/StructureDefinition/medication-manufacturing-instructions-extension*

Der daraus resultierende Hashwert wird in Großbuchstaben dargestellt und stellt den eindeutigen
*EPAMedicationUniqueIdentifier*dar. Der Begriff
*"Kodierung"*in dieser Anforderung bedeutet die ausschließliche Berücksichtigung der FHIR-Elementwerte
*Coding.code*und
*Coding.system*des Datentyps
*Coding*.

Der Medication Service MUSS den
*EPAMedicationUniqueIdentifier*mittels des SHA-256-Algorithmus generieren.
**Beispiel**

```
  "identifier" : [
    {
      "system" : "https://gematik.de/fhir/epa-medication/sid/epa-medication-unique-identifier",
      "value" : "A632B2AB4232C9787E0731E3824942350070FB492EB1005A4AFA00F4BACD8AA1"
    }
  ],

```

###### Beispielimplementierung

Eine Beispielimplementierung für die Generierung eines SHA-256-basierten Hash-Werts ist auf [Medication_Unique_Identifier_Tool] veröffentlicht und steht als Referenz zur Verfügung.

#### Datenherausgabe

Der Medication Service MUSS die Funktion
`GET [base]/epa/medication/api/v1/fhir/metadata`implementieren. Diese Funktionalität stellt sicher, dass bei einem Aufruf von
`/metadata`das FHIR
*CapabilityStatement*des Medication Service mit dem Namen
*EPAMedicationServiceServer*zurückgegeben wird.
**Hinweis:** Das Capability Statement bietet eine detaillierte Beschreibung der Fähigkeiten des Medication Service und ist entscheidend für das Verständnis der unterstützten FHIR-Funktionalitäten. Der Abruf und Zugriff des Capability Statement unterliegt nicht den gesetzlichen Zugriffsbestimmungen bzw. der Legal Policy, da hier aus Client-Sicht ein technisches Spezifikationsartefakt gelesen wird und keine medizinischen Daten ausgetauscht oder anderweitig in Erfahrung gebracht werden. Dies legitimiert bspw. auch den E-Rezept-Fachdienst, das Capability Statement abzufragen.

Der Medication Service MUSS bei der Verarbeitung von FHIR-Operationen spezifische Statusmeldungen im Format
[EPA Medication Service Operation Outcome](./StructureDefinition-epa-ms-operation-outcome.md)bereitstellen. Diese Statusmeldungen MÜSSEN dem Value Set
[EPAMSOperationOutcomeDetailsVS](./ValueSet-epa-ms-operation-outcome-details.md)entsprechen.

Der Medication Service MUSS sicherstellen, dass diese Statusmeldungen in einer konsistenten und maschinenlesbaren Form ausgegeben werden, um eine eindeutige Fehlerbehandlung zu ermöglichen.

Der Medication Service SOLL Diagnosedaten bei auftretenden Fehlern beim Speichern von empfangenen Daten des E-Rezept-Fachdienstes in das Element
*OperationOutcome.issue.diagnostics*zurückgeben. Dieses gilt für folgende FHIR-Operationen:

| | |
| :--- | :--- |
| [Operation API: Verschreibungsdaten einstellen](./op-provide-prescription-erp.md) | providePrescription_MedicationSvc |
| [Operation API: Verschreibungsdaten stornieren](./op-cancel-prescription-erp.md) | cancelPrescription_MedicationSvc |
| [Operation API: Dispensierinformationen einstellen](./op-provide-dispensation-erp.md) | provideDispensation_MedicationSvc |
| [Operation API: Dispensierinformationen stornieren](./op-cancel-dispensation-erp.md) | cancelDispensation_MedicationSvc |

**Tabelle:**Rückgabe von Diagnosedaten beim Einstellen von Daten durch E-Rezept-Fachdienst
**Beispiel für die Nutzung von OperationOutcome.issue.diagnostics zur Beschreibung des Validierungsfehlers**

#### Validierung

Der Medication Service MUSS bei der Validierung der FHIR-Schema- und Strukturvorgaben für FHIR-Operationen, die ausschließlich vom E-Rezept-Fachdienst genutzt werden, auf die Validierung der KBV-Schlüsseltabellen verzichten.
* Die strukturelle FHIR-Validierung der Eingabedaten muss sich auf das FHIR-Schema und die korrekte Verwendung der Ressourcen und Datentypen beschränken.
* Eine Prüfung auf zulässige Werte innerhalb der KBV-Schlüsseltabellen (z.B. für Darreichungsformen) darf nicht erfolgen.
* Der E-Rezept-Fachdienst gilt als vertrauenswürdiger Fachdienst und verwaltet die KBV-Schlüsseltabellen über einen eigenen Aktualisierungsmechanismus.
Dieses gilt für folgende FHIR-Operationen:

| | |
| :--- | :--- |
| [Operation API: Verschreibungsdaten einstellen](./op-provide-prescription-erp.md) | providePrescription_MedicationSvc |
| [Operation API: Verschreibungsdaten stornieren](./op-cancel-prescription-erp.md) | cancelPrescription_MedicationSvc |
| [Operation API: Dispensierinformationen einstellen](./op-provide-dispensation-erp.md) | provideDispensation_MedicationSvc |
| [Operation API: Dispensierinformationen stornieren](./op-cancel-dispensation-erp.md) | cancelDispensation_MedicationSvc |

**Tabelle:**OperationIds für Operation APIs

Der Medication Service MUSS sicherstellen, dass beim Erzeugen von FHIR-Ressourcen in seinen Geschäftslogiken keine FHIR-Elemente und FHIR Extensions aus den FHIR-Eingabedaten übernommen werden, welche nicht in den serviceeigenen FHIR-Profilen mittels Must Support (MS) gelistet sind.

Der Medication Service MUSS bei Schreibzugriffen Angaben einer FHIR-Instanz zur FHIR-Profilkonformität im FHIR-Element
*meta.profile*ignorieren und darf sie nicht dauerhaft in serviceeigenen FHIR-Profilen speichern.
**Hinweis:** Gemäß der Anforderung [gemIG_ePA_Basic#IG-EPA74597GNF] schreibt der Medication Service nach Validierung und Ausführung der entsprechenden Geschäftslogik das FHIR-Element *meta.profile* selbst.

Der Medication Service MUSS sicherstellen, dass die aufbereitete Dosierungsdarstellung der übergebenen Ressourcen von MedicationRequest, MedicationDispense und MedicationStatement gemäß den Vorgaben des
*DosageDgMP*-Profils von HL7 Deutschland generiert wurde. Bei fehlschlagender Validierung ist die Operation mit HTTP Status Code
*400 Bad Request*und einem
*OperationOutcome*mit dem Fehlercode
*MEDSVC_DOSAGE_INVALID*abzulehnen.
**Hinweis:** Die vom E-Rezept-Fachdienst übergebenen Ressourcen von **MedicationRequest** und **MedicationDispense** sollen nicht validiert werden, da die Korrektheit der aufbereiteten Dosierungsdarstellung bereits vom E-Rezept-Fachdienst sichergestellt wird.

**Beispiel für OperationOutcome bei Verstoß gegen DosageDgMP-Textregeln**

