# Darstellung von Dosierungsinformationen - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **Darstellung von Dosierungsinformationen**

## Darstellung von Dosierungsinformationen

Die Dosierangaben für Medikationen der elektronischen Medikationsliste (eML) und des elektronischen Medikationsplans (eMP) sind durch HL7 Deutschland für FHIR profiliert [Medication_IG_DE]. Diese Dosierangaben sind auch Grundlage für die Ausgabe des eMP in der gerenderten Darstellung im Format PDF/A.

Die Darstellung der Dosierungsinformation erfolgt bei der aufbereiteten Ausgabe entweder als tageszeitbasiertes Schema in Tabellenform oder als rein textuelle Beschreibung. Die tabellarische Form entspricht der vertrauten Darstellung des morgens-mittags-abends-nachts-Schemas gemäß BMP, mit der Angabe einzunehmender Einheiten eines Medikaments pro Tagesabschnitt. In der textbasierten Form ist die Dosierung in lesbarer Form erläutert und erlaubt auch die Angabe komplexerer Einnahmeschemas.

Die tabellarische Form kann lediglich für einfache Dosierungsschemas Anwendung finden, also für Einnahmen die sich einem oder mehreren Tagesabschnitten für jeden Tag der Woche zuordnen lassen. Es ist eine verkürzte Form der Darstellung gegenüber der textbasierten Ausgabe. Diese Form ist auch anwendbar, wenn einem Medikationseintrag des eMP zwei oder mehr Dosierinformationen zugeordnet sind und diese jede für sich ein einfaches Dosierschema enthält. In einem solchen Fall erfolgt die tabellarische Darstellung als additive Kombination aus den Angaben der Dosierinformationen.

Alle anderen Dosierinformationen sind als komplex anzusehen, enthalten also ein nicht tagesbasiertes Schema, ein Intervall oder weitere spezielle Angaben. Hier ist eine Darstellung in Tabellenform nicht möglich, sondern die textbasierte Darstellung findet Anwendung (auf Basis der textuellen Repräsentation der Dosierangaben aus der Dosierinformation). Werden mehrere komplexe Dosierinformationen kombiniert, so erfolgt die textbasierte Darstellung zeilenweise untereinander pro Information.

Sind einem Medikationseintrag mehr als eine Dosierinformation zugeordnet und ist mindestens eine davon von komplexer Art, so wird immer die textbasierte Form der Darstellung gewählt, auch für eine weitere Dosierinformation, welche eigentlich in tabellarischer Form anzeigbar wäre.

Das Kriterium für eine tabellarische Darstellung ergibt sich, wenn folgender FHIR-Path Ausdruck über alle vorhandenen **dosage**-Elemente einer Medikation wahr ist.

```
dosageInstruction.all(
    timing.repeat.when.exists()
    and timing.repeat.frequency.exists()
    and timing.repeat.period = 1
    and timing.repeat.periodUnit = 'd'
    and timing.repeat.timeOfDay.empty()
    and timing.repeat.dayOfWeek.empty()
    and timing.repeat.bounds.empty()
)
and dosageInstruction.doseAndRate.dose.unit.distinct().count() = 1

```

Die Bewertung erfolgt pro Medikation. D.h.: es können auf einem eMP im Format PDF/A beide Darstellungsformen auftreten, pro einzelner Medikation, bzw. pro eMP-Eintrag, jedoch nur eine davon.

### Beispiel: eine einfache Dosierinformation

Die folgende Dosierinformation enthält das einfache Tagesschema 1-0-1-0. Die Ausgabe erfolgt in Tabellenform.

```

{
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d",
          "when" : [
            "MORN",
            "EVE"
          ]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```

 Auf Basis der zuvor gezeigten FHIR-Struktur folgt nun eine tabellarische Darstellung, die das Dosierschema in Form einer Kreuztabelle nach Tageszeiten veranschaulicht. 

**Abbildung:**Gerenderte Darstellung der Beispieldosierung mit einem tageszeitbasierten Schema
### Beispiel: eine Kombination aus zwei einfachen Dosierschemas

Für den Medikationseintrag gelten zwei Dosiervorgaben. Eine für die Einnahme einer Tablete morgens (1-0-0-0) und ein für die Einnahme einer halben Tablette abends (0-0-0,5-0). Beide Dosierangaben erlauben die verkürzte Darstellung. Die Ausgabe erfolgt in Tabellenform mit den kombinierten Werten.

```

{
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "when" : ["MORN"]
        }
      },
      "doseAndRate" : [{
        "doseQuantity" : {
          "value" : 1,
          "unit" : "Stück",
          "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
          "code" : "1"
        }
      }]
    },
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "when" : ["EVE"]
        }
      },
      "doseAndRate" : [{
        "doseQuantity" : {
          "value" : 0.5,
          "unit" : "Stück",
          "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
          "code" : "1"
        }
      }]
    }
  ]
}

```

 Aus der strukturierten FHIR-Darstellung wird im nächsten Schritt eine visuell aufbereitete Kreuztabelle erzeugt, die die Einnahmezeiten übersichtlich nach Tagesabschnitten darstellt. 

**Abbildung:**Gerenderte Darstellung der Beispieldosierung mit einer Kombination zweier tageszeitenbasierter Schemas

