# dgMP-Anwendungsfälle - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **dgMP-Anwendungsfälle**

## dgMP-Anwendungsfälle

Die folgenden funktionalen Anwendungsfälle beschreiben, ausgehend von den übergeordneten Szenarien (dgMP-Szenarien) sektorenspezifisch die medikationsbezogenen Tätigkeiten von Leistungserbringer:innen unter Zuhilfenahme ihres Primärsystems oder ePA-Client-Systems, welches gegenüber dem ePA-Aktensystem respektive Medication Service die Medikationsdaten erfasst oder aktualisiert.

> 

#### Demonstrator für den digital gestützten Medikationsprozess

Link zum Demonstrator:[Hier geht’s zum Demonstrator](https://www.figma.com/proto/NChMupKNZHqsVZsCpMoSJu/Demonstr.-Implementation-Guide-ePA-Medication-Service?page-id=0%3A1&node-id=15-329161&viewport=-551%2C-20%2C0.08&t=Tj8nfRnnPgZYLLVB-9&scaling=scale-down&content-scaling=fixed&starting-point-node-id=15%3A329161&show-proto-sidebar=1)**Was ist der Demonstrator?**Der Demonstrator ist eine Sammlung klickbarer Prototypen, die beispielhaft zeigt, wie einige der unten formulierten Anwendungsfälle des digital gestützten Medikationsprozesses in einer Versorgungseinrichtung ablaufen könnten. Anhand des Demonstrators soll der konzeptionelle Gedanke visualisiert, die Diskussion am Bild ermöglicht und ein gemeinsames Verständnis geschaffen werden.**Navigation im Demonstrator**: Die Prototypen sind nach den Anwendungsfällen nummeriert. Über die Navigation auf der linken Seite kann zwischen den Anwendungsfällen gewechselt werden. Innerhalb des Klickpfads kann den grünen Orientierungshilfen gefolgt werden.**Feedback geben**: Feedback ist herzlich willkommen und kann über die Kommentarfunktion am linken oberen Bildschirmrand hinterlassen werden. Hierfür ist ein kostenloses Benutzerkonto bei Figma anzulegen. Es ist zu beachten, dass nicht auf alle Kommentare eine Rückmeldung erfolgen kann. Das Feedback wird je nach Einschätzung kontinuierlich in die Weiterentwicklung eingebaut.**Bitte beachten:**
1. **Kontinuierliche Weiterentwicklung des Demonstrators**: Der Demonstrator befindet sich derzeit in einem kontinuierlichen Feedback- und Entwicklungsprozess. Entsprechend erfolgen Änderungen unabhängig vom Release-Management dieses Implementation Guides.
1. **Medizinische Feinheiten**: Der Fokus liegt auf einer Darstellung des Konzepts, sodass die gezeigten medizinischen Informationen nur exemplarisch sind. Bei Fehlern bitten wir entsprechend um Nachsicht.
1. **Perspektive**: Derzeit wird nur die ärztliche Perspektive aus einem Praxisverwaltungssystem dargestellt. Weitere Perspektiven sind in Planung.
1. **Strukturierte Dosierungen**: Die Benutzeroberfläche zur Eingabe strukturierter Dosierungen ist bisher nur angedeutet und soll in einem eigenen Projekt entwickelt werden.

### Übergreifende Vorbedingungen

Generell gehen die Anwendungsfälle davon aus, dass ein Zugang zum ePA-Aktensystem aufgebaut ist, sowie eine etwaige Befugnis der Nutzer:in vorliegt. Weiterhin wurde durch den Versicherten kein Widerspruch in diesen Versorgungsprozess kenntlich gemacht.

### Anzeige der elektronischen Medikationsliste (eML)

* Beschreibung: Vorbedingungen
  * Sowohl der Versicherte als auch verschiedene Gesundheitsprofessionen benötigen einen möglichst vollständigen Überblick über die Medikationshistorie eines Versicherten, um die Versorgung optimal zu gestalten. Die eML ermöglicht diese Sicht und unterstützt damit Anwendungszwecke wie eine Medikationsanamnese bzw. die Erhebung eines Medikationsstatus. Pflegende und Versicherte greifen insbesondere dann auf die Medikationsliste zu, wenn kein elektronischer Medikationsplan vorhanden ist. In diesem Fall kann die eML für die Planung und Umsetzung der Arzneimittelanwendung berücksichtigt werden. Es muss für den Anwender im Arbeitsumfeld des Primärsystems leicht erkennbar sein, wenn eine eML für ihn abrufbar ist.Standardmäßig wird die eML als tabellarische Ansicht aller per E-Rezept verordneten und abgegebenen oder nachgetragenen Arzneimittel angezeigt. Nachgetragene Arzneimittel müssen eindeutig als solche erkennbar sein. Stornierte Einträge werden in der Regel ausgeblendet. Darüber hinaus sollte der Anwender nachvollziehen können, welche Arzneimittel substituiert, im Rahmen einer Mehrfachverordnung verschrieben und welche auch im eMP berücksichtigt worden sind. Arzneimittel in der eML, die aktuell oder historisch noch nicht im eMP abgebildet sind, können dadurch gesondert betrachtet werden.Zur Auswahl der Spalten einer tabellarischen Ansicht kann auch bei einer nativen FHIR-Darstellung orientierend die Anforderung IG-MED64473BLY-2 - Schematischer Aufbau und Datenherkunft der generierten elektronischen Medikationsliste (eML) genutzt werden. Weitere Informationen sind in einer Detailansicht anzuzeigen. Insbesondere zur Anzeige im ePA-FdV können die Informationen aus der eML um Fach- und Gebrauchsinformationstexte sowie um Bilder der Packung oder Darreichungsform des Arzneimittels angereichert werden.Die Sortierung der Einträge erfolgt in der Regel chronologisch anhand der Verordnungs- und Abgabedaten. Für Arzneimittel, welche über einen Nachtrag in die ePA eingestellt werden, liegen in der eML keine Daten zur Verschreibung und Abgabe vor. Sie werden daher entsprechend des Einstelldatums oder – sofern beim Nachtrag angegeben – einem manuell hinterlegten Datum einsortiert.Nähere Informationen zur eML im ePA-FdV finden sich auch im Abschnitt “Der dgMP aus der Perspektive des Versicherten” im “Überblick”.: * Der Anwender befindet sich im Primärsystem bzw. ePA-FdV.

* Beschreibung: Durchzuführende Aktionen
  * Sowohl der Versicherte als auch verschiedene Gesundheitsprofessionen benötigen einen möglichst vollständigen Überblick über die Medikationshistorie eines Versicherten, um die Versorgung optimal zu gestalten. Die eML ermöglicht diese Sicht und unterstützt damit Anwendungszwecke wie eine Medikationsanamnese bzw. die Erhebung eines Medikationsstatus. Pflegende und Versicherte greifen insbesondere dann auf die Medikationsliste zu, wenn kein elektronischer Medikationsplan vorhanden ist. In diesem Fall kann die eML für die Planung und Umsetzung der Arzneimittelanwendung berücksichtigt werden. Es muss für den Anwender im Arbeitsumfeld des Primärsystems leicht erkennbar sein, wenn eine eML für ihn abrufbar ist.Standardmäßig wird die eML als tabellarische Ansicht aller per E-Rezept verordneten und abgegebenen oder nachgetragenen Arzneimittel angezeigt. Nachgetragene Arzneimittel müssen eindeutig als solche erkennbar sein. Stornierte Einträge werden in der Regel ausgeblendet. Darüber hinaus sollte der Anwender nachvollziehen können, welche Arzneimittel substituiert, im Rahmen einer Mehrfachverordnung verschrieben und welche auch im eMP berücksichtigt worden sind. Arzneimittel in der eML, die aktuell oder historisch noch nicht im eMP abgebildet sind, können dadurch gesondert betrachtet werden.Zur Auswahl der Spalten einer tabellarischen Ansicht kann auch bei einer nativen FHIR-Darstellung orientierend die Anforderung IG-MED64473BLY-2 - Schematischer Aufbau und Datenherkunft der generierten elektronischen Medikationsliste (eML) genutzt werden. Weitere Informationen sind in einer Detailansicht anzuzeigen. Insbesondere zur Anzeige im ePA-FdV können die Informationen aus der eML um Fach- und Gebrauchsinformationstexte sowie um Bilder der Packung oder Darreichungsform des Arzneimittels angereichert werden.Die Sortierung der Einträge erfolgt in der Regel chronologisch anhand der Verordnungs- und Abgabedaten. Für Arzneimittel, welche über einen Nachtrag in die ePA eingestellt werden, liegen in der eML keine Daten zur Verschreibung und Abgabe vor. Sie werden daher entsprechend des Einstelldatums oder – sofern beim Nachtrag angegeben – einem manuell hinterlegten Datum einsortiert.Nähere Informationen zur eML im ePA-FdV finden sich auch im Abschnitt “Der dgMP aus der Perspektive des Versicherten” im “Überblick”.: * Der Anwender wählt die Option “Medikationsliste” aus oder bedient eine Tastenkombination.
* Das Primärsystem bzw. das ePA-FdV ruft die eML vom ePA-Aktensystem ab und bereitet sie für die Anzeige auf.

* Beschreibung: Nachbedingungen
  * Sowohl der Versicherte als auch verschiedene Gesundheitsprofessionen benötigen einen möglichst vollständigen Überblick über die Medikationshistorie eines Versicherten, um die Versorgung optimal zu gestalten. Die eML ermöglicht diese Sicht und unterstützt damit Anwendungszwecke wie eine Medikationsanamnese bzw. die Erhebung eines Medikationsstatus. Pflegende und Versicherte greifen insbesondere dann auf die Medikationsliste zu, wenn kein elektronischer Medikationsplan vorhanden ist. In diesem Fall kann die eML für die Planung und Umsetzung der Arzneimittelanwendung berücksichtigt werden. Es muss für den Anwender im Arbeitsumfeld des Primärsystems leicht erkennbar sein, wenn eine eML für ihn abrufbar ist.Standardmäßig wird die eML als tabellarische Ansicht aller per E-Rezept verordneten und abgegebenen oder nachgetragenen Arzneimittel angezeigt. Nachgetragene Arzneimittel müssen eindeutig als solche erkennbar sein. Stornierte Einträge werden in der Regel ausgeblendet. Darüber hinaus sollte der Anwender nachvollziehen können, welche Arzneimittel substituiert, im Rahmen einer Mehrfachverordnung verschrieben und welche auch im eMP berücksichtigt worden sind. Arzneimittel in der eML, die aktuell oder historisch noch nicht im eMP abgebildet sind, können dadurch gesondert betrachtet werden.Zur Auswahl der Spalten einer tabellarischen Ansicht kann auch bei einer nativen FHIR-Darstellung orientierend die Anforderung IG-MED64473BLY-2 - Schematischer Aufbau und Datenherkunft der generierten elektronischen Medikationsliste (eML) genutzt werden. Weitere Informationen sind in einer Detailansicht anzuzeigen. Insbesondere zur Anzeige im ePA-FdV können die Informationen aus der eML um Fach- und Gebrauchsinformationstexte sowie um Bilder der Packung oder Darreichungsform des Arzneimittels angereichert werden.Die Sortierung der Einträge erfolgt in der Regel chronologisch anhand der Verordnungs- und Abgabedaten. Für Arzneimittel, welche über einen Nachtrag in die ePA eingestellt werden, liegen in der eML keine Daten zur Verschreibung und Abgabe vor. Sie werden daher entsprechend des Einstelldatums oder – sofern beim Nachtrag angegeben – einem manuell hinterlegten Datum einsortiert.Nähere Informationen zur eML im ePA-FdV finden sich auch im Abschnitt “Der dgMP aus der Perspektive des Versicherten” im “Überblick”.: * Der Anwender sieht die elektronische Medikationsliste in einer Übersichtsdarstellung.
* Der Anwender kann bei Bedarf weitere Informationen in einer Detailansicht oder über ein “Overlay” abrufen.
* Der Anwender kann Filter- und Suchfunktionen nutzen, um bestimmte Informationen zu finden oder hervorheben zu lassen.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Sowohl der Versicherte als auch verschiedene Gesundheitsprofessionen benötigen einen möglichst vollständigen Überblick über die Medikationshistorie eines Versicherten, um die Versorgung optimal zu gestalten. Die eML ermöglicht diese Sicht und unterstützt damit Anwendungszwecke wie eine Medikationsanamnese bzw. die Erhebung eines Medikationsstatus. Pflegende und Versicherte greifen insbesondere dann auf die Medikationsliste zu, wenn kein elektronischer Medikationsplan vorhanden ist. In diesem Fall kann die eML für die Planung und Umsetzung der Arzneimittelanwendung berücksichtigt werden. Es muss für den Anwender im Arbeitsumfeld des Primärsystems leicht erkennbar sein, wenn eine eML für ihn abrufbar ist.Standardmäßig wird die eML als tabellarische Ansicht aller per E-Rezept verordneten und abgegebenen oder nachgetragenen Arzneimittel angezeigt. Nachgetragene Arzneimittel müssen eindeutig als solche erkennbar sein. Stornierte Einträge werden in der Regel ausgeblendet. Darüber hinaus sollte der Anwender nachvollziehen können, welche Arzneimittel substituiert, im Rahmen einer Mehrfachverordnung verschrieben und welche auch im eMP berücksichtigt worden sind. Arzneimittel in der eML, die aktuell oder historisch noch nicht im eMP abgebildet sind, können dadurch gesondert betrachtet werden.Zur Auswahl der Spalten einer tabellarischen Ansicht kann auch bei einer nativen FHIR-Darstellung orientierend die Anforderung IG-MED64473BLY-2 - Schematischer Aufbau und Datenherkunft der generierten elektronischen Medikationsliste (eML) genutzt werden. Weitere Informationen sind in einer Detailansicht anzuzeigen. Insbesondere zur Anzeige im ePA-FdV können die Informationen aus der eML um Fach- und Gebrauchsinformationstexte sowie um Bilder der Packung oder Darreichungsform des Arzneimittels angereichert werden.Die Sortierung der Einträge erfolgt in der Regel chronologisch anhand der Verordnungs- und Abgabedaten. Für Arzneimittel, welche über einen Nachtrag in die ePA eingestellt werden, liegen in der eML keine Daten zur Verschreibung und Abgabe vor. Sie werden daher entsprechend des Einstelldatums oder – sofern beim Nachtrag angegeben – einem manuell hinterlegten Datum einsortiert.Nähere Informationen zur eML im ePA-FdV finden sich auch im Abschnitt “Der dgMP aus der Perspektive des Versicherten” im “Überblick”.: * [Lesezugriffe](./technical-use-cases.md#lesezugriffe)

* Beschreibung: Relevante(r) Sektor(en)
  * Sowohl der Versicherte als auch verschiedene Gesundheitsprofessionen benötigen einen möglichst vollständigen Überblick über die Medikationshistorie eines Versicherten, um die Versorgung optimal zu gestalten. Die eML ermöglicht diese Sicht und unterstützt damit Anwendungszwecke wie eine Medikationsanamnese bzw. die Erhebung eines Medikationsstatus. Pflegende und Versicherte greifen insbesondere dann auf die Medikationsliste zu, wenn kein elektronischer Medikationsplan vorhanden ist. In diesem Fall kann die eML für die Planung und Umsetzung der Arzneimittelanwendung berücksichtigt werden. Es muss für den Anwender im Arbeitsumfeld des Primärsystems leicht erkennbar sein, wenn eine eML für ihn abrufbar ist.Standardmäßig wird die eML als tabellarische Ansicht aller per E-Rezept verordneten und abgegebenen oder nachgetragenen Arzneimittel angezeigt. Nachgetragene Arzneimittel müssen eindeutig als solche erkennbar sein. Stornierte Einträge werden in der Regel ausgeblendet. Darüber hinaus sollte der Anwender nachvollziehen können, welche Arzneimittel substituiert, im Rahmen einer Mehrfachverordnung verschrieben und welche auch im eMP berücksichtigt worden sind. Arzneimittel in der eML, die aktuell oder historisch noch nicht im eMP abgebildet sind, können dadurch gesondert betrachtet werden.Zur Auswahl der Spalten einer tabellarischen Ansicht kann auch bei einer nativen FHIR-Darstellung orientierend die Anforderung IG-MED64473BLY-2 - Schematischer Aufbau und Datenherkunft der generierten elektronischen Medikationsliste (eML) genutzt werden. Weitere Informationen sind in einer Detailansicht anzuzeigen. Insbesondere zur Anzeige im ePA-FdV können die Informationen aus der eML um Fach- und Gebrauchsinformationstexte sowie um Bilder der Packung oder Darreichungsform des Arzneimittels angereichert werden.Die Sortierung der Einträge erfolgt in der Regel chronologisch anhand der Verordnungs- und Abgabedaten. Für Arzneimittel, welche über einen Nachtrag in die ePA eingestellt werden, liegen in der eML keine Daten zur Verschreibung und Abgabe vor. Sie werden daher entsprechend des Einstelldatums oder – sofern beim Nachtrag angegeben – einem manuell hinterlegten Datum einsortiert.Nähere Informationen zur eML im ePA-FdV finden sich auch im Abschnitt “Der dgMP aus der Perspektive des Versicherten” im “Überblick”.: APOTHEKER(ZAHN-)ARZTPFLEGEKRAFTVERSICHERTER

**Tabelle:**Fachlicher Anwendungsfall Anzeige der elektronischen Medikationsliste (eML)
### Anzeige des elektronischen Medikationsplans (eMP)

* Beschreibung: Vorbedingungen
  * Sobald erstmalig ein Eintrag im Medikationsplan angelegt wurde, kann der Medikationsplan angezeigt werden. Allen an der Arzneimitteltherapie beteiligten Akteuren soll der aktuelle Medikationsplan digital zur Verfügung stehen. Versicherte und Pflegende können anhand des Medikationsplans die Arzneimittelanwendung planen. Ärzte und Apotheker können den Medikationsplan anzeigen, um eine Medikationsanamnese durchzuführen bzw. den Medikationsstatus und eine Medikationshistorie zu erheben. Außerdem können sie überprüfen, ob etwaige Anpassungen erforderlich sind. Es muss für den Anwender im Arbeitsumfeld des Primärsystems leicht erkennbar sein, wenn ein eMP für ihn abrufbar ist.Es werden grundsätzlich alle eMP-Einträge mit dem Status “aktiv”, “geplant” und “pausiert” angezeigt. Diese sollten gruppiert werden, eindeutig unterscheidbar sein sowie in dieser Reihenfolge angezeigt werden. Die im Anwendungsfall “Anzeige der elektronischen Medikationsliste” benannten zusätzlichen Informationen zum Arzneimittel können auch in der Ansicht des eMP angezeigt werden (bspw. Bilder der Packung oder Darreichungsform).Hier beschrieben wird eine FHIR-basierte Darstellung. Die Darstellung als PDF wird unter “eMP ausdrucken” beschrieben.Nähere Informationen zum eMP im ePA-FdV finden sich auch im Abschnitt “Der dgMP aus der Perspektive des Versicherten” im “Überblick”.: * Der Anwender befindet sich im Primärsystem bzw. ePA-FdV.

* Beschreibung: Durchzuführende Aktionen
  * Sobald erstmalig ein Eintrag im Medikationsplan angelegt wurde, kann der Medikationsplan angezeigt werden. Allen an der Arzneimitteltherapie beteiligten Akteuren soll der aktuelle Medikationsplan digital zur Verfügung stehen. Versicherte und Pflegende können anhand des Medikationsplans die Arzneimittelanwendung planen. Ärzte und Apotheker können den Medikationsplan anzeigen, um eine Medikationsanamnese durchzuführen bzw. den Medikationsstatus und eine Medikationshistorie zu erheben. Außerdem können sie überprüfen, ob etwaige Anpassungen erforderlich sind. Es muss für den Anwender im Arbeitsumfeld des Primärsystems leicht erkennbar sein, wenn ein eMP für ihn abrufbar ist.Es werden grundsätzlich alle eMP-Einträge mit dem Status “aktiv”, “geplant” und “pausiert” angezeigt. Diese sollten gruppiert werden, eindeutig unterscheidbar sein sowie in dieser Reihenfolge angezeigt werden. Die im Anwendungsfall “Anzeige der elektronischen Medikationsliste” benannten zusätzlichen Informationen zum Arzneimittel können auch in der Ansicht des eMP angezeigt werden (bspw. Bilder der Packung oder Darreichungsform).Hier beschrieben wird eine FHIR-basierte Darstellung. Die Darstellung als PDF wird unter “eMP ausdrucken” beschrieben.Nähere Informationen zum eMP im ePA-FdV finden sich auch im Abschnitt “Der dgMP aus der Perspektive des Versicherten” im “Überblick”.: * Der Anwender wählt die Option “Medikationsplan” aus oder bedient eine Tastenkombination.
* Das Primärsystem bzw. das ePA-FdV ruft den eMP vom ePA-Aktensystem ab und bereitet ihn für die Anzeige auf.

* Beschreibung: Nachbedingungen
  * Sobald erstmalig ein Eintrag im Medikationsplan angelegt wurde, kann der Medikationsplan angezeigt werden. Allen an der Arzneimitteltherapie beteiligten Akteuren soll der aktuelle Medikationsplan digital zur Verfügung stehen. Versicherte und Pflegende können anhand des Medikationsplans die Arzneimittelanwendung planen. Ärzte und Apotheker können den Medikationsplan anzeigen, um eine Medikationsanamnese durchzuführen bzw. den Medikationsstatus und eine Medikationshistorie zu erheben. Außerdem können sie überprüfen, ob etwaige Anpassungen erforderlich sind. Es muss für den Anwender im Arbeitsumfeld des Primärsystems leicht erkennbar sein, wenn ein eMP für ihn abrufbar ist.Es werden grundsätzlich alle eMP-Einträge mit dem Status “aktiv”, “geplant” und “pausiert” angezeigt. Diese sollten gruppiert werden, eindeutig unterscheidbar sein sowie in dieser Reihenfolge angezeigt werden. Die im Anwendungsfall “Anzeige der elektronischen Medikationsliste” benannten zusätzlichen Informationen zum Arzneimittel können auch in der Ansicht des eMP angezeigt werden (bspw. Bilder der Packung oder Darreichungsform).Hier beschrieben wird eine FHIR-basierte Darstellung. Die Darstellung als PDF wird unter “eMP ausdrucken” beschrieben.Nähere Informationen zum eMP im ePA-FdV finden sich auch im Abschnitt “Der dgMP aus der Perspektive des Versicherten” im “Überblick”.: * Der Anwender sieht den elektronischen Medikationsplan in einer Übersichtsdarstellung.
* Der Anwender kann bei Bedarf weitere Informationen in einer Detailansicht, als aufklappbare Liste oder über ein “Overlay” abrufen, darunter: 
* Verordnungs- und Abgabehistorie (inkl. Nachträgen) zu diesem eMP-Eintrag.
* Änderungshistorie zu diesem eMP-Eintrag (inkl. Art, Urheber und Zeitpunkt der Änderung).
 
* Der Anwender kann Filter- und Suchfunktionen nutzen, um bestimmte Informationen zu finden oder hervorheben zu lassen.
* Der Anwender kann sich den Zustand des gesamten eMP zu einem bestimmten Zeitpunkt in der Vergangenheit anzeigen lassen (Historie).

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Sobald erstmalig ein Eintrag im Medikationsplan angelegt wurde, kann der Medikationsplan angezeigt werden. Allen an der Arzneimitteltherapie beteiligten Akteuren soll der aktuelle Medikationsplan digital zur Verfügung stehen. Versicherte und Pflegende können anhand des Medikationsplans die Arzneimittelanwendung planen. Ärzte und Apotheker können den Medikationsplan anzeigen, um eine Medikationsanamnese durchzuführen bzw. den Medikationsstatus und eine Medikationshistorie zu erheben. Außerdem können sie überprüfen, ob etwaige Anpassungen erforderlich sind. Es muss für den Anwender im Arbeitsumfeld des Primärsystems leicht erkennbar sein, wenn ein eMP für ihn abrufbar ist.Es werden grundsätzlich alle eMP-Einträge mit dem Status “aktiv”, “geplant” und “pausiert” angezeigt. Diese sollten gruppiert werden, eindeutig unterscheidbar sein sowie in dieser Reihenfolge angezeigt werden. Die im Anwendungsfall “Anzeige der elektronischen Medikationsliste” benannten zusätzlichen Informationen zum Arzneimittel können auch in der Ansicht des eMP angezeigt werden (bspw. Bilder der Packung oder Darreichungsform).Hier beschrieben wird eine FHIR-basierte Darstellung. Die Darstellung als PDF wird unter “eMP ausdrucken” beschrieben.Nähere Informationen zum eMP im ePA-FdV finden sich auch im Abschnitt “Der dgMP aus der Perspektive des Versicherten” im “Überblick”.: * [Lesezugriffe](./technical-use-cases.md#lesezugriffe)

* Beschreibung: Relevante(r) Sektor(en)
  * Sobald erstmalig ein Eintrag im Medikationsplan angelegt wurde, kann der Medikationsplan angezeigt werden. Allen an der Arzneimitteltherapie beteiligten Akteuren soll der aktuelle Medikationsplan digital zur Verfügung stehen. Versicherte und Pflegende können anhand des Medikationsplans die Arzneimittelanwendung planen. Ärzte und Apotheker können den Medikationsplan anzeigen, um eine Medikationsanamnese durchzuführen bzw. den Medikationsstatus und eine Medikationshistorie zu erheben. Außerdem können sie überprüfen, ob etwaige Anpassungen erforderlich sind. Es muss für den Anwender im Arbeitsumfeld des Primärsystems leicht erkennbar sein, wenn ein eMP für ihn abrufbar ist.Es werden grundsätzlich alle eMP-Einträge mit dem Status “aktiv”, “geplant” und “pausiert” angezeigt. Diese sollten gruppiert werden, eindeutig unterscheidbar sein sowie in dieser Reihenfolge angezeigt werden. Die im Anwendungsfall “Anzeige der elektronischen Medikationsliste” benannten zusätzlichen Informationen zum Arzneimittel können auch in der Ansicht des eMP angezeigt werden (bspw. Bilder der Packung oder Darreichungsform).Hier beschrieben wird eine FHIR-basierte Darstellung. Die Darstellung als PDF wird unter “eMP ausdrucken” beschrieben.Nähere Informationen zum eMP im ePA-FdV finden sich auch im Abschnitt “Der dgMP aus der Perspektive des Versicherten” im “Überblick”.: APOTHEKER(ZAHN-)ARZTPFLEGEKRAFTVERSICHERTER

**Tabelle:**Fachlicher Anwendungsfall Anzeige des elektronischen Medikationsplans (eMP)
### Abgleich geplantes Arzneimittel - eMP

* Beschreibung: Vorbedingungen
  * Wird eine Verschreibung oder Dispensierung begonnen, ohne, dass ein eMP-Eintrag referenziert ist, prüft das Primärsystem, ob bereits ein aktiver eMP-Eintrag mit einem vergleichbaren Arzneimittel existiert, um das E-Rezept ggf. mit einem bestehenden eMP-Eintrag zu verknüpfen oder einen neuen eMP-Eintrag anzulegen. Für diesen Abgleich ist bevorzugt der Wirkstoff (ASK- oder ATC-codiert) zu betrachten, aber auch Daten zum spezifischen Arzneimittel (bspw. Handelsname oder PZN) können genutzt werden. Primärsysteme, die vergleichbare Fragestellungen bspw. in einem AMTS-Modul betrachten, können auch eine komplexere Entscheidungsunterstützung anbieten. Es sollte vermieden werden, etwaige Hinweise als Push- oder Pop-Up-Benachrichtigungen darzustellen, die eine Interaktion des Anwenders mit dem Hinweis zwingend voraussetzen. Zu bevorzugen ist ein in den Arbeitsablauf und die Benutzeroberfläche integrierter Vorschlag, der direkt und aufwandsarm angenommen werden kann. Von diesem Anwendungsfall unbetroffen ist die Möglichkeit, einen zu referenzierenden eMP-Eintrag auch ohne Vorschlag des Primärsystems manuell auswählen zu können.: * Der Anwender befindet sich in der Ansicht des Primärsystems, in der Verschreibungen bzw. Dispensierungen verarbeitet werden.
* Der Anwender hat die Verschreibung/Dispensierung und die Auswahl des Arzneimittels gestartet.
* Das Primärsystem hat geprüft, ob für den Versicherten ein eMP in der ePA hinterlegt ist. Das ist der Fall.
* Das Primärsystem hat geprüft, ob mithilfe eines eMP-Identifiers bereits ein eMP-Eintrag referenziert wird. Das ist nicht der Fall.

* Beschreibung: Durchzuführende Aktionen
  * Wird eine Verschreibung oder Dispensierung begonnen, ohne, dass ein eMP-Eintrag referenziert ist, prüft das Primärsystem, ob bereits ein aktiver eMP-Eintrag mit einem vergleichbaren Arzneimittel existiert, um das E-Rezept ggf. mit einem bestehenden eMP-Eintrag zu verknüpfen oder einen neuen eMP-Eintrag anzulegen. Für diesen Abgleich ist bevorzugt der Wirkstoff (ASK- oder ATC-codiert) zu betrachten, aber auch Daten zum spezifischen Arzneimittel (bspw. Handelsname oder PZN) können genutzt werden. Primärsysteme, die vergleichbare Fragestellungen bspw. in einem AMTS-Modul betrachten, können auch eine komplexere Entscheidungsunterstützung anbieten. Es sollte vermieden werden, etwaige Hinweise als Push- oder Pop-Up-Benachrichtigungen darzustellen, die eine Interaktion des Anwenders mit dem Hinweis zwingend voraussetzen. Zu bevorzugen ist ein in den Arbeitsablauf und die Benutzeroberfläche integrierter Vorschlag, der direkt und aufwandsarm angenommen werden kann. Von diesem Anwendungsfall unbetroffen ist die Möglichkeit, einen zu referenzierenden eMP-Eintrag auch ohne Vorschlag des Primärsystems manuell auswählen zu können.: * Das Primärsystem prüft, ob ein eMP-Eintrag mit einem vergleichbaren Arzneimittel existiert. Zu berücksichtigen sind mindestens alle eMP-Einträge mit dem Status “aktiv”, “geplant” und “pausiert”. 
* Wenn ja: Das Primärsystem zeigt den identifizierten eMP-Eintrag als Vorschlag an.
* Wenn nein: Das Primärsystem zeigt an, dass kein vergleichbares Arzneimittel auf dem eMP identifiziert werden konnte.
 
* Das Primärsystem bietet an, den gesamten eMP eingebettet in die aktuelle Arbeitsumgebung anzuzeigen.

* Beschreibung: Nachbedingungen
  * Wird eine Verschreibung oder Dispensierung begonnen, ohne, dass ein eMP-Eintrag referenziert ist, prüft das Primärsystem, ob bereits ein aktiver eMP-Eintrag mit einem vergleichbaren Arzneimittel existiert, um das E-Rezept ggf. mit einem bestehenden eMP-Eintrag zu verknüpfen oder einen neuen eMP-Eintrag anzulegen. Für diesen Abgleich ist bevorzugt der Wirkstoff (ASK- oder ATC-codiert) zu betrachten, aber auch Daten zum spezifischen Arzneimittel (bspw. Handelsname oder PZN) können genutzt werden. Primärsysteme, die vergleichbare Fragestellungen bspw. in einem AMTS-Modul betrachten, können auch eine komplexere Entscheidungsunterstützung anbieten. Es sollte vermieden werden, etwaige Hinweise als Push- oder Pop-Up-Benachrichtigungen darzustellen, die eine Interaktion des Anwenders mit dem Hinweis zwingend voraussetzen. Zu bevorzugen ist ein in den Arbeitsablauf und die Benutzeroberfläche integrierter Vorschlag, der direkt und aufwandsarm angenommen werden kann. Von diesem Anwendungsfall unbetroffen ist die Möglichkeit, einen zu referenzierenden eMP-Eintrag auch ohne Vorschlag des Primärsystems manuell auswählen zu können.: * Liegt ein passender eMP-Eintrag vor: Der Anwender kann die Verknüpfung des vorgeschlagenen eMP-Eintrags mit der geplanten Verschreibung/Dispensierung bestätigen und den eMP-Eintrag inkl. seines Status bei Bedarf anpassen. Alternativ fährt der Anwender ohne Bezug zu dem vorgeschlagenen eMP-Eintrag fort. Vgl. [Pflege des eMP im Rahmen der Rezeptierung per E-Rezept - Aktualisieren eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-im-rahmen-der-rezeptierung-per-e-rezept---aktualisieren-eines-emp-eintrags), [Pflege des eMP im Rahmen der Dispensierung per E-Rezept - Aktualisieren eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-im-rahmen-der-dispensierung-per-e-rezept---aktualisieren-eines-emp-eintrags)
* Liegt kein passender eMP-Eintrag vor: Der Anwender kann einen neuen eMP-Eintrag für diese Verschreibung/Dispensierung anlegen (oder ohne Bezug zu einem eMP-Eintrag fortfahren). Vgl. [Pflege des eMP im Rahmen der Rezeptierung per E-Rezept - Anlage eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-im-rahmen-der-rezeptierung-per-e-rezept---anlage-eines-emp-eintrags), [Pflege des eMP im Rahmen der Dispensierung per E-Rezept - Aktualisieren eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-im-rahmen-der-dispensierung-per-e-rezept---aktualisieren-eines-emp-eintrags)
* Die Verknüpfung mit einem eMP-Eintrag kann bis zur Signatur des E-Rezepts bzw. Abschluss der Dispensierung wieder aufgehoben werden.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Wird eine Verschreibung oder Dispensierung begonnen, ohne, dass ein eMP-Eintrag referenziert ist, prüft das Primärsystem, ob bereits ein aktiver eMP-Eintrag mit einem vergleichbaren Arzneimittel existiert, um das E-Rezept ggf. mit einem bestehenden eMP-Eintrag zu verknüpfen oder einen neuen eMP-Eintrag anzulegen. Für diesen Abgleich ist bevorzugt der Wirkstoff (ASK- oder ATC-codiert) zu betrachten, aber auch Daten zum spezifischen Arzneimittel (bspw. Handelsname oder PZN) können genutzt werden. Primärsysteme, die vergleichbare Fragestellungen bspw. in einem AMTS-Modul betrachten, können auch eine komplexere Entscheidungsunterstützung anbieten. Es sollte vermieden werden, etwaige Hinweise als Push- oder Pop-Up-Benachrichtigungen darzustellen, die eine Interaktion des Anwenders mit dem Hinweis zwingend voraussetzen. Zu bevorzugen ist ein in den Arbeitsablauf und die Benutzeroberfläche integrierter Vorschlag, der direkt und aufwandsarm angenommen werden kann. Von diesem Anwendungsfall unbetroffen ist die Möglichkeit, einen zu referenzierenden eMP-Eintrag auch ohne Vorschlag des Primärsystems manuell auswählen zu können.: * [Lesezugriffe](./technical-use-cases.md#lesezugriffe)

* Beschreibung: Relevante(r) Sektor(en)
  * Wird eine Verschreibung oder Dispensierung begonnen, ohne, dass ein eMP-Eintrag referenziert ist, prüft das Primärsystem, ob bereits ein aktiver eMP-Eintrag mit einem vergleichbaren Arzneimittel existiert, um das E-Rezept ggf. mit einem bestehenden eMP-Eintrag zu verknüpfen oder einen neuen eMP-Eintrag anzulegen. Für diesen Abgleich ist bevorzugt der Wirkstoff (ASK- oder ATC-codiert) zu betrachten, aber auch Daten zum spezifischen Arzneimittel (bspw. Handelsname oder PZN) können genutzt werden. Primärsysteme, die vergleichbare Fragestellungen bspw. in einem AMTS-Modul betrachten, können auch eine komplexere Entscheidungsunterstützung anbieten. Es sollte vermieden werden, etwaige Hinweise als Push- oder Pop-Up-Benachrichtigungen darzustellen, die eine Interaktion des Anwenders mit dem Hinweis zwingend voraussetzen. Zu bevorzugen ist ein in den Arbeitsablauf und die Benutzeroberfläche integrierter Vorschlag, der direkt und aufwandsarm angenommen werden kann. Von diesem Anwendungsfall unbetroffen ist die Möglichkeit, einen zu referenzierenden eMP-Eintrag auch ohne Vorschlag des Primärsystems manuell auswählen zu können.: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Abgleich geplantes Arzneimittel - eMP
### Pflege des eMP im Rahmen der Rezeptierung per E-Rezept - Anlage eines eMP-Eintrags

* Beschreibung: Vorbedingungen
  * Die ärztliche Medikationsplanung mündet häufig in einer Verschreibung. Im Rahmen der Verschreibung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag angelegt werden, um den eMP gemäß der Medikationsplanung zu aktualisieren. So wird der Medikationsplan gepflegt und eine Mehrfachdokumentation vermieden. Es ist zu empfehlen, den gesamten eMP im Laufe des Prozesses – spätestens nach Signatur des E-Rezepts – anzuzeigen, da die Aufnahme einer neuen Therapie auch Konsequenzen für die sonstige Arzneimitteltherapie haben kann. Eine im Hintergrund laufende AMTS-Prüfung kann dabei unterstützen.: * Der Anwender plant, ein Arzneimittel zu verschreiben und hat diesen Vorgang ohne Bezug zu einem bestehenden eMP-Eintrag begonnen (initial kein eMP-Identifier vorhanden).
* Das Primärsystem hat geprüft, ob für den Versicherten ein eMP in der ePA hinterlegt ist. Das ist der Fall.
* Ein Abgleich zwischen dem geplantem Arzneimittel und dem eMP hat keinen vergleichbaren eMP-Eintrag identifiziert. Vgl. [Abgleich geplantes Arzneimittel - eMP](dgmp-use-cases.md#abgleich-geplantes-arzneimittel---emp)
* Für diese Verschreibungen unter diesen Bedingungen ist die Anlage eines eMP-Eintrags standardmäßig aktiviert oder wurde vom Anwender manuell ausgelöst.

* Beschreibung: Durchzuführende Aktionen
  * Die ärztliche Medikationsplanung mündet häufig in einer Verschreibung. Im Rahmen der Verschreibung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag angelegt werden, um den eMP gemäß der Medikationsplanung zu aktualisieren. So wird der Medikationsplan gepflegt und eine Mehrfachdokumentation vermieden. Es ist zu empfehlen, den gesamten eMP im Laufe des Prozesses – spätestens nach Signatur des E-Rezepts – anzuzeigen, da die Aufnahme einer neuen Therapie auch Konsequenzen für die sonstige Arzneimitteltherapie haben kann. Eine im Hintergrund laufende AMTS-Prüfung kann dabei unterstützen.: * Der Anwender gibt mindestens die Pflichtinformationen für das E-Rezept an. Die Dosierung wird nicht als “DJ” angegeben.
* Der Anwender gibt optional weitere Informationen für den eMP-Eintrag an (z.B. den versichertenverständlichen “Grund”) und kann bei Bedarf den Status anpassen (Standardeinstellung: “aktiv”).
* Der Anwender schließt die Bearbeitung des eMP-Eintrags und des E-Rezepts ab.
* Das Primärsystem kreiert einen eMP-Eintrag im ePA-Aktensystem und übergibt den eMP-Identifier an den Verordnungsdatensatz.
* Der Anwender signiert das E-Rezept.
* Das Primärsystem sendet den Verordnungsdatensatz an den E-Rezept-Fachdienst.
* Der E-Rezept-Fachdienst sendet den Verordnungsdatensatz an das ePA-Aktensystem.

* Beschreibung: Nachbedingungen
  * Die ärztliche Medikationsplanung mündet häufig in einer Verschreibung. Im Rahmen der Verschreibung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag angelegt werden, um den eMP gemäß der Medikationsplanung zu aktualisieren. So wird der Medikationsplan gepflegt und eine Mehrfachdokumentation vermieden. Es ist zu empfehlen, den gesamten eMP im Laufe des Prozesses – spätestens nach Signatur des E-Rezepts – anzuzeigen, da die Aufnahme einer neuen Therapie auch Konsequenzen für die sonstige Arzneimitteltherapie haben kann. Eine im Hintergrund laufende AMTS-Prüfung kann dabei unterstützen.: * Die Verordnung wird in der eML angezeigt. Der Anwender kann erkennen, dass eine Verknüpfung mit einem eMP-Eintrag vorliegt.
* Der Anwender kann im eMP erkennen, dass eine Verknüpfung mit einem eML-Eintrag vorliegt.
* Der Anwender kann nachträgliche Änderungen am eMP-Eintrag vornehmen.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Die ärztliche Medikationsplanung mündet häufig in einer Verschreibung. Im Rahmen der Verschreibung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag angelegt werden, um den eMP gemäß der Medikationsplanung zu aktualisieren. So wird der Medikationsplan gepflegt und eine Mehrfachdokumentation vermieden. Es ist zu empfehlen, den gesamten eMP im Laufe des Prozesses – spätestens nach Signatur des E-Rezepts – anzuzeigen, da die Aufnahme einer neuen Therapie auch Konsequenzen für die sonstige Arzneimitteltherapie haben kann. Eine im Hintergrund laufende AMTS-Prüfung kann dabei unterstützen.: * [Anwendungsfall: Verordnung, Verschreibung und Dispensierung mit dem eMP](./technical-use-cases.md#anwendungsfall-verordnung-verschreibung-und-dispensierung-mit-dem-emp)

* Beschreibung: Relevante(r) Sektor(en)
  * Die ärztliche Medikationsplanung mündet häufig in einer Verschreibung. Im Rahmen der Verschreibung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag angelegt werden, um den eMP gemäß der Medikationsplanung zu aktualisieren. So wird der Medikationsplan gepflegt und eine Mehrfachdokumentation vermieden. Es ist zu empfehlen, den gesamten eMP im Laufe des Prozesses – spätestens nach Signatur des E-Rezepts – anzuzeigen, da die Aufnahme einer neuen Therapie auch Konsequenzen für die sonstige Arzneimitteltherapie haben kann. Eine im Hintergrund laufende AMTS-Prüfung kann dabei unterstützen.: (ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Pflege des eMP im Rahmen der Rezeptierung per E-Rezept - Anlage eines eMP-Eintrags
### Pflege des eMP im Rahmen der Rezeptierung per E-Rezept - Aktualisieren eines eMP-Eintrags

* Beschreibung: Vorbedingungen
  * Die ärztliche Medikationsplanung mündet häufig in einer Rezeptierung. Im Rahmen der Rezeptierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag aktualisiert werden, um den eMP gemäß der Medikationsplanung zu aktualisieren. So wird der Medikationsplan gepflegt und eine Mehrfachdokumentation vermieden.: * Der Anwender plant, ein Arzneimittel zu verschreiben.
* Das Primärsystem kann auf die ePA des Versicherten zugreifen.

* Beschreibung: Durchzuführende Aktionen
  * Die ärztliche Medikationsplanung mündet häufig in einer Rezeptierung. Im Rahmen der Rezeptierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag aktualisiert werden, um den eMP gemäß der Medikationsplanung zu aktualisieren. So wird der Medikationsplan gepflegt und eine Mehrfachdokumentation vermieden.: * Der Anwender stellt einen Bezug zwischen der geplanten Verschreibung und einem bestehenden eMP-Eintrag her. Dies kann bspw. ausgelöst werden durch: 
* Die Verschreibung wird als Folgeverordnung aus dem eMP begonnen.
* Die Verschreibung wird als Folgeverordnung aus der eML oder einem lokalen Kontext (z.B. Verordnungshistorie/Medikationsplan) begonnen. Dort ist ein eMP-Identifier für einen eMP-Eintrag hinterlegt, welcher dem Anwender zur Anzeige gebracht wird.
* Der Abgleich zwischen einem geplantem Arzneimittel und dem eMP hat einen vergleichbaren eMP-Eintrag identifiziert und der Anwender hat diese Zuordnung bestätigt. Vgl. [Abgleich_geplantes_Arzneimittel_eMP](dgmp-use-cases.md#abgleich-geplantes-arzneimittel---emp)
 
* Der Anwender editiert bei Bedarf die Informationen zum Arzneimittel für das E-Rezept.
* Der Anwender editiert bei Bedarf die weiteren Informationen des eMP-Eintrags (bspw. “Hinweise” für den Versicherten) und stellt dabei sicher, dass mindestens ein Status und eine Dosierung vorhanden sind.
* Der Anwender schließt die Bearbeitung des eMP-Eintrags und des E-Rezepts ab.
* Der Anwender bestätigt die Verknüpfung des eMP-Eintrags mit dem ausgefüllten E-Rezept.
* Der Anwender signiert das E-Rezept.
* Das Primärsystem sendet den Verordnungsdatensatz an den E-Rezept-Fachdienst.
* Das Primärsystem aktualisiert den eMP-Eintrag.
* Der E-Rezept-Fachdienst sendet den Verordnungsdatensatz an das ePA-Aktensystem.

* Beschreibung: Nachbedingungen
  * Die ärztliche Medikationsplanung mündet häufig in einer Rezeptierung. Im Rahmen der Rezeptierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag aktualisiert werden, um den eMP gemäß der Medikationsplanung zu aktualisieren. So wird der Medikationsplan gepflegt und eine Mehrfachdokumentation vermieden.: * Die Verordnung wird in der eML angezeigt. Der Anwender kann erkennen, dass eine Verknüpfung mit einem eMP-Eintrag vorliegt.
* Der Anwender kann im eMP erkennen, dass eine Verknüpfung mit einem eML-Eintrag vorliegt.
* Der Anwender kann nachträgliche Änderungen am eMP-Eintrag vornehmen.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Die ärztliche Medikationsplanung mündet häufig in einer Rezeptierung. Im Rahmen der Rezeptierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag aktualisiert werden, um den eMP gemäß der Medikationsplanung zu aktualisieren. So wird der Medikationsplan gepflegt und eine Mehrfachdokumentation vermieden.: * [Anwendungsfall: Verordnung, Verschreibung und Dispensierung mit dem eMP](./technical-use-cases.md#anwendungsfall-verordnung-verschreibung-und-dispensierung-mit-dem-emp)
* [Anwendungsfall: Aktualisierung eines eMP-Eintrags](./technical-use-cases.md#anwendungsfall-aktualisierung-eines-emp-eintrags)
* [Lesezugriffe](./technical-use-cases.md#lesezugriffe)

* Beschreibung: Relevante(r) Sektor(en)
  * Die ärztliche Medikationsplanung mündet häufig in einer Rezeptierung. Im Rahmen der Rezeptierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag aktualisiert werden, um den eMP gemäß der Medikationsplanung zu aktualisieren. So wird der Medikationsplan gepflegt und eine Mehrfachdokumentation vermieden.: (ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Pflege des eMP im Rahmen der Rezeptierung per E-Rezept - Aktualisieren eines eMP-Eintrags
### Pflege des eMP im Rahmen der Dispensierung per E-Rezept - Anlage eines eMP-Eintrags

* Beschreibung: Vorbedingungen
  * In der Apotheke werden E-Rezepte abgerufen und eingelöst, um Arzneimittel auf Basis von ärztlichen Verordnungen zu dispensieren und Informationen zu dieser Dispensierung zu dokumentieren. Im Rahmen einer solchen Dispensierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag angelegt werden, um den eMP gemäß der pharmazeutischen Beratung und entsprechend dem abgegebenen Arzneimittel zu aktualisieren. Dies ist nur erforderlich, sofern der verordnende Arzt das E-Rezept ohne Bezug zum eMP (d.h. ohne eMP-Identifier) ausgestellt hat.: * Das E-Rezept wird erfolgreich vom E-Rezept-Fachdienst abgerufen.
* Der Verordnungsdatensatz des E-Rezepts enthält keinen eMP-Identifier, der es einem eMP-Eintrag zuordnet.
* Das Primärsystem hat geprüft, ob für den Versicherten ein eMP in der ePA hinterlegt ist. Das ist der Fall.
* Ein Abgleich zwischen dem abzugebenden Arzneimittel und dem eMP hat keinen vergleichbaren eMP-Eintrag identifiziert.
* Der Anwender plant, das Arzneimittel an den Versicherten abzugeben.
* Für E-Rezepte ohne eMP-Identifier bei vorhandenem eMP ist die Anlage eines eMP-Eintrags standardmäßig aktiviert oder wurde vom Anwender manuell ausgelöst.

* Beschreibung: Durchzuführende Aktionen
  * In der Apotheke werden E-Rezepte abgerufen und eingelöst, um Arzneimittel auf Basis von ärztlichen Verordnungen zu dispensieren und Informationen zu dieser Dispensierung zu dokumentieren. Im Rahmen einer solchen Dispensierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag angelegt werden, um den eMP gemäß der pharmazeutischen Beratung und entsprechend dem abgegebenen Arzneimittel zu aktualisieren. Dies ist nur erforderlich, sofern der verordnende Arzt das E-Rezept ohne Bezug zum eMP (d.h. ohne eMP-Identifier) ausgestellt hat.: * Sofern Dosierung als “DJ” angegeben: Der Anwender ergänzt eine Dosierangabe.
* Der Anwender gibt optional weitere Informationen für den eMP-Eintrag an (z.B. den versichertenverständlichen “Grund”) und kann bei Bedarf den Status anpassen (Standardeinstellung: “aktiv”).
* Das Primärsystem kreiert einen eMP-Eintrag im ePA-Aktensystem und verknüpft diesen mit dem eML-Eintrag zu diesem E-Rezept.
* Der Anwender schließt die Dispensierung ab.
* Das Primärsystem sendet den Dispensierdatensatz an den E-Rezept-Fachdienst.
* Der E-Rezept-Fachdienst sendet den Dispensierdatensatz an das ePA-Aktensystem.

* Beschreibung: Nachbedingungen
  * In der Apotheke werden E-Rezepte abgerufen und eingelöst, um Arzneimittel auf Basis von ärztlichen Verordnungen zu dispensieren und Informationen zu dieser Dispensierung zu dokumentieren. Im Rahmen einer solchen Dispensierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag angelegt werden, um den eMP gemäß der pharmazeutischen Beratung und entsprechend dem abgegebenen Arzneimittel zu aktualisieren. Dies ist nur erforderlich, sofern der verordnende Arzt das E-Rezept ohne Bezug zum eMP (d.h. ohne eMP-Identifier) ausgestellt hat.: * Die Verordnung wird in der eML angezeigt. Der Anwender kann erkennen, dass eine Verknüpfung mit einem eMP-Eintrag vorliegt.
* Das Arzneimittel aus der Verordnung wird auf dem eMP angezeigt. Der Anwender kann erkennen, dass eine Verknüpfung mit einem eML-Eintrag vorliegt.
* Der Anwender kann nachträgliche Änderungen am eMP-Eintrag vornehmen.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * In der Apotheke werden E-Rezepte abgerufen und eingelöst, um Arzneimittel auf Basis von ärztlichen Verordnungen zu dispensieren und Informationen zu dieser Dispensierung zu dokumentieren. Im Rahmen einer solchen Dispensierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag angelegt werden, um den eMP gemäß der pharmazeutischen Beratung und entsprechend dem abgegebenen Arzneimittel zu aktualisieren. Dies ist nur erforderlich, sofern der verordnende Arzt das E-Rezept ohne Bezug zum eMP (d.h. ohne eMP-Identifier) ausgestellt hat.: * [Anwendungsfall: Nachtrag im eMP](./technical-use-cases.md#anwendungsfall-nachtrag-im-emp)
* [Anwendungsfall: Hinzufügen und Entfernen einer eML-eMP-Verknüpfung](./technical-use-cases.md#anwendungsfall-hinzufügen-und-entfernen-einer-eml-emp-verknüpfung)

* Beschreibung: Relevante(r) Sektor(en)
  * In der Apotheke werden E-Rezepte abgerufen und eingelöst, um Arzneimittel auf Basis von ärztlichen Verordnungen zu dispensieren und Informationen zu dieser Dispensierung zu dokumentieren. Im Rahmen einer solchen Dispensierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag angelegt werden, um den eMP gemäß der pharmazeutischen Beratung und entsprechend dem abgegebenen Arzneimittel zu aktualisieren. Dies ist nur erforderlich, sofern der verordnende Arzt das E-Rezept ohne Bezug zum eMP (d.h. ohne eMP-Identifier) ausgestellt hat.: APOTHEKER

**Tabelle:**Fachlicher Anwendungsfall Pflege des eMP im Rahmen der Dispensierung per E-Rezept - Anlage eines eMP-Eintrags
### Pflege des eMP im Rahmen der Dispensierung per E-Rezept - Aktualisieren eines eMP-Eintrags

* Beschreibung: Vorbedingungen
  * In der Apotheke werden E-Rezepte abgerufen, eingelöst und quittiert, um Arzneimittel auf Basis von ärztlichen Verordnungen zu dispensieren und Informationen zu dieser Dispensierung zu dokumentieren. Im Rahmen einer solchen Dispensierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag aktualisiert werden, um den eMP gemäß der pharmazeutischen Beratung und entsprechend dem abgegebenen Arzneimittel zu aktualisieren.: * Das E-Rezept wird erfolgreich vom E-Rezept-Fachdienst abgerufen.
* Der Verordnungsdatensatz des E-Rezepts enthält keinen eMP-Identifier, der es einem eMP-Eintrag zuordnet.
* Das Primärsystem hat geprüft, ob für den Versicherten ein eMP in der ePA hinterlegt ist. Das ist der Fall.
* Ein Abgleich zwischen dem abzugebenden Arzneimittel und dem eMP (durch das Primärsystem oder den Anwender) hat einen vergleichbaren eMP-Eintrag identifiziert.
* Der Anwender plant, das Arzneimittel an den Versicherten abzugeben.

* Beschreibung: Durchzuführende Aktionen
  * In der Apotheke werden E-Rezepte abgerufen, eingelöst und quittiert, um Arzneimittel auf Basis von ärztlichen Verordnungen zu dispensieren und Informationen zu dieser Dispensierung zu dokumentieren. Im Rahmen einer solchen Dispensierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag aktualisiert werden, um den eMP gemäß der pharmazeutischen Beratung und entsprechend dem abgegebenen Arzneimittel zu aktualisieren.: * Der Anwender bestätigt die Auswahl des eMP-Eintrags.
* Der Anwender editiert bei Bedarf die Informationen des eMP-Eintrags (bspw. “Hinweise” für den Versicherten) und stellt dabei sicher, dass mindestens ein Status und eine Dosierung vorhanden sind.
* Das Primärsystem aktualisiert den eMP-Eintrag und verknüpft ihn mit dem eML-Eintrag zu diesem E-Rezept.
* Der Anwender schließt die Dispensierung ab.
* Das Primärsystem sendet den Dispensierdatensatz an den E-Rezept-Fachdienst.
* Der E-Rezept-Fachdienst sendet den Dispensierdatensatz an das ePA-Aktensystem.

* Beschreibung: Nachbedingungen
  * In der Apotheke werden E-Rezepte abgerufen, eingelöst und quittiert, um Arzneimittel auf Basis von ärztlichen Verordnungen zu dispensieren und Informationen zu dieser Dispensierung zu dokumentieren. Im Rahmen einer solchen Dispensierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag aktualisiert werden, um den eMP gemäß der pharmazeutischen Beratung und entsprechend dem abgegebenen Arzneimittel zu aktualisieren.: * Die Verordnung wird in der eML angezeigt. Der Anwender kann erkennen, dass eine Verknüpfung mit einem eMP-Eintrag vorliegt.
* Das Arzneimittel aus der Verordnung wird auf dem eMP angezeigt. Der Anwender kann erkennen, dass eine Verknüpfung mit einem eML-Eintrag vorliegt.
* Der Anwender kann nachträgliche Änderungen am eMP-Eintrag vornehmen.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * In der Apotheke werden E-Rezepte abgerufen, eingelöst und quittiert, um Arzneimittel auf Basis von ärztlichen Verordnungen zu dispensieren und Informationen zu dieser Dispensierung zu dokumentieren. Im Rahmen einer solchen Dispensierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag aktualisiert werden, um den eMP gemäß der pharmazeutischen Beratung und entsprechend dem abgegebenen Arzneimittel zu aktualisieren.: * [Anwendungsfall: Aktualisierung eines eMP-Eintrags](./technical-use-cases.md#anwendungsfall-aktualisierung-eines-emp-eintrags)
* [Anwendungsfall: Hinzufügen und Entfernen einer eML-eMP-Verknüpfung](./technical-use-cases.md#anwendungsfall-hinzufügen-und-entfernen-einer-eml-emp-verknüpfung)

* Beschreibung: Relevante(r) Sektor(en)
  * In der Apotheke werden E-Rezepte abgerufen, eingelöst und quittiert, um Arzneimittel auf Basis von ärztlichen Verordnungen zu dispensieren und Informationen zu dieser Dispensierung zu dokumentieren. Im Rahmen einer solchen Dispensierung eines Arzneimittels per E-Rezept kann ein eMP-Eintrag aktualisiert werden, um den eMP gemäß der pharmazeutischen Beratung und entsprechend dem abgegebenen Arzneimittel zu aktualisieren.: APOTHEKER

**Tabelle:**Fachlicher Anwendungsfall Pflege des eMP im Rahmen der Dispensierung per E-Rezept - Aktualisieren eines eMP-Eintrags
### Abgleich von eML und eMP

* Beschreibung: Vorbedingungen
  * Sowohl in der eML als auch im eMP findet der Anwender Informationen zur Arzneimitteltherapie vor. Da die eML über das E-Rezept ohne Zutun der Leistungserbringer gepflegt wird, kann es vorkommen, dass Arzneimittel in der eML abgebildet sind, die keinen Bezug zum eMP haben. Ein Abgleich zwischen eML und eMP soll diese Arzneimittel identifizieren, damit sie gesondert betrachtet und bei Bedarf auf dem eMP ergänzt werden können. Der Abgleich kann beispielsweise als Filterfunktionalität angeboten oder bereits bei der Anzeige der eML visualisiert werden. Das Primärsystem kann dabei auch eine Einschätzung vornehmen, ob die identifizierten Arzneimittel auf der eML ggf. einem bestehenden eMP-Eintrag zugeordnet werden könnten oder noch kein vergleichbares Arzneimittel auf dem eMP abgebildet ist. Für diesen Abgleich ist bevorzugt der Wirkstoff (ASK- oder ATC-codiert) zu betrachten, aber auch Daten zum spezifischen Arzneimittel (bspw. Handelsname oder PZN) können genutzt werden.: * Der Anwender befindet sich in der Ansicht der eML oder des eMP.

* Beschreibung: Durchzuführende Aktionen
  * Sowohl in der eML als auch im eMP findet der Anwender Informationen zur Arzneimitteltherapie vor. Da die eML über das E-Rezept ohne Zutun der Leistungserbringer gepflegt wird, kann es vorkommen, dass Arzneimittel in der eML abgebildet sind, die keinen Bezug zum eMP haben. Ein Abgleich zwischen eML und eMP soll diese Arzneimittel identifizieren, damit sie gesondert betrachtet und bei Bedarf auf dem eMP ergänzt werden können. Der Abgleich kann beispielsweise als Filterfunktionalität angeboten oder bereits bei der Anzeige der eML visualisiert werden. Das Primärsystem kann dabei auch eine Einschätzung vornehmen, ob die identifizierten Arzneimittel auf der eML ggf. einem bestehenden eMP-Eintrag zugeordnet werden könnten oder noch kein vergleichbares Arzneimittel auf dem eMP abgebildet ist. Für diesen Abgleich ist bevorzugt der Wirkstoff (ASK- oder ATC-codiert) zu betrachten, aber auch Daten zum spezifischen Arzneimittel (bspw. Handelsname oder PZN) können genutzt werden.: * Der Anwender wählt an, dass er eML und eMP vergleichen möchte.
* Der Anwender schränkt bei Bedarf den Zeitraum ein, aus dem Arzneimittel berücksichtigt werden sollen. Ggf. können weitere Parameter angepasst werden.
* Das Primärsystem führt einen Abgleich durch und zeigt die Ergebnisse an. 
* Arzneimittel in der eML, die keinen Bezug zum eMP haben, werden hervorgehoben.
* Der Zeitpunkt der letzten Aktualisierung des eMP kann angezeigt und in einer chronologischer Ansicht der eML visualisiert werden.
 

* Beschreibung: Nachbedingungen
  * Sowohl in der eML als auch im eMP findet der Anwender Informationen zur Arzneimitteltherapie vor. Da die eML über das E-Rezept ohne Zutun der Leistungserbringer gepflegt wird, kann es vorkommen, dass Arzneimittel in der eML abgebildet sind, die keinen Bezug zum eMP haben. Ein Abgleich zwischen eML und eMP soll diese Arzneimittel identifizieren, damit sie gesondert betrachtet und bei Bedarf auf dem eMP ergänzt werden können. Der Abgleich kann beispielsweise als Filterfunktionalität angeboten oder bereits bei der Anzeige der eML visualisiert werden. Das Primärsystem kann dabei auch eine Einschätzung vornehmen, ob die identifizierten Arzneimittel auf der eML ggf. einem bestehenden eMP-Eintrag zugeordnet werden könnten oder noch kein vergleichbares Arzneimittel auf dem eMP abgebildet ist. Für diesen Abgleich ist bevorzugt der Wirkstoff (ASK- oder ATC-codiert) zu betrachten, aber auch Daten zum spezifischen Arzneimittel (bspw. Handelsname oder PZN) können genutzt werden.: * Anwender kann (bei vorhandener Berechtigung) entscheiden, ob die betroffenen Arzneimittel auf den eMP aufgenommen werden sollen. Vgl. [Pflege des eMP aus der eML - Aktualisierung eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-aus-der-eml---aktualisierung-eines-emp-eintrags), [Pflege des eMP aus der eML - Anlage eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-aus-der-eml---anlage-eines-emp-eintrags)

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Sowohl in der eML als auch im eMP findet der Anwender Informationen zur Arzneimitteltherapie vor. Da die eML über das E-Rezept ohne Zutun der Leistungserbringer gepflegt wird, kann es vorkommen, dass Arzneimittel in der eML abgebildet sind, die keinen Bezug zum eMP haben. Ein Abgleich zwischen eML und eMP soll diese Arzneimittel identifizieren, damit sie gesondert betrachtet und bei Bedarf auf dem eMP ergänzt werden können. Der Abgleich kann beispielsweise als Filterfunktionalität angeboten oder bereits bei der Anzeige der eML visualisiert werden. Das Primärsystem kann dabei auch eine Einschätzung vornehmen, ob die identifizierten Arzneimittel auf der eML ggf. einem bestehenden eMP-Eintrag zugeordnet werden könnten oder noch kein vergleichbares Arzneimittel auf dem eMP abgebildet ist. Für diesen Abgleich ist bevorzugt der Wirkstoff (ASK- oder ATC-codiert) zu betrachten, aber auch Daten zum spezifischen Arzneimittel (bspw. Handelsname oder PZN) können genutzt werden.: * [Lesezugriffe](./technical-use-cases.md#lesezugriffe)

* Beschreibung: Relevante(r) Sektor(en)
  * Sowohl in der eML als auch im eMP findet der Anwender Informationen zur Arzneimitteltherapie vor. Da die eML über das E-Rezept ohne Zutun der Leistungserbringer gepflegt wird, kann es vorkommen, dass Arzneimittel in der eML abgebildet sind, die keinen Bezug zum eMP haben. Ein Abgleich zwischen eML und eMP soll diese Arzneimittel identifizieren, damit sie gesondert betrachtet und bei Bedarf auf dem eMP ergänzt werden können. Der Abgleich kann beispielsweise als Filterfunktionalität angeboten oder bereits bei der Anzeige der eML visualisiert werden. Das Primärsystem kann dabei auch eine Einschätzung vornehmen, ob die identifizierten Arzneimittel auf der eML ggf. einem bestehenden eMP-Eintrag zugeordnet werden könnten oder noch kein vergleichbares Arzneimittel auf dem eMP abgebildet ist. Für diesen Abgleich ist bevorzugt der Wirkstoff (ASK- oder ATC-codiert) zu betrachten, aber auch Daten zum spezifischen Arzneimittel (bspw. Handelsname oder PZN) können genutzt werden.: APOTHEKER(ZAHN-)ARZTPFLEGEKRAFTVERSICHERTER

**Tabelle:**Fachlicher Anwendungsfall Abgleich von eML und eMP
### Pflege des eMP aus der eML - Anlage eines eMP-Eintrags

* Beschreibung: Vorbedingungen
  * Stellt ein Arzt oder Apotheker fest, dass ein Arzneimittel auf dem eMP fehlt, das aktuell angewendet wird, sollte es dort aufgenommen werden, damit der eMP die aktuelle Arzneimitteltherapie bestmöglich abbilden kann. Es ist möglich, dass solche Arzneimittel bereits auf der eML abgebildet sind, wenn sie bspw. per E-Rezept verordnet wurden. In diesem Fall können diese eML-Einträge ausgewählt werden, um eMP-Einträge zu erstellen.: * Der Anwender hat einen oder mehrere eML-Einträge ausgewählt, für die eMP-Einträge angelegt werden sollen.
* Der Anwender hat die Anlage der eMP-Einträge aus dem eMP oder der eML heraus begonnen.

* Beschreibung: Durchzuführende Aktionen
  * Stellt ein Arzt oder Apotheker fest, dass ein Arzneimittel auf dem eMP fehlt, das aktuell angewendet wird, sollte es dort aufgenommen werden, damit der eMP die aktuelle Arzneimitteltherapie bestmöglich abbilden kann. Es ist möglich, dass solche Arzneimittel bereits auf der eML abgebildet sind, wenn sie bspw. per E-Rezept verordnet wurden. In diesem Fall können diese eML-Einträge ausgewählt werden, um eMP-Einträge zu erstellen.: * Sofern in der eML noch nicht vorhanden: Der Anwender gibt die Dosierung des jeweiligen Arzneimittels an.
* Der Anwender ergänzt optional weitere Informationen für den eMP (bspw. versichertenverständlicher “Grund”) und passt bei Bedarf den Status an.
* Der Anwender bestätigt die Anlage der eMP-Einträge.
* Das Primärsystem legt die eMP-Einträge im ePA-Aktensystem an, verknüpft die eML-Einträge und zeigt eine Bestätigung an.

* Beschreibung: Nachbedingungen
  * Stellt ein Arzt oder Apotheker fest, dass ein Arzneimittel auf dem eMP fehlt, das aktuell angewendet wird, sollte es dort aufgenommen werden, damit der eMP die aktuelle Arzneimitteltherapie bestmöglich abbilden kann. Es ist möglich, dass solche Arzneimittel bereits auf der eML abgebildet sind, wenn sie bspw. per E-Rezept verordnet wurden. In diesem Fall können diese eML-Einträge ausgewählt werden, um eMP-Einträge zu erstellen.: * Der Anwender kann sich den aktualisierten eMP anzeigen lassen; die neuen eMP-Einträge werden visuell hervorgehoben. Vgl. [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp)
* Der Anwender kann in der eML erkennen, dass eine Verknüpfung der eML-Einträge mit einem eMP-Eintrag vorliegt. Vgl. [Anzeige der elektronischen Medikationsliste (eML)](dgmp-use-cases.md#anzeige-der-elektronischen-medikationsliste-eml)

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Stellt ein Arzt oder Apotheker fest, dass ein Arzneimittel auf dem eMP fehlt, das aktuell angewendet wird, sollte es dort aufgenommen werden, damit der eMP die aktuelle Arzneimitteltherapie bestmöglich abbilden kann. Es ist möglich, dass solche Arzneimittel bereits auf der eML abgebildet sind, wenn sie bspw. per E-Rezept verordnet wurden. In diesem Fall können diese eML-Einträge ausgewählt werden, um eMP-Einträge zu erstellen.: * [Anwendungsfall: Nachtrag im eMP](./technical-use-cases.md#anwendungsfall-nachtrag-im-emp)
* [Anwendungsfall: Hinzufügen und Entfernen einer eML-eMP-Verknüpfung](./technical-use-cases.md#anwendungsfall-hinzufügen-und-entfernen-einer-eml-emp-verknüpfung)

* Beschreibung: Relevante(r) Sektor(en)
  * Stellt ein Arzt oder Apotheker fest, dass ein Arzneimittel auf dem eMP fehlt, das aktuell angewendet wird, sollte es dort aufgenommen werden, damit der eMP die aktuelle Arzneimitteltherapie bestmöglich abbilden kann. Es ist möglich, dass solche Arzneimittel bereits auf der eML abgebildet sind, wenn sie bspw. per E-Rezept verordnet wurden. In diesem Fall können diese eML-Einträge ausgewählt werden, um eMP-Einträge zu erstellen.: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Pflege des eMP aus der eML - Anlage eines eMP-Eintrags
### Pflege des eMP aus der eML - Aktualisierung eines eMP-Eintrags

* Beschreibung: Vorbedingungen
  * Stellt ein Arzt oder Apotheker fest, dass ein eMP-Eintrag nicht mehr aktuell ist, sollte der eMP-Eintrag aktualisiert werden, damit der eMP die aktuelle Arzneimitteltherapie bestmöglich abbilden kann. Das ist bspw. der Fall, wenn das Arzneimittel zwischenzeitlich erneut per E-Rezept verschrieben worden ist, ohne dass dies auf dem eMP abgebildet wurde. In diesem Fall kann einer oder mehrere eML-Einträge ausgewählt werden, um diese einem bestehenden eMP-Eintrag zuzuordnen und diesen zu aktualisieren. Die Anzeige des eMP-Eintrags speist sich aus dem chronologisch jüngsten eML-Eintrag, der mit ihm verknüpft ist (bspw. letzte Abgabe).: * Der Anwender befindet sich in der Ansicht der eML oder einem Split-View aus eML und eMP.
* Der Anwender hat einen oder mehrere eML-Einträge ausgewählt, die einem eMP-Eintrag zugeordnet werden sollen.

* Beschreibung: Durchzuführende Aktionen
  * Stellt ein Arzt oder Apotheker fest, dass ein eMP-Eintrag nicht mehr aktuell ist, sollte der eMP-Eintrag aktualisiert werden, damit der eMP die aktuelle Arzneimitteltherapie bestmöglich abbilden kann. Das ist bspw. der Fall, wenn das Arzneimittel zwischenzeitlich erneut per E-Rezept verschrieben worden ist, ohne dass dies auf dem eMP abgebildet wurde. In diesem Fall kann einer oder mehrere eML-Einträge ausgewählt werden, um diese einem bestehenden eMP-Eintrag zuzuordnen und diesen zu aktualisieren. Die Anzeige des eMP-Eintrags speist sich aus dem chronologisch jüngsten eML-Eintrag, der mit ihm verknüpft ist (bspw. letzte Abgabe).: * Der Anwender wählt den eMP-Eintrag aus, dem die eML-Einträge zuzuordnen ist (bspw. als “Drag and Drop” im Split View).
* Der Anwender editiert bei Bedarf die Informationen des eMP-Eintrags (bspw. “Hinweise” für den Versicherten) und stellt dabei sicher, dass mindestens ein Status und eine Dosierung vorhanden sind.
* Der Anwender bestätigt die Bearbeitung des eMP-Eintrags und die Verknüpfung.
* Das Primärsystem aktualisiert den eMP-Eintrag, verknüpft ihn mit den eML-Einträgen und zeigt eine Bestätigung an.

* Beschreibung: Nachbedingungen
  * Stellt ein Arzt oder Apotheker fest, dass ein eMP-Eintrag nicht mehr aktuell ist, sollte der eMP-Eintrag aktualisiert werden, damit der eMP die aktuelle Arzneimitteltherapie bestmöglich abbilden kann. Das ist bspw. der Fall, wenn das Arzneimittel zwischenzeitlich erneut per E-Rezept verschrieben worden ist, ohne dass dies auf dem eMP abgebildet wurde. In diesem Fall kann einer oder mehrere eML-Einträge ausgewählt werden, um diese einem bestehenden eMP-Eintrag zuzuordnen und diesen zu aktualisieren. Die Anzeige des eMP-Eintrags speist sich aus dem chronologisch jüngsten eML-Eintrag, der mit ihm verknüpft ist (bspw. letzte Abgabe).: * Der Anwender kann sich den aktualisierten eMP anzeigen lassen; der aktualisierte eMP-Eintrag wird visuell hervorgehoben. Vgl. [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp)
* Der Anwender kann in der eML erkennen, dass eine Verknüpfung der eML-Einträge mit einem eMP-Eintrag vorliegt. Vgl. [Anzeige der elektronischen Medikationsliste (eML)](dgmp-use-cases.md#anzeige-der-elektronischen-medikationsliste-eml)

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Stellt ein Arzt oder Apotheker fest, dass ein eMP-Eintrag nicht mehr aktuell ist, sollte der eMP-Eintrag aktualisiert werden, damit der eMP die aktuelle Arzneimitteltherapie bestmöglich abbilden kann. Das ist bspw. der Fall, wenn das Arzneimittel zwischenzeitlich erneut per E-Rezept verschrieben worden ist, ohne dass dies auf dem eMP abgebildet wurde. In diesem Fall kann einer oder mehrere eML-Einträge ausgewählt werden, um diese einem bestehenden eMP-Eintrag zuzuordnen und diesen zu aktualisieren. Die Anzeige des eMP-Eintrags speist sich aus dem chronologisch jüngsten eML-Eintrag, der mit ihm verknüpft ist (bspw. letzte Abgabe).: * [Anwendungsfall: Hinzufügen und Entfernen einer eML-eMP-Verknüpfung](./technical-use-cases.md#anwendungsfall-hinzufügen-und-entfernen-einer-eml-emp-verknüpfung)

* Beschreibung: Relevante(r) Sektor(en)
  * Stellt ein Arzt oder Apotheker fest, dass ein eMP-Eintrag nicht mehr aktuell ist, sollte der eMP-Eintrag aktualisiert werden, damit der eMP die aktuelle Arzneimitteltherapie bestmöglich abbilden kann. Das ist bspw. der Fall, wenn das Arzneimittel zwischenzeitlich erneut per E-Rezept verschrieben worden ist, ohne dass dies auf dem eMP abgebildet wurde. In diesem Fall kann einer oder mehrere eML-Einträge ausgewählt werden, um diese einem bestehenden eMP-Eintrag zuzuordnen und diesen zu aktualisieren. Die Anzeige des eMP-Eintrags speist sich aus dem chronologisch jüngsten eML-Eintrag, der mit ihm verknüpft ist (bspw. letzte Abgabe).: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Pflege des eMP aus der eML - Aktualisierung eines eMP-Eintrags
### Aufheben einer Verknüpfung

* Beschreibung: Vorbedingungen
  * Bei der Zuordnung von Arzneimitteln mitsamt Verschreibungen und Abgaben zu einem eMP-Eintrag können Fehler passieren. Ein solcher Fehler kann vom Anwender oder vom Primärsystem erkannt werden, bspw. da ein verknüpftes Arzneimittel nicht zu den vorangegangenen oder der angegebenen Indikation passt. Möchte ein Anwender einen solchen Fehler korrigieren, kann die Verknüpfung aufgehoben werden.: * Der Anwender befindet sich in der Ansicht des eMP.
* Der Anwender hat einen oder mehrere eML-Einträge ausgewählt, dessen Verknüpfung mit einem eMP-Eintrag er für fehlerhaft befindet.

* Beschreibung: Durchzuführende Aktionen
  * Bei der Zuordnung von Arzneimitteln mitsamt Verschreibungen und Abgaben zu einem eMP-Eintrag können Fehler passieren. Ein solcher Fehler kann vom Anwender oder vom Primärsystem erkannt werden, bspw. da ein verknüpftes Arzneimittel nicht zu den vorangegangenen oder der angegebenen Indikation passt. Möchte ein Anwender einen solchen Fehler korrigieren, kann die Verknüpfung aufgehoben werden.: * Der Anwender wählt eine Option aus, die ihm erlaubt, fehlerhafte Zuordnungen zu einem eMP-Eintrag zu markieren.
* Das Primärsystem hebt die Verknüpfung auf und setzt bei Bedarf die Informationen zum Arzneimittel im eMP auf die der chronologisch jüngeren Verknüpfung zurück.
* Das Primärsystem zeigt eine Bestätigung an.

* Beschreibung: Nachbedingungen
  * Bei der Zuordnung von Arzneimitteln mitsamt Verschreibungen und Abgaben zu einem eMP-Eintrag können Fehler passieren. Ein solcher Fehler kann vom Anwender oder vom Primärsystem erkannt werden, bspw. da ein verknüpftes Arzneimittel nicht zu den vorangegangenen oder der angegebenen Indikation passt. Möchte ein Anwender einen solchen Fehler korrigieren, kann die Verknüpfung aufgehoben werden.: * Der Anwender kann sich den aktualisierten eMP anzeigen lassen; der aktualisierte eMP-Eintrag wird visuell hervorgehoben. Vgl. [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp)
* Das Primärsystem bietet dem Anwender an, eine neue Verknüpfung herzustellen oder einen neuen eMP-Eintrag anzulegen. Vgl. [Pflege des eMP aus der eML - Anlage eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-aus-der-eml---anlage-eines-emp-eintrags), [Pflege des eMP aus der eML - Aktualisierung eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-aus-der-eml---aktualisierung-eines-emp-eintrags)

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Bei der Zuordnung von Arzneimitteln mitsamt Verschreibungen und Abgaben zu einem eMP-Eintrag können Fehler passieren. Ein solcher Fehler kann vom Anwender oder vom Primärsystem erkannt werden, bspw. da ein verknüpftes Arzneimittel nicht zu den vorangegangenen oder der angegebenen Indikation passt. Möchte ein Anwender einen solchen Fehler korrigieren, kann die Verknüpfung aufgehoben werden.: * [Anwendungsfall: Hinzufügen und Entfernen einer eML-eMP-Verknüpfung](./technical-use-cases.md#anwendungsfall-hinzufügen-und-entfernen-einer-eml-emp-verknüpfung)

* Beschreibung: Relevante(r) Sektor(en)
  * Bei der Zuordnung von Arzneimitteln mitsamt Verschreibungen und Abgaben zu einem eMP-Eintrag können Fehler passieren. Ein solcher Fehler kann vom Anwender oder vom Primärsystem erkannt werden, bspw. da ein verknüpftes Arzneimittel nicht zu den vorangegangenen oder der angegebenen Indikation passt. Möchte ein Anwender einen solchen Fehler korrigieren, kann die Verknüpfung aufgehoben werden.: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Aufheben einer Verknüpfung
### Nachtrag von Arzneimitteln

* Beschreibung: Vorbedingungen
  * Wurde ein Arzneimittel nicht über das E-Rezept verordnet und abgegeben, kann es in der ePA nachgetragen werden, um die eML und den eMP auf den aktuellen Wissensstand zu heben. Dies kann beispielsweise der Fall sein, wenn ein Papierrezept ausgestellt, ein rezeptfreies Arzneimittel in der Apotheke erworben wird oder ein Arzt oder Apotheker im Gespräch mit dem Versicherten erhebt, dass ein Arzneimittel angewandt wird, das noch nicht in der ePA abgebildet ist. Die Daten zum Nachtrag werden vorzugsweise vom Primärsystem aus einer Arzneimitteldatenbank (ggf. in Verbindung mit oder alternativ aus einem Verordnungsmodul oder einem Warenwirtschaftssystem) vorausgefüllt und nur in Ausnahmefällen händisch eingetragen. Bei der Verarbeitung von Rezeptdaten abseits des E-Rezepts (z. B. im Verordnungsprozess) kann die Option zum direkten Nachtragen auch standardmäßig aktiviert und nur bei Bedarf vom Anwender abgewählt werden. Auch hier sollten Informationen, die bspw. bei einem Fertigarzneimittel auf dem Rezept fehlen, durch eine Arzneimitteldatenbank ergänzt werden.: * Der Anwender befindet sich in einer Ansicht des Primärsystems oder der ePA (eML/eMP), in der Daten zur Arzneimitteltherapie des Versicherten angezeigt werden.

* Beschreibung: Durchzuführende Aktionen
  * Wurde ein Arzneimittel nicht über das E-Rezept verordnet und abgegeben, kann es in der ePA nachgetragen werden, um die eML und den eMP auf den aktuellen Wissensstand zu heben. Dies kann beispielsweise der Fall sein, wenn ein Papierrezept ausgestellt, ein rezeptfreies Arzneimittel in der Apotheke erworben wird oder ein Arzt oder Apotheker im Gespräch mit dem Versicherten erhebt, dass ein Arzneimittel angewandt wird, das noch nicht in der ePA abgebildet ist. Die Daten zum Nachtrag werden vorzugsweise vom Primärsystem aus einer Arzneimitteldatenbank (ggf. in Verbindung mit oder alternativ aus einem Verordnungsmodul oder einem Warenwirtschaftssystem) vorausgefüllt und nur in Ausnahmefällen händisch eingetragen. Bei der Verarbeitung von Rezeptdaten abseits des E-Rezepts (z. B. im Verordnungsprozess) kann die Option zum direkten Nachtragen auch standardmäßig aktiviert und nur bei Bedarf vom Anwender abgewählt werden. Auch hier sollten Informationen, die bspw. bei einem Fertigarzneimittel auf dem Rezept fehlen, durch eine Arzneimitteldatenbank ergänzt werden.: * Der Anwender startet den Nachtrag: 
* Der Anwender wählt im Primärsystem ein Arzneimittel aus, das nachgetragen werden soll.
* Alternativ: Der Anwender öffnet eine Maske für den Nachtrag eines Arzneimittels.
 
* Das Primärsystem füllt alle Datenfelder für Arzneimittel aus, die aus der lokalen Dokumentation und – sofern vorhanden – Arzneimitteldatenbank befüllt werden können.
* Sofern darüber hinaus erforderlich: Der Anwender ergänzt mindestens die Wirkstoffbezeichnung, die Darreichungsform und die Wirkstärke.
* Sofern das Arzneimittel auch auf dem eMP abgebildet werden soll: 
* Der Anwender gibt an, dass er einen eMP-Eintrag anlegen möchte und stellt sicher, dass mindestens eine Dosierung vorhanden ist. Er ergänzt optional weitere Informationen für den eMP (bspw. versichertenverständlicher “Grund”) und passt bei Bedarf den Status an.
* Alternativ: Der Anwender wählt einen bestehenden eMP-Eintrag aus, der diesem Nachtrag zugeordnet werden kann. Er editiert bei Bedarf die Informationen des eMP-Eintrags (bspw. “Hinweise” für den Versicherten) und stellt dabei sicher, dass mindestens ein Status und eine Dosierung vorhanden sind.
 
* Das Primärsystem kreiert einen Nachtrag für die eML und ggf. einen eMP-Eintrag im ePA-Aktensystem. Es stellt eine Verknüpfung zwischen dem Nachtrag und dem eMP-Eintrag her.
* Das Primärsystem zeigt eine Bestätigung an.

* Beschreibung: Nachbedingungen
  * Wurde ein Arzneimittel nicht über das E-Rezept verordnet und abgegeben, kann es in der ePA nachgetragen werden, um die eML und den eMP auf den aktuellen Wissensstand zu heben. Dies kann beispielsweise der Fall sein, wenn ein Papierrezept ausgestellt, ein rezeptfreies Arzneimittel in der Apotheke erworben wird oder ein Arzt oder Apotheker im Gespräch mit dem Versicherten erhebt, dass ein Arzneimittel angewandt wird, das noch nicht in der ePA abgebildet ist. Die Daten zum Nachtrag werden vorzugsweise vom Primärsystem aus einer Arzneimitteldatenbank (ggf. in Verbindung mit oder alternativ aus einem Verordnungsmodul oder einem Warenwirtschaftssystem) vorausgefüllt und nur in Ausnahmefällen händisch eingetragen. Bei der Verarbeitung von Rezeptdaten abseits des E-Rezepts (z. B. im Verordnungsprozess) kann die Option zum direkten Nachtragen auch standardmäßig aktiviert und nur bei Bedarf vom Anwender abgewählt werden. Auch hier sollten Informationen, die bspw. bei einem Fertigarzneimittel auf dem Rezept fehlen, durch eine Arzneimitteldatenbank ergänzt werden.: * Das Arzneimittel ist auf der eML als Nachtrag und ggf. auf dem eMP abgebildet.
* Der Anwender kann die Informationen zum eMP-Eintrag nachträglich editieren.
* Der Anwender kann den Nachtrag stornieren oder eine ggf. vorhandene Verknüpfung mit einem eMP-Eintrag auflösen.
* Sofern Informationen zum Arzneimittel auch lokal persistiert werden (z.B. bei Nachtrag aus einer Verordnungshistorie) ist dort nachvollziehbar, dass dieses Arzneimittel in der ePA nachgetragen wurde. Ein erneuter Nachtrag desselben Arzneimittels wird verhindert.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Wurde ein Arzneimittel nicht über das E-Rezept verordnet und abgegeben, kann es in der ePA nachgetragen werden, um die eML und den eMP auf den aktuellen Wissensstand zu heben. Dies kann beispielsweise der Fall sein, wenn ein Papierrezept ausgestellt, ein rezeptfreies Arzneimittel in der Apotheke erworben wird oder ein Arzt oder Apotheker im Gespräch mit dem Versicherten erhebt, dass ein Arzneimittel angewandt wird, das noch nicht in der ePA abgebildet ist. Die Daten zum Nachtrag werden vorzugsweise vom Primärsystem aus einer Arzneimitteldatenbank (ggf. in Verbindung mit oder alternativ aus einem Verordnungsmodul oder einem Warenwirtschaftssystem) vorausgefüllt und nur in Ausnahmefällen händisch eingetragen. Bei der Verarbeitung von Rezeptdaten abseits des E-Rezepts (z. B. im Verordnungsprozess) kann die Option zum direkten Nachtragen auch standardmäßig aktiviert und nur bei Bedarf vom Anwender abgewählt werden. Auch hier sollten Informationen, die bspw. bei einem Fertigarzneimittel auf dem Rezept fehlen, durch eine Arzneimitteldatenbank ergänzt werden.: * [Anwendungsfall: Nachtrag in der eML](./technical-use-cases.md#anwendungsfall-nachtrag-in-der-eml)
* [Anwendungsfall: Nachtrag im eMP](./technical-use-cases.md#anwendungsfall-nachtrag-im-emp)
* [Anwendungsfall: Hinzufügen und Entfernen einer eML-eMP-Verknüpfung](./technical-use-cases.md#anwendungsfall-hinzufügen-und-entfernen-einer-eml-emp-verknüpfung)
* [Lesezugriffe](./technical-use-cases.md#lesezugriffe)

* Beschreibung: Relevante(r) Sektor(en)
  * Wurde ein Arzneimittel nicht über das E-Rezept verordnet und abgegeben, kann es in der ePA nachgetragen werden, um die eML und den eMP auf den aktuellen Wissensstand zu heben. Dies kann beispielsweise der Fall sein, wenn ein Papierrezept ausgestellt, ein rezeptfreies Arzneimittel in der Apotheke erworben wird oder ein Arzt oder Apotheker im Gespräch mit dem Versicherten erhebt, dass ein Arzneimittel angewandt wird, das noch nicht in der ePA abgebildet ist. Die Daten zum Nachtrag werden vorzugsweise vom Primärsystem aus einer Arzneimitteldatenbank (ggf. in Verbindung mit oder alternativ aus einem Verordnungsmodul oder einem Warenwirtschaftssystem) vorausgefüllt und nur in Ausnahmefällen händisch eingetragen. Bei der Verarbeitung von Rezeptdaten abseits des E-Rezepts (z. B. im Verordnungsprozess) kann die Option zum direkten Nachtragen auch standardmäßig aktiviert und nur bei Bedarf vom Anwender abgewählt werden. Auch hier sollten Informationen, die bspw. bei einem Fertigarzneimittel auf dem Rezept fehlen, durch eine Arzneimitteldatenbank ergänzt werden.: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Nachtrag von Arzneimitteln
### Korrektur eines Nachtrags

* Beschreibung: Vorbedingungen
  * Beim Nachtrag eines Arzneimittels können Fehler passieren. Möchte ein Anwender einen solchen Fehler korrigieren, kann er den ursprünglichen Nachtrag (unabhängig vom Urheber) als ungültig kennzeichnen und einen neuen Nachtrag verfassen. Dies ist unabhängig davon, ob er der Urheber des Nachtrags war.: * Der Anwender befindet sich in der eML-Ansicht.
* Der Anwender hat einen eML-Eintrag ausgewählt, den er für ungültig befindet.

* Beschreibung: Durchzuführende Aktionen
  * Beim Nachtrag eines Arzneimittels können Fehler passieren. Möchte ein Anwender einen solchen Fehler korrigieren, kann er den ursprünglichen Nachtrag (unabhängig vom Urheber) als ungültig kennzeichnen und einen neuen Nachtrag verfassen. Dies ist unabhängig davon, ob er der Urheber des Nachtrags war.: * Der Anwender wählt die Option “Fehlerhafter Eintrag”.
* Der Anwender bestätigt, dass er den Nachtrag als fehlerhaft markieren möchte (umgangssprachlich: löschen).
* Das Primärsystem aktualisiert den Status des eML-Eintrags zu “entered in error” und zeigt eine Bestätigung an.
* Sofern der Nachtrag die jüngste Verknüpfung zu einem eMP-Eintrag dargestellt hat: Das Primärsystem setzt den eMP-Eintrag auf den letzten Zustand vor der Verknüpfung dieses Nachtrags zurück.

* Beschreibung: Nachbedingungen
  * Beim Nachtrag eines Arzneimittels können Fehler passieren. Möchte ein Anwender einen solchen Fehler korrigieren, kann er den ursprünglichen Nachtrag (unabhängig vom Urheber) als ungültig kennzeichnen und einen neuen Nachtrag verfassen. Dies ist unabhängig davon, ob er der Urheber des Nachtrags war.: * Der Nachtrag wird in eML und eMP ausgeblendet. Soll er angezeigt werden, ist nachvollziehbar, dass er als fehlerhaft bewertet wurde.
* Der Anwender kann einen neuen Nachtrag verfassen. Informationen aus dem fehlerhaften Nachtrag können anteilig übernommen werden. Vgl. [Nachtrag von Arzneimitteln](dgmp-use-cases.md#nachtrag-von-arzneimitteln)

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Beim Nachtrag eines Arzneimittels können Fehler passieren. Möchte ein Anwender einen solchen Fehler korrigieren, kann er den ursprünglichen Nachtrag (unabhängig vom Urheber) als ungültig kennzeichnen und einen neuen Nachtrag verfassen. Dies ist unabhängig davon, ob er der Urheber des Nachtrags war.: * [Anwendungsfall: Aktualisierung eines eML-Eintrags](./technical-use-cases.md#anwendungsfall-stornierung-eines-eml-eintrags)

* Beschreibung: Relevante(r) Sektor(en)
  * Beim Nachtrag eines Arzneimittels können Fehler passieren. Möchte ein Anwender einen solchen Fehler korrigieren, kann er den ursprünglichen Nachtrag (unabhängig vom Urheber) als ungültig kennzeichnen und einen neuen Nachtrag verfassen. Dies ist unabhängig davon, ob er der Urheber des Nachtrags war.: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Korrektur eines Nachtrags
### Editieren von eMP-Einträgen

* Beschreibung: Vorbedingungen
  * Ein eMP-Eintrag kann nach seiner Anlage editiert werden. Dies kann der Fall sein, wenn sich neue Erkenntnisse ergeben oder die Therapie angepasst wird. Hiervon betroffen sind alle eMP-spezifischen Informationen (Indikation, versichertenverständlicher “Grund”, “Hinweise” für den Versicherten, “Hinweise für Mitbehandelnde”, Start- und Enddatum) sowie die Dosierung. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt der eMP-Eintrag editiert wurde.: * Der Anwender befindet sich in einer Ansicht des eMP.
* Der Anwender hat einen eMP-Eintrag ausgewählt, den er bearbeiten möchte.

* Beschreibung: Durchzuführende Aktionen
  * Ein eMP-Eintrag kann nach seiner Anlage editiert werden. Dies kann der Fall sein, wenn sich neue Erkenntnisse ergeben oder die Therapie angepasst wird. Hiervon betroffen sind alle eMP-spezifischen Informationen (Indikation, versichertenverständlicher “Grund”, “Hinweise” für den Versicherten, “Hinweise für Mitbehandelnde”, Start- und Enddatum) sowie die Dosierung. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt der eMP-Eintrag editiert wurde.: * Der Anwender editiert oder ergänzt die eMP-spezifischen Informationen bzw. die Dosierung des eMP-Eintrags (bspw. “Hinweise” für den Versicherten). Er stellt dabei sicher, dass mindestens ein Status und eine Dosierung vorhanden sind.
* Wird die Dosierung angepasst: Der Anwender bestätigt, dass die Dosierungsanpassung abgeschlossen ist.
* Sofern der ausgewählte eMP-Eintrag im Status “beendet” oder “pausiert” vorliegt: Das Primärsystem schlägt vor, den Status auf “aktiv” zu setzen. Der Anwender kann den Statuswechsel bestätigen.
* Das Primärsystem aktualisiert den eMP-Eintrag und zeigt eine Bestätigung an.

* Beschreibung: Nachbedingungen
  * Ein eMP-Eintrag kann nach seiner Anlage editiert werden. Dies kann der Fall sein, wenn sich neue Erkenntnisse ergeben oder die Therapie angepasst wird. Hiervon betroffen sind alle eMP-spezifischen Informationen (Indikation, versichertenverständlicher “Grund”, “Hinweise” für den Versicherten, “Hinweise für Mitbehandelnde”, Start- und Enddatum) sowie die Dosierung. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt der eMP-Eintrag editiert wurde.: * Der Anwender kann sich den aktualisierten eMP anzeigen lassen; aktualisierte Informationen können visuell hervorgehoben werden. Vgl. [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp)
* Der Anwender kann über die Historie des eMP-Eintrags nachvollziehen, wie, von welcher Einrichtung und zu welchem Zeitpunkt der eMP-Eintrag editiert wurde.
* Der Anwender kann die Bearbeitung des eMP-Eintrags fortsetzen, sofern erforderlich.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Ein eMP-Eintrag kann nach seiner Anlage editiert werden. Dies kann der Fall sein, wenn sich neue Erkenntnisse ergeben oder die Therapie angepasst wird. Hiervon betroffen sind alle eMP-spezifischen Informationen (Indikation, versichertenverständlicher “Grund”, “Hinweise” für den Versicherten, “Hinweise für Mitbehandelnde”, Start- und Enddatum) sowie die Dosierung. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt der eMP-Eintrag editiert wurde.: * [Anwendungsfall: Aktualisierung eines eMP-Eintrags](./technical-use-cases.md#anwendungsfall-aktualisierung-eines-emp-eintrags)

* Beschreibung: Relevante(r) Sektor(en)
  * Ein eMP-Eintrag kann nach seiner Anlage editiert werden. Dies kann der Fall sein, wenn sich neue Erkenntnisse ergeben oder die Therapie angepasst wird. Hiervon betroffen sind alle eMP-spezifischen Informationen (Indikation, versichertenverständlicher “Grund”, “Hinweise” für den Versicherten, “Hinweise für Mitbehandelnde”, Start- und Enddatum) sowie die Dosierung. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt der eMP-Eintrag editiert wurde.: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Editieren von eMP-Einträgen
### Pausieren von eMP-Einträgen

* Beschreibung: Vorbedingungen
  * Wird die Therapie mit einem Arzneimittel pausiert, kann der eMP-Eintrag den Status “pausiert” erhalten. Der eMP-Eintrag wird weiterhin auf dem aktuellen eMP abgebildet. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde. Soll die Therapie wieder aufgenommen werden, kann der Status erneut angepasst werden.: * Der Anwender befindet sich in einer Ansicht des eMP.
* Der Anwender hat einen oder mehrere eMP-Einträge ausgewählt, die er bearbeiten möchte.

* Beschreibung: Durchzuführende Aktionen
  * Wird die Therapie mit einem Arzneimittel pausiert, kann der eMP-Eintrag den Status “pausiert” erhalten. Der eMP-Eintrag wird weiterhin auf dem aktuellen eMP abgebildet. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde. Soll die Therapie wieder aufgenommen werden, kann der Status erneut angepasst werden.: * Der Anwender wählt in einer Navigation des Status die Option “Pausiert” aus.
* Das Primärsystem aktualisiert den Status des eMP-Eintrags/der eMP-Einträge und zeigt eine Bestätigung an.

* Beschreibung: Nachbedingungen
  * Wird die Therapie mit einem Arzneimittel pausiert, kann der eMP-Eintrag den Status “pausiert” erhalten. Der eMP-Eintrag wird weiterhin auf dem aktuellen eMP abgebildet. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde. Soll die Therapie wieder aufgenommen werden, kann der Status erneut angepasst werden.: * Der eMP-Eintrag/die eMP-Einträge erhalten den Status “pausiert”; sie werden entsprechend gekennzeichnet und – sofern vorhanden – mit anderen pausierten eMP-Einträgen in der Anzeige des aktuellen eMP gruppiert.
* Der Anwender kann die Bearbeitung des eMP-Eintrags/der eMP-Einträge fortsetzen, sofern erforderlich.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Wird die Therapie mit einem Arzneimittel pausiert, kann der eMP-Eintrag den Status “pausiert” erhalten. Der eMP-Eintrag wird weiterhin auf dem aktuellen eMP abgebildet. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde. Soll die Therapie wieder aufgenommen werden, kann der Status erneut angepasst werden.: * [Anwendungsfall: Aktualisierung eines eMP-Eintrags](./technical-use-cases.md#anwendungsfall-aktualisierung-eines-emp-eintrags)

* Beschreibung: Relevante(r) Sektor(en)
  * Wird die Therapie mit einem Arzneimittel pausiert, kann der eMP-Eintrag den Status “pausiert” erhalten. Der eMP-Eintrag wird weiterhin auf dem aktuellen eMP abgebildet. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde. Soll die Therapie wieder aufgenommen werden, kann der Status erneut angepasst werden.: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Pausieren von eMP-Einträgen
### Beenden von eMP-Einträgen

* Beschreibung: Vorbedingungen
  * Wird die Therapie mit einem Arzneimittel abgeschlossen, kann der eMP-Eintrag den Status “beendet” oder “abgebrochen” erhalten. Der eMP-Eintrag wird damit nicht mehr auf dem aktuellen eMP abgebildet. Über die Historie kann weiterhin nachvollzogen werden, dass das Arzneimittel zeitweilig auf dem eMP abgebildet war und von welcher Einrichtung zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde.: * Der Anwender befindet sich in einer Ansicht des eMP.
* Der Anwender hat einen oder mehrere eMP-Einträge ausgewählt, die er bearbeiten möchte.

* Beschreibung: Durchzuführende Aktionen
  * Wird die Therapie mit einem Arzneimittel abgeschlossen, kann der eMP-Eintrag den Status “beendet” oder “abgebrochen” erhalten. Der eMP-Eintrag wird damit nicht mehr auf dem aktuellen eMP abgebildet. Über die Historie kann weiterhin nachvollzogen werden, dass das Arzneimittel zeitweilig auf dem eMP abgebildet war und von welcher Einrichtung zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde.: * Der Anwender wählt in einer Navigation des Status die Option “Beendet” aus.
* Das Primärsystem zeigt ein Fenster mit der Frage an “Konnte die Therapie mit diesem Arzneimittel planmäßig abgeschlossen werden?”. Die Vorauswahl für alle Arzneimittel ist “Ja”.
* Der Anwender passt die Vorauswahl ggf. an (“Nein”) und bestätigt das Beenden des eMP-Eintrags.
* Primärsystem aktualisiert den Status des eMP-Eintrags/der eMP-Einträge und zeigt eine Bestätigung an.

* Beschreibung: Nachbedingungen
  * Wird die Therapie mit einem Arzneimittel abgeschlossen, kann der eMP-Eintrag den Status “beendet” oder “abgebrochen” erhalten. Der eMP-Eintrag wird damit nicht mehr auf dem aktuellen eMP abgebildet. Über die Historie kann weiterhin nachvollzogen werden, dass das Arzneimittel zeitweilig auf dem eMP abgebildet war und von welcher Einrichtung zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde.: * Der eMP-Eintrag/die eMP-Einträge erhalten den Status “beendet”, sofern der Anwender bestätigt hat, dass die Therapie planmäßig abgeschlossen werden konnte. Anderenfalls erhalten sie den Status “abgebrochen”. Sie werden in der Ansicht des aktuellen eMP nicht mehr angezeigt. Soll er angezeigt werden, ist nachvollziehbar, dass die Therapie beendet wurde. Vgl. [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp)

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Wird die Therapie mit einem Arzneimittel abgeschlossen, kann der eMP-Eintrag den Status “beendet” oder “abgebrochen” erhalten. Der eMP-Eintrag wird damit nicht mehr auf dem aktuellen eMP abgebildet. Über die Historie kann weiterhin nachvollzogen werden, dass das Arzneimittel zeitweilig auf dem eMP abgebildet war und von welcher Einrichtung zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde.: * [Anwendungsfall: Aktualisierung eines eMP-Eintrags](./technical-use-cases.md#anwendungsfall-aktualisierung-eines-emp-eintrags)

* Beschreibung: Relevante(r) Sektor(en)
  * Wird die Therapie mit einem Arzneimittel abgeschlossen, kann der eMP-Eintrag den Status “beendet” oder “abgebrochen” erhalten. Der eMP-Eintrag wird damit nicht mehr auf dem aktuellen eMP abgebildet. Über die Historie kann weiterhin nachvollzogen werden, dass das Arzneimittel zeitweilig auf dem eMP abgebildet war und von welcher Einrichtung zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde.: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Beenden von eMP-Einträgen
### Aktivieren von eMP-Einträgen

* Beschreibung: Vorbedingungen
  * Wird die Therapie mit einem Arzneimittel wieder aufgenommen, die im Vorfeld als pausiert oder beendet gegolten hat, kann der eMP-Eintrag (erneut) den Status “aktiv” erhalten. Der eMP-Eintrag wird damit (wieder) auf dem aktuellen eMP abgebildet. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde.: * Der Anwender befindet sich in einer Ansicht des eMP.
* Der Anwender hat einen oder mehrere eMP-Einträge ausgewählt, die er bearbeiten möchte.

* Beschreibung: Durchzuführende Aktionen
  * Wird die Therapie mit einem Arzneimittel wieder aufgenommen, die im Vorfeld als pausiert oder beendet gegolten hat, kann der eMP-Eintrag (erneut) den Status “aktiv” erhalten. Der eMP-Eintrag wird damit (wieder) auf dem aktuellen eMP abgebildet. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde.: * Der Anwender wählt in einer Navigation des Status die Option “Aktiv” aus.
* Das Primärsystem aktualisiert den Status des eMP-Eintrags/der eMP-Einträge und zeigt eine Bestätigung an.

* Beschreibung: Nachbedingungen
  * Wird die Therapie mit einem Arzneimittel wieder aufgenommen, die im Vorfeld als pausiert oder beendet gegolten hat, kann der eMP-Eintrag (erneut) den Status “aktiv” erhalten. Der eMP-Eintrag wird damit (wieder) auf dem aktuellen eMP abgebildet. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde.: * Der eMP-Eintrag/die eMP-Einträge erhalten den Status “aktiv”; sie werden entsprechend gekennzeichnet und – sofern vorhanden – mit anderen aktiven eMP-Einträgen in der Anzeige des aktuellen eMP gruppiert.
* Der Anwender kann die Bearbeitung des eMP-Eintrags/der eMP-Einträge fortsetzen, sofern erforderlich.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Wird die Therapie mit einem Arzneimittel wieder aufgenommen, die im Vorfeld als pausiert oder beendet gegolten hat, kann der eMP-Eintrag (erneut) den Status “aktiv” erhalten. Der eMP-Eintrag wird damit (wieder) auf dem aktuellen eMP abgebildet. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde.: * [Anwendungsfall: Aktualisierung eines eMP-Eintrags](./technical-use-cases.md#anwendungsfall-aktualisierung-eines-emp-eintrags)

* Beschreibung: Relevante(r) Sektor(en)
  * Wird die Therapie mit einem Arzneimittel wieder aufgenommen, die im Vorfeld als pausiert oder beendet gegolten hat, kann der eMP-Eintrag (erneut) den Status “aktiv” erhalten. Der eMP-Eintrag wird damit (wieder) auf dem aktuellen eMP abgebildet. Über die Historie kann nachvollzogen werden, von welcher Einrichtung und zu welchem Zeitpunkt die Statusanpassung vorgenommen wurde.: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Aktivieren von eMP-Einträgen
### Planen von eMP-Einträgen

* Beschreibung: Vorbedingungen
  * Es kann vorkommen, dass die Therapie mit einem Arzneimittel vorerst nur im eMP dokumentiert werden soll, ohne dass eine Rezeptierung oder Abgabe erfolgt. Da die Therapie mit diesem Arzneimittel ausschließlich im eMP dargestellt wird, befindet sich der Eintrag formal im “Planungszustand”. Der Planungszustand trifft jedoch keine medizinische Aussage, ob die Therapie mit dem Arzneimittel bereits begonnen wurde.: * Der Anwender befindet sich in einer Ansicht des eMP.

* Beschreibung: Durchzuführende Aktionen
  * Es kann vorkommen, dass die Therapie mit einem Arzneimittel vorerst nur im eMP dokumentiert werden soll, ohne dass eine Rezeptierung oder Abgabe erfolgt. Da die Therapie mit diesem Arzneimittel ausschließlich im eMP dargestellt wird, befindet sich der Eintrag formal im “Planungszustand”. Der Planungszustand trifft jedoch keine medizinische Aussage, ob die Therapie mit dem Arzneimittel bereits begonnen wurde.: * Der Anwender wählt die Option “Anlage eines eMP-Eintrags” aus.
* Der Anwender gibt mindestens alle verpflichtend auszufüllenden Datenfelder für den eMP-Eintrag im Planungsstatus an.
* Das Primärsystem kreiert einen eMP-Eintrag im ePA-Aktensystem und zeigt eine Bestätigung an.

* Beschreibung: Nachbedingungen
  * Es kann vorkommen, dass die Therapie mit einem Arzneimittel vorerst nur im eMP dokumentiert werden soll, ohne dass eine Rezeptierung oder Abgabe erfolgt. Da die Therapie mit diesem Arzneimittel ausschließlich im eMP dargestellt wird, befindet sich der Eintrag formal im “Planungszustand”. Der Planungszustand trifft jedoch keine medizinische Aussage, ob die Therapie mit dem Arzneimittel bereits begonnen wurde.: * Der eMP-Eintrag kann im eMP nachvollzogen werden. Das Arzneimittel ist nicht in der eML abgebildet.
* Der Anwender kann ein E-Rezept oder einen Nachtrag zu diesem eMP-Eintrag erstellen. Mit stattgehabter Verknüpfung erfolgt ein Statuswechsel zu “aktiv” Vgl. [Nachtrag_von_Arzneimitteln](dgmp-use-cases.md#nachtrag-von-arzneimitteln), [Pflege des eMP im Rahmen der Rezeptierung per E-Rezept - Aktualisieren eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-im-rahmen-der-rezeptierung-per-e-rezept---aktualisieren-eines-emp-eintrags)

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Es kann vorkommen, dass die Therapie mit einem Arzneimittel vorerst nur im eMP dokumentiert werden soll, ohne dass eine Rezeptierung oder Abgabe erfolgt. Da die Therapie mit diesem Arzneimittel ausschließlich im eMP dargestellt wird, befindet sich der Eintrag formal im “Planungszustand”. Der Planungszustand trifft jedoch keine medizinische Aussage, ob die Therapie mit dem Arzneimittel bereits begonnen wurde.: * [Anwendungsfall: Verordnung, Verschreibung und Dispensierung mit dem eMP](./technical-use-cases.md#anwendungsfall-verordnung-verschreibung-und-dispensierung-mit-dem-emp) ohne E-Rezept.

* Beschreibung: Relevante(r) Sektor(en)
  * Es kann vorkommen, dass die Therapie mit einem Arzneimittel vorerst nur im eMP dokumentiert werden soll, ohne dass eine Rezeptierung oder Abgabe erfolgt. Da die Therapie mit diesem Arzneimittel ausschließlich im eMP dargestellt wird, befindet sich der Eintrag formal im “Planungszustand”. Der Planungszustand trifft jedoch keine medizinische Aussage, ob die Therapie mit dem Arzneimittel bereits begonnen wurde.: APOTHEKER(ZAHN-)ARZT

**Tabelle:**Fachlicher Anwendungsfall Planen von eMP-Einträgen
### eMP ausdrucken

* Beschreibung: Vorbedingungen
  * Der eMP kann als PDF dargestellt werden, um anschließend ausgedruckt und zum Beispiel dem Versicherten oder einem benannten Vertreter mitgegeben werden zu können. Außerdem kann das PDF/der Ausdruck Gesundheitseinrichtungen übergeben werden, die an der Versorgung beteiligt sind, aber keinen Zugriff auf den eMP haben, um Versorgungsbrüche zu vermeiden.Form und Inhalt des Ausdrucks werden von der gematik vorgegeben. Das PDF für den Ausdruck wird vom Aktensystem generiert und hat daher unabhängig vom Primärsystem bzw. ePA-FdV denselben Aufbau.Der Aufbau des Ausdrucks orientiert sich sowohl in der visuellen Darstellung als auch in den Inhalten mehrheitlich am BMP. Das inkludiert die strukturierte Darstellung von Dosierungen, welche eine langfristige und tägliche Anwendung mit Tageszeiten-Bezug (bspw. täglich: morgens — je 400 mg)​ vorsehen. Strukturiert erfasste Dosierungen, die diese Abbildungsregeln erfüllen, werden in einer Kreuztabelle ausgegeben; dort nicht abbildbare Dosierungen erscheinen in einer Zusatzzeile unterhalb des eMP-Eintrags.Abweichend vom BMP trägt der Ausdruck des eMP keinen DataMatrix-Code, da das Transportmedium des eMP die ePA ist. Außerdem werden bis auf Weiteres keine Zwischenüberschriften, keine individualisierbare Zeilenreihenfolge und keine weiteren AMTS-relevanten Informationen im Ausdruck unterstützt. Die Reihenfolge der eMP-Einträge untereinander wird in erster Linie anhand des Erstellungsdatums des eMP-Eintrags festgelegt. Durch das Persistieren dieser Zeilenreihenfolge bleibt die Orientierung auf dem Ausdruck auch über mehrere Versionen hinweg erhalten.Es ist anzumerken, dass nicht alle Informationen, die digital im eMP erfasst werden, auch auf dem Ausdruck nachvollziehbar sind. Insbesondere die Indikation (ICD-10-Code) und die “Hinweise für Mitbehandelnde” sind dort nicht abgebildet, da sie keine wesentlichen Informationen für die Arzneimittelanwendung des Versicherten enthalten.Das Aktensystem generiert den Ausdruck stets aus dem letztgültigen Zustand des eMP; historisierte Versionen des eMP können nicht über das Aktensystem ausgedruckt werden. Auf dem Ausdruck ist nachvollziehbar, zu welchem Zeitpunkt er erstellt wurde. Es wird darauf hingewiesen, dass ggf. weitere oder aktuellere Informationen in der elektronischen Patientenakte vorliegen könnten.: * Der Anwender befindet sich in einer Ansicht des eMP.

* Beschreibung: Durchzuführende Aktionen
  * Der eMP kann als PDF dargestellt werden, um anschließend ausgedruckt und zum Beispiel dem Versicherten oder einem benannten Vertreter mitgegeben werden zu können. Außerdem kann das PDF/der Ausdruck Gesundheitseinrichtungen übergeben werden, die an der Versorgung beteiligt sind, aber keinen Zugriff auf den eMP haben, um Versorgungsbrüche zu vermeiden.Form und Inhalt des Ausdrucks werden von der gematik vorgegeben. Das PDF für den Ausdruck wird vom Aktensystem generiert und hat daher unabhängig vom Primärsystem bzw. ePA-FdV denselben Aufbau.Der Aufbau des Ausdrucks orientiert sich sowohl in der visuellen Darstellung als auch in den Inhalten mehrheitlich am BMP. Das inkludiert die strukturierte Darstellung von Dosierungen, welche eine langfristige und tägliche Anwendung mit Tageszeiten-Bezug (bspw. täglich: morgens — je 400 mg)​ vorsehen. Strukturiert erfasste Dosierungen, die diese Abbildungsregeln erfüllen, werden in einer Kreuztabelle ausgegeben; dort nicht abbildbare Dosierungen erscheinen in einer Zusatzzeile unterhalb des eMP-Eintrags.Abweichend vom BMP trägt der Ausdruck des eMP keinen DataMatrix-Code, da das Transportmedium des eMP die ePA ist. Außerdem werden bis auf Weiteres keine Zwischenüberschriften, keine individualisierbare Zeilenreihenfolge und keine weiteren AMTS-relevanten Informationen im Ausdruck unterstützt. Die Reihenfolge der eMP-Einträge untereinander wird in erster Linie anhand des Erstellungsdatums des eMP-Eintrags festgelegt. Durch das Persistieren dieser Zeilenreihenfolge bleibt die Orientierung auf dem Ausdruck auch über mehrere Versionen hinweg erhalten.Es ist anzumerken, dass nicht alle Informationen, die digital im eMP erfasst werden, auch auf dem Ausdruck nachvollziehbar sind. Insbesondere die Indikation (ICD-10-Code) und die “Hinweise für Mitbehandelnde” sind dort nicht abgebildet, da sie keine wesentlichen Informationen für die Arzneimittelanwendung des Versicherten enthalten.Das Aktensystem generiert den Ausdruck stets aus dem letztgültigen Zustand des eMP; historisierte Versionen des eMP können nicht über das Aktensystem ausgedruckt werden. Auf dem Ausdruck ist nachvollziehbar, zu welchem Zeitpunkt er erstellt wurde. Es wird darauf hingewiesen, dass ggf. weitere oder aktuellere Informationen in der elektronischen Patientenakte vorliegen könnten.: * Der Anwender wählt die Option “PDF erstellen” oder “eMP ausdrucken” aus.
* Das Aktensystem generiert den PDF-Ausdruck.
* Das Primärsystem bietet an, den generierten PDF-Ausdruck lokal zu speichern oder zu drucken.

* Beschreibung: Nachbedingungen
  * Der eMP kann als PDF dargestellt werden, um anschließend ausgedruckt und zum Beispiel dem Versicherten oder einem benannten Vertreter mitgegeben werden zu können. Außerdem kann das PDF/der Ausdruck Gesundheitseinrichtungen übergeben werden, die an der Versorgung beteiligt sind, aber keinen Zugriff auf den eMP haben, um Versorgungsbrüche zu vermeiden.Form und Inhalt des Ausdrucks werden von der gematik vorgegeben. Das PDF für den Ausdruck wird vom Aktensystem generiert und hat daher unabhängig vom Primärsystem bzw. ePA-FdV denselben Aufbau.Der Aufbau des Ausdrucks orientiert sich sowohl in der visuellen Darstellung als auch in den Inhalten mehrheitlich am BMP. Das inkludiert die strukturierte Darstellung von Dosierungen, welche eine langfristige und tägliche Anwendung mit Tageszeiten-Bezug (bspw. täglich: morgens — je 400 mg)​ vorsehen. Strukturiert erfasste Dosierungen, die diese Abbildungsregeln erfüllen, werden in einer Kreuztabelle ausgegeben; dort nicht abbildbare Dosierungen erscheinen in einer Zusatzzeile unterhalb des eMP-Eintrags.Abweichend vom BMP trägt der Ausdruck des eMP keinen DataMatrix-Code, da das Transportmedium des eMP die ePA ist. Außerdem werden bis auf Weiteres keine Zwischenüberschriften, keine individualisierbare Zeilenreihenfolge und keine weiteren AMTS-relevanten Informationen im Ausdruck unterstützt. Die Reihenfolge der eMP-Einträge untereinander wird in erster Linie anhand des Erstellungsdatums des eMP-Eintrags festgelegt. Durch das Persistieren dieser Zeilenreihenfolge bleibt die Orientierung auf dem Ausdruck auch über mehrere Versionen hinweg erhalten.Es ist anzumerken, dass nicht alle Informationen, die digital im eMP erfasst werden, auch auf dem Ausdruck nachvollziehbar sind. Insbesondere die Indikation (ICD-10-Code) und die “Hinweise für Mitbehandelnde” sind dort nicht abgebildet, da sie keine wesentlichen Informationen für die Arzneimittelanwendung des Versicherten enthalten.Das Aktensystem generiert den Ausdruck stets aus dem letztgültigen Zustand des eMP; historisierte Versionen des eMP können nicht über das Aktensystem ausgedruckt werden. Auf dem Ausdruck ist nachvollziehbar, zu welchem Zeitpunkt er erstellt wurde. Es wird darauf hingewiesen, dass ggf. weitere oder aktuellere Informationen in der elektronischen Patientenakte vorliegen könnten.: * Die Person, für die der Ausdruck vorgesehen war, erhält den Ausdruck und kann anhand dessen die Arzneimitteltherapie anwenden.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Der eMP kann als PDF dargestellt werden, um anschließend ausgedruckt und zum Beispiel dem Versicherten oder einem benannten Vertreter mitgegeben werden zu können. Außerdem kann das PDF/der Ausdruck Gesundheitseinrichtungen übergeben werden, die an der Versorgung beteiligt sind, aber keinen Zugriff auf den eMP haben, um Versorgungsbrüche zu vermeiden.Form und Inhalt des Ausdrucks werden von der gematik vorgegeben. Das PDF für den Ausdruck wird vom Aktensystem generiert und hat daher unabhängig vom Primärsystem bzw. ePA-FdV denselben Aufbau.Der Aufbau des Ausdrucks orientiert sich sowohl in der visuellen Darstellung als auch in den Inhalten mehrheitlich am BMP. Das inkludiert die strukturierte Darstellung von Dosierungen, welche eine langfristige und tägliche Anwendung mit Tageszeiten-Bezug (bspw. täglich: morgens — je 400 mg)​ vorsehen. Strukturiert erfasste Dosierungen, die diese Abbildungsregeln erfüllen, werden in einer Kreuztabelle ausgegeben; dort nicht abbildbare Dosierungen erscheinen in einer Zusatzzeile unterhalb des eMP-Eintrags.Abweichend vom BMP trägt der Ausdruck des eMP keinen DataMatrix-Code, da das Transportmedium des eMP die ePA ist. Außerdem werden bis auf Weiteres keine Zwischenüberschriften, keine individualisierbare Zeilenreihenfolge und keine weiteren AMTS-relevanten Informationen im Ausdruck unterstützt. Die Reihenfolge der eMP-Einträge untereinander wird in erster Linie anhand des Erstellungsdatums des eMP-Eintrags festgelegt. Durch das Persistieren dieser Zeilenreihenfolge bleibt die Orientierung auf dem Ausdruck auch über mehrere Versionen hinweg erhalten.Es ist anzumerken, dass nicht alle Informationen, die digital im eMP erfasst werden, auch auf dem Ausdruck nachvollziehbar sind. Insbesondere die Indikation (ICD-10-Code) und die “Hinweise für Mitbehandelnde” sind dort nicht abgebildet, da sie keine wesentlichen Informationen für die Arzneimittelanwendung des Versicherten enthalten.Das Aktensystem generiert den Ausdruck stets aus dem letztgültigen Zustand des eMP; historisierte Versionen des eMP können nicht über das Aktensystem ausgedruckt werden. Auf dem Ausdruck ist nachvollziehbar, zu welchem Zeitpunkt er erstellt wurde. Es wird darauf hingewiesen, dass ggf. weitere oder aktuellere Informationen in der elektronischen Patientenakte vorliegen könnten.: * [Lesezugriffe](./technical-use-cases.md#lesezugriffe)

* Beschreibung: Relevante(r) Sektor(en)
  * Der eMP kann als PDF dargestellt werden, um anschließend ausgedruckt und zum Beispiel dem Versicherten oder einem benannten Vertreter mitgegeben werden zu können. Außerdem kann das PDF/der Ausdruck Gesundheitseinrichtungen übergeben werden, die an der Versorgung beteiligt sind, aber keinen Zugriff auf den eMP haben, um Versorgungsbrüche zu vermeiden.Form und Inhalt des Ausdrucks werden von der gematik vorgegeben. Das PDF für den Ausdruck wird vom Aktensystem generiert und hat daher unabhängig vom Primärsystem bzw. ePA-FdV denselben Aufbau.Der Aufbau des Ausdrucks orientiert sich sowohl in der visuellen Darstellung als auch in den Inhalten mehrheitlich am BMP. Das inkludiert die strukturierte Darstellung von Dosierungen, welche eine langfristige und tägliche Anwendung mit Tageszeiten-Bezug (bspw. täglich: morgens — je 400 mg)​ vorsehen. Strukturiert erfasste Dosierungen, die diese Abbildungsregeln erfüllen, werden in einer Kreuztabelle ausgegeben; dort nicht abbildbare Dosierungen erscheinen in einer Zusatzzeile unterhalb des eMP-Eintrags.Abweichend vom BMP trägt der Ausdruck des eMP keinen DataMatrix-Code, da das Transportmedium des eMP die ePA ist. Außerdem werden bis auf Weiteres keine Zwischenüberschriften, keine individualisierbare Zeilenreihenfolge und keine weiteren AMTS-relevanten Informationen im Ausdruck unterstützt. Die Reihenfolge der eMP-Einträge untereinander wird in erster Linie anhand des Erstellungsdatums des eMP-Eintrags festgelegt. Durch das Persistieren dieser Zeilenreihenfolge bleibt die Orientierung auf dem Ausdruck auch über mehrere Versionen hinweg erhalten.Es ist anzumerken, dass nicht alle Informationen, die digital im eMP erfasst werden, auch auf dem Ausdruck nachvollziehbar sind. Insbesondere die Indikation (ICD-10-Code) und die “Hinweise für Mitbehandelnde” sind dort nicht abgebildet, da sie keine wesentlichen Informationen für die Arzneimittelanwendung des Versicherten enthalten.Das Aktensystem generiert den Ausdruck stets aus dem letztgültigen Zustand des eMP; historisierte Versionen des eMP können nicht über das Aktensystem ausgedruckt werden. Auf dem Ausdruck ist nachvollziehbar, zu welchem Zeitpunkt er erstellt wurde. Es wird darauf hingewiesen, dass ggf. weitere oder aktuellere Informationen in der elektronischen Patientenakte vorliegen könnten.: APOTHEKER(ZAHN-)ARZTPFLEGEKRAFTVERSICHERTER

**Tabelle:**Fachlicher Anwendungsfall eMP ausdrucken
### Durchführung von AMTS-Prüfungen

* Beschreibung: Vorbedingungen
  * AMTS-Prüfungen (Arzneimitteltherapiesicherheits-Prüfungen) können arzneimittelbezogene Probleme identifizieren. Hierzu sollen alle Daten zur Arzneimitteltherapie des Versicherten in der ePA zu Rate gezogen werden können, darunter Verordnungs- und Dispensierdaten (eML) und Daten zur aktuellen Arzneimitteltherapie (eMP). Die Prüfung selbst wird von AMTS-Modulen außerhalb der Telematikinfrastruktur durchgeführt. In diesem Anwendungsfall wird ausschließlich diese softwaregestützte AMTS-Prüfung beschrieben. Eine vollständige AMTS-Prüfung umfasst in der Regel weitere Aspekte, bspw. ein Gespräch zwischen Apotheker und Versichertem, die hier nicht beschrieben sind.: * Der Anwender verfügt über ein in das Primärsystem/das ePA-FdV integriertes AMTS-Modul.
* Der Anwender befindet sich: 
* in einer lokalen Ansicht, in der Arzneimittel verwaltet werden oder
* in einer Ansicht der eML oder des eMP.
 

* Beschreibung: Durchzuführende Aktionen
  * AMTS-Prüfungen (Arzneimitteltherapiesicherheits-Prüfungen) können arzneimittelbezogene Probleme identifizieren. Hierzu sollen alle Daten zur Arzneimitteltherapie des Versicherten in der ePA zu Rate gezogen werden können, darunter Verordnungs- und Dispensierdaten (eML) und Daten zur aktuellen Arzneimitteltherapie (eMP). Die Prüfung selbst wird von AMTS-Modulen außerhalb der Telematikinfrastruktur durchgeführt. In diesem Anwendungsfall wird ausschließlich diese softwaregestützte AMTS-Prüfung beschrieben. Eine vollständige AMTS-Prüfung umfasst in der Regel weitere Aspekte, bspw. ein Gespräch zwischen Apotheker und Versichertem, die hier nicht beschrieben sind.: * Der Anwender startet die AMTS-Prüfung in seinem AMTS-Modul.
* Der Anwender kann – abhängig vom Angebot des AMTS-Moduls – bestimmte Parameter anpassen (z.B. zu berücksichtigender Zeitraum oder Status von Arzneimitteln im eMP).
* Das Primärsystem führt die AMTS-Prüfung unter Einbezug der Daten aus der ePA durch und zeigt die Ergebnisse an, wobei die von arzneimittelbezogenen Problemen betroffenen Arzneimittel hervorgehoben werden.

* Beschreibung: Nachbedingungen
  * AMTS-Prüfungen (Arzneimitteltherapiesicherheits-Prüfungen) können arzneimittelbezogene Probleme identifizieren. Hierzu sollen alle Daten zur Arzneimitteltherapie des Versicherten in der ePA zu Rate gezogen werden können, darunter Verordnungs- und Dispensierdaten (eML) und Daten zur aktuellen Arzneimitteltherapie (eMP). Die Prüfung selbst wird von AMTS-Modulen außerhalb der Telematikinfrastruktur durchgeführt. In diesem Anwendungsfall wird ausschließlich diese softwaregestützte AMTS-Prüfung beschrieben. Eine vollständige AMTS-Prüfung umfasst in der Regel weitere Aspekte, bspw. ein Gespräch zwischen Apotheker und Versichertem, die hier nicht beschrieben sind.: * Der Anwender kann entscheiden, ob er Maßnahmen ergreifen möchte, um die identifizierten Probleme zu adressieren (z.B. im Falle von Leistungserbringerinstitutionen die Anpassung des eMP oder bei Versicherten die Kontaktierung eines Arztes).

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * AMTS-Prüfungen (Arzneimitteltherapiesicherheits-Prüfungen) können arzneimittelbezogene Probleme identifizieren. Hierzu sollen alle Daten zur Arzneimitteltherapie des Versicherten in der ePA zu Rate gezogen werden können, darunter Verordnungs- und Dispensierdaten (eML) und Daten zur aktuellen Arzneimitteltherapie (eMP). Die Prüfung selbst wird von AMTS-Modulen außerhalb der Telematikinfrastruktur durchgeführt. In diesem Anwendungsfall wird ausschließlich diese softwaregestützte AMTS-Prüfung beschrieben. Eine vollständige AMTS-Prüfung umfasst in der Regel weitere Aspekte, bspw. ein Gespräch zwischen Apotheker und Versichertem, die hier nicht beschrieben sind.: * [Lesezugriffe](./technical-use-cases.md#lesezugriffe)

* Beschreibung: Relevante(r) Sektor(en)
  * AMTS-Prüfungen (Arzneimitteltherapiesicherheits-Prüfungen) können arzneimittelbezogene Probleme identifizieren. Hierzu sollen alle Daten zur Arzneimitteltherapie des Versicherten in der ePA zu Rate gezogen werden können, darunter Verordnungs- und Dispensierdaten (eML) und Daten zur aktuellen Arzneimitteltherapie (eMP). Die Prüfung selbst wird von AMTS-Modulen außerhalb der Telematikinfrastruktur durchgeführt. In diesem Anwendungsfall wird ausschließlich diese softwaregestützte AMTS-Prüfung beschrieben. Eine vollständige AMTS-Prüfung umfasst in der Regel weitere Aspekte, bspw. ein Gespräch zwischen Apotheker und Versichertem, die hier nicht beschrieben sind.: APOTHEKER(ZAHN-)ARZTPFLEGEKRAFTVERSICHERTER

**Tabelle:**Fachlicher Anwendungsfall Durchführung von AMTS-Prüfungen
### Übernahme des eMP in das lokale PS

* Beschreibung: Vorbedingungen
  * Der aktuelle Zustand des eMP kann in das lokale Primärsystem überführt werden. Dies ist insbesondere an Versorgungsschnittstellen relevant, bspw. wenn ein Abgleich mit der Hausmedikation erfolgen muss oder die Medikationsplanung während eines stationären Aufenthalts lokal vorgenommen werden soll. Im Sinne der Nachnutzbarkeit sollten hierfür stets die nativen FHIR-Daten genutzt werden; das PDF ist auf die Bedürfnisse des Versicherten zugeschnitten und hierfür nicht zu empfehlen. Idealerweise gibt es für diesen Anwendungsfall einen dedizierten Speicherort im lokalen System, der bereits vorausgewählt ist.: * Der Anwender befindet sich in einer Ansicht des eMP.
* Der Anwender hat den eMP ggf. aktualisiert, sofern ihm Änderungen bekannt gewesen sind oder von ihm angestoßen wurden.

* Beschreibung: Durchzuführende Aktionen
  * Der aktuelle Zustand des eMP kann in das lokale Primärsystem überführt werden. Dies ist insbesondere an Versorgungsschnittstellen relevant, bspw. wenn ein Abgleich mit der Hausmedikation erfolgen muss oder die Medikationsplanung während eines stationären Aufenthalts lokal vorgenommen werden soll. Im Sinne der Nachnutzbarkeit sollten hierfür stets die nativen FHIR-Daten genutzt werden; das PDF ist auf die Bedürfnisse des Versicherten zugeschnitten und hierfür nicht zu empfehlen. Idealerweise gibt es für diesen Anwendungsfall einen dedizierten Speicherort im lokalen System, der bereits vorausgewählt ist.: * Der Anwender wählt die Option “Medikationsplan speichern/herunterladen” aus.
* Das Primärsystem lädt den aktuellen Stand des Medikationsplans herunter und zeigt eine Bestätigung an.

* Beschreibung: Nachbedingungen
  * Der aktuelle Zustand des eMP kann in das lokale Primärsystem überführt werden. Dies ist insbesondere an Versorgungsschnittstellen relevant, bspw. wenn ein Abgleich mit der Hausmedikation erfolgen muss oder die Medikationsplanung während eines stationären Aufenthalts lokal vorgenommen werden soll. Im Sinne der Nachnutzbarkeit sollten hierfür stets die nativen FHIR-Daten genutzt werden; das PDF ist auf die Bedürfnisse des Versicherten zugeschnitten und hierfür nicht zu empfehlen. Idealerweise gibt es für diesen Anwendungsfall einen dedizierten Speicherort im lokalen System, der bereits vorausgewählt ist.: * Der Anwender kann die Daten des Medikationsplans nutzen, um eine lokale Medikationsplanung zu beginnen/aktualisieren.
* Wurde bereits eine frühere Version des eMP lokal hinterlegt: Der Anwender kann sich eine Differenzansicht anzeigen lassen.

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Der aktuelle Zustand des eMP kann in das lokale Primärsystem überführt werden. Dies ist insbesondere an Versorgungsschnittstellen relevant, bspw. wenn ein Abgleich mit der Hausmedikation erfolgen muss oder die Medikationsplanung während eines stationären Aufenthalts lokal vorgenommen werden soll. Im Sinne der Nachnutzbarkeit sollten hierfür stets die nativen FHIR-Daten genutzt werden; das PDF ist auf die Bedürfnisse des Versicherten zugeschnitten und hierfür nicht zu empfehlen. Idealerweise gibt es für diesen Anwendungsfall einen dedizierten Speicherort im lokalen System, der bereits vorausgewählt ist.: * [Lesezugriffe](./technical-use-cases.md#lesezugriffe)

* Beschreibung: Relevante(r) Sektor(en)
  * Der aktuelle Zustand des eMP kann in das lokale Primärsystem überführt werden. Dies ist insbesondere an Versorgungsschnittstellen relevant, bspw. wenn ein Abgleich mit der Hausmedikation erfolgen muss oder die Medikationsplanung während eines stationären Aufenthalts lokal vorgenommen werden soll. Im Sinne der Nachnutzbarkeit sollten hierfür stets die nativen FHIR-Daten genutzt werden; das PDF ist auf die Bedürfnisse des Versicherten zugeschnitten und hierfür nicht zu empfehlen. Idealerweise gibt es für diesen Anwendungsfall einen dedizierten Speicherort im lokalen System, der bereits vorausgewählt ist.: APOTHEKER(ZAHN-)ARZTPFLEGEKRAFT

**Tabelle:**Fachlicher Anwendungsfall Übernahme des eMP in das lokale PS
### Abgleich von lokalen Daten zur Arzneimitteltherapie und eMP

* Beschreibung: Vorbedingungen
  * Lokal gespeicherte Daten zur Arzneimitteltherapie, insb. eine lokale Medikationsplanung, können mit dem eMP abgeglichen werden. Dies ist insbesondere an Versorgungsschnittstellen relevant, an denen Informationen zur weiteren Arzneimitteltherapie an Mitbehandler und den Versicherten übergeben werden sollen. Etwaige Differenzen können in die weitere Beurteilung mit einfließen und Ausgangspunkt für eine Aktualisierung des eMP sein.: * Der Anwender befindet sich in einer Ansicht des eMP, ggf. in gemeinsamer Anzeige mit lokalen Daten zur Arzneimitteltherapie (z.B. lokaler Medikationsplan).

* Beschreibung: Durchzuführende Aktionen
  * Lokal gespeicherte Daten zur Arzneimitteltherapie, insb. eine lokale Medikationsplanung, können mit dem eMP abgeglichen werden. Dies ist insbesondere an Versorgungsschnittstellen relevant, an denen Informationen zur weiteren Arzneimitteltherapie an Mitbehandler und den Versicherten übergeben werden sollen. Etwaige Differenzen können in die weitere Beurteilung mit einfließen und Ausgangspunkt für eine Aktualisierung des eMP sein.: * Der Anwender wählt die Option “Vergleiche eMP mit meiner Medikation”.
* Das Primärsystem zeigt an: 
* Alle Arzneimittel im Primärsystem und eMP, für die derselbe eMP-Identifier hinterlegt ist.
* Alle Arzneimittel im Primärsystem und eMP, für die kein eMP-Identifier vorliegt, die aber Ähnlichkeiten zeigen.
* Alle Arzneimittel, die im Primärsystem hinterlegt sind, für die kein passender eMP-Eintrag vorliegt.
 

* Beschreibung: Nachbedingungen
  * Lokal gespeicherte Daten zur Arzneimitteltherapie, insb. eine lokale Medikationsplanung, können mit dem eMP abgeglichen werden. Dies ist insbesondere an Versorgungsschnittstellen relevant, an denen Informationen zur weiteren Arzneimitteltherapie an Mitbehandler und den Versicherten übergeben werden sollen. Etwaige Differenzen können in die weitere Beurteilung mit einfließen und Ausgangspunkt für eine Aktualisierung des eMP sein.: * Der Anwender kann (bei vorhandener Berechtigung) den eMP anhand der Informationen im Primärsystem aktualisieren. Vgl. [Nachtrag_von_Arzneimitteln](dgmp-use-cases.md#nachtrag-von-arzneimitteln), [Pausieren von eMP-Einträgen](dgmp-use-cases.md#pausieren-von-emp-einträgen), [Beenden von eMP-Einträgen](dgmp-use-cases.md#beenden-von-emp-einträgen), [Aktivieren von eMP-Einträgen](dgmp-use-cases.md#aktivieren-von-emp-einträgen), [Editieren von eMP-Einträgen](dgmp-use-cases.md#editieren-von-emp-einträgen).

* Beschreibung: Technische Anwendungsfälle des Medication Service
  * Lokal gespeicherte Daten zur Arzneimitteltherapie, insb. eine lokale Medikationsplanung, können mit dem eMP abgeglichen werden. Dies ist insbesondere an Versorgungsschnittstellen relevant, an denen Informationen zur weiteren Arzneimitteltherapie an Mitbehandler und den Versicherten übergeben werden sollen. Etwaige Differenzen können in die weitere Beurteilung mit einfließen und Ausgangspunkt für eine Aktualisierung des eMP sein.: * [Lesezugriffe](./technical-use-cases.md#lesezugriffe)

* Beschreibung: Relevante(r) Sektor(en)
  * Lokal gespeicherte Daten zur Arzneimitteltherapie, insb. eine lokale Medikationsplanung, können mit dem eMP abgeglichen werden. Dies ist insbesondere an Versorgungsschnittstellen relevant, an denen Informationen zur weiteren Arzneimitteltherapie an Mitbehandler und den Versicherten übergeben werden sollen. Etwaige Differenzen können in die weitere Beurteilung mit einfließen und Ausgangspunkt für eine Aktualisierung des eMP sein.: APOTHEKER(ZAHN-)ARZTPFLEGEKRAFT

**Tabelle:**Fachlicher Anwendungsfall Abgleich von lokalen Daten zur Arzneimitteltherapie und eMP

