# dgMP-Szenarien - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* **dgMP-Szenarien**

## dgMP-Szenarien

Die nachfolgenden Szenarien beschreiben idealtypische Teilprozessschritte des dgMP in umsetzenden Systemen. Ferner werden jeweils relevante fachliche Anwendungsfälle zugeordnet. Die Szenarien selbst basieren auf der Vorarbeit zum [MIO eMP AMTS-rZI]. Sowohl die Szenarien als auch die zugeordneten Anwendungsfälle stehen stets in einem handlungsrelevanten Bezug zu den Komponenten und Inhalten der ePA im dgMP. Davon unberührte Versorgungsszenarien, bspw. der Umgang mit dem Anspruch auf einen Medikationsplan bei vorliegendem Widerspruch gegen die ePA, müssen an anderer Stelle beschrieben werden. Dazu gehört auch das Ausstellen und Einlösen von E-Rezepten ohne Bezug zum Medikationsplan. Dies ist weiterhin möglich, da es sich jedoch um Anwendungsfälle ohne direkten Bezug zur ePA handelt, sind diese in diesem Implementation Guide nicht näher beschrieben.

### Medikationsplanung und Verschreibung eines Arzneimittels durch einen Arzt

**Die partizipative Entscheidung von Arzt und Versichertem für eine Arzneimitteltherapie, die Dokumentation dieser Entscheidung und – bei Bedarf – die Verschreibung des Arzneimittels stellen eine Schlüsselstelle des dgMP dar. Das hier dargestellte Szenario ist nicht streng auf den ambulanten Sektor beschränkt. Es wird aber davon ausgegangen, dass der Medikationsplan in der ePA als zentrale Informationsgrundlage für die Arzneimittelanwendung des Versicherten dient.**

Es findet zunächst die ärztliche Anamnese statt, gefolgt von der Indikationsstellung zur medikamentösen Therapie. Es folgt eine ärztliche Auswahl des Arzneimittels unter Berücksichtigung aller medikationsrelevanten Daten (Medikationsplanung) sowie die Beratung des Versicherten. Die Entscheidung für eine medikamentöse Therapie wird gemeinsam von Arzt und Versichertem getroffen.

Ist keine Verschreibung erforderlich, kann diese Therapieentscheidung direkt im Medikationsplan dokumentiert werden. Dies ist bspw. der Fall, wenn die Dosierung einer bestehenden Therapie angepasst oder eine neue Therapie zwar geplant wurde, aber noch nicht begonnen werden soll und daher vorerst ausschließlich als Planung festzuhalten ist.

Ist eine Verschreibung erforderlich, ist diese Verschreibung formal Konsequenz der Therapieentscheidung, die im Medikationsplan erfasst werden soll. Im Sinne einer Prozessintegration sollte dies jedoch in einem Arbeitsschritt durchführbar sein. Dabei sind zwei Szenarien zu unterscheiden:

1. Erstmalige Entscheidung für ein Arzneimittel, welches noch nicht auf dem Medikationsplan vertreten ist: Der Arzt gibt im Rahmen des gewohnten Verordnungsprozesses an, dass ein eMP-Eintrag erstellt werden soll. Weitere Informationen sind – neben den Pflichtinformationen für das E-Rezept – nicht erforderlich, können aber ergänzt werden (z.B. der versichertenverständliche “Grund”). Es wird ein neuer eMP-Eintrag angelegt, der vom entstehenden E-Rezept über den**eMP-Identifier**referenziert wird.
1. Folgeverordnung eines Arzneimittels, welches bereits auf dem Medikationsplan vertreten ist: Eine Folgeverordnung setzt die Therapie mit einem Arzneimittel auf dem eMP fort und sollte daher den bestehenden eMP-Eintrag aktualisieren. Es handelt sich auch dann um eine Folgeverordnung, wenn sich zwar bestimmte Eigenschaften des Arzneimittels ändern (bspw. Wirkstärke oder Handelsname), dies jedoch mit einer gleichbleibenden Therapieintention erfolgt. Im Rahmen des Verordnungsprozesses muss der bestehende eMP-Eintrag referenziert werden. Dies kann wie folgt stattfinden:a) Eine Folgeverordnung wird aus dem eMP oder der eML ausgelöst.b) Sofern der**eMP-Identifier**auch lokal persistiert wird: Eine Folgeverordnung wird bspw. aus einer lokalen Verordnungshistorie oder einem lokalen Medikationsplan ausgelöst. Der eMP-Eintrag ist anhand des eMP-Identifiers abzurufen und darzustellen, um sicherzustellen, dass die Folgeverordnung dem aktuellen Stand entspricht.c) Der zu referenzierende eMP-Eintrag wird manuell ausgewählt. Bei der Auswahl kann das Primärsystem unterstützen, indem es die Anzeige des Medikationsplans sinnvoll einbettet oder Vorschläge anhand von Ähnlichkeiten zwischen dem ausgewählten Arzneimittel und einem eMP-Eintrag macht.

Die Informationen zum Arzneimittel für das E-Rezept sowie etwaige weitere Informationen zum eMP-Eintrag (z.B. “Hinweise für Mitbehandelnde”) können bei Bedarf angepasst oder vollständig übernommen werden. Der eMP-Eintrag wird angelegt oder aktualisiert und vom entstehenden E-Rezept über den **eMP-Identifier** referenziert.

Es folgt die qualifizierte elektronische Signatur und die Übermittlung des E-Rezepts an den E-Rezept-Fachdienst. Der E-Rezept-Fachdienst übermittelt die Daten zum E-Rezept und dessen Dispensierung an die ePA (ePA Medication Service). Durch die Referenzierung des eMP-Eintrags werden diese Daten nicht nur in der eML abgebildet, sondern können auch als Verschreibungsgeschehen im eMP nachvollzogen werden. Die Aktualisierung des Arzneimittels gegenüber dem Planungsstand oder zuletzt abgegebenen Arzneimittel erfolgt erst im nächsten Prozessschritt mit der Dispensierung, sodass der eMP die dem Versicherten tatsächlich vorliegenden Arzneimittel darstellt. Der Arzt kann alternativ auch eine Aktualisierung anhand der Verschreibungsdaten in der eML auslösen. In nachfolgenden Prozessen (z.B. Einlösen des E-Rezepts in der Apotheke) kann anhand der Referenz zum eMP-Eintrag die ärztliche Medikationsplanung nachvollzogen werden.

Nach ärztlichem Ermessen und bei entsprechender Delegationsfähigkeit kann das E-Rezept alternativ auch durch ärztliches Assistenzpersonal vorbereitet werden.

**Wichtig anzumerken ist, dass dieser Idealprozess nicht in jedem Szenario erfolgen kann, in dem eine Therapieentscheidung und/oder Verschreibung erfolgt. Es muss u.a. davon abgewichen werden, wenn kein Zugriff auf das Primärsystem und die Telematikinfrastruktur besteht, bspw. im Rahmen eines Haus- oder Pflegeheimbesuchs. War dies erforderlich, lassen sich alle Änderungen an der Arzneimitteltherapie im Medikationsplan in der ePA nachtragen. Die nachträgliche Erfassung von Informationen im eMP wird in[Szenario 4](./dgmp-scenarios.md#medikationsanamnese--analyse-und--beratung-durch-einen-arzt-oder-einen-apotheker)beschrieben.**

**Beteiligte Systeme:** Primärsystem, ePA Medication Service, E-Rezept-Fachdienst

**Fachliche Anwendungsfälle**

| |
| :--- |
| [Anzeige der elektronischen Medikationsliste (eML)](dgmp-use-cases.md#anzeige-der-elektronischen-medikationsliste-eml) |
| [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp) |
| [Abgleich geplantes Arzneimittel - eMP](dgmp-use-cases.md#abgleich-geplantes-arzneimittel---emp) |
| [Pflege des eMP im Rahmen der Rezeptierung per E-Rezept - Anlage eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-im-rahmen-der-rezeptierung-per-e-rezept---anlage-eines-emp-eintrags) |
| [Pflege des eMP im Rahmen der Rezeptierung per E-Rezept - Aktualisieren eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-im-rahmen-der-rezeptierung-per-e-rezept---aktualisieren-eines-emp-eintrags) |
| [Durchführung von AMTS-Prüfungen](dgmp-use-cases.md#durchführung-von-amts-prüfungen) |

**Tabelle:**Fachliche Anwendungsfälle mit Bezug zu Szenario
*Medikationsplanung und Verschreibung eines Arzneimittels durch einen Arzt*
### Dispensierung eines Arzneimittels in der Apotheke (E-Rezept)

**Wurde dem Patienten ein Arzneimittel verschrieben, muss das Rezept in einer Apotheke eingelöst und das Arzneimittel ausgegeben werden. Dieser Vorgang wird Dispensierung genannt. Dabei kann das Rezept digital (E-Rezept) oder analog vorliegen. Das nachfolgende Szenario geht davon aus, dass das vorliegende Rezept als E-Rezept ausgestellt wurde.**

Zunächst wird das E-Rezept durch die Apotheke in Empfang genommen. Erfolgt dies durch Einlesen der eGK, wird für die Apotheke im gleichen Vorgang in der Regel auch ein 3-tägiger Zugriff auf die ePA hergestellt. Erfolgt die Freigabe hingegen auf anderem Wege, muss der ePA-Zugriff bei Bedarf in einem separaten Prozessschritt hergestellt werden.

Als Nächstes findet eine medikationsbezogene Anamnese statt. Besteht ein Zugriff auf die ePA kann zu diesem Zwecke der Medikationsplan und die Medikationsliste zurate gezogen werden. Bei bestehendem Anspruch auf einen eMP sollte im Regelfall ärztlicherseits ein eMP-Eintrag im E-Rezept referenziert worden sein, sodass die Apotheke nachvollziehen kann, wie sich das verschriebene Arzneimittel in den eMP integriert. Ist dies nicht erfolgt, kann die Apotheke dies nachholen, indem sie einen eMP-Eintrag erstellt oder das E-Rezept einem bestehenden eMP-Eintrag zuordnet. Angaben zur Indikation bzw. zum versichertenverständlichen “Grund” können nur ergänzt werden, wenn die Apotheke hierüber informiert wurde.

Anschließend wird das abzugebende Arzneimittel unter Berücksichtigung von u.a. Abrechenbarkeit (Rabattverträge), Verfügbarkeit (Lieferbarkeit) und patientenindividuellen Faktoren ausgewählt. Ergeben sich bei einer pharmazeutischen AMTS-Prüfung des ausgewählten Arzneimittels arzneimittelbezogene Probleme (ABP), werden diese geprüft. 

Es folgt die Beratung des Patienten und die Dispensierung des Arzneimittels auf Basis des E-Rezepts. Eine Aktualisierung des Medikationsplans erfolgt mit der Abgabe automatisch, sofern das E-Rezept einem eMP-Eintrag zugeordnet wurde. Etwaige Änderungen, die durch die Apotheke vorgenommen worden sind, bspw. die Abgabe eines alternativen Arzneimittels im Rahmen einer Substituierung, werden damit auch auf dem Medikationsplan nachvollziehbar. Eine Dosisanpassung durch die Apotheke in den Abgabedaten wird ausschließlich in den eMP übernommen, wenn die Abgabe als Substitution gekennzeichnet wurde. Bei mehreren abgegebenen Arzneimitteln zu einer Verschreibung wird der Apotheker darauf hingewiesen, dass eine automatisierte Aktualisierung nicht erfolgen kann, da diese nicht einem einzigen eMP-Eintrag zugeordnet werden können.

Wird eine Stammkundenkartei gepflegt, wird auch diese aktualisiert.

**Beteiligte Systeme:** Primärsystem, ePA Medication Service, E-Rezept-Fachdienst

**Fachliche Anwendungsfälle**

| |
| :--- |
| [Anzeige der elektronischen Medikationsliste (eML)](dgmp-use-cases.md#anzeige-der-elektronischen-medikationsliste-eml) |
| [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp) |
| [Abgleich geplantes Arzneimittel - eMP](dgmp-use-cases.md#abgleich-geplantes-arzneimittel---emp) |
| [Pflege des eMP im Rahmen der Dispensierung per E-Rezept - Anlage eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-im-rahmen-der-dispensierung-per-e-rezept---anlage-eines-emp-eintrags) |
| [Pflege des eMP im Rahmen der Dispensierung per E-Rezept - Aktualisieren eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-im-rahmen-der-dispensierung-per-e-rezept---aktualisieren-eines-emp-eintrags) |
| [Durchführung von AMTS-Prüfungen](dgmp-use-cases.md#durchführung-von-amts-prüfungen) |

**Tabelle:**Fachliche Anwendungsfälle mit Bezug zu Szenario
*Dispensierung eines Arzneimittels in der Apotheke (E-Rezept)*
### Dispensierung eines Arzneimittels in der Apotheke (Kein E-Rezept)

**Auch ohne vorliegendes E-Rezept werden Arzneimittel in der Apotheke dispensiert. Dies erfolgt einerseits, wenn ein Versicherter ein analoges Rezept vorlegt, und andererseits, wenn ein rezeptfreies Arzneimittel (OTC) erworben wird. Das nachfolgende Szenario beschreibt beide Fälle einer solchen Dispensierung ohne vorliegendes E-Rezept.**

Zunächst wird das analoge Rezept in Empfang genommen bzw. der Bedarf nach einem rezeptfreien Arzneimittel (OTC) festgestellt. Um medikationsrelevante Daten in der ePA (insb. eML und eMP) in den weiteren Prozess mit einbeziehen zu können, muss der Zugriff auf die ePA in der Regel aktiv hergestellt werden. Der Apotheker muss hierfür ggf. im Gespräch klären, für wen das Arzneimittel vorgesehen ist, und anschließend eine Zugriffsberechtigung durch Einlesen der eGK bzw. über das FdV herstellen lassen.

Besteht bereits Zugriff auf eine ePA, die mutmaßlich der Person zugeordnet werden kann, für die das Arzneimittel vorgesehen ist (bspw. da eine eGK bereits am Arbeitsplatz eingelesen wurde, nebenläufig mit einer Kundenkartei gearbeitet wird oder personenbezogene Daten zu einem analogen Rezept digital verarbeitet werden), kann das Primärsystem dem Apotheker diese für ihn bereits freigeschaltete ePA auch vorschlagen.

Die weitere pharmazeutische Bewertung und Beratung erfolgt im Wesentlichen analog zu [Szenario 2](./dgmp-scenarios.md#dispensierung-eines-arzneimittels-in-der-apotheke-e-rezept).

Wird eines oder mehrere Arzneimittel abgegeben, ist der Apotheker angehalten, dies im Sinne eines Nachtrags in der ePA abzubilden. Das gilt insbesondere für verschriebene Arzneimittel, aber auch für rezeptfreie Arzneimittel (OTC), sofern eine Aufnahme in die ePA entweder vom Versicherten gewünscht oder pharmazeutisch zu empfehlen ist. Diese Entscheidung ist durch den Apotheker mit seiner pharmazeutischen Expertise und auf Basis der ihm zur Verfügung stehenden Informationen zum Versicherten zu treffen. Digital erfasste Daten zum Arzneimittel sollen für den Nachtrag verwendet werden, sodass eine manuelle Erfassung dieser entfällt.

Liegt bei bestehendem Anspruch des Versicherten ein eMP vor, soll dieser Nachtrag direkt im eMP erfolgen. Im eMP kann für jedes Arzneimittel entweder ein neuer eMP-Eintrag angelegt (Aufnahme einer Therapie) oder anhand des Nachtrags ein bestehender eMP-Eintrag aktualisiert (Fortsetzung einer Therapie) werden. Die eMP-spezifischen Informationen des eMP-Eintrags können in diesem Fall bei Bedarf angepasst oder übernommen werden. Der Nachtrag wird ohne weiteres Zutun gleichermaßen in der eML abgebildet.

**Beteiligte Systeme:** Primärsystem, ePA Medication Service

**Fachliche Anwendungsfälle**

| |
| :--- |
| [Anzeige der elektronischen Medikationsliste (eML)](dgmp-use-cases.md#anzeige-der-elektronischen-medikationsliste-eml) |
| [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp) |
| [Abgleich geplantes Arzneimittel - eMP](dgmp-use-cases.md#abgleich-geplantes-arzneimittel---emp) |
| [Nachtrag von Arzneimitteln](dgmp-use-cases.md#nachtrag-von-arzneimitteln) |
| [Korrektur eines Nachtrags](dgmp-use-cases.md#korrektur-eines-nachtrags) |
| [Durchführung von AMTS-Prüfungen](dgmp-use-cases.md#durchführung-von-amts-prüfungen) |

**Tabelle:**Fachliche Anwendungsfälle mit Bezug zu Szenario
*Dispensierung eines Arzneimittels in der Apotheke (Kein E-Rezept)*
### Medikationsanamnese, -analyse und -beratung durch einen Arzt oder einen Apotheker

**Die gesamthafte Untersuchung des Medikationsplans auf Aktualität und AMTS-Aspekte wie korrekte Indikationen, Angemessenheit und Interaktionen ist eine wichtige Voraussetzung für ein erfolgreiches Medikationsmanagement. Sie sollte regelmäßig sowohl ärztlich als auch pharmazeutisch mit dem jeweiligen Schwerpunkt erfolgen.**

Es findet zunächst eine medikationsbezogene Anamnese im Gespräch mit dem Patienten statt. Hier werden der aktuelle Medikationsstatus und ggf. bekannte arzneimittelbezogene Probleme (ABP) erhoben. Alle in der ePA gespeicherten Informationen, darunter der Medikationsplan, die Medikationsliste sowie weitere klinische Daten und Vorbefunde (z.B. Allergien oder Laborbefunde) können dabei eine Unterstützung bieten und bei Bedarf in das Primärsystem übernommen werden. Weiterhin kann es zur gesamthaften AMTS-Prüfung durch ein AMTS-Modul kommen.

Im Rahmen dieses Versorgungsprozesses können Anpassungen am Medikationsplan erforderlich sein. Gründe sind:

1. Ergebnis der Medikationsanamnese: Der Medikationsplan ist nicht aktuell. Folgende Erkenntnisse sollen daher auf dem Medikationsplan festgehalten werden:a) Ein angewendetes Arzneimittel fehlt auf dem Medikationsplanb) Die Therapie mit einem Arzneimittel auf dem Medikationsplan wurde zwischenzeitlich beendetc) Die Therapie mit einem Arzneimittel auf dem Medikationsplan wurde zwischenzeitlich angepasst
1. Ergebnis der Medikationsanalyse und -beratung: Aus medizinischen oder pharmazeutischen Gründen wird eine Anpassung der bestehenden Therapie empfohlen. Folgende Anpassungen sollen daher auf dem Medikationsplan festgehalten werden:a) Eine neue Therapie soll aufgenommen werden (Anmerkung: Hier kann auch eine Verschreibung per E-Rezept erforderlich sein)b) Eine bestehende Therapie mit einem Arzneimittel auf dem Medikationsplan soll angepasst werdenc) Eine bestehende Therapie mit einem Arzneimittel auf dem Medikationsplan soll beendet werden

Erkenntnisse und Anpassungen müssen ggf. an mitbehandelnde Leistungserbringerinstitutionen kommuniziert werden. Dies kann bspw. über die “Hinweise für Mitbehandelnde” erfolgen. Sollte der Patient dies wünschen, kann der Medikationsplan zum Abschluss für ihn ausgedruckt werden. 

**Beteiligte Systeme:** Primärsystem, ePA Medication Service, ggf. E-Rezept-Fachdienst

**Fachliche Anwendungsfälle**

| |
| :--- |
| [Anzeige der elektronischen Medikationsliste (eML)](dgmp-use-cases.md#anzeige-der-elektronischen-medikationsliste-eml) |
| [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp) |
| [Abgleich von eML und eMP](dgmp-use-cases.md#abgleich-von-eml-und-emp) |
| [Pflege des eMP aus der eML - Anlage eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-aus-der-eml---anlage-eines-emp-eintrags) |
| [Pflege des eMP aus der eML - Aktualisierung eines eMP-Eintrags](dgmp-use-cases.md#pflege-des-emp-aus-der-eml---aktualisierung-eines-emp-eintrags) |
| [Aufheben einer Verknüpfung](dgmp-use-cases.md#aufheben-einer-verknüpfung) |
| [Nachtrag von Arzneimitteln](dgmp-use-cases.md#nachtrag-von-arzneimitteln) |
| [Korrektur eines Nachtrags](dgmp-use-cases.md#korrektur-eines-nachtrags) |
|  |
| [Editieren von eMP-Einträgen](dgmp-use-cases.md#editieren-von-emp-einträgen) |
| [Pausieren von eMP-Einträgen](dgmp-use-cases.md#pausieren-von-emp-einträgen) |
| [Beenden von eMP-Einträgen](dgmp-use-cases.md#beenden-von-emp-einträgen) |
| [Aktivieren von eMP-Einträgen](dgmp-use-cases.md#aktivieren-von-emp-einträgen) |
| [Planen von eMP-Einträgen](dgmp-use-cases.md#planen-von-emp-einträgen) |
| [eMP ausdrucken](dgmp-use-cases.md#emp-ausdrucken) |
| [Durchführung von AMTS-Prüfungen](dgmp-use-cases.md#durchführung-von-amts-prüfungen) |
| [Abgleich von lokalen Daten zur Arzneimitteltherapie und eMP](dgmp-use-cases.md#abgleich-von-lokalen-daten-zur-arzneimitteltherapie-und-emp) |

**Tabelle:**Fachliche Anwendungsfälle mit Bezug zu Szenario
*Medikationsanamnese, -analyse und -beratung durch einen Arzt oder einen Apotheker*
### Lesen eines Medikationsplans durch einen berechtigten Anwender

Mehrere Anwendungsfälle benötigen einen rein lesenden Zugriff auf den Medikationsplan. Das gilt sowohl für Ärzte und Apotheker als auch für Personengruppen mit reinen Leserechten. Beispielhafte Anwendungsfälle sind:

1. Der Patient will Arzneimittel einnehmen oder deren Einnahme planen.
1. Der ambulante Pflegedienst möchte Arzneimittel stellen und/oder verabreichen.
1. Der Therapeut möchte einsehen, welche Arzneimittel eingenommen werden (z.B. ein Physiotherapeut zur Berücksichtigung der Analgesie bei der Beurteilung von Schmerzzuständen).

Filter- und Suchfunktionen können den Anwender unterstützen. Neben dem eMP liegen dem Anwender häufig weitere Informationen zur Arzneimitteltherapie vor (bspw. eML). Es kann daher hilfreich sein, diese Informationen neben dem eMP oder in Beziehung zu ihm einsehen zu können.

**Beteiligte Systeme:** Primärsystem, ePA Medication Service

**Fachliche Anwendungsfälle**

| |
| :--- |
| [Anzeige der elektronischen Medikationsliste (eML)](dgmp-use-cases.md#anzeige-der-elektronischen-medikationsliste-eml) |
| [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp) |
| [Abgleich von eML und eMP](dgmp-use-cases.md#abgleich-von-eml-und-emp) |
| [eMP ausdrucken](dgmp-use-cases.md#emp-ausdrucken) |

**Tabelle:**Fachliche Anwendungsfälle mit Bezug zu Szenario
*Lesen eines Medikationsplans durch einen berechtigten Anwender*
### Stationärer Aufenthalt und Versorgungsschnittstellen

**Während eines stationären Aufenthalts findet ein wesentlicher Teil der Medikationsplanung ohne direkten Bezug zur Telematikinfrastruktur (insb. E-Rezept und ePA) statt. Aus diesem Grund muss an den Versorgungsschnittstellen rund um einen stationären Aufenthalt sichergestellt werden, dass möglichst vollständige Informationen zur Arzneimitteltherapie übergeben werden. Das nachfolgende Szenario beschreibt den Umgang mit dem eMP an der Schnittstelle von und zu einem stationären Aufenthalt.**

Bei Aufnahme eines Patienten in eine stationäre Behandlung (z.B. Krankenhaus, Rehabilitationseinrichtung) muss erhoben werden, welche Arzneimittel vor Aufnahme in die stationäre Behandlung angewendet wurden. Die ePA bietet mit dem eMP eine zentrale Informationsquelle für diesen Anwendungszweck.

Der eMP muss im Gespräch und/oder anhand zusätzlicher Informationen (eML, Medikationsplan in Papierform, vorliegende Arzneimittel, ggf. Archiv-Daten etc.) auf Aktualität und Vollständigkeit überprüft werden. Dies kann systematisch im Sinne eines Medikationsabgleichs (Englisch: **Medication Reconciliation**) erfolgen. Alle Erkenntnisse aus diesem Prozess können im eMP erfasst werden. Werden arzneimittelbezogene Probleme (ABP) festgestellt, können Anpassungen an der Arzneimitteltherapie, die auch über den stationären Aufenthalt hinaus empfehlenswert sind, im eMP festgehalten werden. Das Vorgehen entspricht dem [Szenario 4](./dgmp-scenarios.md#medikationsanamnese--analyse-und--beratung-durch-einen-arzt-oder-einen-apotheker).

Die Daten zur **aktuellen** Arzneimitteltherapie gemäß eMP werden anschließend in das Primärsystem (z.B. KIS) überführt, um die Therapie auf die in der Einrichtung gelisteten und benötigten Arzneimittel umzustellen.

Die weitere Medikationsplanung im Rahmen des stationären Aufenthalts findet lokal im Primärsystem statt. Um den Bezug zwischen Aufnahmemedikation (eMP) und stationär angewandten Arzneimitteln zu erhalten, kann der **eMP-Identifier** der eMP-Einträge, die als Ausgangspunkt für die stationäre Medikationsplanung gedient haben, lokal persistiert werden.

Bei der Entlassung aus dem stationären Aufenthalt wird der eMP in der ePA gemäß der Entlassmedikation aktualisiert. Der **eMP-Identifier** der eMP-Einträge kann hierbei unterstützen, sofern er lokal persistiert wurde. Es können folgende Änderungen erforderlich sein:

1. Eine neue Therapie wurde während des stationären Aufenthalts begonnen und soll fortgeführt werden/soll mit der Entlassung aufgenommen werden: Ein eMP-Eintrag wird angelegt. Dies kann mit oder ohne Verschreibung per E-Rezept stattfinden (Entlassrezept). Alternativ kann auch ein Nachtrag mit einem eMP-Eintrag angelegt werden (z.B. bei direkter Abgabe eines Arzneimittels an den Patienten).
1. Eine bestehende Therapie mit einem Arzneimittel auf dem Medikationsplan wurde während des stationären Aufenthalts angepasst/soll mit der Entlassung angepasst werden: Der eMP-Eintrag wird editiert. Wird die Therapie mit einem neuen Arzneimittel fortgesetzt, findet dies im Rahmen einer Verschreibung per E-Rezept statt oder geht mit einem Nachtrag einher (z.B. bei direkter Abgabe des Arzneimittels an den Patienten).
1. Eine bestehende Therapie mit einem Arzneimittel auf dem Medikationsplan wurde während des stationären Aufenthalts beendet/soll mit der Entlassung beendet werden: Der eMP-Eintrag wird “beendet”.

Wird im Laufe des Prozesses ein Entlassrezept per E-Rezept ausgestellt, kann analog zu [Szenario 1](./dgmp-scenarios.md#medikationsplanung-und-verschreibung-eines-arzneimittels-durch-einen-arzt) verfahren werden. Ist der eMP aktualisiert worden, kann er bei Bedarf für den Versicherten ausgedruckt werden. Alternativ kann die Aktualisierung des eMP in der ePA durch den nachbehandelnden Arzt anhand der Entlassdokumentation erfolgen.

**Beteiligte System:** Primärsystem, ePA Medication Service, ggf. E-Rezept-Fachdienst

**Fachliche Anwendungsfälle**

| |
| :--- |
| [Anzeige der elektronischen Medikationsliste (eML)](dgmp-use-cases.md#anzeige-der-elektronischen-medikationsliste-eml) |
| [Anzeige des elektronischen Medikationsplans (eMP)](dgmp-use-cases.md#anzeige-des-elektronischen-medikationsplans-emp) |
| [eMP ausdrucken](dgmp-use-cases.md#emp-ausdrucken) |
| [Durchführung von AMTS-Prüfungen](dgmp-use-cases.md#durchführung-von-amts-prüfungen) |
| [Übernahme des eMP in das lokale PS](dgmp-use-cases.md#übernahme-des-emp-in-das-lokale-ps) |
| [Abgleich von lokalen Daten zur Arzneimitteltherapie und eMP](dgmp-use-cases.md#abgleich-von-lokalen-daten-zur-arzneimitteltherapie-und-emp) |

**Tabelle:**Fachliche Anwendungsfälle mit Bezug zu Szenario
*Stationärer Aufenthalt und Versorgungsschnittstellen*

