# Steckbrief: ePA Medication Service - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**Steckbriefe**](spec-sheet.md)
* **Steckbrief: ePA Medication Service**

## Steckbrief: ePA Medication Service

Die nachstehende Tabelle fasst Anforderungen dieses Implementation Guide für den **ePA Medication Service** zusammen.

| | | |
| :--- | :--- | :--- |
| [IG-MED97245ECM](./render-api-emp.md) | eMP-PDF/A: Grundlegendes Layout | MUSS |
| [IG-MED86167Z7G](./migration.md) | Einmalige Durchführung der Migration | MUSS |
| [IG-MED27473S8B-02](./op-cancel-prescription-erp.md) | Verarbeitung der Operation Verschreibungsdaten stornieren durch den Medication Service | MUSS |
| [IG-MED22047NEW-01](./op-update-emp-entry.md) | Ausführung der Geschäftlogik der Operation eMP-Eintrag aktualisieren | MUSS |
| [IG-MED99873AG4](./op-batch-emp.md) | Atomare Ausführung der Operation Batch eMP-Einträge | MUSS |
| [IG-MED53837PHV](./op-batch-emp.md) | Antwortverhalten der Operation Batch eMP-Einträge | MUSS |
| [IG-MED72454UMG](./privacy-security.md) | Medication Service - Erzeugung eines XHTML-Exports | MUSS |
| [IG-MED72042KWR-03](./op-get-medication-list.md) | Abruf der Medikationsliste (eML) ohne Datumsfilter | MUSS |
| [IG-MED31793UJS](./general-principles.md) | Non-FHIR HTTP Status Codes für Schnittstellen des Medciation Service | MUSS |
| [IG-MED22121MHS](./render-api-eml.md) | Unterstützung der Media Types für die aufbereitete elektronische Medikationsliste (eML) | MUSS |
| [IG-MED97456XU7](./query-api-practitioner.md) | Verarbeitung von Suchparametern für Practitioner | MUSS |
| [IG-MED35195DPV](./op-batch-emp.md) | Reihenfolge der Verarbeitung in der Operation Batch eMP-Einträge | MUSS |
| [IG-MED91552N6U-02](./op-cancel-dispensation-erp.md) | Verarbeitung der Operation Dispensierinformationen stornieren durch den Medication Service | MUSS |
| [IG-MED39684YEU-03](./query-api-practitioner.md) | Standardsortierung für Practitioner | MUSS |
| [IG-MED11670DEY-01](./op-cancel-prescription-erp.md) | Ausführung der Geschäftlogik der Operation Verschreibungsdaten stornieren | MUSS |
| [IG-MED41440L4D](./render-api-eml.md) | Ausschluss fehlerhafter oder stornierter Daten in der gerenderten Medikationsliste (eML) | MUSS |
| [IG-MED97505ZEG](./general-principles.md) | Gewährleistung der Profilkonformität | MUSS |
| [IG-MED94460V8J-01](./privacy-security.md) | Zugriffsrechte gemäß Legal Policy | MUSS |
| [IG-MED25360QCP](./op-get-medication-list.md) | Patient-Instanz als erstes Element der ersten Ergebnisseite im Suchergebnis der Operation Medikationsliste abrufen (eML) | MUSS |
| [IG-MED99966BUK](./op-update-emp-entry.md) | HTTP Header X-Requesting-Organization bei Operation eMP-Eintrag aktualisieren | MUSS |
| [IG-MED93348UAJ-01](./op-add-emp-entry.md) | Ausführung der Geschäftlogik der Operation eMP-Eintrag hinzufügen | MUSS |
| [IG-MED91662SNC](./op-get-medication-list.md) | Rückgabe eines FHIR Bundle vom Typ searchset für die Operation Medikationsliste abrufen (eML) | MUSS |
| [IG-MED30597ZJA](./privacy-security.md) | Erforderliche Benutzerinformationen für Medication Service Schnittstellen | MUSS |
| [IG-MED65720GKQ](./op-emp-commit.md) | Fehlerbehandlung bei Aufruf der Operation eMP commit außerhalb einer Stapelverarbeitung | MUSS |
| [IG-MED59929SZJ-01](./op-unlink-emp.md) | Ausführung der Geschäftlogik der Operation Entfernen einer eML-eMP-Verknüpfung | MUSS |
| [IG-MED08038M2V](./op-batch-emp.md) | Operation Batch eMP-Einträge – Serverinternes Ausführungskontext‑Flag | MUSS |
| [IG-MED98922HV4](./op-link-emp.md) | HTTP Header X-Requesting-Organization bei Operation Hinzufügen einer eML-eMP-Verknüpfung | MUSS |
| [IG-MED11815X3Q](./render-api-emp.md) | eMP-PDF/A: Administrationsblock | MUSS |
| [IG-MED37997J2U](./query-api-medicationstatement.md) | Standardsortierung für MedicationStatement | MUSS |
| [IG-MED03955ENL](./op-cancel-eml-entry.md) | Durchführung der Operation eML-Eintrag stornieren | MUSS |
| [IG-MED17706LL3-01](./op-add-emp-entry.md) | Setzen des MedicationPlanIdentifier beim Erstellen eines eMP-Eintrags | MUSS |
| [IG-MED72972QGC](./render-api-emp.md) | eMP-PDF/A: Darstellung der Dosierung in einer Zusatzzeile | MUSS |
| [IG-MED23573F00](./render-api-eml.md) | Darstellung von Substitution und Mehrfachverordnung in der gerenderten elektronischen Medikationsliste (eML) | MUSS |
| [IG-MED02895QQP](./query-api-provenance.md) | Verarbeitung von Suchparametern für Provenance | MUSS |
| [IG-MED23860M4B](./render-api-emp.md) | eMP-PDF/A: Unterstützung der Media Types | MUSS |
| [IG-MED12861P6W](./general-principles.md) | Verwerfen übermittelter Ressource-IDs bei Operationen | MUSS |
| [IG-MED54433PBV-02](./general-principles.md) | Ausschluss der KBV-Schlüsseltabellen-Validierung für FHIR-Operationen des E-Rezept-Fachdienstes | MUSS |
| [IG-MED91744QDR](./op-medication-plan-log.md) | Rückgabe eines FHIR Bundle vom Typ searchset für die Operation eMP-Chronologie abrufen | MUSS |
| [IG-MED18735RJF](./render-api-emp.md) | eMP-PDF/A: FHIR-Daten für die Operation | MUSS |
| [IG-MED20374GEG](./render-api-emp.md) | eMP-PDF/A: tabellarische Darstellung der Dosierung | MUSS |
| [IG-MED17281DXD-01](./op-cancel-eml-entry.md) | Ausführung der Geschäftlogik der Operation eML-Eintrag stornieren | MUSS |
| [IG-MED44250WUY](./render-api-emp.md) | eMP-PDF/A: Bereiche | MUSS |
| [IG-MED14869UQV](./op-medication-plan-log.md) | Durchführung der Operation eMP Chronologie abrufen nach der FHIR OperationDefinition | MUSS |
| [IG-MED03194N37](./op-get-medication-list.md) | Durchführung der Operation Medikationsliste abrufen (eML) nach der FHIR OperationDefinition | MUSS |
| [IG-MED07754P5P-02](./op-cancel-prescription-erp.md) | Partial Success für die Operation Verschreibungsdaten stornieren | MUSS |
| [IG-MED32282ZGM](./general-principles.md) | Ignorierung von FHIR-Profilangaben | MUSS |
| [IG-MED48361BE0](./general-principles.md) | Generierung des EPAMedicationUniqueIdentifier | MUSS |
| [IG-MED03188C0X-04](./op-get-medication-list.md) | Sortierung des Suchergebnisses in der Operation Medikationsliste abrufen (eML) | MUSS |
| [IG-MED07036EKU-03](./query-api-medicationrequest.md) | Standardsortierung für MedicationRequest | MUSS |
| [IG-MED20855WKX-03](./general-principles.md) | Bereitstellung von Statusmeldungen als EPAOperationOutcome durch den Medication Service | MUSS |
| [IG-MED14428K6S](./op-get-medication-plan.md) | Fehlerantwort bei nicht existierender Version des Medikationsplans (eMP) | MUSS |
| [IG-MED31287N4W](./privacy-security.md) | Medication Service - Ablehnung von Request bei vorliegendem Widerspruch | MUSS |
| [IG-MED84431U1K](./render-api-emp.md) | eMP-PDF/A: Darstellung mehrerer Dosierinformationen in einer Zusatzzeile | MUSS |
| [IG-MED71271QKC](./op-update-emp-entry.md) | Durchführung der Operation eMP-Eintrag aktualisieren nach der FHIR OperationDefinition | MUSS |
| [IG-MED94401KPF-01](./op-cancel-dispensation-erp.md) | Ausführung der Geschäftlogik der Operation Dispensierinformationen stornieren | MUSS |
| [IG-MED77591TGH](./op-medication-plan-log.md) | Sortierung des Suchergebnisses in der Operation eMP-Chronologie abrufen | MUSS |
| [IG-MED45106BK4](./op-batch-emp.md) | Durchführung der Operation Batch eMP-Einträge nach der FHIR OperationDefinition | MUSS |
| [IG-MED30756HWV](./op-add-eml-entry.md) | HTTP Header X-Requesting-Organization bei Operation eML-Eintrag hinzufügen | MUSS |
| [IG-MED40234G89](./general-principles.md) | Erzeugung und Zuweisung des RxPrescriptionProcessIdentifier | MUSS |
| [IG-MED30750BK0-02](./op-get-medication-list.md) | Ausschluss stornierter Instanzen in der Operation Medikationsliste abrufen (eML) | MUSS |
| [IG-MED54318LJQ](./render-api-emp.md) | eMP-PDF/A: Darstellung der Stärke | MUSS |
| [IG-MED06281JMT](./general-principles.md) | Keine Übernahme von Referenzen bei übermittelten Ressourcen in Operationen | MUSS |
| [IG-MED98977HQ9-01](./migration.md) | Migrationsschritte Version 1.3.0 | MUSS |
| [IG-MED98996PR0-03](./op-get-medication-list.md) | Verarbeitung des Datumsfilters in der Operation Medikationsliste abrufen (eML) | MUSS |
| [IG-MED20540Q9L](./op-emp-commit.md) | Durchführung der Operation eMP commit nach der FHIR OperationDefinition | MUSS |
| [IG-MED29796HBG](./privacy-security.md) | Medication Service - Nutzung der FHIR-Operationen durch den E-Rezept-Fachdienst | MUSS |
| [IG-MED72792GXE](./op-link-emp.md) | Durchführung der Operation Hinzufügen einer eML-eMP-Verknüpfung nach der FHIR OperationDefinition | MUSS |
| [IG-MED59111MZT-03](./query-api-organization.md) | Standardsortierung für Organization | MUSS |
| [IG-MED75135Q7B-02](./render-api-eml.md) | Status Codes der Render API für das Abrufen der aufbereiteten elektronische Medikationsliste (eML) | MUSS |
| [IG-MED93814QXJ](./render-api-eml.md) | Inhalte der gerenderten Medikationsliste (eML) in PDF/A und XHTML | MUSS |
| [IG-MED50059JZB](./op-add-eml-entry.md) | Durchführung der Operation eML-Eintrag hinzufügen | MUSS |
| [IG-MED89895TXC](./general-principles.md) | Keine EPAMedicationUniqueIdentifier für Contained Medications | MUSS |
| [IG-MED75912NBU](./op-unlink-emp.md) | Durchführung der Operation Entfernen einer eML-eMP-Verknüpfung nach der FHIR OperationDefinition | MUSS |
| [IG-MED63198EH0](./op-medication-plan-log.md) | Rückgabe eines leeren Bundles bei fehlenden eMP-Chronologieeinträgen | MUSS |
| [IG-MED00545NYB](./migration.md) | Nachtrag von Versionen in ATC-Codes | MUSS |
| [IG-MED35894UP4](./op-get-medication-plan.md) | eMP-FHIR: Fehlerantwort bei nicht existierendem Medikationsplan (eMP) | MUSS |
| [IG-MED46271FNY-01](./render-api-emp.md) | eMP-PDF/A: Identifikationsblock | MUSS |
| [IG-MED66689BZJ](./render-api-emp.md) | eMP-PDF/A: Darstellung des Anwendungszeitraums | MUSS |
| [IG-MED12459N5S-01](./render-api-emp.md) | eMP-PDF/A: Toleranzen | MUSS |
| [IG-MED59646EXK](./general-principles.md) | Erzeugung und Zuweisung des RxOriginatorProcessIdentifier | MUSS |
| [IG-MED06437XCT-03](./render-api-eml.md) | Datenquelle und Aufbereitung der gerenderten elektronischen Medikationsliste (eML) in PDF/A und XHTML im Medication Service | MUSS |
| [IG-MED07348YLU-02](./op-cancel-dispensation-erp.md) | Partial Success für die Operation Dispensierung stornieren | MUSS |
| [IG-MED20994Z5N](./render-api-emp.md) | eMP-PDF/A: Zeilenumbrüche in Tabellenfeldern | MUSS |
| [IG-MED88626YDT-01](./migration.md) | Korrektur von Berufsbezeichnungen in Practitioner-Instanzen bei Verschreibungsdaten | MUSS |
| [IG-MED18505C38](./op-get-medication-plan.md) | Durchführung der Operation Medikationsplan abrufen (eMP) nach der FHIR OperationDefinition | MUSS |
| [IG-MED85114G5M](./op-cancel-eml-entry.md) | HTTP Header X-Requesting-Organization bei Operation eML-Eintrag stornieren | MUSS |
| [IG-MED81255FHZ](./render-api-emp.md) | eMP-PDF/A: Seitenbefüllung | MUSS |
| [IG-MED66902Z2U](./query-api-medicationdispense.md) | Verarbeitung von Suchparametern für MedicationDispense | MUSS |
| [IG-MED87542J43](./general-principles.md) | Implementierung der /metadata Funktion im Medication Service | MUSS |
| [IG-MED73200HNW](./op-get-medication-plan.md) | Rückgabe eines FHIR Bundle vom Typ collection für die Operation Medikationsplan abrufen (eMP) | MUSS |
| [IG-MED69057S0X](./op-get-medication-list.md) | Einbindung der Patient-Instanz aus dem Patient Service in das Suchergebnis der Operation Medikationsliste abrufen (eML) | MUSS |
| [IG-MED03519KYL](./render-api-emp.md) | eMP-PDF/A: Darstellung von Kombipräparaten | MUSS |
| [IG-MED55122C60](./query-api-medicationrequest.md) | Verarbeitung von Suchparametern für MedicationRequest | MUSS |
| [IG-MED68581A3P-03](./query-api-medicationdispense.md) | Standardsortierung für MedicationDispense | MUSS |
| [IG-MED51601THQ](./general-principles.md) | Validierung der aufbereiteten Dosierungsdarstellung gemäß HL7 Deutschland e.V. DosageDgMP-Profil | MUSS |
| [IG-MED20676FFH](./render-api-emp.md) | eMP-PDF/A: Darstellung der Dosierung (dosageInstruction) | MUSS |
| [IG-MED39764RR6](./op-batch-emp.md) | Operation Batch eMP-Einträge – Konformität zu FHIR R4 batch/transaction | MUSS |
| [IG-MED68233Q6E](./query-api-medication.md) | Verarbeitung von Suchparametern für Medication | MUSS |
| [IG-MED24600WA1](./privacy-security.md) | Medication Service - Schemavalidierung | MUSS |
| [IG-MED00206H71-02](./op-provide-dispensation-erp.md) | Verarbeitung der Operation Dispensierinformationen einstellen durch den Medication Service | MUSS |
| [IG-MED16008ST8-02](./op-get-medication-list.md) | Integrität der Suchergebnisseite bei Abruf der Medikationsliste (eML) | MUSS |
| [IG-MED90648H2W](./op-unlink-emp.md) | HTTP Header X-Requesting-Organization bei Operation Entfernen einer eML-eMP-Verknüpfung | MUSS |
| [IG-MED78911M80](./general-principles.md) | Komma als Dezimaltrennzeichen in Render APIs | MUSS |
| [IG-MED45859RPQ-02](./op-provide-dispensation-erp.md) | Durchführung der Operation Dispensierinformationen einstellen nach der FHIR OperationDefinition | MUSS |
| [IG-MED55163NJS-02](./op-cancel-dispensation-erp.md) | Durchführung der Operation Dispensierinformationen stornieren nach der FHIR OperationDefinition | MUSS |
| [IG-MED99233F7E](./op-medication-plan-log.md) | Suchergebnis und Datenmenge für die Operation eMP-Chronologie abrufen | MUSS |
| [IG-MED36764UB7-02](./op-provide-prescription-erp.md) | Verarbeitung der Operation Verschreibungsdaten einstellen durch den Medication Service | MUSS |
| [IG-MED32071XZW-02](./op-provide-prescription-erp.md) | Durchführung der Operation Verschreibungsdaten einstellen nach der FHIR OperationDefinition | MUSS |
| [IG-MED16176F73](./op-provide-prescription-erp.md) | Kennzeichnung neuer MedicationStatement-Instanz mit PRESCRIPTION bei der Operation Verschreibungsdaten einstellen | MUSS |
| [IG-MED46774KZV](./op-link-emp.md) | Ausführung der Geschäftlogik der Operation Hinzufügen einer eML-eMP-Verknüpfung | MUSS |
| [IG-MED28501PRA](./query-api-organization.md) | Verarbeitung von Suchparametern für Organization | MUSS |
| [IG-MED71384CP6-03](./query-api-medication.md) | Standardsortierung für Medication | MUSS |
| [IG-MED61434W6C](./render-api-emp.md) | eMP-PDF/A: Medikationstabelle | MUSS |
| [IG-MED60410V23-02](./op-cancel-prescription-erp.md) | Durchführung der Operation Verschreibungsdaten stornieren nach der FHIR OperationDefinition | MUSS |
| [IG-MED03974KZQ](./migration.md) | Durchführungszeitpunkt | MUSS |
| [IG-MED24331WH3](./op-medication-plan-log.md) | Unterstützung der Paginierung in der Operation eMP-Chronologie abrufen | MUSS |
| [IG-MED14935D6N](./op-add-eml-entry.md) | Ausführung der Geschäftlogik der Operation eML-Eintrag hinzufügen | MUSS |
| [IG-MED57011GPN-03](./general-principles.md) | Zusammenstellung der Hashwerte des EPAMedicationUniqueIdentifier | MUSS |
| [IG-MED47869JD8-02](./op-provide-dispensation-erp.md) | Erkennung und Verarbeitung von Substitutionen bei der Operation Dispensierinformationen einstellen | MUSS |
| [IG-MED73987WSL-02](./op-provide-prescription-erp.md) | Partial Success für die Operation Verschreibungsdaten einstellen | MUSS |
| [IG-MED10129K1D](./general-principles.md) | Verwaltung des EPAMedicationUniqueIdentifier | MUSS |
| [IG-MED07144WB0-01](./op-get-medication-plan.md) | Sortierung des Suchergebnisses in der Operation Medikationsplan abrufen (eMP) | MUSS |
| [IG-MED23887CCD-01](./op-add-emp-entry.md) | Durchführung der Operation eMP-Eintrag hinzufügen nach der FHIR OperationDefinition | MUSS |
| [IG-MED17488MTF](./general-principles.md) | Medication-Service-Schnittstellen: Bereitstellung auf vordefinierten Pfaden im VAU-Kanal | MUSS |
| [IG-MED64473BLY-02](./render-api-eml.md) | Schematischer Aufbau und Datenherkunft der generierten elektronischen Medikationsliste (eML) | MUSS |
| [IG-MED06688ZUT](./query-api-medicationstatement.md) | Verarbeitung von Suchparametern für MedicationStatement | MUSS |
| [IG-MED67446E6Y-02](./op-provide-dispensation-erp.md) | Partial Success für die Operation Dispensierinformationen einstellen | MUSS |
| [IG-MED98676XV4](./op-batch-emp.md) | Ausführung der Geschäftlogik der Operation Batch eMP-Einträge | MUSS |
| [IG-MED60219YNT](./render-api-emp.md) | Status Codes der Render API für das Abrufen des aufbereiteten elektronischen Medikationsplans (eMP) | MUSS |
| [IG-MED61563Z4Y](./op-get-medication-list.md) | Auflösung von Organization-Referenzen in Provenance.agent.who für die Operation Medikationsliste abrufen (eML) | MUSS |
| [IG-MED44820T9V](./query-api-provenance.md) | Standardsortierung für Provenance | MUSS |
| [IG-MED25166HZB-03](./query-api-practitioner-role.md) | Standardsortierung für PractitionerRole | MUSS |
| [IG-MED98457Y57-02](./op-get-medication-list.md) | Konsistenz der referenzierten Instanzen innerhalb einer Ergebnisseite in der Operation Medikationsliste abrufen (eML) | MUSS |
| [IG-MED19844CVF](./render-api-emp.md) | eMP-PDF/A: Zeilenumbruch im Feld Form | MUSS |
| [IG-MED80730R7R](./render-api-emp.md) | eMP-PDF/A: Datenherkunft Tabelleninhalte | MUSS |
| [IG-MED25363BKT](./privacy-security.md) | Medication Service - Ablehnung von Request bei vorliegendem Widerspruch gegen die Nutzung durch eine spezifische LEI | MUSS |
| [IG-MED93441Y6A](./render-api-emp.md) | eMP-PDF/A: Fußbereich | MUSS |
| [IG-MED56911ZM0](./op-get-medication-list.md) | Unterstützung der Paginierung in der Operation Medikationsliste abrufen (eML) | MUSS |
| [IG-MED40417H68-02](./general-principles.md) | Rückgabe von Diagnosedaten beim Einstellen von Daten durch E-Rezept-Fachdienst | SOLL |
| [IG-MED29593UZM](./privacy-security.md) | Medication Service - Löschen der Daten des Medication Service | MUSS |
| [IG-MED83410GLG](./op-add-eml-entry.md) | Kennzeichnung neuer MedicationStatement-Instanz mit MANUAL bei der Operation eML-Eintrag hinzufügen | MUSS |
| [IG-MED67431CY7](./privacy-security.md) | Medication Service - Ablehnung neuer Daten bei vorliegendem Widerspruch | MUSS |
| [IG-MED98416U4Q-02](./op-get-medication-list.md) | Suchergebnis und Datenmenge für die Operation Medikationsliste abrufen (eML) | MUSS |
| [IG-MED97198KBW-01](./op-add-emp-entry.md) | HTTP Header X-Requesting-Organization bei Operation eMP-Eintrag hinzufügen | MUSS |
| [IG-MED90507DCV](./op-emp-commit.md) | Ausführung der Geschäftlogik der Operation eMP commit | MUSS |
| [IG-MED70442FNC](./render-api-emp.md) | eMP-PDF/A: Verbot von Dubletten | MUSS |
| [IG-MED77392SBV](./op-get-medication-plan.md) | Ergebnis und Datenmenge für die Operation Medikationsplan abrufen (eMP) | MUSS |
| [IG-MED53251YE4](./op-provide-prescription-erp.md) | Ausführung der Geschäftlogik der Operation Verschreibungsdaten einstellen | MUSS |
| [IG-MED78473ZXQ-01](./op-provide-dispensation-erp.md) | Ausführung der Geschäftlogik der Operation Dispensierinformationen einstellen | MUSS |
| [IG-MED16217P4A](./op-get-medication-list.md) | Fehlerantwort bei leerer Medikationsliste (eML) | MUSS |
| [IG-MED41381ZKR](./op-batch-emp.md) | HTTP Header X-Requesting-Organization bei Operation Batch eMP-Einträge | MUSS |
| [IG-MED88881HWN](./query-api-practitioner-role.md) | Verarbeitung von Suchparametern für PractitionerRole | MUSS |

**Tabelle:**Anforderungen
*ePA Medication Service*

