# TeratogenicExtension - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **TeratogenicExtension**

## Extension: TeratogenicExtension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/teratogenic-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:TeratogenicExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Abbildung der Angaben zur Verordnung eines teratogenen Arzneimittels (T-Rezept)

**Context of Use**

This extension may be used on the following element(s):

* Element ID Element

**Usage info**

**Usages:**

* Use this Extension: [EPA MedicationRequest](StructureDefinition-epa-medication-request.md)
* Examples for this Extension: [MedicationRequest/f6b1d9ab-4ff0-405e-8d2d-7a181d9fdbdd](MedicationRequest-f6b1d9ab-4ff0-405e-8d2d-7a181d9fdbdd.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/teratogenic-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-teratogenic-extension.csv), [Excel](StructureDefinition-teratogenic-extension.xlsx), [Schematron](StructureDefinition-teratogenic-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "teratogenic-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/teratogenic-extension",
  "version" : "1.3.0",
  "name" : "TeratogenicExtension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Abbildung der Angaben zur Verordnung eines teratogenen Arzneimittels (T-Rezept)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Abbildung der Angaben zur Verordnung eines teratogenen Arzneimittels (T-Rezept)"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "description" : "Extensions are always sliced by (at least) url",
          "rules" : "closed"
        },
        "min" : 5
      },
      {
        "id" : "Extension.extension:off-label",
        "path" : "Extension.extension",
        "sliceName" : "off-label",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:off-label.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:off-label.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "off-label"
      },
      {
        "id" : "Extension.extension:off-label.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Off-Label",
        "definition" : "Dieses Feld enthält eine Angabe, ob eine Behandlung außerhalb der jeweils zugelassenen Anwendungsgebiete („Off-Label“) erfolgt.",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:childbearing-potential",
        "path" : "Extension.extension",
        "sliceName" : "childbearing-potential",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:childbearing-potential.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:childbearing-potential.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "childbearing-potential"
      },
      {
        "id" : "Extension.extension:childbearing-potential.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Gebärfähige Frau",
        "definition" : "Dieses Feld enthält die Angabe, ob es sich um eine Verschreibung für eine gebärfähige Frau handelt.",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:security-compliance",
        "path" : "Extension.extension",
        "sliceName" : "security-compliance",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:security-compliance.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:security-compliance.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "security-compliance"
      },
      {
        "id" : "Extension.extension:security-compliance.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Einhaltung Sicherheitsmaßnahmen",
        "definition" : "Dieses Feld enthält eine Angabe, ob die Sicherheitsmaßnahmen gemäß der aktuellen Fachinformation eines entsprechenden Fertigarzneimittels eingehalten werden, insbesondere, dass erforderlichenfalls ein Schwangerschafts-Präventionsprogramm durchgeführt wird.",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:hand-out-information-material",
        "path" : "Extension.extension",
        "sliceName" : "hand-out-information-material",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:hand-out-information-material.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:hand-out-information-material.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "hand-out-information-material"
      },
      {
        "id" : "Extension.extension:hand-out-information-material.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Aushändigung Informationsmaterialien",
        "definition" : "Dieses Feld enthält eine Angabe, ob der Patientin oder dem Patienten vor Beginn der medikamentösen Behandlung geeignete medizinische Informationsmaterialien ausgehändigt wurden.",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:declaration-of-expertise",
        "path" : "Extension.extension",
        "sliceName" : "declaration-of-expertise",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:declaration-of-expertise.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:declaration-of-expertise.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "declaration-of-expertise"
      },
      {
        "id" : "Extension.extension:declaration-of-expertise.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Erklärung Sachkenntnis",
        "definition" : "Dieses Feld enthält die Erklärung, ob die verschreibende Person über ausreichende Sachkenntnisse zur Verschreibung von Arzneimitteln mit Lenalidomid, Pomalidomid oder Thalidomid verfügt.",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/teratogenic-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
