# RxPrescriptionProcessIdentifierExtension - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **RxPrescriptionProcessIdentifierExtension**

## Extension: RxPrescriptionProcessIdentifierExtension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension | *Version*:1.0.6-2 |
| Active as of 2025-05-12 | *Computable Name*:RxPrescriptionProcessIdentifierExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

This extension is used to track medication prescription transactions between the E-Rezept-Fachdienst and the ePA. The RxPrescriptionProcessIdentifier is generated by the ePA Medication Service and consists of the PrescriptionId and the authoredOn date of the operation parameters request. It ensures consistent referencing and management of medication-related resources across different systems.

**Context of Use**

This extension may be used on the following element(s):

* Element ID Element

**Usage info**

**Usages:**

* Use this Extension: [EPA MedicationDispense](StructureDefinition-epa-medication-dispense.md), [EPA Pharmaceutical Product Medication](StructureDefinition-epa-medication-pharmaceutical-product.md), [EPA Medication PZN Ingredient](StructureDefinition-epa-medication-pzn-ingredient.md), [EPA MedicationStatement](StructureDefinition-epa-medication-statement.md) and [EPA Medication](StructureDefinition-epa-medication.md)
* Examples for this Extension: [Bundle/example-get-medication-list-bundle1](Bundle-example-get-medication-list-bundle1.md), [Bundle/example-get-medication-plan-bundle-1](Bundle-example-get-medication-plan-bundle-1.md), [Bundle/example-searchset-medication](Bundle-example-searchset-medication.md), [Bundle/example-searchset-medicationdispense](Bundle-example-searchset-medicationdispense.md)...Show 31 more,[Bundle/example-searchset-medicationstatement](Bundle-example-searchset-medicationstatement.md),[Medication/1254591a-dd2d-4d17-b8f8-ee3155da0699](Medication-1254591a-dd2d-4d17-b8f8-ee3155da0699.md),[Medication/19549515-60a8-4e1c-b86a-49518053fe9f](Medication-19549515-60a8-4e1c-b86a-49518053fe9f.md),[Medication/312d581c-f5e7-4faa-9de5-c4e1568c6db2](Medication-312d581c-f5e7-4faa-9de5-c4e1568c6db2.md),[Medication/3f0b0cb0-e8cf-4aaf-bad8-01a51619417b](Medication-3f0b0cb0-e8cf-4aaf-bad8-01a51619417b.md),[Medication/56ca34f1-a3f3-42f7-95a2-f5a6423c2031](Medication-56ca34f1-a3f3-42f7-95a2-f5a6423c2031.md),[Medication/659c0be1-2ec8-4137-9698-dcffee811934](Medication-659c0be1-2ec8-4137-9698-dcffee811934.md),[Medication/83d7ad1c-47d1-4524-829a-5b86ce333bbc](Medication-83d7ad1c-47d1-4524-829a-5b86ce333bbc.md),[Medication/a2aa2baf-c37d-40e0-bff5-f6e8a58dc2c3](Medication-a2aa2baf-c37d-40e0-bff5-f6e8a58dc2c3.md),[Medication/ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e](Medication-ab8addbd-c4c7-48d2-bf4b-4a7c99f9fd6e.md),[Medication/bb91cde8-0426-4f4b-a766-5d818d0605bd](Medication-bb91cde8-0426-4f4b-a766-5d818d0605bd.md),[Medication/deecd514-235d-41df-a664-e3672208f410](Medication-deecd514-235d-41df-a664-e3672208f410.md),[Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e](Medication-fc7b28e8-05ac-4ac8-86d7-7677d9c6134e.md),[MedicationDispense/3c10c1ad-1d7a-47e8-abab-00b8299b49b8](MedicationDispense-3c10c1ad-1d7a-47e8-abab-00b8299b49b8.md),[MedicationDispense/4e6e1623-778e-44a3-b208-8479f5339e43](MedicationDispense-4e6e1623-778e-44a3-b208-8479f5339e43.md),[MedicationDispense/5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad](MedicationDispense-5aeaf266-a7ee-4e9d-bcb9-3c7dde96abad.md),[MedicationDispense/6250569a-3505-4db7-aebc-45dba1f98acc](MedicationDispense-6250569a-3505-4db7-aebc-45dba1f98acc.md),[MedicationDispense/b2911d1e-fc63-47bb-8887-63b701bc49c4](MedicationDispense-b2911d1e-fc63-47bb-8887-63b701bc49c4.md),[MedicationDispense/c0b553bd-2542-49d7-b5e1-0a770185e39f](MedicationDispense-c0b553bd-2542-49d7-b5e1-0a770185e39f.md),[MedicationDispense/c3a353f0-c61a-4d6b-affa-daf8c0f6e77c](MedicationDispense-c3a353f0-c61a-4d6b-affa-daf8c0f6e77c.md),[MedicationDispense/f7240e05-01a1-4ce6-a8bb-edb71b6b5104](MedicationDispense-f7240e05-01a1-4ce6-a8bb-edb71b6b5104.md),[MedicationDispense/fa0c29e1-c4e7-4f08-91ab-598a2233867c](MedicationDispense-fa0c29e1-c4e7-4f08-91ab-598a2233867c.md),[MedicationStatement/0fc1f006-5793-4501-81b6-fe3918fcfa2d](MedicationStatement-0fc1f006-5793-4501-81b6-fe3918fcfa2d.md),[MedicationStatement/133c8159-6398-4937-984a-d741e24556ad](MedicationStatement-133c8159-6398-4937-984a-d741e24556ad.md),[MedicationStatement/1b88713c-64cc-40ad-9665-70ca5f7dfb08](MedicationStatement-1b88713c-64cc-40ad-9665-70ca5f7dfb08.md),[MedicationStatement/405ff43e-bc8e-4109-b370-3e31431c5fe0](MedicationStatement-405ff43e-bc8e-4109-b370-3e31431c5fe0.md),[MedicationStatement/ab495b80-c9d2-4ed6-a076-b44b8dfae75a](MedicationStatement-ab495b80-c9d2-4ed6-a076-b44b8dfae75a.md),[MedicationStatement/b87b0908-7765-4ec0-8662-7d3daff08f6e](MedicationStatement-b87b0908-7765-4ec0-8662-7d3daff08f6e.md),[MedicationStatement/cfb84928-15d6-468c-8e17-e77f1ed44904](MedicationStatement-cfb84928-15d6-468c-8e17-e77f1ed44904.md),[MedicationStatement/f29f1d0c-be05-4b0d-a335-3e508da39c0c](MedicationStatement-f29f1d0c-be05-4b0d-a335-3e508da39c0c.md)and[MedicationStatement/f3988023-2313-4645-bd6b-f9e37cfb6fc7](MedicationStatement-f3988023-2313-4645-bd6b-f9e37cfb6fc7.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/rx-prescription-process-identifier-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-rx-prescription-process-identifier-extension.csv), [Excel](StructureDefinition-rx-prescription-process-identifier-extension.xlsx), [Schematron](StructureDefinition-rx-prescription-process-identifier-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rx-prescription-process-identifier-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension",
  "version" : "1.0.6-2",
  "name" : "RxPrescriptionProcessIdentifierExtension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-05-12",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "This extension is used to track medication prescription transactions between the E-Rezept-Fachdienst and the ePA. The RxPrescriptionProcessIdentifier is generated by the ePA Medication Service and consists of the PrescriptionId and the authoredOn date of the operation parameters request. It ensures consistent referencing and management of medication-related resources across different systems.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "This extension is used to track medication prescription transactions between the E-Rezept-Fachdienst and the ePA. The RxPrescriptionProcessIdentifier is generated by the ePA Medication Service and consists of the PrescriptionId and the authoredOn date of the operation parameters request. It ensures consistent referencing and management of medication-related resources across different systems."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "https://gematik.de/fhir/epa-medication/StructureDefinition/rx-prescription-process-identifier"
            ]
          }
        ]
      }
    ]
  }
}

```
