# NarcoticsExtension - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **NarcoticsExtension**

## Extension: NarcoticsExtension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/narcotics-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:NarcoticsExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Abbildung der Angaben zur Verordnung eines Betäubungsmittels im Sinne des Betäubungsmittelgesetzes (BtMG)

**Context of Use**

This extension may be used on the following element(s):

* Element ID Element

**Usage info**

**Usages:**

* Use this Extension: [EPA MedicationRequest](StructureDefinition-epa-medication-request.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/narcotics-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-narcotics-extension.csv), [Excel](StructureDefinition-narcotics-extension.xlsx), [Schematron](StructureDefinition-narcotics-extension.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "narcotics-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/narcotics-extension",
  "version" : "1.3.0",
  "name" : "NarcoticsExtension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Abbildung der Angaben zur Verordnung eines Betäubungsmittels im Sinne des Betäubungsmittelgesetzes (BtMG)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Abbildung der Angaben zur Verordnung eines Betäubungsmittels im Sinne des Betäubungsmittelgesetzes (BtMG)"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "description" : "Extensions are always sliced by (at least) url",
          "rules" : "closed"
        }
      },
      {
        "id" : "Extension.extension:narcotics-markings",
        "path" : "Extension.extension",
        "sliceName" : "narcotics-markings",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:narcotics-markings.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:narcotics-markings.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "narcotics-markings"
      },
      {
        "id" : "Extension.extension:narcotics-markings.value[x]",
        "path" : "Extension.extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:narcotics-markings.value[x]:valueCoding",
        "path" : "Extension.extension.value[x]",
        "sliceName" : "valueCoding",
        "comment" : "Die KBV aktualisiert ihr \"Schüsseltabellen\"-Paket häufiger, als neue ePA-Versionen veröffentlicht werden. Allerdings übernehmen die E-Rezept-Clients und der E-Rezept-Fachdienst neue KBV-Paketversionen schnell nach deren Veröffentlichung und geben sie somit an den ePA-MedicationService weiter. Da der MedicationService möglicherweise an eine ältere Version des KBV-Pakets gebunden ist, würde er die weitergeleiteten E-Rezept-Daten ablehnen. Zukünftig wird der MedicationService in der Lage sein, auf die neuesten KBV-Paketversionen zu aktualisieren, ohne dass eine neue ePA-Version erforderlich ist.  \n    Da das E-Rezept *tatsächlich* die Codes gegen die neueste KBV-Paketversion prüft, wird der MedicationService keine \"ungültigen\" Codes erhalten, und die Clients können darauf vertrauen, dass die Daten des MedicationService mit der neuesten KBV-Paketversion übereinstimmen.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "patternCoding" : {
          "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_KBV_NARCOTIC_LABEL"
        },
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.kbv.de/ValueSet/KBV_VS_SFHIR_KBV_NARCOTIC_LABEL"
        }
      },
      {
        "id" : "Extension.extension:narcotics-markings.value[x]:valueCoding.system",
        "path" : "Extension.extension.value[x].system",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:narcotics-markings.value[x]:valueCoding.code",
        "path" : "Extension.extension.value[x].code",
        "short" : "Kennzeichen nach § 9 Abs. 1 Nr. 6 BtMVV",
        "definition" : "Kennzeichen nach § 9 Abs. 1 Nr. 6 BtMVV",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:additional-information-substitutes",
        "path" : "Extension.extension",
        "sliceName" : "additional-information-substitutes",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:additional-information-substitutes.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:additional-information-substitutes.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "additional-information-substitutes"
      },
      {
        "id" : "Extension.extension:additional-information-substitutes.value[x]",
        "path" : "Extension.extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:additional-information-substitutes.value[x]:valueString",
        "path" : "Extension.extension.value[x]",
        "sliceName" : "valueString",
        "short" : "Ergänzende Angaben zu Substitutionsmittel",
        "definition" : "Dieses Feld enthält ergänzende Angaben zu Reichdauer und Teilmengen des Substitutionsmittels, insbesondere Zeitpunkte, zu denen das Substitutionsmittel abgegeben bzw. verabreicht werden soll.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/narcotics-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
