# MultiplePrescription - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **MultiplePrescription**

## Extension: MultiplePrescription 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:MultiplePrescriptionExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

This FHIR Extension for multiple prescriptions adds details such as repetition count and time intervals for repeated medication orders to FHIR resources.

**Context of Use**

This extension may be used on the following element(s):

* Element ID Element

**Usage info**

**Usages:**

* Use this Extension: [EPA MedicationRequest](StructureDefinition-epa-medication-request.md)
* Examples for this Extension: [Bundle/example-get-medication-list-bundle1](Bundle-example-get-medication-list-bundle1.md), [Bundle/example-get-medication-plan-bundle-1](Bundle-example-get-medication-plan-bundle-1.md), [Bundle/example-searchset-medicationrequest](Bundle-example-searchset-medicationrequest.md), [MedicationRequest/0435e19e-ed9a-4b5b-a9e9-70924c5922a0](MedicationRequest-0435e19e-ed9a-4b5b-a9e9-70924c5922a0.md)...Show 14 more,[MedicationRequest/08cb8487-2758-406c-999a-e23a05e63c0b](MedicationRequest-08cb8487-2758-406c-999a-e23a05e63c0b.md),[MedicationRequest/0e7f16e4-d879-4a2c-8292-41c55201bbdd](MedicationRequest-0e7f16e4-d879-4a2c-8292-41c55201bbdd.md),[MedicationRequest/2a794a78-8a72-46ca-bb81-09f702f94e11](MedicationRequest-2a794a78-8a72-46ca-bb81-09f702f94e11.md),[MedicationRequest/3191d752-3adf-4c7f-848d-8d43766fed72](MedicationRequest-3191d752-3adf-4c7f-848d-8d43766fed72.md),[MedicationRequest/3ffb5c34-81e7-45ec-842c-82a2422cb8c8](MedicationRequest-3ffb5c34-81e7-45ec-842c-82a2422cb8c8.md),[MedicationRequest/40df19aa-40e2-4ebc-a11d-9d232dcb0f67](MedicationRequest-40df19aa-40e2-4ebc-a11d-9d232dcb0f67.md),[MedicationRequest/4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8](MedicationRequest-4dd6f19d-002c-44ac-ae2f-3c9d08ad35b8.md),[MedicationRequest/6461edff-13ec-4dc7-b9f3-aea66bcb0643](MedicationRequest-6461edff-13ec-4dc7-b9f3-aea66bcb0643.md),[MedicationRequest/7efae80a-a4d9-4e26-a1b9-92c72e79cfaa](MedicationRequest-7efae80a-a4d9-4e26-a1b9-92c72e79cfaa.md),[MedicationRequest/ed2eeb8c-9ab6-4f4f-be9d-7e1a3784045e](MedicationRequest-ed2eeb8c-9ab6-4f4f-be9d-7e1a3784045e.md),[MedicationRequest/f14498f0-4932-490a-91a2-9de8616e133b](MedicationRequest-f14498f0-4932-490a-91a2-9de8616e133b.md),[MedicationRequest/f6b1d9ab-4ff0-405e-8d2d-7a181d9fdbdd](MedicationRequest-f6b1d9ab-4ff0-405e-8d2d-7a181d9fdbdd.md),[Parameters/example-epa-op-provide-prescription-erp-input-parameters-1](Parameters-example-epa-op-provide-prescription-erp-input-parameters-1.md)and[Parameters/example-epa-op-provide-prescription-erp-input-parameters-2](Parameters-example-epa-op-provide-prescription-erp-input-parameters-2.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/multiple-prescription-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-multiple-prescription-extension.csv), [Excel](StructureDefinition-multiple-prescription-extension.xlsx), [Schematron](StructureDefinition-multiple-prescription-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "multiple-prescription-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension",
  "version" : "1.3.0",
  "name" : "MultiplePrescriptionExtension",
  "title" : "MultiplePrescription",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "This FHIR Extension for multiple prescriptions adds details such as repetition count and time intervals for repeated medication orders to FHIR resources.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "MultiplePrescription",
        "definition" : "This FHIR Extension for multiple prescriptions adds details such as repetition count and time intervals for repeated medication orders to FHIR resources."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "description" : "Extensions are always sliced by (at least) url",
          "rules" : "closed"
        }
      },
      {
        "id" : "Extension.extension:indicator",
        "path" : "Extension.extension",
        "sliceName" : "indicator",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:indicator.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:indicator.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "indicator"
      },
      {
        "id" : "Extension.extension:indicator.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Multiple Prescription Indicator",
        "definition" : "Indicator of whether the current prescription is part of a multiple prescription\r\n\r\ntrue - the current prescription is part of a multiple prescription \r\nfalse - the current prescription is not part of a multiple prescription",
        "min" : 1,
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Extension.extension:counter",
        "path" : "Extension.extension",
        "sliceName" : "counter",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:counter.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:counter.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "counter"
      },
      {
        "id" : "Extension.extension:counter.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "Extension.extension:counter.value[x].numerator",
        "path" : "Extension.extension.value[x].numerator",
        "min" : 1
      },
      {
        "id" : "Extension.extension:counter.value[x].numerator.value",
        "path" : "Extension.extension.value[x].numerator.value",
        "short" : "Multiple Prescription Counter",
        "definition" : "The field serves to indicate which number in a series of multiple prescriptions it is. Example: \"2\" in \"2 out of 4\"",
        "min" : 1
      },
      {
        "id" : "Extension.extension:counter.value[x].numerator.comparator",
        "path" : "Extension.extension.value[x].numerator.comparator",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:counter.value[x].numerator.unit",
        "path" : "Extension.extension.value[x].numerator.unit",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:counter.value[x].numerator.system",
        "path" : "Extension.extension.value[x].numerator.system",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:counter.value[x].numerator.code",
        "path" : "Extension.extension.value[x].numerator.code",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:counter.value[x].denominator",
        "path" : "Extension.extension.value[x].denominator",
        "min" : 1
      },
      {
        "id" : "Extension.extension:counter.value[x].denominator.value",
        "path" : "Extension.extension.value[x].denominator.value",
        "short" : "Denominator of Multiple Prescription Series",
        "definition" : "The field serves to indicate the length of this series. Example: \"4\" in \"2 out of 4\"",
        "min" : 1
      },
      {
        "id" : "Extension.extension:counter.value[x].denominator.comparator",
        "path" : "Extension.extension.value[x].denominator.comparator",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:counter.value[x].denominator.unit",
        "path" : "Extension.extension.value[x].denominator.unit",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:counter.value[x].denominator.system",
        "path" : "Extension.extension.value[x].denominator.system",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:counter.value[x].denominator.code",
        "path" : "Extension.extension.value[x].denominator.code",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:period",
        "path" : "Extension.extension",
        "sliceName" : "period",
        "short" : "Zeitraum der Einlösefrist",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:period.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:period.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "period"
      },
      {
        "id" : "Extension.extension:period.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Period"
          }
        ],
        "constraint" : [
          {
            "key" : "-limitationDateStart",
            "severity" : "error",
            "human" : "Limitation of the date format to 10 characters YYYY-MM-DD",
            "expression" : "start.toString().length()=10",
            "source" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
          },
          {
            "key" : "-limitationDateEnd",
            "severity" : "error",
            "human" : "Limitation of the date format to 10 characters YYYY-MM-DD",
            "expression" : "end.exists().not() or end.toString().length()=10",
            "source" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
          }
        ]
      },
      {
        "id" : "Extension.extension:period.value[x].start",
        "path" : "Extension.extension.value[x].start",
        "short" : "Start Date of the Prescription Redemption Period",
        "definition" : "Date from which the partial prescription of the multiple prescription can be redeemed",
        "min" : 1
      },
      {
        "id" : "Extension.extension:period.value[x].end",
        "path" : "Extension.extension.value[x].end",
        "short" : "End Date of the Prescription Redemption Period",
        "definition" : "Date of the last redemption day for the partial prescription within the multiple prescription series. \nThe issuer may specify a redemption period different from the one outlined in the Medicinal Products Prescription Ordinance (AMVV)"
      },
      {
        "id" : "Extension.extension:id",
        "path" : "Extension.extension",
        "sliceName" : "id",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:id.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:id.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "id"
      },
      {
        "id" : "Extension.extension:id.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Extension.extension:id.value[x].use",
        "path" : "Extension.extension.value[x].use",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:id.value[x].type",
        "path" : "Extension.extension.value[x].type",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:id.value[x].system",
        "path" : "Extension.extension.value[x].system",
        "short" : "Specification as UUID",
        "fixedUri" : "urn:ietf:rfc:3986"
      },
      {
        "id" : "Extension.extension:id.value[x].value",
        "path" : "Extension.extension.value[x].value",
        "short" : "Multiple Prescription ID",
        "definition" : "A unique ID that is identical across all partial prescriptions of a multiple prescription."
      },
      {
        "id" : "Extension.extension:id.value[x].period",
        "path" : "Extension.extension.value[x].period",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:id.value[x].assigner",
        "path" : "Extension.extension.value[x].assigner",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/multiple-prescription-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
