# MedicationTotalQuantityFormulationExtension - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **MedicationTotalQuantityFormulationExtension**

## Extension: MedicationTotalQuantityFormulationExtension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:MedicationTotalQuantityFormulationExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Total quantity of the formulation (without the unit).

**Context of Use**

This extension may be used on the following element(s):

* Element ID Element

**Usage info**

**Usages:**

* Use this Extension: [EPA Pharmaceutical Product Medication](StructureDefinition-epa-medication-pharmaceutical-product.md), [EPA Medication PZN Ingredient](StructureDefinition-epa-medication-pzn-ingredient.md) and [EPA Medication](StructureDefinition-epa-medication.md)
* Examples for this Extension: [Bundle/example-epa-batch-emp-request-bundle](Bundle-example-epa-batch-emp-request-bundle.md), [Bundle/example-epa-batch-emp-response-bundle](Bundle-example-epa-batch-emp-response-bundle.md), [Bundle/example-get-medication-list-bundle1](Bundle-example-get-medication-list-bundle1.md), [Bundle/example-get-medication-plan-bundle-1](Bundle-example-get-medication-plan-bundle-1.md)...Show 15 more,[Bundle/example-searchset-medication](Bundle-example-searchset-medication.md),[Medication/1254591a-dd2d-4d17-b8f8-ee3155da0699](Medication-1254591a-dd2d-4d17-b8f8-ee3155da0699.md),[Medication/13c66845-d0ce-43e1-9b0b-884cbbe8df7f](Medication-13c66845-d0ce-43e1-9b0b-884cbbe8df7f.md),[Medication/19549515-60a8-4e1c-b86a-49518053fe9f](Medication-19549515-60a8-4e1c-b86a-49518053fe9f.md),[Medication/2571d29b-e213-40ec-b817-a1490718f491](Medication-2571d29b-e213-40ec-b817-a1490718f491.md),[Medication/3f0b0cb0-e8cf-4aaf-bad8-01a51619417b](Medication-3f0b0cb0-e8cf-4aaf-bad8-01a51619417b.md),[Medication/87f08ba2-da7e-467e-86aa-404d9035297c](Medication-87f08ba2-da7e-467e-86aa-404d9035297c.md),[Medication/fc7b28e8-05ac-4ac8-86d7-7677d9c6134e](Medication-fc7b28e8-05ac-4ac8-86d7-7677d9c6134e.md),[Parameters/example-epa-op-add-eml-entry-input-parameters-1](Parameters-example-epa-op-add-eml-entry-input-parameters-1.md),[Parameters/example-epa-op-add-emp-entry-input-parameters-1](Parameters-example-epa-op-add-emp-entry-input-parameters-1.md),[Parameters/example-epa-op-eml-entry-output-parameters-1](Parameters-example-epa-op-eml-entry-output-parameters-1.md),[Parameters/example-epa-op-emp-entry-output-parameters-1](Parameters-example-epa-op-emp-entry-output-parameters-1.md),[Parameters/example-epa-op-emp-entry-output-parameters-2](Parameters-example-epa-op-emp-entry-output-parameters-2.md),[Parameters/example-epa-op-provide-dispensation-erp-input-parameters-1](Parameters-example-epa-op-provide-dispensation-erp-input-parameters-1.md)and[Parameters/example-epa-op-provide-prescription-erp-input-parameters-1](Parameters-example-epa-op-provide-prescription-erp-input-parameters-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/medication-total-quantity-formulation-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medication-total-quantity-formulation-extension.csv), [Excel](StructureDefinition-medication-total-quantity-formulation-extension.xlsx), [Schematron](StructureDefinition-medication-total-quantity-formulation-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medication-total-quantity-formulation-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension",
  "version" : "1.3.0",
  "name" : "MedicationTotalQuantityFormulationExtension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Total quantity of the formulation (without the unit).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Total quantity of the formulation (without the unit)."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/medication-total-quantity-formulation-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Total quantity of the formulation.",
        "definition" : "Total quantity of the formulation (without the unit).",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "maxLength" : 7
      }
    ]
  }
}

```
