# IsEMPChronologyExtension - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **IsEMPChronologyExtension**

## Extension: IsEMPChronologyExtension 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:IsEMPChronologyExtension |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

Definiert, ob die Provenance ein eMP-Chronologieeintrag ist.

**Context of Use**

This extension may be used on the following element(s):

* Element ID Provenance

**Usage info**

**Usages:**

* Use this Extension: [eMP Chronology Provenance](StructureDefinition-emp-chronology-provenance.md)
* Examples for this Extension: [Bundle/example-epa-batch-emp-response-bundle](Bundle-example-epa-batch-emp-response-bundle.md), [Bundle/example-get-medication-plan-bundle-1](Bundle-example-get-medication-plan-bundle-1.md), [Bundle/medication-plan-chronology-log-bundle](Bundle-medication-plan-chronology-log-bundle.md), [Parameters/example-epa-op-emp-entry-output-parameters-1](Parameters-example-epa-op-emp-entry-output-parameters-1.md)...Show 8 more,[Parameters/example-epa-op-emp-entry-output-parameters-2](Parameters-example-epa-op-emp-entry-output-parameters-2.md),[Parameters/example-epa-op-link-emp-entry-output-parameters-1](Parameters-example-epa-op-link-emp-entry-output-parameters-1.md),[Parameters/example-epa-op-unlink-emp-entry-output-parameters-1](Parameters-example-epa-op-unlink-emp-entry-output-parameters-1.md),[Provenance/0b383501-f078-464b-b984-9fdb6751601b](Provenance-0b383501-f078-464b-b984-9fdb6751601b.md),[Provenance/2e112cb5-3b9f-4434-848e-26e27756cd30](Provenance-2e112cb5-3b9f-4434-848e-26e27756cd30.md),[Provenance/2e1ba746-1aef-4eef-b741-2dfc771c7001](Provenance-2e1ba746-1aef-4eef-b741-2dfc771c7001.md),[Provenance/319fcc6e-049d-4eb1-9a5c-82c33438cf94](Provenance-319fcc6e-049d-4eb1-9a5c-82c33438cf94.md)and[Provenance/b467ce05-e0e5-4d71-9a0b-d824dbb492ef](Provenance-b467ce05-e0e5-4d71-9a0b-d824dbb492ef.md)
* Search Parameters using this Extension: [IsEMPChronologySP](SearchParameter-is-emp-chronology-sp.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/is-emp-chronology-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-is-emp-chronology-extension.csv), [Excel](StructureDefinition-is-emp-chronology-extension.xlsx), [Schematron](StructureDefinition-is-emp-chronology-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "is-emp-chronology-extension",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension",
  "version" : "1.3.0",
  "name" : "IsEMPChronologyExtension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "Definiert, ob die Provenance ein eMP-Chronologieeintrag ist.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Provenance"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Definiert, ob die Provenance ein eMP-Chronologieeintrag ist."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://gematik.de/fhir/epa-medication/StructureDefinition/is-emp-chronology-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Gibt an, ob diese Provenance-Instanz ein eMP-Chronologieeintrag ist.",
        "min" : 1,
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
