# EPA eMP Commit Operation Input-Parameters - Implementation Guide ePA Medication Service v1.3.0

Implementation Guide

ePA Medication Service

Version 1.3.0 - release

* [**Table of Contents**](toc.md)
* [**FHIR-Artefakte**](artifacts.md)
* **EPA eMP Commit Operation Input-Parameters**

## Resource Profile: EPA eMP Commit Operation Input-Parameters 

| | |
| :--- | :--- |
| *Official URL*:https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rmp-commit-input-parameters | *Version*:1.3.0 |
| Active as of 2025-12-15 | *Computable Name*:EPAOpEMPCommitInputParameters |
| **Copyright/Legal**: gematik GmbH / Dieses Artefakt ist lizenziert unter[Apache License](./license.md), Version 2.0. | |

 
EPA eMP Commit Operation Input-Parameters 

**Usages:**

* Use this Profile: [Batch API eMP-Einträge - Request-Bundle](StructureDefinition-epa-batch-emp-request-bundle.md)
* Examples for this Profile: [Parameters/example-epa-op-rmp-commit-input-parameters-1](Parameters-example-epa-op-rmp-commit-input-parameters-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.gematik.epa.medication|current/StructureDefinition/epa-op-rmp-commit-input-parameters)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-epa-op-rmp-commit-input-parameters.csv), [Excel](StructureDefinition-epa-op-rmp-commit-input-parameters.xlsx), [Schematron](StructureDefinition-epa-op-rmp-commit-input-parameters.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "epa-op-rmp-commit-input-parameters",
  "url" : "https://gematik.de/fhir/epa-medication/StructureDefinition/epa-op-rmp-commit-input-parameters",
  "version" : "1.3.0",
  "name" : "EPAOpEMPCommitInputParameters",
  "title" : "EPA eMP Commit Operation Input-Parameters",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-15",
  "publisher" : "gematik GmbH",
  "contact" : [
    {
      "name" : "gematik GmbH",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gematik.de"
        },
        {
          "system" : "email",
          "value" : "patientteam [ at ] gematik.de"
        }
      ]
    }
  ],
  "description" : "EPA eMP Commit Operation Input-Parameters",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DE"
        }
      ]
    }
  ],
  "copyright" : "gematik GmbH / Dieses Artefakt ist lizenziert unter [Apache License](./license.html), Version 2.0.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Parameters",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Parameters",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Parameters.parameter",
        "path" : "Parameters.parameter",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "rules" : "closed"
        },
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:acknowledgedChronologyId",
        "path" : "Parameters.parameter",
        "sliceName" : "acknowledgedChronologyId",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:acknowledgedChronologyId.name",
        "path" : "Parameters.parameter.name",
        "patternString" : "acknowledgedChronologyId",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:acknowledgedChronologyId.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "id"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter:acknowledgedChronologyId.resource",
        "path" : "Parameters.parameter.resource",
        "max" : "0"
      },
      {
        "id" : "Parameters.parameter:acknowledgedChronologyId.part",
        "path" : "Parameters.parameter.part",
        "max" : "0"
      }
    ]
  }
}

```
